/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Named;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.web.jsf.api.editor.JsfFacesComponentsProvider;
import org.netbeans.modules.web.jsf.editor.InjectCompositeComponent;
import org.netbeans.modules.web.jsf.editor.JsfNavigationHelper;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsf.editor.completion.JsfAttributesCompletionHelper;
import org.netbeans.modules.web.jsf.editor.completion.JsfCompletionItem;
import org.netbeans.modules.web.jsf.editor.facelets.AbstractFaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.CompositeComponentLibrary;
import org.netbeans.modules.web.jsf.editor.hints.HintsRegistry;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.netbeans.modules.web.jsfapi.api.JsfVersion;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryComponent;
import org.netbeans.modules.web.jsfapi.api.NamespaceUtils;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.lexer.MutableTextInput;

public class JsfHtmlExtension
extends HtmlExtension {
    private static final String EL_ENABLED_KEY = "el_enabled";

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights(HtmlParserResult result, SchedulerEvent event) {
        HashMap<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        this.highlightJsfTags(result, highlights);
        this.checkELEnabled(result);
        return highlights;
    }

    public void checkELEnabled(HtmlParserResult result) {
        Language xhtmlLang;
        Document doc = result.getSnapshot().getSource().getDocument(true);
        InputAttributes inputAttributes = (InputAttributes)doc.getProperty(InputAttributes.class);
        if (inputAttributes == null) {
            inputAttributes = new InputAttributes();
            doc.putProperty(InputAttributes.class, inputAttributes);
        }
        if (inputAttributes.getValue(LanguagePath.get((Language)(xhtmlLang = Language.find((String)"text/xhtml"))), (Object)EL_ENABLED_KEY) == null) {
            inputAttributes.setValue(LanguagePath.get((Language)xhtmlLang), (Object)EL_ENABLED_KEY, new Object(), false);
            this.recolor(doc);
        }
    }

    private void recolor(final Document doc) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ JsfHtmlExtension this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                NbEditorDocument nbdoc = (NbEditorDocument)doc;
                nbdoc.extWriteLock();
                try {
                    MutableTextInput mti = (MutableTextInput)doc.getProperty(MutableTextInput.class);
                    if (mti != null) {
                        mti.tokenHierarchyControl().rebuild();
                    }
                }
                finally {
                    nbdoc.extWriteUnlock();
                }
            }
        });
    }

    private void highlightJsfTags(HtmlParserResult result, final Map<OffsetRange, Set<ColoringAttributes>> highlights) {
        final Snapshot snapshot = result.getSnapshot();
        Source source = snapshot.getSource();
        JsfSupportImpl jsfs = JsfSupportImpl.findFor(source);
        if (jsfs == null) {
            return;
        }
        Map<String, Library> libs = jsfs.getLibraries();
        Map nss = result.getNamespaces();
        for (String namespace : nss.keySet()) {
            Node root = result.root(namespace);
            if (root == null) continue;
            final Library tldl = (Library)NamespaceUtils.getForNs(libs, (String)namespace);
            ElementUtils.visitChildren((Node)root, (ElementVisitor)new ElementVisitor(){
                final /* synthetic */ JsfHtmlExtension this$0;
                {
                    this.this$0 = this$0;
                }

                public void visit(Element element) {
                    Named named;
                    if ((element.type() == ElementType.OPEN_TAG || element.type() == ElementType.CLOSE_TAG) && (named = (Named)element).namespacePrefix() != null) {
                        EnumSet coloring = tldl == null ? ColoringAttributes.CLASS_SET : ColoringAttributes.METHOD_SET;
                        try {
                            this.this$0.highlight(snapshot, named, highlights, coloring);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    private void highlight(Snapshot s, Named node, Map<OffsetRange, Set<ColoringAttributes>> hls, Set<ColoringAttributes> cas) throws BadLocationException {
        int prefixLen = node.type() == ElementType.OPEN_TAG ? 1 : 2;
        hls.put(this.getDocumentOffsetRange(s, node.from(), node.from() + node.name().length() + prefixLen), cas);
        hls.put(this.getDocumentOffsetRange(s, node.to() - 1, node.to()), cas);
    }

    private OffsetRange getDocumentOffsetRange(Snapshot s, int astFrom, int astTo) throws BadLocationException {
        int from = s.getOriginalOffset(astFrom);
        int to = s.getOriginalOffset(astTo);
        if (from == -1 || to == -1) {
            throw new BadLocationException("Cannot convert snapshot offset to document offset", -1);
        }
        return new OffsetRange(from, to);
    }

    public List<CompletionItem> completeOpenTags(HtmlExtension.CompletionContext context) {
        HtmlParserResult result = context.getResult();
        Source source = result.getSnapshot().getSource();
        JsfSupportImpl jsfs = JsfSupportImpl.findFor(source);
        if (jsfs == null) {
            return Collections.emptyList();
        }
        Map<String, Library> libs = jsfs.getLibraries();
        HashSet<Library> librariesSet = new HashSet<Library>(libs.values());
        Map declaredNS = result.getNamespaces();
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        int colonIndex = context.getPrefix().indexOf(58);
        if (colonIndex == -1) {
            for (Library lib : librariesSet) {
                String declaredPrefix = (String)NamespaceUtils.getForNs((Map)declaredNS, (String)lib.getNamespace());
                if (declaredPrefix == null) {
                    if (lib.getDefaultPrefix() == null || !lib.getDefaultPrefix().startsWith(context.getPrefix())) continue;
                    items.addAll(this.queryLibrary(context, lib, lib.getDefaultPrefix(), true, jsfs.getJsfVersion().isAtLeast(JsfVersion.JSF_2_2)));
                    continue;
                }
                items.addAll(this.queryLibrary(context, lib, declaredPrefix, false, jsfs.getJsfVersion().isAtLeast(JsfVersion.JSF_2_2)));
            }
        } else {
            String tagNamePrefix = context.getPrefix().substring(0, colonIndex);
            String namespace = this.getUriForPrefix(tagNamePrefix, declaredNS);
            if (namespace == null) {
                for (Library lib : librariesSet) {
                    if (lib.getDefaultPrefix() == null || !lib.getDefaultPrefix().equals(tagNamePrefix)) continue;
                    items.addAll(this.queryLibrary(context, lib, tagNamePrefix, true, jsfs.getJsfVersion().isAtLeast(JsfVersion.JSF_2_2)));
                }
            } else {
                Library lib = (Library)NamespaceUtils.getForNs(libs, (String)namespace);
                if (lib == null) {
                    return Collections.emptyList();
                }
                items.addAll(this.queryLibrary(context, lib, tagNamePrefix, false, jsfs.getJsfVersion().isAtLeast(JsfVersion.JSF_2_2)));
            }
        }
        Iterator itr = items.iterator();
        while (itr.hasNext()) {
            if (CharSequenceUtilities.startsWith((CharSequence)((CompletionItem)itr.next()).getInsertPrefix(), (CharSequence)context.getPrefix())) continue;
            itr.remove();
        }
        return items;
    }

    private String getUriForPrefix(String prefix, Map<String, String> namespaces) {
        for (Map.Entry<String, String> entry : namespaces.entrySet()) {
            if (!prefix.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private Collection<CompletionItem> queryLibrary(HtmlExtension.CompletionContext context, Library lib, String nsPrefix, boolean undeclared, boolean isJsf22Plus) {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        for (LibraryComponent component : lib.getComponents()) {
            if (component instanceof AbstractFaceletsLibrary.Function) continue;
            items.add((CompletionItem)JsfCompletionItem.createTag(context.getCCItemStartOffset(), component, nsPrefix, undeclared, isJsf22Plus));
        }
        return items;
    }

    public List<CompletionItem> completeAttributes(HtmlExtension.CompletionContext context) {
        HtmlParserResult result = context.getResult();
        Source source = result.getSnapshot().getSource();
        JsfSupportImpl jsfs = JsfSupportImpl.findFor(source);
        if (jsfs == null) {
            return Collections.emptyList();
        }
        Map<String, Library> libs = jsfs.getLibraries();
        Map declaredNS = result.getNamespaces();
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        Element queriedNode = context.getCurrentNode();
        if (queriedNode.type() != ElementType.OPEN_TAG) {
            return Collections.emptyList();
        }
        OpenTag ot = (OpenTag)queriedNode;
        CharSequence nsPrefix = ot.namespacePrefix();
        if (nsPrefix == null) {
            String jsfPrefix = (String)declaredNS.get(DefaultLibraryInfo.JSF.getNamespace());
            if (context.getItemText().startsWith(jsfPrefix + ":")) {
                Library htmlLibrary = (Library)NamespaceUtils.getForNs(libs, (String)DefaultLibraryInfo.HTML.getNamespace());
                return JsfAttributesCompletionHelper.getJsfItemsForHtmlElement(context, htmlLibrary, context.getItemText());
            }
            return Collections.emptyList();
        }
        String tagName = ot.unqualifiedName().toString();
        String namespace = this.getUriForPrefix(nsPrefix.toString(), declaredNS);
        Library flib = null;
        if (namespace == null) {
            for (Library lib : libs.values()) {
                if (lib.getDefaultPrefix() == null || !lib.getDefaultPrefix().equals(nsPrefix.toString())) continue;
                flib = lib;
                break;
            }
        } else {
            flib = (Library)NamespaceUtils.getForNs(libs, (String)namespace);
        }
        if (flib == null) {
            return Collections.emptyList();
        }
        JsfAttributesCompletionHelper.completeAttributes(context, items, "", flib, tagName, context.getPrefix());
        return items;
    }

    public List<CompletionItem> completeAttributeValue(HtmlExtension.CompletionContext context) {
        OpenTag openTag;
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        JsfSupportImpl jsfs = JsfSupportImpl.findFor(context.getResult().getSnapshot().getSource());
        String ns = ElementUtils.getNamespace((Element)context.getCurrentNode());
        OpenTag openTag2 = openTag = context.getCurrentNode().type() == ElementType.OPEN_TAG ? (OpenTag)context.getCurrentNode() : null;
        if (jsfs != null) {
            JsfAttributesCompletionHelper.completeXMLNSAttribute(context, items, jsfs);
        }
        if (ns == null || openTag == null) {
            return items;
        }
        JsfAttributesCompletionHelper.completeTagLibraryMetadata(context, items, ns, openTag);
        if (jsfs == null) {
            return items;
        }
        JsfAttributesCompletionHelper.completeValueAccordingToType(context, items, ns, openTag, jsfs);
        JsfAttributesCompletionHelper.completeFaceletsFromProject(context, items, ns, openTag);
        JsfAttributesCompletionHelper.completeSectionsOfTemplate(context, items, ns, openTag);
        JsfAttributesCompletionHelper.completeJavaClasses(context, items, ns, openTag);
        JsfAttributesCompletionHelper.completeFacetsInCCImpl(context, items, ns, openTag, jsfs);
        JsfAttributesCompletionHelper.completeFacets(context, items, ns, openTag, jsfs);
        return items;
    }

    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult result, int caretOffset) {
        assert (result instanceof HtmlParserResult);
        HtmlParserResult htmlresult = (HtmlParserResult)result;
        int embeddedOffset = result.getSnapshot().getEmbeddedOffset(caretOffset);
        if (embeddedOffset == -1) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        Element leaf = htmlresult.findByPhysicalRange(embeddedOffset, true);
        if (leaf == null || leaf.type() != ElementType.OPEN_TAG) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        JsfSupportImpl jsfs = JsfSupportImpl.findFor(result.getSnapshot().getSource());
        if (jsfs == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        String ns = ElementUtils.getNamespace((Element)leaf);
        if (ns == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        Library lib = jsfs.getLibrary(ns);
        if (lib == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        TokenSequence ts = JsfNavigationHelper.getTokenSequenceAtCaret(result.getSnapshot().getTokenHierarchy(), embeddedOffset);
        if (ts == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        Token t = ts.token();
        if (t.id() == HTMLTokenId.VALUE) {
            String value = CharSequenceUtilities.toString((CharSequence)ts.token().text()).replaceAll("[\"']", "");
            String attribute = "";
            while (ts.movePrevious()) {
                if (ts.token().id() == HTMLTokenId.TAG_OPEN) {
                    String tag = CharSequenceUtilities.toString((CharSequence)ts.token().text());
                    return JsfNavigationHelper.goToReferencedFile(htmlresult, embeddedOffset, tag, attribute, value);
                }
                if (ts.token().id() != HTMLTokenId.ARGUMENT || !attribute.isEmpty()) continue;
                attribute = CharSequenceUtilities.toString((CharSequence)ts.token().text());
            }
        } else {
            if (lib instanceof CompositeComponentLibrary) {
                return JsfNavigationHelper.goToCompositeComponentLibrary(htmlresult, embeddedOffset, lib);
            }
            if (lib instanceof JsfFacesComponentsProvider.FacesComponentLibrary) {
                return JsfNavigationHelper.goToFacesComponentLibrary(htmlresult, embeddedOffset, (JsfFacesComponentsProvider.FacesComponentLibrary)lib);
            }
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public OffsetRange getReferenceSpan(Document doc, int caretOffset) {
        block7: {
            Token t;
            TokenSequence ts;
            block9: {
                block8: {
                    TokenHierarchy th = TokenHierarchy.get((Document)doc);
                    ts = JsfNavigationHelper.getTokenSequenceAtCaret(th, caretOffset);
                    if (ts == null) {
                        return OffsetRange.NONE;
                    }
                    t = ts.token();
                    if (t.id() != HTMLTokenId.TAG_OPEN) break block8;
                    if (CharSequenceUtilities.indexOf((CharSequence)t.text(), (int)58) != -1) {
                        return new OffsetRange(ts.offset(), ts.offset() + t.length());
                    }
                    break block7;
                }
                if (t.id() != HTMLTokenId.ARGUMENT) break block9;
                int from = ts.offset();
                int to = from + t.text().length();
                while (ts.movePrevious()) {
                    if (ts.token().id() != HTMLTokenId.TAG_OPEN) continue;
                    if (CharSequenceUtilities.indexOf((CharSequence)ts.token().text(), (int)58) != -1) {
                        return new OffsetRange(from, to);
                    }
                    break block7;
                }
                break block7;
            }
            if (t.id() != HTMLTokenId.VALUE) break block7;
            CharSequence value = ts.token().text();
            int from = ts.offset();
            int to = from + t.text().length();
            while (ts.movePrevious()) {
                if (ts.token().id() != HTMLTokenId.TAG_OPEN) continue;
                if (CharSequenceUtilities.indexOf((CharSequence)ts.token().text(), (CharSequence)"include") != -1) {
                    if (CharSequenceUtilities.indexOf((CharSequence)value, (CharSequence)"'") != -1 || CharSequenceUtilities.indexOf((CharSequence)value, (CharSequence)"\"") != -1) {
                        ++from;
                        --to;
                    }
                    return new OffsetRange(from, to);
                }
                break;
            }
        }
        return OffsetRange.NONE;
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        hints.addAll(HintsRegistry.getDefault().gatherHints(context));
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, int start, int end) {
        Hint injectCC = InjectCompositeComponent.getHint(context, start, end);
        if (injectCC != null) {
            hints.add(injectCC);
        }
    }
}

