/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.ui.customizer;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.phpunit.PhpUnitVersion;
import org.netbeans.modules.php.phpunit.commands.PhpUnit;
import org.netbeans.modules.php.phpunit.options.PhpUnitOptions;
import org.netbeans.modules.php.phpunit.preferences.PhpUnitPreferences;
import org.netbeans.modules.php.phpunit.preferences.PhpUnitPreferencesValidator;
import org.netbeans.modules.php.phpunit.ui.customizer.Bundle;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class CustomizerPhpUnit
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = 2171421712032630826L;
    private static final RequestProcessor RP = new RequestProcessor(CustomizerPhpUnit.class);
    private final ProjectCustomizer.Category category;
    private final PhpModule phpModule;
    private JCheckBox askForTestGroupsCheckBox;
    private JButton bootstrapBrowseButton;
    private JCheckBox bootstrapCheckBox;
    private JCheckBox bootstrapForCreateTestsCheckBox;
    private JButton bootstrapGenerateButton;
    private JLabel bootstrapLabel;
    private JTextField bootstrapTextField;
    private JButton configurationBrowseButton;
    private JCheckBox configurationCheckBox;
    private JButton configurationGenerateButton;
    private JLabel configurationLabel;
    private JTextField configurationTextField;
    private JCheckBox runPhpUnitOnlyCheckBox;
    private JCheckBox runTestUsingUnitCheckBox;
    private JButton scriptBrowseButton;
    private JCheckBox scriptCheckBox;
    private JLabel scriptLabel;
    private JTextField scriptTextField;
    private JButton suiteBrowseButton;
    private JCheckBox suiteCheckBox;
    private JLabel suiteInfoLabel;
    private JLabel suiteLabel;
    private JTextField suiteTextField;
    private JLabel versionLabel;
    private JLabel versionLineLabel;

    public CustomizerPhpUnit(ProjectCustomizer.Category category, PhpModule phpModule) {
        this.category = category;
        this.phpModule = phpModule;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.initFile(PhpUnitPreferences.isBootstrapEnabled(this.phpModule), PhpUnitPreferences.getBootstrapPath(this.phpModule), this.bootstrapCheckBox, this.bootstrapTextField);
        this.bootstrapForCreateTestsCheckBox.setSelected(PhpUnitPreferences.isBootstrapForCreateTests(this.phpModule));
        this.initFile(PhpUnitPreferences.isConfigurationEnabled(this.phpModule), PhpUnitPreferences.getConfigurationPath(this.phpModule), this.configurationCheckBox, this.configurationTextField);
        this.initFile(PhpUnitPreferences.isCustomSuiteEnabled(this.phpModule), PhpUnitPreferences.getCustomSuitePath(this.phpModule), this.suiteCheckBox, this.suiteTextField);
        this.initFile(PhpUnitPreferences.isPhpUnitEnabled(this.phpModule), PhpUnitPreferences.getPhpUnitPath(this.phpModule), this.scriptCheckBox, this.scriptTextField);
        this.runPhpUnitOnlyCheckBox.setSelected(PhpUnitPreferences.getRunPhpUnitOnly(this.phpModule));
        this.runTestUsingUnitCheckBox.setSelected(PhpUnitPreferences.getRunAllTestFiles(this.phpModule));
        this.askForTestGroupsCheckBox.setSelected(PhpUnitPreferences.getAskForTestGroups(this.phpModule));
        this.initPhpUnitVersion();
        this.enableFile(this.bootstrapCheckBox.isSelected(), this.bootstrapLabel, this.bootstrapTextField, this.bootstrapGenerateButton, this.bootstrapBrowseButton, this.bootstrapForCreateTestsCheckBox);
        this.enableFile(this.configurationCheckBox.isSelected(), this.configurationLabel, this.configurationTextField, this.configurationGenerateButton, this.configurationBrowseButton);
        this.enableFile(this.suiteCheckBox.isSelected(), this.suiteLabel, this.suiteTextField, this.suiteBrowseButton, this.suiteInfoLabel);
        this.enableFile(this.scriptCheckBox.isSelected(), this.scriptLabel, this.scriptTextField, this.scriptBrowseButton);
        this.addListeners();
        this.validateData();
        this.category.setStoreListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizerPhpUnit.this.storeData();
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.project.ui.customizer.CustomizerPhpUnit");
    }

    void enableFile(boolean enabled, JComponent ... components) {
        for (JComponent component : components) {
            component.setEnabled(enabled);
        }
    }

    void validateData() {
        ValidationResult result = new PhpUnitPreferencesValidator().validateBootstrap(this.bootstrapCheckBox.isSelected(), this.bootstrapTextField.getText()).validateConfiguration(this.configurationCheckBox.isSelected(), this.configurationTextField.getText()).validateCustomSuite(this.suiteCheckBox.isSelected(), this.suiteTextField.getText()).validatePhpUnit(this.scriptCheckBox.isSelected(), this.scriptTextField.getText()).getResult();
        Iterator iterator = result.getErrors().iterator();
        if (iterator.hasNext()) {
            ValidationResult.Message message = (ValidationResult.Message)iterator.next();
            this.category.setErrorMessage(message.getMessage());
            this.category.setValid(false);
            return;
        }
        iterator = result.getWarnings().iterator();
        if (iterator.hasNext()) {
            ValidationResult.Message message = (ValidationResult.Message)iterator.next();
            this.category.setErrorMessage(message.getMessage());
            this.category.setValid(true);
            return;
        }
        this.category.setErrorMessage(null);
        this.category.setValid(true);
    }

    void updatePhpUnitVersion() {
        assert (EventQueue.isDispatchThread());
        ValidationResult result = new PhpUnitPreferencesValidator().validatePhpUnit(this.scriptCheckBox.isSelected(), this.scriptTextField.getText()).getResult();
        if (result.hasErrors() || result.hasWarnings()) {
            this.versionLineLabel.setText(Bundle.CustomizerPhpUnit_notFound_phpUnit_version());
            return;
        }
        this.setPhpUnitVersion();
    }

    private boolean resetPhpUnitVersions() {
        return this.scriptCheckBox.isSelected() != PhpUnitPreferences.isPhpUnitEnabled(this.phpModule) || !this.scriptTextField.getText().equals(PhpUnitPreferences.getPhpUnitPath(this.phpModule));
    }

    void storeData() {
        if (this.resetPhpUnitVersions()) {
            PhpUnit.resetVersions();
        }
        PhpUnitPreferences.setBootstrapEnabled(this.phpModule, this.bootstrapCheckBox.isSelected());
        PhpUnitPreferences.setBootstrapPath(this.phpModule, this.bootstrapTextField.getText());
        PhpUnitPreferences.setBootstrapForCreateTests(this.phpModule, this.bootstrapForCreateTestsCheckBox.isSelected());
        PhpUnitPreferences.setConfigurationEnabled(this.phpModule, this.configurationCheckBox.isSelected());
        PhpUnitPreferences.setConfigurationPath(this.phpModule, this.configurationTextField.getText());
        PhpUnitPreferences.setCustomSuiteEnabled(this.phpModule, this.suiteCheckBox.isSelected());
        PhpUnitPreferences.setCustomSuitePath(this.phpModule, this.suiteTextField.getText());
        PhpUnitPreferences.setPhpUnitEnabled(this.phpModule, this.scriptCheckBox.isSelected());
        PhpUnitPreferences.setPhpUnitPath(this.phpModule, this.scriptTextField.getText());
        PhpUnitPreferences.setRunPhpUnitOnly(this.phpModule, this.runPhpUnitOnlyCheckBox.isSelected());
        PhpUnitPreferences.setRunAllTestFiles(this.phpModule, this.runTestUsingUnitCheckBox.isSelected());
        PhpUnitPreferences.setAskForTestGroups(this.phpModule, this.askForTestGroupsCheckBox.isSelected());
    }

    private void initFile(boolean enabled, String file, JCheckBox checkBox, JTextField textField) {
        checkBox.setSelected(enabled);
        textField.setText(file);
    }

    private void addListeners() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.bootstrapCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerPhpUnit.this.enableFile(e.getStateChange() == 1, CustomizerPhpUnit.this.bootstrapLabel, CustomizerPhpUnit.this.bootstrapTextField, CustomizerPhpUnit.this.bootstrapGenerateButton, CustomizerPhpUnit.this.bootstrapBrowseButton, CustomizerPhpUnit.this.bootstrapForCreateTestsCheckBox);
                CustomizerPhpUnit.this.validateData();
            }
        });
        this.bootstrapTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.bootstrapForCreateTestsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerPhpUnit.this.validateData();
            }
        });
        this.configurationCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerPhpUnit.this.enableFile(e.getStateChange() == 1, CustomizerPhpUnit.this.configurationLabel, CustomizerPhpUnit.this.configurationTextField, CustomizerPhpUnit.this.configurationGenerateButton, CustomizerPhpUnit.this.configurationBrowseButton);
                CustomizerPhpUnit.this.validateData();
            }
        });
        this.configurationTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.suiteCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerPhpUnit.this.enableFile(e.getStateChange() == 1, CustomizerPhpUnit.this.suiteLabel, CustomizerPhpUnit.this.suiteTextField, CustomizerPhpUnit.this.suiteBrowseButton, CustomizerPhpUnit.this.suiteInfoLabel);
                CustomizerPhpUnit.this.validateData();
            }
        });
        this.suiteTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.scriptCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerPhpUnit.this.enableFile(e.getStateChange() == 1, CustomizerPhpUnit.this.scriptLabel, CustomizerPhpUnit.this.scriptTextField, CustomizerPhpUnit.this.scriptBrowseButton);
                CustomizerPhpUnit.this.validateData();
                CustomizerPhpUnit.this.updatePhpUnitVersion();
            }
        });
        this.scriptTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.scriptTextField.getDocument().addDocumentListener(new PhpUnitScriptDocumentListener());
        ItemListener validateItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerPhpUnit.this.validateData();
            }
        };
        this.runPhpUnitOnlyCheckBox.addItemListener(validateItemListener);
        this.runTestUsingUnitCheckBox.addItemListener(validateItemListener);
        this.askForTestGroupsCheckBox.addItemListener(validateItemListener);
    }

    private File getDefaultDirectory() {
        File defaultDirectory;
        FileObject testDirectory = this.phpModule.getTestDirectory(null);
        if (testDirectory != null) {
            defaultDirectory = FileUtil.toFile((FileObject)testDirectory);
        } else {
            FileObject sourcesDirectory = this.phpModule.getSourceDirectory();
            assert (sourcesDirectory != null);
            defaultDirectory = FileUtil.toFile((FileObject)sourcesDirectory);
        }
        assert (defaultDirectory != null);
        return defaultDirectory;
    }

    private boolean checkTestDirectory() {
        if (this.phpModule.getTestDirectory(null) == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.CustomizerPhpUnit_error_noTestDir(), 1));
            return false;
        }
        return true;
    }

    private void initPhpUnitVersion() {
        this.setPhpUnitVersion();
    }

    private void setPhpUnitVersion() {
        assert (EventQueue.isDispatchThread());
        this.versionLineLabel.setText(Bundle.CustomizerPhpUnit_getting_phpUnit_version());
        String phpUnitPath = this.scriptCheckBox.isSelected() ? this.scriptTextField.getText().trim() : PhpUnitOptions.getInstance().getPhpUnitPath();
        if (!StringUtils.hasText((String)phpUnitPath)) {
            SwingUtilities.invokeLater(() -> this.versionLineLabel.setText(Bundle.CustomizerPhpUnit_notFound_phpUnit_version()));
        } else {
            RP.post(() -> {
                String versionLine = PhpUnit.getVersionLine(phpUnitPath);
                SwingUtilities.invokeLater(() -> this.versionLineLabel.setText(versionLine));
            });
        }
    }

    private void initComponents() {
        this.bootstrapLabel = new JLabel();
        this.bootstrapTextField = new JTextField();
        this.bootstrapBrowseButton = new JButton();
        this.bootstrapGenerateButton = new JButton();
        this.bootstrapForCreateTestsCheckBox = new JCheckBox();
        this.configurationCheckBox = new JCheckBox();
        this.configurationLabel = new JLabel();
        this.configurationTextField = new JTextField();
        this.configurationBrowseButton = new JButton();
        this.bootstrapCheckBox = new JCheckBox();
        this.configurationGenerateButton = new JButton();
        this.suiteCheckBox = new JCheckBox();
        this.suiteLabel = new JLabel();
        this.suiteTextField = new JTextField();
        this.suiteBrowseButton = new JButton();
        this.suiteInfoLabel = new JLabel();
        this.scriptCheckBox = new JCheckBox();
        this.scriptLabel = new JLabel();
        this.scriptTextField = new JTextField();
        this.scriptBrowseButton = new JButton();
        this.runPhpUnitOnlyCheckBox = new JCheckBox();
        this.runTestUsingUnitCheckBox = new JCheckBox();
        this.askForTestGroupsCheckBox = new JCheckBox();
        this.versionLabel = new JLabel();
        this.versionLineLabel = new JLabel();
        this.bootstrapLabel.setLabelFor(this.bootstrapTextField);
        Mnemonics.setLocalizedText((JLabel)this.bootstrapLabel, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapLabel.text"));
        this.bootstrapTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.bootstrapBrowseButton, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapBrowseButton.text"));
        this.bootstrapBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPhpUnit.this.bootstrapBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bootstrapGenerateButton, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapGenerateButton.text"));
        this.bootstrapGenerateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPhpUnit.this.bootstrapGenerateButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bootstrapForCreateTestsCheckBox, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapForCreateTestsCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.configurationCheckBox, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationCheckBox.text"));
        this.configurationLabel.setLabelFor(this.configurationTextField);
        Mnemonics.setLocalizedText((JLabel)this.configurationLabel, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationLabel.text"));
        this.configurationTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.configurationBrowseButton, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationBrowseButton.text"));
        this.configurationBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPhpUnit.this.configurationBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bootstrapCheckBox, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.configurationGenerateButton, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationGenerateButton.text"));
        this.configurationGenerateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPhpUnit.this.configurationGenerateButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.suiteCheckBox, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteCheckBox.text"));
        this.suiteLabel.setLabelFor(this.suiteTextField);
        Mnemonics.setLocalizedText((JLabel)this.suiteLabel, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteLabel.text"));
        this.suiteTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.suiteBrowseButton, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteBrowseButton.text"));
        this.suiteBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPhpUnit.this.suiteBrowseButtonActionPerformed(evt);
            }
        });
        this.suiteInfoLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.suiteInfoLabel, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteInfoLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.scriptCheckBox, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.scriptCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.scriptLabel, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.scriptLabel.text"));
        this.scriptTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.scriptBrowseButton, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.scriptBrowseButton.text"));
        this.scriptBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPhpUnit.this.scriptBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.runPhpUnitOnlyCheckBox, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.runPhpUnitOnlyCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.runTestUsingUnitCheckBox, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.runTestUsingUnitCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.askForTestGroupsCheckBox, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.askForTestGroupsCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.versionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.versionLineLabel, (String)"VERSION");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.configurationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configurationTextField, -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configurationBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configurationGenerateButton)).addGroup(layout.createSequentialGroup().addComponent(this.suiteLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.suiteInfoLabel).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.suiteTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.suiteBrowseButton)))).addGroup(layout.createSequentialGroup().addComponent(this.bootstrapForCreateTestsCheckBox).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.bootstrapLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bootstrapTextField, -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bootstrapBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bootstrapGenerateButton)).addGroup(layout.createSequentialGroup().addComponent(this.scriptLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scriptTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scriptBrowseButton)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.configurationCheckBox).addComponent(this.suiteCheckBox).addComponent(this.bootstrapCheckBox).addComponent(this.runTestUsingUnitCheckBox).addComponent(this.askForTestGroupsCheckBox).addComponent(this.scriptCheckBox).addComponent(this.runPhpUnitOnlyCheckBox)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionLineLabel).addGap(0, 0, Short.MAX_VALUE)));
        layout.linkSize(0, this.bootstrapBrowseButton, this.bootstrapGenerateButton, this.configurationBrowseButton, this.configurationGenerateButton, this.scriptBrowseButton, this.suiteBrowseButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.bootstrapCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bootstrapLabel).addComponent(this.bootstrapTextField, -2, -1, -2).addComponent(this.bootstrapGenerateButton).addComponent(this.bootstrapBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bootstrapForCreateTestsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.configurationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configurationLabel).addComponent(this.configurationTextField, -2, -1, -2).addComponent(this.configurationGenerateButton).addComponent(this.configurationBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.suiteCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.suiteLabel).addComponent(this.suiteTextField, -2, -1, -2).addComponent(this.suiteBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.suiteInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scriptCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scriptLabel).addComponent(this.scriptTextField, -2, -1, -2).addComponent(this.scriptBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.runPhpUnitOnlyCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.runTestUsingUnitCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.askForTestGroupsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionLabel).addComponent(this.versionLineLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.bootstrapLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapLabel.AccessibleContext.accessibleName"));
        this.bootstrapLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapLabel.AccessibleContext.accessibleDescription"));
        this.bootstrapTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapTextField.AccessibleContext.accessibleName"));
        this.bootstrapTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapTextField.AccessibleContext.accessibleDescription"));
        this.bootstrapBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapBrowseButton.AccessibleContext.accessibleName"));
        this.bootstrapBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapBrowseButton.AccessibleContext.accessibleDescription"));
        this.bootstrapGenerateButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapGenerateButton.AccessibleContext.accessibleName"));
        this.bootstrapGenerateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapGenerateButton.AccessibleContext.accessibleDescription"));
        this.bootstrapForCreateTestsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapForCreateTestsCheckBox.AccessibleContext.accessibleName"));
        this.bootstrapForCreateTestsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapForCreateTestsCheckBox.AccessibleContext.accessibleDescription"));
        this.configurationCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationCheckBox.AccessibleContext.accessibleName"));
        this.configurationCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationCheckBox.AccessibleContext.accessibleDescription"));
        this.configurationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationLabel.AccessibleContext.accessibleName"));
        this.configurationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationLabel.AccessibleContext.accessibleDescription"));
        this.configurationTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationTextField.AccessibleContext.accessibleName"));
        this.configurationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationTextField.AccessibleContext.accessibleDescription"));
        this.configurationBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationBrowseButton.AccessibleContext.accessibleName"));
        this.configurationBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationBrowseButton.AccessibleContext.accessibleDescription"));
        this.bootstrapCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapCheckBox.AccessibleContext.accessibleName"));
        this.bootstrapCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapCheckBox.AccessibleContext.accessibleDescription"));
        this.configurationGenerateButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationGenerateButton.AccessibleContext.accessibleName"));
        this.configurationGenerateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationGenerateButton.AccessibleContext.accessibleDescription"));
        this.suiteCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteCheckBox.AccessibleContext.accessibleName"));
        this.suiteCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteCheckBox.AccessibleContext.accessibleDescription"));
        this.suiteLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteLabel.AccessibleContext.accessibleName"));
        this.suiteLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteLabel.AccessibleContext.accessibleDescription"));
        this.suiteTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteTextField.AccessibleContext.accessibleName"));
        this.suiteTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteTextField.AccessibleContext.accessibleDescription"));
        this.suiteBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteBrowseButton.AccessibleContext.accessibleName"));
        this.suiteBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteBrowseButton.AccessibleContext.accessibleDescription"));
        this.suiteInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteInfoLabel.AccessibleContext.accessibleName"));
        this.suiteInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteInfoLabel.AccessibleContext.accessibleDescription"));
        this.versionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.versionLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.AccessibleContext.accessibleDescription"));
    }

    private void bootstrapBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(CustomizerPhpUnit.class).setTitle(Bundle.CustomizerPhpUnit_chooser_bootstrap()).setFilesOnly(true).setDefaultWorkingDirectory(this.getDefaultDirectory()).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.bootstrapTextField.setText(file.getAbsolutePath());
        }
    }

    private void bootstrapGenerateButtonActionPerformed(ActionEvent evt) {
        File bootstrap;
        if (this.checkTestDirectory() && (bootstrap = PhpUnit.createBootstrapFile(this.phpModule)) != null) {
            this.bootstrapTextField.setText(bootstrap.getAbsolutePath());
        }
    }

    private void configurationBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(CustomizerPhpUnit.class).setTitle(Bundle.CustomizerPhpUnit_chooser_configuration()).setFilesOnly(true).setDefaultWorkingDirectory(this.getDefaultDirectory()).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.configurationTextField.setText(file.getAbsolutePath());
        }
    }

    private void configurationGenerateButtonActionPerformed(ActionEvent evt) {
        File configuration;
        if (this.checkTestDirectory() && (configuration = PhpUnit.createConfigurationFile(this.phpModule)) != null) {
            this.configurationTextField.setText(configuration.getAbsolutePath());
        }
    }

    private void suiteBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(CustomizerPhpUnit.class).setTitle(Bundle.CustomizerPhpUnit_chooser_suite()).setFilesOnly(true).setDefaultWorkingDirectory(this.getDefaultDirectory()).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.suiteTextField.setText(file.getAbsolutePath());
        }
    }

    private void scriptBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(CustomizerPhpUnit.class).setTitle(Bundle.CustomizerPhpUnit_chooser_phpUnit()).setFilesOnly(true).setDefaultWorkingDirectory(this.getDefaultDirectory()).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.scriptTextField.setText(file.getAbsolutePath());
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            CustomizerPhpUnit.this.validateData();
        }
    }

    private final class PhpUnitScriptDocumentListener
    implements DocumentListener {
        private PhpUnitScriptDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            CustomizerPhpUnit.this.updatePhpUnitVersion();
        }
    }

    private static class PhpUnitVersionComboBoxModel
    extends DefaultComboBoxModel<PhpUnitVersion> {
        private static final long serialVersionUID = 5850175934190021687L;

        public PhpUnitVersionComboBoxModel() {
            this((PhpUnitVersion)null);
        }

        public PhpUnitVersionComboBoxModel(PhpUnitVersion preselected) {
            super(PhpUnitVersion.values());
            if (preselected != null) {
                this.setSelectedItem((Object)preselected);
            } else {
                this.setSelectedItem((Object)PhpUnitVersion.getDefault());
            }
        }
    }
}

