/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.ImageCapabilitySchemaDescriptor;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="descriptorType")
@JsonFilter(value="explicitlySetFilter")
public final class BooleanImageCapabilitySchemaDescriptor
extends ImageCapabilitySchemaDescriptor {
    @JsonProperty(value="defaultValue")
    private final Boolean defaultValue;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public BooleanImageCapabilitySchemaDescriptor(ImageCapabilitySchemaDescriptor.Source source, Boolean defaultValue) {
        super(source);
        this.defaultValue = defaultValue;
    }

    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BooleanImageCapabilitySchemaDescriptor(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", defaultValue=").append(String.valueOf(this.defaultValue));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BooleanImageCapabilitySchemaDescriptor)) {
            return false;
        }
        BooleanImageCapabilitySchemaDescriptor other = (BooleanImageCapabilitySchemaDescriptor)((Object)o);
        return Objects.equals(this.defaultValue, other.defaultValue) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.defaultValue == null ? 43 : this.defaultValue.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="source")
        private ImageCapabilitySchemaDescriptor.Source source;
        @JsonProperty(value="defaultValue")
        private Boolean defaultValue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder source(ImageCapabilitySchemaDescriptor.Source source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder defaultValue(Boolean defaultValue) {
            this.defaultValue = defaultValue;
            this.__explicitlySet__.add("defaultValue");
            return this;
        }

        public BooleanImageCapabilitySchemaDescriptor build() {
            BooleanImageCapabilitySchemaDescriptor model = new BooleanImageCapabilitySchemaDescriptor(this.source, this.defaultValue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BooleanImageCapabilitySchemaDescriptor model) {
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("defaultValue")) {
                this.defaultValue(model.getDefaultValue());
            }
            return this;
        }
    }
}

