/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum Severity implements Api
{
    LOW("LOW", "LOW"),
    MEDIUM("MEDIUM", "MEDIUM"),
    HIGH("HIGH", "HIGH"),
    CRITICAL("CRITICAL", "CRITICAL"),
    NONE("-", ""),
    NOT_FOUND("", "");

    private final String uiString;
    private final String apiString;

    private Severity(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public Severity getDefault() {
        return NONE;
    }

    @Override
    public Severity getNotFound() {
        return NOT_FOUND;
    }

    public Severity[] getAll() {
        return Severity.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static Severity fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        switch (text) {
            case "low": 
            case "LOW": 
            case "Low": {
                return LOW;
            }
            case "medium": 
            case "MEDIUM": 
            case "Medium": {
                return MEDIUM;
            }
            case "high": 
            case "HIGH": 
            case "High": {
                return HIGH;
            }
            case "critical": 
            case "CRITICAL": 
            case "Critical": {
                return CRITICAL;
            }
        }
        return NOT_FOUND;
    }

    public static List<Severity> getAsList() {
        return Arrays.asList(Severity.values());
    }
}

