/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.spi.debugger.ui.BreakpointAnnotation;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class BreakpointCustomizeAction
extends SystemAction
implements ContextAwareAction {
    public BreakpointCustomizeAction() {
        this.setEnabled(false);
    }

    public String getName() {
        return NbBundle.getMessage(BreakpointCustomizeAction.class, (String)"CTL_customize");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public void actionPerformed(ActionEvent ev) {
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        Collection ann = actionContext.lookupAll(BreakpointAnnotation.class);
        if (ann.size() == 1) {
            return new BreakpointAwareAction((BreakpointAnnotation)((Object)ann.iterator().next()));
        }
        return this;
    }

    private class BreakpointAwareAction
    implements Action,
    Presenter.Popup {
        private BreakpointAnnotation ann;

        public BreakpointAwareAction(BreakpointAnnotation ann) {
            this.ann = ann;
        }

        public JMenuItem getPopupPresenter() {
            return new Actions.MenuItem((Action)this, false);
        }

        @Override
        public Object getValue(String key) {
            return BreakpointCustomizeAction.this.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public boolean isEnabled() {
            return this.getCustomizerClass(this.ann.getBreakpoint()) != null;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            BreakpointCustomizeAction.this.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            BreakpointCustomizeAction.this.removePropertyChangeListener(listener);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.customize(this.ann.getBreakpoint());
        }

        private BeanInfo findBeanInfo(Class clazz) {
            Class<?> biClass;
            try {
                biClass = ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass(clazz.getName() + "BeanInfo");
            }
            catch (ClassNotFoundException cnfex) {
                biClass = null;
            }
            if (biClass == null) {
                if ((clazz = clazz.getSuperclass()) != null) {
                    return this.findBeanInfo(clazz);
                }
                return null;
            }
            try {
                Constructor c = biClass.getConstructor(new Class[0]);
                c.setAccessible(true);
                return (BeanInfo)c.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        private Class getCustomizerClass(Breakpoint b) {
            BeanDescriptor bd;
            BeanInfo bi = this.findBeanInfo(b.getClass());
            if (bi == null) {
                try {
                    bi = Introspector.getBeanInfo(b.getClass());
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }
            if ((bd = bi.getBeanDescriptor()) == null) {
                return null;
            }
            Class<?> cc = bd.getCustomizerClass();
            return cc;
        }

        private Customizer getCustomizer(Breakpoint b) {
            Class cc = this.getCustomizerClass(b);
            if (cc == null) {
                return null;
            }
            try {
                Customizer c = (Customizer)cc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                c.setObject(b);
                return c;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        private void customize(Breakpoint b) {
            Dialog d;
            String accessibleDescription;
            Customizer c = this.getCustomizer(b);
            if (c == null) {
                return;
            }
            HelpCtx helpCtx = HelpCtx.findHelp((Object)c);
            if (helpCtx == null) {
                helpCtx = new HelpCtx("debug.add.breakpoint");
            }
            final Controller[] cPtr = new Controller[]{null};
            if (c instanceof Controller) {
                cPtr[0] = (Controller)((Object)c);
            }
            final DialogDescriptor[] descriptorPtr = new DialogDescriptor[1];
            final Dialog[] dialogPtr = new Dialog[1];
            ActionListener buttonsActionListener = null;
            if (cPtr[0] != null) {
                buttonsActionListener = new ActionListener(){
                    final /* synthetic */ BreakpointAwareAction this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (descriptorPtr[0].getValue() == DialogDescriptor.OK_OPTION) {
                            boolean ok = cPtr[0].ok();
                            if (ok) {
                                dialogPtr[0].setVisible(false);
                            }
                        } else {
                            dialogPtr[0].setVisible(false);
                        }
                    }
                };
            }
            DialogDescriptor descriptor = new DialogDescriptor((Object)c, NbBundle.getMessage(BreakpointCustomizeAction.class, (String)"CTL_Breakpoint_Customizer_Title"), true, 2, DialogDescriptor.OK_OPTION, 0, helpCtx, buttonsActionListener);
            if (buttonsActionListener != null) {
                descriptor.setClosingOptions(new Object[0]);
            }
            if ((accessibleDescription = (d = DialogDisplayer.getDefault().createDialog(descriptor)).getAccessibleContext().getAccessibleDescription()) == null) {
                if (c instanceof JComponent) {
                    accessibleDescription = ((JComponent)((Object)c)).getAccessibleContext().getAccessibleDescription();
                }
                if (accessibleDescription == null) {
                    accessibleDescription = NbBundle.getMessage(BreakpointCustomizeAction.class, (String)"ACSD_Breakpoint_Customizer", (Object)b);
                }
                d.getAccessibleContext().setAccessibleDescription(accessibleDescription);
            }
            d.pack();
            descriptorPtr[0] = descriptor;
            dialogPtr[0] = d;
            d.setVisible(true);
        }
    }
}

