/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.resources.api.model;

import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.openide.filesystems.FileObject;

public final class JndiResourcesModelUnit {
    private final ClasspathInfo classPathInfo;
    private final ClassPath bootPath;
    private final ClassPath compilePath;
    private final ClassPath sourcePath;

    private JndiResourcesModelUnit(ClassPath bootPath, ClassPath compilePath, ClassPath sourcePath) {
        this.bootPath = bootPath;
        this.compilePath = compilePath;
        this.sourcePath = sourcePath;
        this.classPathInfo = ClasspathInfo.create((ClassPath)bootPath, (ClassPath)compilePath, (ClassPath)sourcePath);
    }

    public ClassPath getBootPath() {
        return this.bootPath;
    }

    public ClassPath getCompilePath() {
        return this.compilePath;
    }

    public ClassPath getSourcePath() {
        return this.sourcePath;
    }

    public ClasspathInfo getClassPathInfo() {
        return this.classPathInfo;
    }

    public static JndiResourcesModelUnit create(ClassPath bootPath, ClassPath compilePath, ClassPath sourcePath) {
        return new JndiResourcesModelUnit(bootPath, compilePath, sourcePath);
    }

    FileObject getSourceFileObject() {
        FileObject[] roots = this.sourcePath.getRoots();
        if (roots != null && roots.length > 0) {
            return roots[0];
        }
        return null;
    }

    public int hashCode() {
        return JndiResourcesModelUnit.computeModelUnitHash(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof JndiResourcesModelUnit) {
            JndiResourcesModelUnit unit = (JndiResourcesModelUnit)obj;
            return JndiResourcesModelUnit.hasClassPathesIdenticEntries(unit.getBootPath(), this.bootPath) && JndiResourcesModelUnit.hasClassPathesIdenticEntries(unit.compilePath, this.compilePath) && JndiResourcesModelUnit.hasClassPathesIdenticEntries(unit.sourcePath, this.sourcePath);
        }
        return false;
    }

    private static boolean hasClassPathesIdenticEntries(ClassPath cp1, ClassPath cp2) {
        if (cp1.entries().size() != cp2.entries().size()) {
            return false;
        }
        for (int i = 0; i < cp1.entries().size(); ++i) {
            if (((ClassPath.Entry)cp1.entries().get(i)).getURL().sameFile(((ClassPath.Entry)cp2.entries().get(i)).getURL())) continue;
            return false;
        }
        return true;
    }

    private static int computeModelUnitHash(JndiResourcesModelUnit unit) {
        return JndiResourcesModelUnit.computeClassPathHash(unit.getBootPath()) + JndiResourcesModelUnit.computeClassPathHash(unit.getCompilePath()) + JndiResourcesModelUnit.computeClassPathHash(unit.getSourcePath());
    }

    private static int computeClassPathHash(ClassPath classPath) {
        int hashValue = 0;
        for (ClassPath.Entry entry : classPath.entries()) {
            hashValue += entry.getURL().getPath().hashCode();
        }
        return hashValue;
    }
}

