/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.impl.metamodel;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;
import org.netbeans.modules.web.jsf.impl.facesmodel.AnnotationRenderer;
import org.netbeans.modules.web.jsf.impl.metamodel.Refreshable;

class RendererImpl
extends AnnotationRenderer
implements Refreshable {
    private String myClass;
    private String myType;
    private String myKitId;
    private String myComponentFamily;

    RendererImpl(AnnotationModelHelper helper, TypeElement typeElement) {
        super(helper, typeElement);
        boolean valid = this.refresh(typeElement);
        assert (valid);
    }

    @Override
    protected String getRenderKitId() {
        return this.myKitId;
    }

    @Override
    public boolean refresh(TypeElement type) {
        Map types = this.getHelper().getAnnotationsByType(this.getHelper().getCompilationController().getElements().getAllAnnotationMirrors(type));
        AnnotationMirror annotationMirror = (AnnotationMirror)types.get("jakarta.faces.render.FacesRenderer");
        if (annotationMirror == null) {
            annotationMirror = (AnnotationMirror)types.get("javax.faces.render.FacesRenderer");
        }
        if (annotationMirror == null) {
            return false;
        }
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.getHelper());
        parser.expectString("renderKitId", AnnotationParser.defaultValue((Object)"HTML_BASIC"));
        parser.expectString("rendererType", null);
        parser.expectString("componentFamily", null);
        ParseResult parseResult = parser.parse(annotationMirror);
        this.myKitId = (String)parseResult.get("renderKitId", String.class);
        this.myClass = type.getQualifiedName().toString();
        this.myType = (String)parseResult.get("rendererType", String.class);
        this.myComponentFamily = (String)parseResult.get("componentFamily", String.class);
        return true;
    }

    @Override
    public String getRendererClass() {
        return this.myClass;
    }

    @Override
    public String getRendererType() {
        return this.myType;
    }

    @Override
    public String getComponentFamily() {
        return this.myComponentFamily;
    }
}

