/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Tag;
import org.languagetool.language.Demo;
import org.languagetool.rules.FakeRule;
import org.languagetool.rules.GRPCPostProcessing;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.ml.MLServerProto;

public class GRPCPostProcessingTest {
    @Test
    public void testRuleMatchModification() throws Exception {
        GRPCPostProcessingMock instance = new GRPCPostProcessingMock();
        JLanguageTool lt = new JLanguageTool((Language)new Demo());
        List sentenceList = lt.analyzeText("This is a test. This is another sentence.");
        List<RuleMatch> matches = Arrays.asList(new RuleMatch((Rule)new FakeRule(), (AnalyzedSentence)sentenceList.get(0), 0, 1, "first match"), new RuleMatch((Rule)new FakeRule(), (AnalyzedSentence)sentenceList.get(1), ((AnalyzedSentence)sentenceList.get(0)).getText().length() + 3, ((AnalyzedSentence)sentenceList.get(0)).getText().length() + 5, "second match"));
        List<RuleMatch> original = Arrays.asList(new RuleMatch((Rule)new FakeRule(), (AnalyzedSentence)sentenceList.get(0), 0, 1, "first match"), new RuleMatch((Rule)new FakeRule(), (AnalyzedSentence)sentenceList.get(1), ((AnalyzedSentence)sentenceList.get(0)).getText().length() + 3, ((AnalyzedSentence)sentenceList.get(0)).getText().length() + 5, "second match"));
        List transformed = instance.filter(sentenceList, matches, 0L, false);
        Assert.assertEquals((String)"matches are equal after postprocessing", original, (Object)transformed);
    }

    @Test
    public void testTagEnums() {
        Tag[] javaValues = Tag.values();
        MLServerProto.Rule.Tag[] protoValues = MLServerProto.Rule.Tag.values();
        Assert.assertEquals((String)"Tags in Java and Protobuf are equal", Arrays.stream(javaValues).map(t -> t.name()).sorted().collect(Collectors.toList()), Arrays.stream(protoValues).map(t -> t.name()).filter(s -> !s.equals("UNRECOGNIZED")).sorted().collect(Collectors.toList()));
    }

    @Test
    public void testMatchTypeEnums() {
        RuleMatch.Type[] javaValues = RuleMatch.Type.values();
        MLServerProto.Match.MatchType[] protoValues = MLServerProto.Match.MatchType.values();
        Assert.assertEquals((String)"Match types in Java and Protobuf are equal", Arrays.stream(javaValues).map(t -> t.name()).sorted().collect(Collectors.toList()), Arrays.stream(protoValues).map(t -> t.name()).filter(s -> !s.equals("UNRECOGNIZED")).sorted().collect(Collectors.toList()));
    }

    @Test
    public void testSuggestionTypeEnums() {
        SuggestedReplacement.SuggestionType[] javaValues = SuggestedReplacement.SuggestionType.values();
        MLServerProto.SuggestedReplacement.SuggestionType[] protoValues = MLServerProto.SuggestedReplacement.SuggestionType.values();
        Assert.assertEquals((String)"Suggestion types in Java and Protobuf are equal", Arrays.stream(javaValues).map(t -> t.name()).sorted().collect(Collectors.toList()), Arrays.stream(protoValues).map(t -> t.name()).filter(s -> !s.equals("UNRECOGNIZED")).sorted().collect(Collectors.toList()));
    }

    static class GRPCPostProcessingMock
    extends GRPCPostProcessing {
        static RemoteRuleConfig config = new RemoteRuleConfig();

        GRPCPostProcessingMock() throws Exception {
            super(config);
        }

        protected MLServerProto.MatchResponse sendRequest(MLServerProto.PostProcessingRequest req, long timeout) throws TimeoutException {
            throw new TimeoutException("Testing timeouts");
        }

        static {
            GRPCPostProcessingMock.config.url = "localhost";
            GRPCPostProcessingMock.config.port = 1234;
            GRPCPostProcessingMock.config.ruleId = "TEST";
        }
    }
}

