/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryAttributes;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoverySender;

@Deprecated
public class UDPDiscoverySenderThread
implements Runnable {
    private static final Log log = LogManager.getLog(UDPDiscoverySenderThread.class);
    private final UDPDiscoveryAttributes attributes;
    private ArrayList<String> cacheNames = new ArrayList();

    protected void setCacheNames(ArrayList<String> cacheNames) {
        log.info("Resetting cacheNames = [{0}]", cacheNames);
        this.cacheNames = cacheNames;
    }

    protected ArrayList<String> getCacheNames() {
        return this.cacheNames;
    }

    public UDPDiscoverySenderThread(UDPDiscoveryAttributes attributes, ArrayList<String> cacheNames) {
        this.attributes = attributes;
        this.cacheNames = cacheNames;
        Supplier[] supplierArray = new Supplier[4];
        supplierArray[0] = attributes::getUdpDiscoveryAddr;
        supplierArray[1] = attributes::getUdpDiscoveryPort;
        supplierArray[2] = attributes::getServiceAddress;
        supplierArray[3] = attributes::getServicePort;
        log.debug("Creating sender thread for discoveryAddress = [{0}] and discoveryPort = [{1}] myHostName = [{2}] and port = [{3}]", supplierArray);
        try (UDPDiscoverySender sender = new UDPDiscoverySender(attributes.getUdpDiscoveryAddr(), attributes.getUdpDiscoveryPort(), attributes.getUdpTTL());){
            sender.requestBroadcast();
            log.debug("Sent a request broadcast to the group");
        }
        catch (IOException e) {
            log.error("Problem sending a Request Broadcast", e);
        }
    }

    @Override
    public void run() {
        try (UDPDiscoverySender sender = new UDPDiscoverySender(this.attributes.getUdpDiscoveryAddr(), this.attributes.getUdpDiscoveryPort(), this.attributes.getUdpTTL());){
            sender.passiveBroadcast(this.attributes.getServiceAddress(), this.attributes.getServicePort(), this.cacheNames);
            log.debug("Called sender to issue a passive broadcast");
        }
        catch (IOException e) {
            log.error("Problem calling the UDP Discovery Sender [{0}:{1}]", this.attributes.getUdpDiscoveryAddr(), this.attributes.getUdpDiscoveryPort(), e);
        }
    }

    protected void shutdown() {
        try (UDPDiscoverySender sender = new UDPDiscoverySender(this.attributes.getUdpDiscoveryAddr(), this.attributes.getUdpDiscoveryPort(), this.attributes.getUdpTTL());){
            sender.removeBroadcast(this.attributes.getServiceAddress(), this.attributes.getServicePort(), this.cacheNames);
            log.debug("Called sender to issue a remove broadcast in shutdown.");
        }
        catch (IOException e) {
            log.error("Problem calling the UDP Discovery Sender", e);
        }
    }
}

