/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.util.ArrayUtil;

public class ExceptionInfoEditor {
    private final CodeAttribute codeAttribute;

    public ExceptionInfoEditor(CodeAttribute codeAttribute) {
        this.codeAttribute = codeAttribute;
    }

    void prependException(ExceptionInfo exceptionInfo) {
        ExceptionInfo[] exceptionTable = this.codeAttribute.exceptionTable;
        int exceptionTableLength = this.codeAttribute.u2exceptionTableLength;
        int newExceptionTableLength = exceptionTableLength + 1;
        if (exceptionTable.length < newExceptionTableLength) {
            ExceptionInfo[] newExceptionTable = new ExceptionInfo[newExceptionTableLength];
            System.arraycopy(exceptionTable, 0, newExceptionTable, 1, exceptionTableLength);
            newExceptionTable[0] = exceptionInfo;
            this.codeAttribute.exceptionTable = newExceptionTable;
        } else {
            System.arraycopy(exceptionTable, 0, exceptionTable, 1, exceptionTableLength);
            exceptionTable[0] = exceptionInfo;
        }
        this.codeAttribute.u2exceptionTableLength = newExceptionTableLength;
    }

    void appendException(ExceptionInfo exceptionInfo) {
        this.codeAttribute.exceptionTable = ArrayUtil.add(this.codeAttribute.exceptionTable, this.codeAttribute.u2exceptionTableLength++, exceptionInfo);
    }
}

