/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.postgresql;

import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.server.postgresql.PostgreSQLEnumDataTypeHelper;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorOptions;
import schemacrawler.tools.databaseconnector.DatabaseConnectorOptionsBuilder;
import schemacrawler.tools.executable.commandline.PluginCommand;
import us.fatehi.utility.datasource.DatabaseConnectionSourceBuilder;
import us.fatehi.utility.datasource.DatabaseServerType;

public final class PostgreSQLDatabaseConnector
extends DatabaseConnector {
    private static DatabaseConnectorOptions databaseConnectorOptions() {
        DatabaseServerType dbServerType = new DatabaseServerType("postgresql", "PostgreSQL");
        DatabaseConnectionSourceBuilder connectionSourceBuilder = DatabaseConnectionSourceBuilder.builder((String)"jdbc:postgresql://${host}:${port}/${database}").withDefaultPort(5432).withDefaultUrlx("ApplicationName", "SchemaCrawler").withDefaultUrlx("loggerLevel", "DEBUG");
        PluginCommand pluginCommand = PluginCommand.newDatabasePluginCommand((DatabaseServerType)dbServerType);
        pluginCommand.addOption("server", String.class, new String[]{"--server=postgresql%nLoads SchemaCrawler plug-in for PostgreSQL"}).addOption("host", String.class, new String[]{"Host name%nOptional, uses the PGHOSTADDR and PGHOST environmental variables if available, or defaults to localhost"}).addOption("port", Integer.class, new String[]{"Port number%nOptional, uses the PGPORT environmental variable if available, or defaults to 5432"}).addOption("database", String.class, new String[]{"Database name%nOptional, uses the PGDATABASE environmental variable if available"});
        return (DatabaseConnectorOptions)DatabaseConnectorOptionsBuilder.builder((DatabaseServerType)dbServerType).withHelpCommand(pluginCommand).withUrlStartsWith("jdbc:postgresql:").withInformationSchemaViewsFromResourceFolder("/postgresql.information_schema").withSchemaRetrievalOptionsBuilder((schemaRetrievalOptionsBuilder, connection) -> schemaRetrievalOptionsBuilder.with(SchemaInfoMetadataRetrievalStrategy.tableColumnsRetrievalStrategy, MetadataRetrievalStrategy.metadata_over_schemas).withEnumDataTypeHelper((EnumDataTypeHelper)new PostgreSQLEnumDataTypeHelper())).withLimitOptionsBuilder(limitOptionsBuilder -> limitOptionsBuilder.includeSchemas((InclusionRule)new RegularExpressionExclusionRule("pg_catalog|information_schema"))).withDatabaseConnectionSourceBuilder(() -> connectionSourceBuilder).build();
    }

    public PostgreSQLDatabaseConnector() {
        super(PostgreSQLDatabaseConnector.databaseConnectorOptions());
    }
}

