/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler.impl;

import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.profiler.impl.WildcardFilter;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.graalvm.shadowed.org.json.JSONObject;

abstract class ProfilerCLI {
    public static final String UNKNOWN = "<Unknown>";

    ProfilerCLI() {
    }

    static SourceSectionFilter buildFilter(boolean roots, boolean statements, boolean calls, final boolean internals, final WildcardFilter filterRootName, final WildcardFilter filterFile, final String filterMimeType, final String filterLanguage) {
        SourceSectionFilter.Builder builder = SourceSectionFilter.newBuilder();
        if (!internals || filterFile != null || filterMimeType != null || filterLanguage != null) {
            builder.sourceIs(new SourceSectionFilter.SourcePredicate(){

                public boolean test(Source source) {
                    boolean internal = internals || !source.isInternal();
                    boolean file = filterFile.testWildcardExpressions(source.getPath());
                    boolean mimeType = filterMimeType.equals("") || filterMimeType.equals(source.getMimeType());
                    boolean languageId = filterLanguage.equals("") || filterMimeType.equals(source.getLanguage());
                    return internal && file && mimeType && languageId;
                }
            });
        }
        ArrayList<Class<StandardTags.CallTag>> tags = new ArrayList<Class<StandardTags.CallTag>>();
        if (roots) {
            tags.add(StandardTags.RootTag.class);
        }
        if (statements) {
            tags.add(StandardTags.StatementTag.class);
        }
        if (calls) {
            tags.add(StandardTags.CallTag.class);
        }
        if (!(roots || statements || calls)) {
            throw new IllegalArgumentException("No elements specified. Either roots, statements or calls must remain enabled.");
        }
        builder.tagIs(tags.toArray(new Class[0]));
        builder.rootNameIs((Predicate)new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return filterRootName.testWildcardExpressions(s);
            }
        });
        return builder.build();
    }

    static String repeat(String s, int times) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            b.append(s);
        }
        return b.toString();
    }

    static String getShortDescription(SourceSection sourceSection) {
        if (sourceSection == null) {
            return UNKNOWN;
        }
        if (sourceSection.getSource() == null) {
            return UNKNOWN;
        }
        StringBuilder b = new StringBuilder();
        Source source = sourceSection.getSource();
        URL url = source.getURL();
        if (url != null && !"file".equals(url.getProtocol())) {
            b.append(url.toExternalForm());
        } else if (source.getPath() != null) {
            try {
                Path pathAbsolute = new File(source.getPath()).toPath();
                Path pathBase = new File("").getAbsoluteFile().toPath();
                Path pathRelative = pathBase.relativize(pathAbsolute);
                b.append(pathRelative.toFile());
            }
            catch (IllegalArgumentException e) {
                b.append(source.getName());
            }
        } else {
            b.append(source.getName());
        }
        b.append("~").append(ProfilerCLI.formatIndices(sourceSection, true));
        return b.toString();
    }

    static String formatIndices(SourceSection sourceSection, boolean needsColumnSpecifier) {
        boolean singleLine;
        if (sourceSection == null) {
            return UNKNOWN;
        }
        StringBuilder b = new StringBuilder();
        boolean bl = singleLine = sourceSection.getStartLine() == sourceSection.getEndLine();
        if (singleLine) {
            b.append(sourceSection.getStartLine());
        } else {
            b.append(sourceSection.getStartLine()).append("-").append(sourceSection.getEndLine());
        }
        if (needsColumnSpecifier) {
            b.append(":");
            if (sourceSection.getCharLength() <= 1) {
                b.append(sourceSection.getCharIndex());
            } else {
                b.append(sourceSection.getCharIndex()).append("-").append(sourceSection.getCharIndex() + sourceSection.getCharLength() - 1);
            }
        }
        return b.toString();
    }

    static boolean testWildcardExpressions(String value, Object[] fileFilters) {
        if (fileFilters == null || fileFilters.length == 0) {
            return true;
        }
        if (value == null) {
            return false;
        }
        for (Object filter : fileFilters) {
            if (filter instanceof Pattern) {
                if (!((Pattern)filter).matcher(value).matches()) continue;
                return true;
            }
            if (filter instanceof String) {
                if (!filter.equals(value)) continue;
                return true;
            }
            throw new AssertionError();
        }
        return false;
    }

    static JSONObject sourceSectionToJSON(SourceSection sourceSection) {
        JSONObject sourceSectionJson = new JSONObject();
        if (sourceSection != null) {
            Source source = sourceSection.getSource();
            if (source != null) {
                String path;
                if (source.getLanguage() != null) {
                    sourceSectionJson.put("language", (Object)source.getLanguage().toString());
                }
                if ((path = source.getPath()) != null) {
                    sourceSectionJson.put("path", (Object)path);
                }
            }
            sourceSectionJson.put("source_name", (Object)sourceSection.getSource().getName());
            sourceSectionJson.put("start_line", sourceSection.getStartLine());
            sourceSectionJson.put("end_line", sourceSection.getEndLine());
            sourceSectionJson.put("start_column", sourceSection.getStartColumn());
            sourceSectionJson.put("end_column", sourceSection.getEndColumn());
        }
        return sourceSectionJson;
    }

    protected static AbstractTruffleException handleFileNotFound() {
        return new AbstractTruffleException(){
            static final long serialVersionUID = -1L;

            public String getMessage() {
                return "File IO Exception caught during output printing.";
            }
        };
    }

    static class SourceLocation {
        private final SourceSection sourceSection;
        private final String rootName;

        SourceLocation(SourceSection sourceSection, String rootName) {
            this.sourceSection = sourceSection;
            this.rootName = rootName;
        }

        SourceSection getSourceSection() {
            return this.sourceSection;
        }

        public String getRootName() {
            return this.rootName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourceLocation that = (SourceLocation)o;
            if (!Objects.equals(this.sourceSection, that.sourceSection)) {
                return false;
            }
            return Objects.equals(this.rootName, that.rootName);
        }

        public int hashCode() {
            int result = this.sourceSection != null ? this.sourceSection.hashCode() : 0;
            result = 31 * result + (this.rootName != null ? this.rootName.hashCode() : 0);
            return result;
        }
    }
}

