/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.associations;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import schemacrawler.schema.Column;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraintColumn;

final class TableColumns {
    private final Table table;
    private final Set<Column> candidateKeys;

    TableColumns(Table table) {
        this.table = Objects.requireNonNull(table, "No table provided");
        this.candidateKeys = new HashSet<Column>();
        this.buildLookups();
    }

    public Set<Column> getCandidateKeys() {
        return Set.copyOf(this.candidateKeys);
    }

    public Table getTable() {
        return this.table;
    }

    public NamedObjectKey key() {
        return this.table.key();
    }

    public String toString() {
        return "%s: %s".formatted(this.table, this.candidateKeys);
    }

    private void buildLookups() {
        PrimaryKey primaryKey = this.table.getPrimaryKey();
        if (primaryKey != null && primaryKey.getConstrainedColumns().size() == 1) {
            TableConstraintColumn tableConstraintColumn = primaryKey.getConstrainedColumns().get(0);
            this.candidateKeys.add(tableConstraintColumn);
        }
        for (Index index : this.table.getIndexes()) {
            if (index == null || !index.isUnique() || index.getColumns().size() != 1) continue;
            IndexColumn indexColumn = index.getColumns().get(0);
            this.candidateKeys.add(indexColumn);
        }
    }
}

