/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Logger;
import oracle.core.lmx.CoreException;
import oracle.sql.LnxLib;
import oracle.sql.LnxLibThinFormat;
import oracle.sql.LxMetaData;
import oracle.sql.NUMBER;

class LnxLibThin
implements LnxLib {
    static final int EXP_DBL = 0;
    static final int POS_DBL = 1;
    static final int NEG_DBL = 2;
    static final int LNXREN_TABLEDBLSTART = 4;
    static final boolean DEBUG = false;
    private static final byte[] lnxqone;
    private static final byte[] lnxqtwo;
    private static final int LNXQACOS = 0;
    private static final int LNXQASIN = 1;
    private static final int LNXQATAN = 2;
    private static final int LNXQCOS = 3;
    private static final int LNXQSIN = 4;
    private static final int LNXQTAN = 5;
    private static final int LNXQCSH = 6;
    private static final int LNXQSNH = 7;
    private static final int LNXQTNH = 8;
    private static final int LNXQEXP = 9;
    private static final int LNXM_NUM = 22;
    private static final int LNXDIGS = 20;
    private static final int LNXSGNBT = 128;
    private static final int LNXEXPMX = 127;
    private static final int LNXEXPMN = 0;
    private static final int LNXEXPBS = 64;
    private static final int LNXBASE = 100;
    private static final int LNXMXFMT = 64;
    private static final int LNXMXOUT = 40;
    private static final int LNXDIV_LNXBASE_SQUARED = 10000;
    private static final int MINUB1MAXVAL = 255;
    private static final double ORANUM_FBASE = 100.0;
    private static final int LNXQNOSGN = 127;
    private static final char LNXNFT_COMMA = ',';
    private static final int LNXBYTEMASK = 255;
    private static final int LNXSHORTMASK = 65535;
    private static byte[] LnxqFirstDigit;
    private static byte[] LnxqNegate;
    private static byte[] LnxqTruncate_P;
    private static byte[] LnxqTruncate_N;
    private static byte[] LnxqRound_P;
    private static byte[] LnxqRound_N;
    private static byte[][] LnxqComponents_P;
    private static byte[][] LnxqComponents_N;
    private static byte[][] LnxqAdd_PPP;
    private static byte[][] LnxqAdd_NNN;
    private static byte[][] LnxqAdd_PNP;
    private static byte[][] LnxqAdd_PNN;
    private static byte[] LnxsubIdentity;
    private static byte[][] LnxqDigit_P;
    private static byte[][] LnxqDigit_N;
    private static final double[][] powerTable;
    private static final double[][] factorTable;
    private static final char[] lnx_chars;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;

    LnxLibThin() {
    }

    @Override
    public byte[] lnxabs(byte[] n2) throws SQLException {
        byte[] op = new byte[n2.length];
        if (NUMBER._isPositive(n2)) {
            System.arraycopy(n2, 0, op, 0, n2.length);
            return op;
        }
        if (NUMBER._isNegInf(n2)) {
            return NUMBER.posInf().shareBytes();
        }
        int len = n2.length;
        if (n2[len - 1] == 102) {
            --len;
        }
        System.arraycopy(n2, 0, op, 0, len);
        LnxLibThin._negateNumber(op);
        return LnxLibThin._setLength(op, len);
    }

    @Override
    public byte[] lnxacos(byte[] n2) throws SQLException {
        return this.lnxqtri(n2, 0);
    }

    @Override
    public byte[] lnxadd(byte[] n1, byte[] n2) throws SQLException {
        int outEnd;
        int outLast;
        boolean overflow;
        int outDig;
        int opLowerFlag;
        int opLower;
        int opUpperFlag;
        int opUpper;
        int outExp;
        int outCarry;
        byte outZero;
        byte[][] addArray;
        boolean outPos;
        int op2Exp;
        int op1Exp;
        int n1len = n1.length;
        int n1p = 0;
        int n2len = n2.length;
        int n2p = 0;
        byte[] out = new byte[41];
        int outp = 0;
        int opMiddle1 = 0;
        int opMiddle2 = 0;
        int upperDigits = 0;
        int middleDigits = 0;
        int lowerDigits = 0;
        int outFirst = outp + 1;
        boolean op1Pos = NUMBER._isPositive(n1);
        int n3 = op1Exp = n1[0] < 0 ? 256 + n1[0] : 255 - n1[0];
        if (!op1Pos && n1[n1len - 1] == 102) {
            --n1len;
        }
        int op1Dig = n1len - 1;
        boolean op2Pos = NUMBER._isPositive(n2);
        int n4 = op2Exp = n2[0] < 0 ? 256 + n2[0] : 255 - n2[0];
        if (!op2Pos && n2[n2len - 1] == 102) {
            --n2len;
        }
        int op2Dig = n2len - 1;
        if (op1Exp == 255 && (op1Dig == 0 || n1[1] == 101)) {
            boolean outPos2 = op1Pos;
            if (outPos2) {
                return NUMBER._makePosInf();
            }
            return NUMBER._makeNegInf();
        }
        if (op2Exp == 255 && (op2Dig == 0 || n2[1] == 101)) {
            boolean outPos3 = op2Pos;
            if (outPos3) {
                return NUMBER._makePosInf();
            }
            return NUMBER._makeNegInf();
        }
        if (op1Exp == 128 && op1Dig == 0) {
            out = new byte[n2len];
            System.arraycopy(n2, 0, out, 0, n2len);
            boolean outPos4 = op2Pos;
            int outLen = n2len;
            return LnxLibThin._setLength(out, outLen);
        }
        if (op2Exp == 128 && op2Dig == 0) {
            out = new byte[n1len];
            System.arraycopy(n1, 0, out, 0, n1len);
            boolean outPos5 = op1Pos;
            int outLen = n1len;
            return LnxLibThin._setLength(out, outLen);
        }
        int expDiff = op1Exp - op2Exp;
        if (op1Pos == op2Pos) {
            outPos = op1Pos;
            if (outPos) {
                addArray = LnxqAdd_PPP;
                outZero = 1;
                outCarry = 1;
            } else {
                addArray = LnxqAdd_NNN;
                outZero = 101;
                outCarry = -1;
            }
        } else {
            int sign = expDiff;
            if (sign == 0) {
                int op1Ptr = n1p + 1;
                int op2Ptr = n2p + 1;
                int opEnd = n1p + (op1Dig < op2Dig ? op1Dig : op2Dig);
                while (op1Ptr <= opEnd && n1[op1Ptr] + n2[op2Ptr] == 102) {
                    ++op1Ptr;
                    ++op2Ptr;
                }
                sign = op1Ptr <= opEnd ? (op1Pos ? n1[op1Ptr] + n2[op2Ptr] - 102 : 102 - (n1[op1Ptr] + n2[op2Ptr])) : op1Dig - op2Dig;
            }
            if (sign == 0) {
                return NUMBER._makeZero();
            }
            boolean bl = outPos = sign > 0 ? op1Pos : op2Pos;
            if (outPos) {
                addArray = LnxqAdd_PNP;
                outZero = 1;
                outCarry = -1;
            } else {
                addArray = LnxqAdd_PNN;
                outZero = 101;
                outCarry = 1;
            }
        }
        if (expDiff >= 0) {
            outExp = op1Exp;
            if (expDiff + op2Dig <= op1Dig) {
                upperDigits = expDiff;
                middleDigits = op2Dig;
                lowerDigits = op1Dig - (expDiff + op2Dig);
                opUpper = n1p + upperDigits;
                opUpperFlag = 1;
                opMiddle1 = opUpper + middleDigits;
                opMiddle2 = n2p + op2Dig;
                opLower = n1p + op1Dig;
                opLowerFlag = 1;
                outDig = op1Dig;
                overflow = lowerDigits != 0 && op1Pos != outPos;
            } else if (expDiff < op1Dig) {
                upperDigits = expDiff;
                middleDigits = op1Dig - expDiff;
                lowerDigits = op2Dig - middleDigits;
                opUpper = n1p + upperDigits;
                opUpperFlag = 1;
                opMiddle1 = n1p + op1Dig;
                opMiddle2 = n2p + middleDigits;
                opLower = n2p + op2Dig;
                opLowerFlag = 2;
                outDig = expDiff + op2Dig;
                overflow = op2Pos != outPos;
            } else {
                upperDigits = op1Dig;
                middleDigits = -(expDiff - op1Dig);
                lowerDigits = op2Dig;
                opUpper = n1p + op1Dig;
                opUpperFlag = 1;
                opLower = n2p + op2Dig;
                opLowerFlag = 2;
                outDig = expDiff + op2Dig;
                overflow = op2Pos != outPos;
            }
        } else {
            outExp = op2Exp;
            if ((expDiff = -expDiff) + op1Dig <= op2Dig) {
                upperDigits = expDiff;
                middleDigits = op1Dig;
                lowerDigits = op2Dig - (expDiff + op1Dig);
                opUpper = n2p + upperDigits;
                opUpperFlag = 2;
                opMiddle1 = n1p + op1Dig;
                opMiddle2 = opUpper + middleDigits;
                opLower = n2p + op2Dig;
                opLowerFlag = 2;
                outDig = op2Dig;
                overflow = lowerDigits != 0 && op2Pos != outPos;
            } else if (expDiff < op2Dig) {
                upperDigits = expDiff;
                middleDigits = op2Dig - expDiff;
                lowerDigits = op1Dig - middleDigits;
                opUpper = n2p + upperDigits;
                opUpperFlag = 2;
                opMiddle1 = n1p + middleDigits;
                opMiddle2 = n2p + op2Dig;
                opLower = n1p + op1Dig;
                opLowerFlag = 1;
                outDig = expDiff + op1Dig;
                overflow = op1Pos != outPos;
            } else {
                upperDigits = op2Dig;
                middleDigits = -(expDiff - op2Dig);
                lowerDigits = op1Dig;
                opUpper = n2p + op2Dig;
                opUpperFlag = 2;
                opLower = n1p + op1Dig;
                opLowerFlag = 1;
                outDig = expDiff + op1Dig;
                boolean bl = overflow = op1Pos != outPos;
            }
        }
        if (outDig > 20) {
            if (expDiff > 20) {
                middleDigits = 0;
                lowerDigits = 0;
                outDig = upperDigits;
                overflow = false;
            } else {
                outFirst = 1;
            }
        }
        int outPtr = outLast = outFirst + (outDig - 1);
        if (lowerDigits != 0) {
            outEnd = outPtr - lowerDigits;
            out[outPtr] = opLowerFlag == 1 ? n1[opLower] : n2[opLower];
            --opLower;
            --outPtr;
            if (overflow) {
                while (outPtr > outEnd) {
                    out[outPtr] = opLowerFlag == 1 ? (byte)(n1[opLower] + outCarry) : (byte)(n2[opLower] + outCarry);
                    --opLower;
                    --outPtr;
                }
            } else {
                while (outPtr > outEnd) {
                    out[outPtr] = opLowerFlag == 1 ? n1[opLower] : n2[opLower];
                    --opLower;
                    --outPtr;
                }
            }
        }
        if (middleDigits > 0) {
            outEnd = outPtr - middleDigits;
            int addp = 0;
            int addPtr = overflow ? addp + 1 : addp;
            do {
                addPtr = addp + n1[opMiddle1] + n2[opMiddle2] + addArray[addPtr][1];
                out[outPtr] = addArray[addPtr][0];
                --opMiddle1;
                --opMiddle2;
            } while (--outPtr > outEnd);
            overflow = (addArray[addPtr][1] & 1) != 0;
        } else {
            byte digit = overflow ? (outCarry == 1 ? (byte)2 : 100) : outZero;
            outEnd = outPtr + middleDigits;
            while (outPtr > outEnd) {
                out[outPtr] = digit;
                --outPtr;
            }
        }
        if (upperDigits != 0) {
            outEnd = outPtr - upperDigits;
            if (overflow) {
                int trigger = (outCarry == 1 ? 100 : 1) + (outPos ? 0 : 1);
                int result = (outCarry == 1 ? 1 : 100) + (outPos ? 0 : 1);
                do {
                    if (opUpperFlag == 1) {
                        overflow = n1[opUpper] == trigger;
                        out[outPtr] = (byte)(overflow ? result : n1[opUpper] + outCarry);
                    } else {
                        overflow = n2[opUpper] == trigger;
                        out[outPtr] = (byte)(overflow ? result : n2[opUpper] + outCarry);
                    }
                    --opUpper;
                } while (overflow && --outPtr > outEnd);
            }
            while (outPtr > outEnd) {
                out[outPtr] = opUpperFlag == 1 ? n1[opUpper] : n2[opUpper];
                --opUpper;
                --outPtr;
            }
        }
        if (overflow) {
            if (outExp == 255) {
                if (outPos) {
                    return NUMBER._makePosInf();
                }
                return NUMBER._makeNegInf();
            }
            out[--outFirst] = (byte)(outPos ? 2 : 100);
            ++outExp;
            ++outDig;
        }
        if (out[outFirst] == outZero) {
            do {
                --outExp;
                --outDig;
            } while (out[++outFirst] == outZero);
            if (outExp < 128) {
                return NUMBER._makeZero();
            }
        }
        if (outDig > 20) {
            outLast = outFirst + 19;
            outDig = 20;
            if ((outPos ? out[outLast + 1] : LnxqNegate[out[outLast + 1]]) > 50) {
                byte maximum;
                byte by = maximum = outPos ? (byte)100 : 2;
                if (!overflow) {
                    out[outFirst - 1] = outZero;
                }
                while (out[outLast] == maximum) {
                    --outLast;
                    --outDig;
                }
                if (outLast < outFirst) {
                    if (outExp == 255) {
                        if (outPos) {
                            return NUMBER._makePosInf();
                        }
                        return NUMBER._makeNegInf();
                    }
                    --outFirst;
                    ++outExp;
                    outDig = 1;
                }
                int n5 = outLast;
                out[n5] = (byte)(out[n5] + (outPos ? 1 : -1));
            }
        }
        while (out[outLast] == outZero) {
            --outLast;
            --outDig;
        }
        if (outFirst != 1) {
            byte[] temp = new byte[41];
            System.arraycopy(out, outFirst, temp, 1, outDig);
            System.arraycopy(temp, 1, out, 1, outDig);
        }
        int outLen = outDig + 1;
        if (!outPos && outLen <= 20) {
            out[outLen] = 102;
            ++outLen;
        }
        out[outp] = (byte)(outPos ? outExp - 256 : 255 - outExp);
        return LnxLibThin._setLength(out, outLen);
    }

    @Override
    public byte[] lnxasin(byte[] n2) throws SQLException {
        return this.lnxqtri(n2, 1);
    }

    @Override
    public byte[] lnxatan(byte[] n2) throws SQLException {
        return this.lnxqtri(n2, 2);
    }

    @Override
    public byte[] lnxatan2(byte[] y2, byte[] x2) throws SQLException {
        if (NUMBER._isZero(y2) && NUMBER._isZero(x2)) {
            throw new SQLException(CoreException.getMessage((byte)11));
        }
        byte[] buffer = this.lnxdiv(y2, x2);
        buffer = this.lnxatan(buffer);
        if (NUMBER._isPositive(x2)) {
            return buffer;
        }
        byte[] lnxqpi = NUMBER.pi().shareBytes();
        if (NUMBER._isPositive(y2)) {
            return this.lnxadd(buffer, lnxqpi);
        }
        return this.lnxsub(buffer, lnxqpi);
    }

    @Override
    public byte[] lnxbex(byte[] b2, byte[] n2) throws SQLException {
        switch (this.lnxsgn(b2)) {
            case 1: {
                byte[] buf = this.lnxln(b2);
                buf = this.lnxmul(n2, buf);
                return this.lnxexp(buf);
            }
            case 0: {
                if (NUMBER._isZero(n2)) {
                    byte[] buf = new byte[lnxqone.length];
                    System.arraycopy(lnxqone, 0, buf, 0, lnxqone.length);
                    return buf;
                }
                return NUMBER._makeZero();
            }
            case -1: {
                if (new NUMBER(n2).isInt()) {
                    byte[] buf = this.lnxneg(b2);
                    buf = this.lnxln(buf);
                    buf = this.lnxmul(n2, buf);
                    buf = this.lnxexp(buf);
                    if (!NUMBER._isZero(this.lnxmod(n2, lnxqtwo))) {
                        buf = this.lnxneg(buf);
                    }
                    return buf;
                }
                return NUMBER._makePosInf();
            }
        }
        return null;
    }

    @Override
    public byte[] lnxcos(byte[] n2) throws SQLException {
        return this.lnxqtra(n2, 3);
    }

    @Override
    public byte[] lnxcsh(byte[] n2) throws SQLException {
        return this.lnxqtra(n2, 6);
    }

    @Override
    public byte[] lnxdec(byte[] n2) throws SQLException {
        int exponent;
        int nlength = n2.length;
        byte[] temp = new byte[22];
        System.arraycopy(n2, 0, temp, 0, nlength);
        if (NUMBER._isPositive(temp) && (exponent = (int)((temp[0] & 0xFFFFFF7F) - 65)) >= 0 && exponent <= 18) {
            int opPtr = exponent + 1;
            int opEnd = nlength - 1;
            if (opPtr <= opEnd) {
                int n3 = opPtr;
                temp[n3] = (byte)(temp[n3] - 1);
                if (temp[opPtr] == 1 && opPtr == opEnd && --nlength == 1) {
                    return NUMBER._makeZero();
                }
            } else {
                int n4 = opEnd;
                temp[n4] = (byte)(temp[n4] - 1);
                while (opPtr > opEnd) {
                    temp[opPtr] = 100;
                    --opPtr;
                }
                if (temp[1] == 1) {
                    for (int i2 = 1; i2 <= exponent; ++i2) {
                        temp[i2] = temp[i2 + 1];
                    }
                    --exponent;
                }
                nlength = exponent + 2;
            }
            temp[0] = (byte)(exponent + 128 + 64 + 1);
            byte[] outtemp = new byte[nlength];
            System.arraycopy(temp, 0, outtemp, 0, nlength);
            return outtemp;
        }
        return NUMBER._makeZero();
    }

    @Override
    public byte[] lnxdiv(byte[] n1, byte[] n2) throws SQLException {
        int rslExp;
        int dbl3Full2;
        int dbl3Ptr;
        int dbl2Last;
        int dbl1Ptr;
        byte[] op1p = n1;
        int op1l = op1p.length;
        byte[] op2p = n2;
        int op2l = op2p.length;
        byte[] rslp = new byte[22];
        int[] dbl1 = new int[22];
        int[] dbl2 = new int[10];
        int[] dbl3 = new int[13];
        boolean op1Pos = op1p[0] >> 7 != 0;
        byte op1Exp = op1p[0];
        if (!op1Pos) {
            op1Exp = ~op1Exp;
            if (op1p[op1l - 1] == 102) {
                --op1l;
            }
        }
        boolean op2Pos = op2p[0] >> 7 != 0;
        byte op2Exp = op2p[0];
        if (!op2Pos) {
            op2Exp = ~op2Exp;
            if (op2p[op2l - 1] == 102) {
                --op2l;
            }
        }
        if ((op2Exp & 0xFF) == 128 && op2l == 1) {
            if (op1Pos == op2Pos) {
                return NUMBER._makePosInf();
            }
            return NUMBER._makeNegInf();
        }
        if ((op1Exp & 0xFF) == 128 && op1l == 1) {
            return NUMBER._makeZero();
        }
        int temp = op1l == 1 ? 0 : 1;
        if ((op1Exp & 0xFF) == 255 && (op1l == 2 || op1p[temp] == 101) || op1l == 1 && op1p[0] == 0) {
            if (op1Pos == op2Pos) {
                return NUMBER._makePosInf();
            }
            return NUMBER._makeNegInf();
        }
        temp = op2l == 1 ? 0 : 1;
        if ((op2Exp & 0xFF) == 255 && (op2l == 2 || op2p[temp] == 101) || op2l == 1 && op2p[0] == 0) {
            return NUMBER._makeZero();
        }
        int dbl1Last = op1l / 2 - 1;
        int op1Ptr = op1l - 2;
        for (dbl1Ptr = 21; dbl1Ptr > dbl1Last; --dbl1Ptr) {
            dbl1[dbl1Ptr] = 0;
        }
        if (op1Pos) {
            if ((op1l & 1) == 0) {
                dbl1[dbl1Ptr] = op1p[op1Ptr + 1] * 100 - 100;
                --op1Ptr;
                --dbl1Ptr;
            }
            while (op1Ptr > 0) {
                dbl1[dbl1Ptr] = op1p[op1Ptr] * 100 + op1p[op1Ptr + 1] - 101;
                op1Ptr -= 2;
                --dbl1Ptr;
            }
        } else {
            if ((op1l & 1) == 0) {
                dbl1[dbl1Ptr] = 10100 - op1p[op1Ptr + 1] * 100;
                --op1Ptr;
                --dbl1Ptr;
            }
            while (op1Ptr > 0) {
                dbl1[dbl1Ptr] = 10201 - (op1p[op1Ptr] * 100 + op1p[op1Ptr + 1]);
                op1Ptr -= 2;
                --dbl1Ptr;
            }
        }
        int dbl2Ptr = dbl2Last = op2l / 2 - 1;
        int op2Ptr = op2l - 2;
        if (op2Pos) {
            if ((op2l & 1) == 0) {
                dbl2[dbl2Ptr] = op2p[op2Ptr + 1] * 100 - 100;
                --op2Ptr;
                --dbl2Ptr;
            }
            while (op2Ptr > 0) {
                dbl2[dbl2Ptr] = op2p[op2Ptr] * 100 + op2p[op2Ptr + 1] - 101;
                op2Ptr -= 2;
                --dbl2Ptr;
            }
        } else {
            if ((op2l & 1) == 0) {
                dbl2[dbl2Ptr] = 10100 - op2p[op2Ptr + 1] * 100;
                --op2Ptr;
                --dbl2Ptr;
            }
            while (op2Ptr > 0) {
                dbl2[dbl2Ptr] = 10201 - (op2p[op2Ptr] * 100 + op2p[op2Ptr + 1]);
                op2Ptr -= 2;
                --dbl2Ptr;
            }
        }
        int dbl3First = 0;
        int dbl3Last = -1;
        if (op2l <= 3) {
            dbl1Ptr = 0;
            int dividend = dbl1[0];
            int divisor = dbl2[0];
            do {
                int quotient = dividend / divisor;
                dividend -= quotient * divisor;
                dividend = dividend * 10000 + dbl1[++dbl1Ptr];
                dbl3[++dbl3Last] = quotient;
            } while ((dividend != 0 || dbl1Ptr < dbl1Last) && dbl3Last < 10 + (dbl3[0] == 0 ? 2 : 1));
        } else {
            int start = 0;
            int end = dbl2Last;
            double dividend = (double)(dbl1[start] * 10000) + (double)dbl1[start + 1];
            double divisor = (double)(dbl2[0] * 10000) + (double)dbl2[1];
            do {
                int quotient;
                if ((quotient = (int)(dividend / divisor)) != 0) {
                    dbl1Ptr = start + 2;
                    dbl2Ptr = 2;
                    while (dbl1Ptr <= end) {
                        int n3 = dbl1Ptr++;
                        dbl1[n3] = dbl1[n3] - quotient * dbl2[dbl2Ptr];
                        ++dbl2Ptr;
                    }
                }
                dividend -= (double)quotient * divisor;
                dividend = dividend * 10000.0 + (double)dbl1[start + 2];
                if (quotient >= 10000) {
                    dbl3Ptr = dbl3Last;
                    while (dbl3[dbl3Ptr] == 9999) {
                        dbl3[dbl3Ptr] = 0;
                        --dbl3Ptr;
                    }
                    int n4 = dbl3Ptr;
                    dbl3[n4] = dbl3[n4] + 1;
                    quotient -= 10000;
                }
                while (quotient < 0) {
                    dbl3Ptr = dbl3Last;
                    while (dbl3[dbl3Ptr] == 0) {
                        dbl3[dbl3Ptr] = 9999;
                        --dbl3Ptr;
                    }
                    int n5 = dbl3Ptr;
                    dbl3[n5] = dbl3[n5] - 1;
                    quotient += 10000;
                }
                dbl3[++dbl3Last] = quotient;
                if (start >= dbl1Last) {
                    double d2 = dividend < 0.0 ? -dividend : dividend;
                    if (d2 < 0.1) {
                        for (dbl1Ptr = start + 2; dbl1Ptr <= end && dbl1[dbl1Ptr] == 0; ++dbl1Ptr) {
                        }
                        if (dbl1Ptr > end) break;
                    }
                }
                ++start;
                ++end;
            } while (dbl3Last < 10 + (dbl3[0] == 0 ? 2 : 1));
        }
        if (dbl3[0] == 0) {
            ++dbl3First;
        }
        while (dbl3[dbl3Last] == 0) {
            --dbl3Last;
        }
        int dbl3Full1 = dbl3[dbl3First] >= 100 ? 1 : 0;
        int rslDig = 2 * (dbl3Last - dbl3First) + dbl3Full1 + (dbl3Full2 = dbl3[dbl3Last] % 100 != 0 ? 1 : 0);
        if (rslDig > 20) {
            if (dbl3Full1 > 0) {
                int n6 = dbl3Last = dbl3First + 9;
                dbl3[n6] = dbl3[n6] + (dbl3[dbl3Last + 1] >= 5000 ? 1 : 0);
            } else {
                dbl3Last = dbl3First + 10;
                dbl3[dbl3Last] = (dbl3[dbl3Last] + 50) / 100 * 100;
            }
            if (dbl3[dbl3Last] == 10000) {
                while (dbl3[--dbl3Last] == 9999) {
                }
                int n7 = dbl3Last;
                dbl3[n7] = dbl3[n7] + 1;
            }
            if (dbl3[0] != 0) {
                dbl3First = 0;
            }
            while (dbl3[dbl3Last] == 0) {
                --dbl3Last;
            }
            dbl3Full1 = dbl3[dbl3First] >= 100 ? 1 : 0;
            dbl3Full2 = dbl3[dbl3Last] % 100 != 0 ? 1 : 0;
            rslDig = 2 * (dbl3Last - dbl3First) + dbl3Full1 + dbl3Full2;
        }
        if ((rslExp = (op1Exp & 0xFF) - (op2Exp & 0xFF) - (dbl3[0] == 0 ? 1 : 0) + 193) > 255) {
            if (op1Pos == op2Pos) {
                return NUMBER._makePosInf();
            }
            return NUMBER._makeNegInf();
        }
        if (rslExp < 128) {
            return NUMBER._makeZero();
        }
        int rslLen = rslDig + 1;
        rslp = new byte[rslLen];
        int rslPtr = rslDig;
        dbl3Ptr = dbl3Last;
        if (dbl3Full2 == 0) {
            rslp[rslPtr] = (byte)(dbl3[dbl3Ptr] / 100 + 1);
            --rslPtr;
            --dbl3Ptr;
        }
        while (rslPtr > 1) {
            int highDigit = dbl3[dbl3Ptr] / 100;
            int lowDigit = dbl3[dbl3Ptr] - highDigit * 100;
            rslp[rslPtr] = (byte)(lowDigit + 1);
            rslp[--rslPtr] = (byte)(highDigit + 1);
            --rslPtr;
            --dbl3Ptr;
        }
        if (dbl3Full1 == 0) {
            rslp[rslPtr] = (byte)(dbl3[dbl3Ptr] + 1);
        }
        rslp[0] = (byte)rslExp;
        if (op1Pos != op2Pos) {
            int i2;
            byte[] rslp1;
            if (++rslLen > 20) {
                rslp1 = new byte[21];
                rslLen = 21;
            } else {
                rslp1 = new byte[rslLen];
            }
            rslp1[0] = (byte)(~rslExp);
            for (i2 = 0; i2 < rslLen - 2; ++i2) {
                rslp1[i2 + 1] = (byte)(102 - rslp[i2 + 1]);
            }
            if (rslLen <= 20) {
                rslp1[rslLen - 1] = 102;
            } else if (rslp.length == 20) {
                rslp1[rslLen - 1] = 102;
            } else {
                rslp1[i2 + 1] = (byte)(102 - rslp[i2 + 1]);
            }
            return rslp1;
        }
        return rslp;
    }

    @Override
    public byte[] lnxexp(byte[] n2) throws SQLException {
        return this.lnxqtra(n2, 9);
    }

    @Override
    public byte[] lnxflo(byte[] n2) throws SQLException {
        byte[] t2 = this.lnxtru(n2, 0);
        if (NUMBER.compareBytes(t2, n2) != 0 && !NUMBER._isPositive(n2)) {
            t2 = this.lnxsub(t2, lnxqone);
        }
        return t2;
    }

    @Override
    public byte[] lnxceil(byte[] n2) throws SQLException {
        byte[] t2 = this.lnxtru(n2, 0);
        if (NUMBER.compareBytes(t2, n2) != 0 && NUMBER._isPositive(n2)) {
            t2 = this.lnxadd(t2, lnxqone);
        }
        return t2;
    }

    @Override
    public byte[] lnxfpr(byte[] n2, int precision) throws SQLException {
        int outLen;
        byte inpEnd;
        byte[] op;
        int inpSign;
        byte inpMax;
        byte inpZero;
        boolean odd;
        int offset;
        boolean inpPos;
        block23: {
            block22: {
                int len = n2.length;
                if (NUMBER._isZero(n2)) {
                    return NUMBER._makeZero();
                }
                if (NUMBER._isNegInf(n2)) {
                    return NUMBER._makeNegInf();
                }
                if (NUMBER._isPosInf(n2)) {
                    return NUMBER._makePosInf();
                }
                if (precision < 0) {
                    return NUMBER._makeZero();
                }
                inpPos = NUMBER._isPositive(n2);
                if (inpPos) {
                    offset = (precision += (n2[1] & 0xFF) < 11 ? 2 : 1) >> 1;
                    odd = (precision & 1) == 1;
                    inpZero = 1;
                    inpMax = 100;
                    inpSign = 1;
                } else {
                    offset = (precision += (n2[1] & 0xFF) > 91 ? 2 : 1) >> 1;
                    odd = (precision & 1) == 1;
                    inpZero = 101;
                    inpMax = 2;
                    inpSign = -1;
                    len -= (n2[len - 1] & 0xFF) == 102 ? 1 : 0;
                }
                op = new byte[len];
                System.arraycopy(n2, 0, op, 0, len);
                if (offset > len - 1 || offset == len - 1 && (odd || LnxqFirstDigit[n2[offset]] == 1)) {
                    return LnxLibThin._setLength(n2, len);
                }
                if (offset == 0 && (!odd || (!inpPos ? n2[1] > 51 : n2[1] < 51))) break block22;
                if (offset != 1 || odd || !(inpPos ? n2[1] < 6 : n2[1] > 96)) break block23;
            }
            return NUMBER._makeZero();
        }
        if (offset == 0) {
            if (NUMBER._isInf(n2)) {
                if (inpPos) {
                    return NUMBER._makePosInf();
                }
                return NUMBER._makeNegInf();
            }
            op[0] = (byte)(n2[0] + inpSign);
            op[1] = (byte)(inpZero + inpSign);
            return LnxLibThin._setLength(op, 2);
        }
        byte outEnd = inpEnd = (byte)offset;
        op[outEnd] = odd ? ((inpPos ? n2[inpEnd + 1] > 50 : n2[inpEnd + 1] < 52) ? (byte)(n2[inpEnd] + inpSign) : n2[inpEnd]) : (inpPos ? LnxqRound_P[n2[inpEnd]] : LnxqRound_N[n2[inpEnd]]);
        if (op[outEnd] == inpMax + inpSign) {
            for (inpEnd = (byte)(inpEnd - 1); inpEnd > 0 && n2[inpEnd] == inpMax; inpEnd = (byte)(inpEnd - 1)) {
            }
            if (inpEnd == 0) {
                if (NUMBER._isInf(n2)) {
                    if (inpPos) {
                        return NUMBER._makePosInf();
                    }
                    return NUMBER._makeNegInf();
                }
                op[0] = (byte)(n2[0] + inpSign);
                op[1] = (byte)(inpZero + inpSign);
                return LnxLibThin._setLength(op, 2);
            }
            op[inpEnd] = (byte)(n2[inpEnd] + inpSign);
            outLen = inpEnd + 1;
            inpEnd = (byte)(inpEnd - 1);
        } else if (op[outEnd] == inpZero) {
            while (n2[inpEnd] == inpZero) {
                inpEnd = (byte)(inpEnd - 1);
            }
            outLen = inpEnd + 1;
        } else {
            outLen = offset + 1;
        }
        return LnxLibThin._setLength(op, outLen);
    }

    @Override
    public byte[] lnxinc(byte[] n2) throws SQLException {
        int nlen = n2.length;
        byte[] op = new byte[22];
        System.arraycopy(n2, 0, op, 0, nlen);
        byte nPtr = 0;
        int exponent = (op[0] & 0xFFFFFF7F) - 65;
        if (exponent >= 0 && exponent <= 18) {
            byte opPtr = (byte)(exponent + 1);
            byte opEnd = (byte)(nlen - 1);
            if (opPtr <= opEnd) {
                if (op[opPtr] < 100) {
                    byte by = opPtr;
                    op[by] = (byte)(op[by] + 1);
                } else {
                    op[nPtr] = 0;
                    while (op[opPtr = (byte)(opPtr - 1)] == 100) {
                    }
                    if (opPtr > nPtr) {
                        byte by = opPtr;
                        op[by] = (byte)(op[by] + 1);
                    } else {
                        ++exponent;
                        opPtr = (byte)(opPtr + 1);
                        op[opPtr] = 2;
                    }
                    op[nPtr] = (byte)(exponent + 128 + 64 + 1);
                    nlen = opPtr - nPtr + 1;
                }
            } else {
                op[opPtr] = 2;
                for (opPtr = (byte)(opPtr - 1); opPtr > opEnd; opPtr = (byte)(opPtr - 1)) {
                    op[opPtr] = 1;
                }
                nlen = exponent + 2;
            }
        } else {
            op[0] = -63;
            op[1] = 2;
            nlen = 2;
        }
        byte[] outtmp = new byte[nlen];
        System.arraycopy(op, 0, outtmp, 0, nlen);
        return outtmp;
    }

    @Override
    public byte[] lnxln(byte[] n2) throws SQLException {
        if (this.lnxsgn(n2) <= 0) {
            return NUMBER._makeNegInf();
        }
        if (NUMBER._isPosInf(n2)) {
            return NUMBER._makePosInf();
        }
        byte[] buffer = new byte[n2.length];
        System.arraycopy(n2, 0, buffer, 0, n2.length);
        int exponent = (buffer[0] & 0xFF) - 193;
        buffer[0] = -63;
        double x2 = this.lnxnur(buffer);
        double y2 = Math.log(x2);
        byte[] approx = NUMBER.toBytes(y2);
        byte[] temp = this.lnxexp(approx);
        byte[] quot = this.lnxdiv(buffer, temp);
        quot = this.lnxsub(quot, lnxqone);
        byte[] sum = new byte[quot.length];
        System.arraycopy(quot, 0, sum, 0, quot.length);
        byte[] term = this.lnxmul(quot, quot);
        int index = 1;
        while ((term[0] & 0xFF) > 172) {
            temp = this.lnxqIDiv(term, ++index);
            sum = this.lnxsub(sum, temp);
            term = this.lnxmul(quot, term);
            temp = this.lnxqIDiv(term, ++index);
            sum = this.lnxadd(sum, temp);
            term = this.lnxmul(quot, term);
        }
        byte[] lnxqln10 = NUMBER.ln10().shareBytes();
        quot = this.lnxmin(exponent *= 2);
        temp = this.lnxmul(quot, lnxqln10);
        temp = this.lnxadd(temp, approx);
        return this.lnxadd(temp, sum);
    }

    @Override
    public byte[] lnxlog(byte[] n2, byte[] b2) throws SQLException {
        double dbl = NUMBER.toDouble(b2);
        if (dbl > 0.0) {
            if (dbl == 10.0) {
                byte[] buffer1 = this.lnxln(n2);
                byte[] lnxqln10 = NUMBER.ln10().shareBytes();
                return this.lnxdiv(buffer1, lnxqln10);
            }
            byte[] buffer1 = this.lnxln(n2);
            byte[] buffer2 = this.lnxln(b2);
            return this.lnxdiv(buffer1, buffer2);
        }
        return NUMBER._makeNegInf();
    }

    @Override
    public byte[] lnxmod(byte[] n1, byte[] n2) throws SQLException {
        byte[] buffer1 = this.lnxdiv(n1, n2);
        byte[] buffer2 = this.lnxtru(buffer1, 0);
        buffer1 = this.lnxmul(n2, buffer2);
        byte[] r2 = this.lnxsub(n1, buffer1);
        return r2;
    }

    @Override
    public byte[] lnxmul(byte[] n1, byte[] n2) throws SQLException {
        int rslLen;
        int dbl2Last;
        int dbl1Last;
        byte[] op1p = n1;
        int op1l = op1p.length;
        byte[] op2p = n2;
        int op2l = op2p.length;
        byte[] rslp = new byte[22];
        int[] dbl1 = new int[10];
        int[] dbl2 = new int[10];
        short rslExp = 0;
        byte[] rslBuf = new byte[41];
        int rslFirst = 0;
        int sum = 0;
        boolean op1Pos = op1p[0] >> 7 != 0;
        byte op1Exp = op1p[0];
        if (!op1Pos) {
            op1Exp = ~op1Exp;
            if (op1p[op1l - 1] == 102) {
                --op1l;
            }
        }
        boolean op2Pos = op2p[0] >> 7 != 0;
        byte op2Exp = op2p[0];
        if (!op2Pos) {
            op2Exp = ~op2Exp;
            if (op2p[op2l - 1] == 102) {
                --op2l;
            }
        }
        if (-op1Exp == 128 && op1l == 1) {
            rslp = NUMBER._makeZero();
            return rslp;
        }
        if (-op2Exp == 128 && op2l == 1) {
            rslp = NUMBER._makeZero();
            return rslp;
        }
        if ((op1Exp & 0xFF) == 255 && (op1l == 1 || op1p[1] == 101)) {
            rslp = op1Pos == op2Pos ? NUMBER._makePosInf() : NUMBER._makeNegInf();
            return rslp;
        }
        if ((op2Exp & 0xFF) == 255 && (op2l == 1 || op2p[1] == 101)) {
            rslp = op1Pos == op2Pos ? NUMBER._makePosInf() : NUMBER._makeNegInf();
            return rslp;
        }
        if (op1l > op2l) {
            byte[] tmpPtr = op1p;
            op1p = op2p;
            op2p = tmpPtr;
            int tmpLen = op1l;
            op1l = op2l;
            op2l = tmpLen;
            boolean tmpPos = op1Pos;
            op1Pos = op2Pos;
            op2Pos = tmpPos;
        }
        int dbl1Ptr = dbl1Last = op1l / 2 - 1;
        int op1Ptr = op1l - 2;
        if (op1Pos) {
            if ((op1l & 1) == 0) {
                dbl1[dbl1Ptr] = op1p[op1Ptr + 1] * 100 - 100;
                --op1Ptr;
                --dbl1Ptr;
            }
            while (op1Ptr > 0) {
                dbl1[dbl1Ptr] = op1p[op1Ptr] * 100 + op1p[op1Ptr + 1] - 101;
                op1Ptr -= 2;
                --dbl1Ptr;
            }
        } else {
            if ((op1l & 1) == 0) {
                dbl1[dbl1Ptr] = 10100 - op1p[op1Ptr + 1] * 100;
                --op1Ptr;
                --dbl1Ptr;
            }
            while (op1Ptr > 0) {
                dbl1[dbl1Ptr] = 10201 - (op1p[op1Ptr] * 100 + op1p[op1Ptr + 1]);
                op1Ptr -= 2;
                --dbl1Ptr;
            }
        }
        int dbl2Ptr = dbl2Last = op2l / 2 - 1;
        int op2Ptr = op2l - 2;
        if (op2Pos) {
            if ((op2l & 1) == 0) {
                dbl2[dbl2Ptr] = op2p[op2Ptr + 1] * 100 - 100;
                --op2Ptr;
                --dbl2Ptr;
            }
            while (op2Ptr > 0) {
                dbl2[dbl2Ptr] = op2p[op2Ptr] * 100 + op2p[op2Ptr + 1] - 101;
                op2Ptr -= 2;
                --dbl2Ptr;
            }
        } else {
            if ((op2l & 1) == 0) {
                dbl2[dbl2Ptr] = 10100 - op2p[op2Ptr + 1] * 100;
                --op2Ptr;
                --dbl2Ptr;
            }
            while (op2Ptr > 0) {
                dbl2[dbl2Ptr] = 10201 - (op2p[op2Ptr] * 100 + op2p[op2Ptr + 1]);
                op2Ptr -= 2;
                --dbl2Ptr;
            }
        }
        if (dbl1[0] * dbl2[0] < 1000000) {
            rslExp = (short)((op1Exp & 0xFF) + (op2Exp & 0xFF) - 193);
            rslLen = (op1l & 0xFE) + (op2l & 0xFE);
        } else {
            rslExp = (short)((op1Exp & 0xFF) + (op2Exp & 0xFF) - 192);
            rslLen = (op1l & 0xFE) + (op2l & 0xFE) + 1;
        }
        rslFirst = 1;
        int rslPtr = rslLen;
        if (op1l <= 3) {
            sum = dbl1[0] * dbl2[dbl2Last];
            sum = LnxLibThin.LnxmulSetDigit1(rslBuf, rslPtr, sum);
            rslPtr -= 2;
            for (dbl2Ptr = dbl2Last - 1; dbl2Ptr >= 0; --dbl2Ptr) {
                sum += dbl1[0] * dbl2[dbl2Ptr];
                sum = LnxLibThin.LnxmulSetDigit1(rslBuf, rslPtr, sum);
                rslPtr -= 2;
            }
            LnxLibThin.LnxmulSetDigit2(rslBuf, rslPtr, sum);
            rslPtr -= 2;
        } else {
            sum += dbl1[dbl1Last] * dbl2[dbl2Last];
            sum = LnxLibThin.LnxmulSetDigit1(rslBuf, rslPtr, sum);
            rslPtr -= 2;
            for (dbl2Ptr = dbl2Last - 1; dbl2Ptr > dbl2Last - (op1l / 2 - 1); --dbl2Ptr) {
                switch (dbl2Last - dbl2Ptr + 1) {
                    case 9: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 8, sum);
                    }
                    case 8: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 7, sum);
                    }
                    case 7: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 6, sum);
                    }
                    case 6: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 5, sum);
                    }
                    case 5: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 4, sum);
                    }
                    case 4: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 3, sum);
                    }
                    case 3: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 2, sum);
                    }
                    case 2: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 1, sum);
                    }
                }
                sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 0, sum);
                sum = LnxLibThin.LnxmulSetDigit1(rslBuf, rslPtr, sum);
                rslPtr -= 2;
            }
            do {
                switch (op1l / 2) {
                    case 10: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 9, sum);
                    }
                    case 9: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 8, sum);
                    }
                    case 8: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 7, sum);
                    }
                    case 7: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 6, sum);
                    }
                    case 6: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 5, sum);
                    }
                    case 5: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 4, sum);
                    }
                    case 4: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 3, sum);
                    }
                    case 3: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 2, sum);
                    }
                    case 2: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 1, sum);
                    }
                }
                sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Last, dbl2Ptr, 0, sum);
                sum = LnxLibThin.LnxmulSetDigit1(rslBuf, rslPtr, sum);
                rslPtr -= 2;
            } while (--dbl2Ptr >= 0);
            for (dbl1Ptr = dbl1Last - 1; dbl1Ptr > 0; --dbl1Ptr) {
                switch (dbl1Ptr + 1) {
                    case 9: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Ptr, 0, 8, sum);
                    }
                    case 8: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Ptr, 0, 7, sum);
                    }
                    case 7: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Ptr, 0, 6, sum);
                    }
                    case 6: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Ptr, 0, 5, sum);
                    }
                    case 5: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Ptr, 0, 4, sum);
                    }
                    case 4: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Ptr, 0, 3, sum);
                    }
                    case 3: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Ptr, 0, 2, sum);
                    }
                    case 2: {
                        sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Ptr, 0, 1, sum);
                    }
                }
                sum = LnxLibThin.LnxmulSetSum(dbl1, dbl2, dbl1Ptr, 0, 0, sum);
                sum = LnxLibThin.LnxmulSetDigit1(rslBuf, rslPtr, sum);
                rslPtr -= 2;
            }
            sum += dbl1[0] * dbl2[0];
            sum = LnxLibThin.LnxmulSetDigit1(rslBuf, rslPtr, sum);
            LnxLibThin.LnxmulSetDigit2(rslBuf, rslPtr -= 2, sum);
            rslPtr -= 2;
        }
        if ((rslLen & 1) == 0 && rslBuf[rslPtr] != 1) {
            rslExp = (short)(rslExp + 1);
            ++rslLen;
            --rslFirst;
        }
        while (rslBuf[rslFirst + rslLen - 2] == 1) {
            --rslLen;
        }
        if (rslLen > 21) {
            rslPtr = rslFirst + 19;
            rslLen = 21;
            if (rslBuf[rslPtr + 1] > 50) {
                while (rslBuf[rslPtr] == 100) {
                    --rslPtr;
                    --rslLen;
                }
                if (rslPtr < rslFirst) {
                    rslBuf[rslFirst] = 2;
                    rslExp = (short)(rslExp + 1);
                    ++rslLen;
                }
                int n3 = rslPtr;
                rslBuf[n3] = (byte)(rslBuf[n3] + 1);
            } else {
                while (rslBuf[rslFirst + rslLen - 2] == 1) {
                    --rslLen;
                }
            }
        }
        if ((rslExp & 0xFFFF) > 255) {
            if (op1Pos == op2Pos) {
                return NUMBER._makePosInf();
            }
            return NUMBER._makeNegInf();
        }
        if ((rslExp & 0xFFFF) < 128) {
            return NUMBER._makeZero();
        }
        if (op1Pos != op2Pos) {
            rslp = new byte[++rslLen];
            rslp[0] = (byte)(~rslExp);
            for (int i2 = 0; i2 < rslLen - 1; ++i2) {
                rslp[i2 + 1] = (byte)(102 - rslBuf[rslFirst + i2]);
            }
            rslp[rslLen - 1] = 102;
        } else {
            rslp = new byte[rslLen];
            rslp[0] = (byte)rslExp;
            for (int i3 = 0; i3 < rslLen - 1; ++i3) {
                rslp[i3 + 1] = rslBuf[rslFirst + i3];
            }
        }
        return rslp;
    }

    private static int LnxmulSetSum(int[] ptr1, int[] ptr2, int index1, int index2, int element, int sum) throws SQLException {
        int ret = 0;
        try {
            ret = sum + ptr1[index1 - element] * ptr2[index2 + element];
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new SQLException(CoreException.getMessage((byte)4));
        }
        return ret;
    }

    private static int LnxmulSetDigit1(byte[] rslBuf, int index, int sum) {
        int quotient1 = sum / 100;
        int quotient2 = sum / 10000;
        rslBuf[(index -= 2) + 1] = (byte)(sum - quotient1 * 100 + 1);
        rslBuf[index] = (byte)(quotient1 - quotient2 * 100 + 1);
        return quotient2;
    }

    private static void LnxmulSetDigit2(byte[] rslBuf, int index, int sum) {
        int quotient = sum / 100;
        rslBuf[index -= 2] = (byte)(quotient + 1);
        rslBuf[index + 1] = (byte)(sum - quotient * 100 + 1);
    }

    @Override
    public byte[] lnxneg(byte[] n2) throws SQLException {
        if (NUMBER._isZero(n2)) {
            return NUMBER._makeZero();
        }
        if (NUMBER._isPosInf(n2)) {
            return NUMBER._makeNegInf();
        }
        if (NUMBER._isNegInf(n2)) {
            return NUMBER._makePosInf();
        }
        int len = n2.length;
        if (!NUMBER._isPositive(n2) && n2[len - 1] == 102) {
            --len;
        }
        byte[] temp = new byte[len];
        System.arraycopy(n2, 0, temp, 0, len);
        LnxLibThin._negateNumber(temp);
        return LnxLibThin._setLength(temp, len);
    }

    @Override
    public byte[] lnxpow(byte[] n2, int power) throws SQLException {
        byte[] z2;
        if (power >= 0) {
            z2 = new byte[n2.length];
            System.arraycopy(n2, 0, z2, 0, n2.length);
        } else {
            int MIN_INT_JAVA = Integer.MIN_VALUE;
            if (power == MIN_INT_JAVA) {
                byte[] z3 = this.lnxpow(n2, MIN_INT_JAVA + 1);
                return this.lnxdiv(z3, n2);
            }
            power = -power;
            z2 = this.lnxdiv(lnxqone, n2);
        }
        byte[] y2 = lnxqone;
        while (power > 0) {
            if ((power & 1) == 1) {
                y2 = this.lnxmul(y2, z2);
            }
            if ((power >>= 1) <= 0) continue;
            z2 = this.lnxmul(z2, z2);
        }
        return y2;
    }

    @Override
    public byte[] lnxrou(byte[] n2, int decimal_place) throws SQLException {
        int outLen;
        byte outEnd;
        byte[] out;
        int inpSign;
        byte inpMaximum;
        byte inpZero;
        boolean odd;
        int offset;
        boolean inpPos;
        byte inp;
        block26: {
            block25: {
                int nlen = n2.length;
                inp = 0;
                if (nlen == 1) {
                    if (n2[inp] == -128) {
                        return NUMBER._makeZero();
                    }
                    return NUMBER._makeNegInf();
                }
                if (nlen == 2 && n2[0] == -1 && n2[1] == 101) {
                    return NUMBER._makePosInf();
                }
                int expon = n2[0] < 0 ? 256 + n2[0] : n2[0];
                inpPos = NUMBER._isPositive(n2);
                if (inpPos) {
                    if (decimal_place >= 0) {
                        offset = expon + (decimal_place + 1 >> 1) - 192;
                        odd = (decimal_place & 1) != 0;
                    } else {
                        decimal_place = -decimal_place;
                        offset = expon - (decimal_place >> 1) - 192;
                        odd = (decimal_place & 1) != 0;
                    }
                    inpZero = 1;
                    inpMaximum = 100;
                    inpSign = 1;
                } else {
                    if (decimal_place >= 0) {
                        offset = 63 + (decimal_place + 1 >> 1) - expon;
                        odd = (decimal_place & 1) != 0;
                    } else {
                        decimal_place = -decimal_place;
                        offset = 63 - (decimal_place >> 1) - expon;
                        odd = (decimal_place & 1) != 0;
                    }
                    inpZero = 101;
                    inpMaximum = 2;
                    inpSign = -1;
                    nlen -= n2[nlen - 1] == 102 ? 1 : 0;
                }
                out = new byte[nlen];
                System.arraycopy(n2, 0, out, 0, nlen);
                if (offset > nlen - 1 || offset == nlen - 1 && (!odd || LnxqFirstDigit[n2[offset]] == 1)) {
                    return LnxLibThin._setLength(n2, nlen);
                }
                if (offset < 0 || offset == 0 && (odd || (!inpPos ? n2[1] > 51 : n2[1] < 51))) break block25;
                if (offset != 1 || !odd || !(inpPos ? n2[1] < 6 : n2[1] > 96)) break block26;
            }
            return NUMBER._makeZero();
        }
        if (offset == 0) {
            if (inpPos ? n2[inp] == -1 : n2[inp] == 0) {
                if (inpPos) {
                    return NUMBER._makePosInf();
                }
                return NUMBER._makeNegInf();
            }
            out[0] = (byte)(n2[inp] + inpSign);
            out[1] = (byte)(inpZero + inpSign);
            return LnxLibThin._setLength(out, 2);
        }
        byte inpEnd = outEnd = (byte)offset;
        out[outEnd] = odd ? (inpPos ? LnxqRound_P[n2[inpEnd]] : LnxqRound_N[n2[inpEnd]]) : ((inpPos ? n2[inpEnd + 1] > 50 : n2[inpEnd + 1] < 52) ? (byte)(n2[inpEnd] + inpSign) : n2[inpEnd]);
        if (out[outEnd] == inpMaximum + inpSign) {
            for (inpEnd = (byte)(inpEnd - 1); inpEnd > inp && n2[inpEnd] == inpMaximum; inpEnd = (byte)(inpEnd - 1)) {
            }
            if (inpEnd == inp) {
                if (inpPos ? n2[inp] == -1 : n2[inp] == 0) {
                    if (inpPos) {
                        return NUMBER._makePosInf();
                    }
                    return NUMBER._makeNegInf();
                }
                out[0] = (byte)(n2[inp] + inpSign);
                out[1] = (byte)(inpZero + inpSign);
                return LnxLibThin._setLength(out, 2);
            }
            out[inpEnd - inp] = (byte)(n2[inpEnd] + inpSign);
            outLen = inpEnd - inp + 1;
            inpEnd = (byte)(inpEnd - 1);
        } else if (out[outEnd] == inpZero) {
            while (n2[inpEnd] == inpZero) {
                inpEnd = (byte)(inpEnd - 1);
            }
            outLen = inpEnd - inp + 1;
        } else {
            outLen = offset + 1;
        }
        return LnxLibThin._setLength(out, outLen);
    }

    @Override
    public byte[] lnxsca(byte[] n2, int left, int right, boolean[] big) throws SQLException {
        int inlen = n2.length;
        if (inlen != 1) {
            byte mantn;
            byte mant1;
            byte xpon;
            if (NUMBER._isPositive(n2)) {
                xpon = (byte)((n2[0] & 0xFFFFFF7F) - 65);
                mant1 = n2[1];
                mantn = n2[inlen - 1];
            } else {
                xpon = (byte)((~n2[0] & 0xFFFFFF7F) - 65);
                mant1 = LnxqNegate[n2[1]];
                mantn = LnxqNegate[n2[--inlen - 1]];
            }
            if (2 * (inlen - (xpon + 1) - 1) - (mantn % 10 == 1 ? 1 : 0) > right) {
                byte[] outnum = this.lnxrou(n2, right);
                if (NUMBER._isPositive(outnum)) {
                    xpon = (byte)((outnum[0] & 0xFFFFFF7F) - 65);
                    mant1 = outnum.length != 1 ? outnum[1] : (byte)1;
                } else {
                    xpon = (byte)((~outnum[0] & 0xFFFFFF7F) - 65);
                    mant1 = LnxqNegate[outnum[1]];
                }
                big[0] = 2 * (xpon + 1) - (mant1 < 11 ? 1 : 0) > left;
                return outnum;
            }
            int nlength = n2.length;
            byte[] temp = new byte[nlength];
            System.arraycopy(n2, 0, temp, 0, nlength);
            big[0] = 2 * (xpon + 1) - (mant1 < 11 ? 1 : 0) > left;
            return temp;
        }
        big[0] = false;
        return NUMBER._makeZero();
    }

    @Override
    public byte[] lnxshift(byte[] n2, int nDig) throws SQLException {
        byte[] inNum = n2;
        int inLen = inNum.length;
        byte[] outNum = new byte[22];
        int inPtr = 0;
        int outPtr = 0;
        int i2 = inLen == 1 ? 0 : 1;
        if ((inNum[0] & 0xFF) == 128 && inLen == 1 || inLen == 2 && (inNum[0] & 0xFF) == 255 && inNum[i2] == 101 || inLen == 1 && inNum[0] == 0) {
            byte[] rslp = new byte[inLen];
            for (i2 = 0; i2 < inLen; ++i2) {
                rslp[i2] = inNum[i2];
            }
            return rslp;
        }
        boolean negative = inNum[0] >> 7 == 0;
        int exponent = negative ? 255 - inNum[0] & 0xFF : inNum[0] & 0xFF;
        int length = inLen;
        if ((nDig & 1) > 0) {
            byte zero;
            byte[][] digitPtr;
            byte[][] componentPtr;
            if (negative) {
                if (inNum[length - 1] == 102) {
                    --length;
                }
                componentPtr = LnxqComponents_N;
                digitPtr = LnxqDigit_N;
                zero = 101;
            } else {
                componentPtr = LnxqComponents_P;
                digitPtr = LnxqDigit_P;
                zero = 1;
            }
            if (componentPtr[inNum[1]][0] != 0) {
                boolean round;
                exponent = nDig >= 0 ? exponent + (nDig / 2 + 1) : exponent - -nDig / 2;
                inPtr = length - 2;
                outPtr = length - 1;
                if (length > 20) {
                    round = componentPtr[inNum[inPtr + 1]][1] >= 5;
                } else {
                    outNum[outPtr + 1] = digitPtr[componentPtr[inNum[inPtr + 1]][1]][0];
                    ++length;
                    round = false;
                }
                while (inPtr > 0) {
                    outNum[outPtr] = digitPtr[componentPtr[inNum[inPtr + 0]][1]][componentPtr[inNum[inPtr + 1]][0]];
                    --inPtr;
                    --outPtr;
                }
                outNum[1] = digitPtr[0][componentPtr[inNum[inPtr + 1]][0]];
                if (round) {
                    byte maximum = negative ? (byte)2 : 100;
                    int carry = negative ? -1 : 1;
                    outPtr = 20;
                    while (outNum[outPtr] == maximum) {
                        --outPtr;
                        --length;
                    }
                    int n3 = outPtr;
                    outNum[n3] = (byte)(outNum[n3] + carry);
                }
            } else {
                exponent = nDig >= 0 ? exponent + nDig / 2 : exponent - (-nDig / 2 + 1);
                inPtr = 1;
                for (outPtr = 1; outPtr < length - 1; ++outPtr) {
                    outNum[outPtr] = digitPtr[componentPtr[inNum[inPtr + 0]][1]][componentPtr[inNum[inPtr + 1]][0]];
                    ++inPtr;
                }
                outNum[outPtr] = digitPtr[componentPtr[inNum[inPtr + 0]][1]][0];
            }
            while (outNum[length - 1] == zero) {
                --length;
            }
            if (negative) {
                outNum[++length - 1] = 102;
            }
        } else {
            exponent = nDig >= 0 ? exponent + nDig / 2 : exponent - -(nDig / 2);
            for (i2 = 1; i2 < length; ++i2) {
                outNum[i2] = inNum[i2];
            }
        }
        if (exponent > 255) {
            byte[] rslp = negative ? new byte[]{0} : new byte[]{-1, 101};
            return rslp;
        }
        if (exponent < 128) {
            byte[] rslp = new byte[]{-128};
            return rslp;
        }
        outNum[0] = negative ? (byte)(255 - exponent) : (byte)exponent;
        byte[] rslp = new byte[length];
        for (i2 = 0; i2 < length; ++i2) {
            rslp[i2] = outNum[i2];
        }
        return rslp;
    }

    @Override
    public byte[] lnxsin(byte[] n2) throws SQLException {
        return this.lnxqtra(n2, 4);
    }

    @Override
    public byte[] lnxsnh(byte[] n2) throws SQLException {
        return this.lnxqtra(n2, 7);
    }

    @Override
    public byte[] lnxsqr(byte[] n2) throws SQLException {
        int rslEnd;
        int remain;
        int index;
        int nlen = n2.length;
        int[] num = new int[29];
        int[] rsl = new int[29];
        if (!NUMBER._isPositive(n2)) {
            return NUMBER._makeNegInf();
        }
        if (NUMBER._isPosInf(n2)) {
            return NUMBER._makePosInf();
        }
        if (NUMBER._isZero(n2)) {
            return NUMBER._makeZero();
        }
        int exponent = (n2[0] & 0xFF) - 193;
        for (index = 1; index < nlen; ++index) {
            num[index] = n2[index] - 1;
        }
        int nump = 1;
        int numEnd = nump + 20 + 3;
        if ((exponent + 128 & 1) != 0) {
            remain = ((num[nump] * 100 + num[nump + 1]) * 100 + num[nump + 2]) * 100 + num[nump + 3];
            nump += 3;
        } else {
            remain = (num[nump] * 100 + num[nump + 1]) * 100 + num[nump + 2];
            nump += 2;
        }
        int approx = (int)(Math.sqrt(remain) * 100.0);
        rsl[1] = approx / 10000;
        rsl[2] = approx / 100 % 100;
        rsl[3] = approx % 100;
        remain -= rsl[1] * approx;
        remain = remain * 100 + num[nump + 1];
        remain -= rsl[2] * approx;
        remain = remain * 100 + num[nump + 2];
        remain -= rsl[3] * approx;
        nump += 3;
        approx *= 2;
        int rslStart = 3;
        int rslp = rslStart + 1;
        while (nump < numEnd) {
            int np;
            remain = remain * 100 + num[nump];
            int digit = remain / approx;
            remain -= digit * approx;
            rsl[rslp] = digit;
            int n3 = rslEnd = rslStart + (numEnd - nump) < rslp ? rslStart + (numEnd - nump) : rslp;
            if (digit != 0) {
                np = nump + 1;
                for (int rp = rslStart + 1; rp < rslEnd; ++rp) {
                    int n4 = np++;
                    num[n4] = num[n4] - 2 * digit * rsl[rp];
                }
                if (np < numEnd) {
                    int n5 = np;
                    num[n5] = num[n5] - digit * digit;
                }
            } else if (remain == 0) {
                for (np = nump + 1; np < numEnd && num[np] == 0; ++np) {
                }
                if (np == numEnd) break;
            }
            ++nump;
            ++rslp;
        }
        rslEnd = rslp--;
        rsl[0] = 0;
        while (rslp > 0) {
            while (rsl[rslp] > 99) {
                int n6 = rslp;
                rsl[n6] = rsl[n6] - 100;
                int n7 = rslp - 1;
                rsl[n7] = rsl[n7] + 1;
            }
            while (rsl[rslp] < 0) {
                int n8 = rslp;
                rsl[n8] = rsl[n8] + 100;
                int n9 = rslp - 1;
                rsl[n9] = rsl[n9] - 1;
            }
            --rslp;
        }
        exponent = (exponent - (exponent + 128 & 1)) / 2 + 1;
        while (rsl[rslp] == 0) {
            ++rslp;
            if (--exponent >= -65) continue;
            return NUMBER._makeZero();
        }
        while (rsl[--rslEnd] == 0) {
        }
        int rslLen = rslEnd - rslp + 2;
        if (rslLen > 21) {
            rslEnd = rslp + 20;
            if (rsl[rslEnd] >= 50) {
                while (rsl[--rslEnd] == 99) {
                }
                int n10 = rslEnd;
                rsl[n10] = rsl[n10] + 1;
            } else {
                while (rsl[--rslEnd] == 0) {
                }
            }
            if (rslEnd < rslp) {
                rslp = rslEnd;
                if (++exponent > 62) {
                    return NUMBER._makePosInf();
                }
            }
            rslLen = rslEnd - rslp + 2;
        }
        byte[] out = new byte[rslLen];
        out[0] = (byte)(exponent - 63);
        for (index = rslp; index <= rslEnd; ++index) {
            out[index - (rslp - 1)] = (byte)(rsl[index] + 1);
        }
        return out;
    }

    @Override
    public byte[] lnxsub(byte[] n1, byte[] n2) throws SQLException {
        return this.lnxadd(n1, this.lnxneg(n2));
    }

    @Override
    public byte[] lnxtan(byte[] n2) throws SQLException {
        return this.lnxqtra(n2, 5);
    }

    @Override
    public byte[] lnxtnh(byte[] n2) throws SQLException {
        return this.lnxqtra(n2, 8);
    }

    @Override
    public byte[] lnxtru(byte[] n2, int decimal_place) throws SQLException {
        int outLen;
        byte inpEnd;
        byte inpZero;
        boolean odd;
        int offset;
        int len = n2.length;
        if (NUMBER._isZero(n2)) {
            return NUMBER._makeZero();
        }
        if (NUMBER._isNegInf(n2)) {
            return NUMBER._makeNegInf();
        }
        if (NUMBER._isPosInf(n2)) {
            return NUMBER._makePosInf();
        }
        int expon = n2[0] < 0 ? 256 + n2[0] : n2[0];
        boolean inpPos = NUMBER._isPositive(n2);
        if (inpPos) {
            if (decimal_place >= 0) {
                offset = expon + (decimal_place + 1 >> 1) - 192;
                odd = (decimal_place & 1) == 1;
            } else {
                decimal_place = -decimal_place;
                offset = expon - (decimal_place >> 1) - 192;
                odd = (decimal_place & 1) == 1;
            }
            inpZero = 1;
        } else {
            if (decimal_place >= 0) {
                offset = 63 + (decimal_place + 1 >> 1) - expon;
                odd = (decimal_place & 1) == 1;
            } else {
                decimal_place = -decimal_place;
                offset = 63 - (decimal_place >> 1) - expon;
                odd = (decimal_place & 1) == 1;
            }
            inpZero = 101;
            if (n2[len - 1] == 102) {
                --len;
            }
        }
        byte[] op = new byte[len];
        System.arraycopy(n2, 0, op, 0, len);
        if (offset > len - 1 || offset == len - 1 && (odd || LnxqFirstDigit[n2[offset]] == 1)) {
            return LnxLibThin._setLength(n2, len);
        }
        if (offset <= 0 || offset == 1 && odd && (inpPos ? n2[1] < 11 : n2[1] > 91)) {
            return NUMBER._makeZero();
        }
        byte outEnd = inpEnd = (byte)offset;
        op[outEnd] = odd ? (inpPos ? LnxqTruncate_P[n2[inpEnd]] : LnxqTruncate_N[n2[inpEnd]]) : n2[inpEnd];
        inpEnd = (byte)(inpEnd - 1);
        if (op[outEnd] == inpZero) {
            while (n2[inpEnd] == inpZero) {
                inpEnd = (byte)(inpEnd - 1);
            }
            outLen = inpEnd + 1;
        } else {
            outLen = offset + 1;
        }
        return LnxLibThin._setLength(op, outLen);
    }

    @Override
    public byte[] lnxcpn(String num, boolean precflag, int preclen, boolean scaleflag, int scalelen, String lang) throws SQLException {
        int opTerm;
        int digitsUsed;
        int opStart;
        int afterDigits;
        int beforeDigits;
        int opPtr;
        Locale currloc;
        int opAfter = 0;
        int exponent = 0;
        boolean numNegative = false;
        boolean expNegative = false;
        int lengthBRC = 0;
        int digitsBRC = 0;
        int lengthARC = 0;
        int digitsARC = 0;
        int lengthExp = 0;
        int digitsExp = 0;
        boolean isRadix = false;
        boolean overRadix = false;
        boolean leadingDigit = false;
        boolean trailingDigit = false;
        boolean wnr = false;
        if (lang != null) {
            int unsc = lang.indexOf("_");
            if (unsc == -1) {
                currloc = LxMetaData.getJavaLocale(lang, "");
            } else {
                String la = lang.substring(0, unsc);
                String terr = lang.substring(unsc + 1);
                currloc = LxMetaData.getJavaLocale(la, terr);
            }
            if (currloc == null) {
                currloc = Locale.getDefault(Locale.Category.FORMAT);
            }
        } else {
            currloc = Locale.getDefault(Locale.Category.FORMAT);
        }
        DecimalFormatSymbols currdfs = new DecimalFormatSymbols(currloc);
        char radix = currdfs.getDecimalSeparator();
        char minus = currdfs.getMinusSign();
        char[] opArray = num.toCharArray();
        int opLast = opArray.length - 1;
        for (opPtr = 0; opPtr <= opLast && Character.isSpaceChar(opArray[opPtr]); ++opPtr) {
        }
        if (opPtr <= opLast && (opArray[opPtr] == minus || opArray[opPtr] == '+')) {
            numNegative = opArray[opPtr] == minus;
            ++opPtr;
        }
        int opCurrent = opPtr;
        while (opPtr <= opLast && opArray[opPtr] == '0') {
            ++opPtr;
        }
        int opBefore = opPtr;
        while (opPtr <= opLast && Character.isDigit(opArray[opPtr])) {
            ++opPtr;
        }
        lengthBRC = opPtr - opCurrent;
        digitsBRC = opPtr - opBefore;
        if (opPtr <= opLast && opArray[opPtr] == radix) {
            opAfter = ++opPtr;
            while (opPtr <= opLast && Character.isDigit(opArray[opPtr])) {
                ++opPtr;
            }
            lengthARC = opPtr - opAfter;
            opCurrent = opPtr;
            while (--opPtr >= opAfter && opArray[opPtr] == '0') {
            }
            digitsARC = opPtr - opAfter + 1;
            opPtr = opCurrent;
        }
        if (lengthBRC + lengthARC != 0) {
            if (opPtr <= opLast && (opArray[opPtr] == 'E' || opArray[opPtr] == 'e')) {
                if (++opPtr <= opLast && (opArray[opPtr] == minus || opArray[opPtr] == '+')) {
                    expNegative = opArray[opPtr] == minus;
                    ++opPtr;
                }
                opCurrent = opPtr;
                while (opPtr <= opLast && opArray[opPtr] == '0') {
                    ++opPtr;
                }
                int opExponent = opPtr;
                while (opPtr <= opLast && Character.isDigit(opArray[opPtr])) {
                    exponent = exponent * 10 + (opArray[opPtr] - 48);
                    ++opPtr;
                }
                lengthExp = opPtr - opCurrent;
                digitsExp = opPtr - opExponent;
                if (lengthExp != 0 && expNegative) {
                    exponent = -exponent;
                }
            }
            while (opPtr <= opLast && Character.isSpaceChar(opArray[opPtr])) {
                ++opPtr;
            }
        }
        if (digitsBRC != 0) {
            if (digitsARC != 0) {
                exponent += digitsBRC - 1;
                beforeDigits = digitsBRC;
                afterDigits = digitsARC;
                opStart = opBefore;
            } else {
                exponent += digitsBRC - 1;
                opPtr = opBefore + (digitsBRC - 1);
                while (opArray[opPtr] == '0') {
                    --opPtr;
                }
                beforeDigits = opPtr - opBefore + 1;
                afterDigits = 0;
                opStart = opBefore;
            }
        } else if (digitsARC != 0) {
            opPtr = opAfter;
            while (opArray[opPtr] == '0') {
                ++opPtr;
            }
            exponent -= opPtr - opAfter + 1;
            beforeDigits = digitsARC - (opPtr - opAfter);
            afterDigits = 0;
            opStart = opPtr;
        } else {
            return NUMBER._makeZero();
        }
        int digitsMaximum = (exponent & 1) == 1 ? 40 : 39;
        int digitsInput = beforeDigits + afterDigits;
        if (precflag || scaleflag) {
            if (!precflag) {
                preclen = Integer.MAX_VALUE;
            }
            if (!scaleflag) {
                scalelen = 0;
            }
            digitsUsed = exponent + 1 + scalelen;
        } else {
            digitsUsed = digitsInput;
        }
        digitsUsed = Math.min(digitsUsed, digitsMaximum);
        if (digitsUsed < 0 || digitsUsed == 0 && opArray[opStart] < '5') {
            return NUMBER._makeZero();
        }
        boolean roundUp = false;
        if (digitsUsed < digitsInput) {
            opPtr = opStart + digitsUsed + (digitsUsed < beforeDigits ? 0 : 1);
            if (opArray[opPtr] < '5') {
                while (--opPtr >= opStart && (opArray[opPtr] == '0' || opArray[opPtr] == radix)) {
                }
            } else {
                while (--opPtr >= opStart && (opArray[opPtr] == '9' || opArray[opPtr] == radix)) {
                }
                roundUp = true;
            }
            if (opPtr < opStart) {
                opArray[1] = 49;
                opArray[2] = 48;
                opStart = 1;
                isRadix = false;
                leadingDigit = (++exponent & 1) != 1;
                trailingDigit = false;
                beforeDigits = (exponent & 1) == 1 ? 2 : 0;
                afterDigits = 0;
                roundUp = false;
                wnr = true;
            } else if (afterDigits != 0) {
                if (opPtr - opStart < beforeDigits) {
                    beforeDigits = opPtr - opStart + 1;
                    afterDigits = 0;
                } else {
                    afterDigits = opPtr - opStart - beforeDigits;
                }
            } else {
                beforeDigits = opPtr - opStart + 1;
            }
        }
        if (!wnr) {
            if (afterDigits != 0) {
                isRadix = true;
                overRadix = (exponent & 1) == (beforeDigits & 1);
                leadingDigit = (exponent & 1) != 1;
                trailingDigit = overRadix != ((afterDigits & 1) == 1);
                beforeDigits -= (leadingDigit ? 1 : 0) + (overRadix ? 1 : 0);
                afterDigits -= (overRadix ? 1 : 0) + (trailingDigit ? 1 : 0);
            } else {
                isRadix = false;
                leadingDigit = (exponent & 1) != 1;
                trailingDigit = (exponent & 1) == (beforeDigits & 1);
                beforeDigits -= (leadingDigit ? 1 : 0) + (trailingDigit ? 1 : 0);
            }
        }
        if (!(expNegative || digitsExp <= 3 && exponent <= 125)) {
            if (numNegative) {
                return NUMBER._makeNegInf();
            }
            return NUMBER._makePosInf();
        }
        if (expNegative && (digitsExp > 3 || exponent < -130)) {
            return NUMBER._makeZero();
        }
        byte[] rslArray = new byte[22];
        int rslPtr = 1;
        opPtr = opStart;
        if (leadingDigit) {
            rslArray[rslPtr] = LnxLibThin.digitPtr(0, LnxLibThin.lnxqctn(opArray[opPtr]), numNegative);
            ++rslPtr;
            ++opPtr;
        }
        if (beforeDigits != 0) {
            opTerm = opPtr + beforeDigits;
            while (opPtr < opTerm) {
                rslArray[rslPtr] = LnxLibThin.digitPtr(LnxLibThin.lnxqctn(opArray[opPtr]), LnxLibThin.lnxqctn(opArray[opPtr + 1]), numNegative);
                ++rslPtr;
                opPtr += 2;
            }
        }
        if (isRadix) {
            if (overRadix) {
                rslArray[rslPtr] = LnxLibThin.digitPtr(LnxLibThin.lnxqctn(opArray[opPtr]), LnxLibThin.lnxqctn(opArray[opPtr + 2]), numNegative);
                ++rslPtr;
                opPtr += 3;
            } else {
                ++opPtr;
            }
        }
        if (afterDigits != 0) {
            opTerm = opPtr + afterDigits;
            while (opPtr < opTerm) {
                rslArray[rslPtr] = LnxLibThin.digitPtr(LnxLibThin.lnxqctn(opArray[opPtr]), LnxLibThin.lnxqctn(opArray[opPtr + 1]), numNegative);
                ++rslPtr;
                opPtr += 2;
            }
        }
        if (trailingDigit) {
            rslArray[rslPtr] = LnxLibThin.digitPtr(LnxLibThin.lnxqctn(opArray[opPtr]), 0, numNegative);
            ++rslPtr;
            ++opPtr;
        }
        if (roundUp) {
            int n2 = rslPtr - 1;
            rslArray[n2] = (byte)(rslArray[n2] + (numNegative ? -1 : 1) * (trailingDigit ? 10 : 1));
        }
        int rslExp = exponent < 0 ? (int)(193 - (1 - exponent) / 2) : (int)(193 + exponent / 2);
        int rslLen = rslPtr;
        rslArray[0] = (byte)(numNegative ? ~rslExp : rslExp);
        return LnxLibThin._setLength(rslArray, rslLen);
    }

    private static byte digitPtr(int index1, int index2, boolean sign) {
        return sign ? LnxqDigit_N[index1][index2] : LnxqDigit_P[index1][index2];
    }

    private static int lnxqctn(char charnum) {
        return Character.digit(charnum, 10);
    }

    @Override
    public byte[] lnxfcn(String num, String fmt, String lang) throws SQLException {
        int LNXFCN_MINUS = 45;
        int LNXFCN_PLUS = 43;
        int LNXFCN_PERIOD = 46;
        int LNXFCN_COMMA = 44;
        int LNXFCN_DOLLAR = 36;
        int LNXFCN_LT = 60;
        int LNXFCN_GT = 62;
        int LNXFCN_LPAR = 40;
        int LNXFCN_RPAR = 41;
        int LNXFCN_A = 65;
        int LNXFCN_a = 97;
        int LNXFCN_E = 69;
        int LNXFCN_e = 101;
        int LNXFCN_F = 70;
        int LNXFCN_f = 102;
        int LNXFCN_ZERO = 48;
        int LNXFCN_FIVE = 53;
        int LNXQMAXBUFSIZE = 255;
        if (lang != null && !lang.equals("AMERICAN_AMERICAN")) {
            throw new SQLException(CoreException.getMessage((byte)12));
        }
        LnxLibThinFormat lnxFmt = new LnxLibThinFormat();
        lnxFmt.parseFormat(fmt);
        lnxFmt.LNXNFRDX = true;
        int nlhd = lnxFmt.lnxnflhd;
        int nrhd = lnxFmt.lnxnfrhd;
        int nsiz = lnxFmt.lnxnfsiz;
        int nzld = lnxFmt.lnxnfzld;
        if (lnxFmt.LNXNFFDA | lnxFmt.LNXNFFED | lnxFmt.LNXNFFRN | lnxFmt.LNXNFFTM) {
            throw new SQLException(CoreException.getMessage((byte)5));
        }
        if (lnxFmt.LNXNFFRC | lnxFmt.LNXNFFCH | lnxFmt.LNXNFFCT) {
            throw new SQLException(CoreException.getMessage((byte)12));
        }
        char[] numArray = num.toCharArray();
        int np = 0;
        int ep = numArray.length - 1;
        int lb = 0;
        while (np <= ep && Character.isSpaceChar(numArray[np])) {
            ++np;
            ++lb;
        }
        if (lnxFmt.LNXNFFBL && lb == nsiz && lb == numArray.length) {
            return NUMBER._makeZero();
        }
        if (np > ep) {
            throw new SQLException(CoreException.getMessage((byte)14));
        }
        char[] ibuf = new char[255];
        int ip = 0;
        if (lnxFmt.LNXNFFSH) {
            if (numArray[np] != '-' && numArray[np] != '+') {
                throw new SQLException(CoreException.getMessage((byte)14));
            }
            ibuf[ip++] = numArray[np++];
        } else if (lnxFmt.LNXNFFPR) {
            if (numArray[np] == '<') {
                ibuf[ip++] = 45;
                ++np;
            } else {
                ibuf[ip++] = 43;
            }
        } else if (lnxFmt.LNXNFFPT) {
            if (numArray[np] == '(') {
                ibuf[ip++] = 45;
                ++np;
            } else {
                ibuf[ip++] = 43;
            }
        } else if (!lnxFmt.LNXNFFMI && !lnxFmt.LNXNFFST) {
            if (numArray[np] == '-') {
                ibuf[ip++] = numArray[np++];
            }
        } else {
            ++ip;
        }
        if (np > ep) {
            throw new SQLException(CoreException.getMessage((byte)14));
        }
        if (lnxFmt.LNXNFFDS) {
            if (numArray[np] != '$') {
                throw new SQLException(CoreException.getMessage((byte)14));
            }
            if (++np > ep) {
                throw new SQLException(CoreException.getMessage((byte)14));
            }
        } else if (lnxFmt.LNXNFFCH) {
            throw new SQLException(CoreException.getMessage((byte)12));
        }
        byte[] gpsbuf = new byte[40];
        int gpsp = 0;
        int gsepp = 0;
        int dpos = 0;
        boolean decimal = false;
        while (np <= ep) {
            if (Character.isDigit(numArray[np]) || lnxFmt.LNXNFFHX && (numArray[np] >= 'a' && numArray[np] <= 'f' || numArray[np] >= 'A' && numArray[np] <= 'F')) {
                ibuf[ip++] = numArray[np++];
                ++dpos;
                continue;
            }
            if (!decimal) {
                if (lnxFmt.LNXNFRDX) {
                    if (numArray[np] == ',') {
                        ++np;
                        gpsbuf[gpsp++] = (byte)dpos;
                        continue;
                    }
                    if (numArray[np] == '.') {
                        if (dpos > nlhd || dpos < nzld) {
                            throw new SQLException(CoreException.getMessage((byte)14));
                        }
                        dpos = nlhd - dpos;
                        gpsp = 0;
                        while (lnxFmt.lnxnfgps[gsepp] != 0) {
                            byte temp = (byte)(lnxFmt.lnxnfgps[gsepp] & 0x7F);
                            if (temp > dpos) {
                                if (gpsbuf[gpsp] != temp - dpos) {
                                    throw new SQLException(CoreException.getMessage((byte)14));
                                }
                                ++gpsp;
                            }
                            ++gsepp;
                        }
                        dpos = 0;
                        decimal = true;
                        ibuf[ip] = 46;
                        ++ip;
                        ++np;
                        continue;
                    }
                } else {
                    throw new SQLException(CoreException.getMessage((byte)12));
                }
            }
            if ((numArray[np] == 'E' || numArray[np] == 'e') && lnxFmt.LNXNFFSN) {
                if (dpos <= 0 && !decimal) {
                    throw new SQLException(CoreException.getMessage((byte)14));
                }
                ibuf[ip++] = numArray[np++];
                if (np > ep) {
                    throw new SQLException(CoreException.getMessage((byte)14));
                }
                if (numArray[np] == '+' || numArray[np] == '-') {
                    ibuf[ip++] = numArray[np++];
                }
                int vp = np;
                while (np <= ep && Character.isDigit(numArray[np])) {
                    ibuf[ip++] = numArray[np++];
                }
                if (vp != np) continue;
                throw new SQLException(CoreException.getMessage((byte)14));
            }
            if (!lnxFmt.LNXNFFRC) break;
            throw new SQLException(CoreException.getMessage((byte)12));
        }
        if (!decimal) {
            int tmppos = nlhd - dpos;
            gpsp = 0;
            while (lnxFmt.lnxnfgps[gsepp] != 0) {
                byte temp = (byte)(lnxFmt.lnxnfgps[gsepp] & 0x7F);
                if (temp > tmppos) {
                    if (gpsbuf[gpsp] != temp - tmppos) {
                        throw new SQLException(CoreException.getMessage((byte)14));
                    }
                    ++gpsp;
                }
                ++gsepp;
            }
        }
        if (lnxFmt.LNXNFFCT) {
            throw new SQLException(CoreException.getMessage((byte)12));
        }
        if (lnxFmt.LNXNFFST) {
            if (np > ep) {
                throw new SQLException(CoreException.getMessage((byte)14));
            }
            if (numArray[np] != '-' && numArray[np] != '+') {
                throw new SQLException(CoreException.getMessage((byte)14));
            }
            ibuf[0] = numArray[np];
            ++np;
        } else if (lnxFmt.LNXNFFMI) {
            if (np > ep) {
                if (lnxFmt.LNXNFFIL || np != numArray.length) {
                    throw new SQLException(CoreException.getMessage((byte)14));
                }
                ibuf[0] = 43;
            } else {
                ibuf[0] = numArray[np] == '-' ? 45 : 43;
                ++np;
            }
        } else if (lnxFmt.LNXNFFPR) {
            if (numArray[np] == '>' && ibuf[0] == '-') {
                ++np;
            }
        } else if (lnxFmt.LNXNFFPT && np < numArray.length && numArray[np] == ')' && ibuf[0] == '-') {
            ++np;
        }
        if (np <= ep) {
            throw new SQLException(CoreException.getMessage((byte)14));
        }
        if (decimal) {
            if (dpos > nrhd) {
                throw new SQLException(CoreException.getMessage((byte)14));
            }
        } else {
            if (dpos > nlhd) {
                throw new SQLException(CoreException.getMessage((byte)14));
            }
            if (dpos < nzld) {
                throw new SQLException(CoreException.getMessage((byte)14));
            }
        }
        if (lnxFmt.LNXNFF05 && (decimal && dpos == nrhd || nrhd == 0)) {
            if (ibuf[--ip] != '0' && ibuf[ip] != '5') {
                throw new SQLException(CoreException.getMessage((byte)14));
            }
            ++ip;
        }
        if (lnxFmt.LNXNFFHX) {
            return this.lnxqh2n(ibuf);
        }
        return this.lnxcpn(new String(ibuf), false, 0, false, 0, lang);
    }

    @Override
    public String lnxnfn(byte[] n2, String format, String lang) throws SQLException {
        int i2;
        int i3;
        byte[] temp;
        boolean sign;
        char[] output = null;
        int nlhd = 0;
        int nrhd = 0;
        int nsiz = 0;
        int nzld = 0;
        int nztr = 0;
        int xpon = 0;
        int rhd = 0;
        int lhd = 0;
        int digs = 0;
        int index = 0;
        int numpIndex = 0;
        int gsepp = 0;
        int curcom = 0;
        int diff = 0;
        int curdig = 0;
        int dpos = 0;
        int slen = 0;
        int tmp = 0;
        byte[] nump = null;
        boolean[] big = new boolean[1];
        boolean negexp = false;
        boolean pos = true;
        boolean bot = true;
        String currsym = null;
        LnxLibThinFormat fmt = new LnxLibThinFormat();
        fmt.parseFormat(format);
        nlhd = fmt.lnxnflhd;
        nrhd = fmt.lnxnfrhd;
        nsiz = fmt.lnxnfsiz;
        nzld = fmt.lnxnfzld;
        nztr = fmt.lnxnfztr;
        if (fmt.LNXNFFRN || fmt.LNXNFFHX) {
            if (fmt.LNXNFFRN) {
                throw new SQLException(CoreException.getMessage((byte)1));
            }
            throw new SQLException(CoreException.getMessage((byte)1));
        }
        if (fmt.LNXNFFTM) {
            int length;
            int digits;
            int exponent;
            int numl = n2.length;
            if (!NUMBER._isZero(n2)) {
                int numd;
                if (NUMBER._isPositive(n2)) {
                    numd = numl - 1;
                    exponent = 2 * ((n2[0] & 0xFF) - 193) + ((n2[1] & 0xFF) > 10 ? 1 : 0);
                    digits = 2 * numd - ((n2[1] & 0xFF) < 11 ? 1 : 0) - LnxqFirstDigit[n2[numd]];
                    length = 0;
                } else {
                    if ((n2[numl - 1] & 0xFF) == 102) {
                        --numl;
                    }
                    numd = numl - 1;
                    exponent = 2 * (62 - n2[0]) + ((n2[1] & 0xFF) < 92 ? 1 : 0);
                    digits = 2 * numd - ((n2[1] & 0xFF) > 91 ? 1 : 0) - LnxqFirstDigit[n2[numd]];
                    length = 1;
                }
            } else {
                exponent = 0;
                digits = 1;
                length = 0;
            }
            length = exponent >= 0 ? (length += digits > exponent + 1 ? digits + 1 : exponent + 1) : (length += -(exponent + 1) + digits + 1);
            if (!fmt.LNXNFFSN && length > 64) {
                fmt.LNXNFFSN = true;
            }
            if (fmt.LNXNFFSN) {
                nlhd = 1;
                nrhd = digits - 1;
                nsiz = digits > 1 ? digits + 7 : 7;
            } else {
                nlhd = exponent + 1 > 0 ? exponent + 1 : 0;
                nrhd = digits - (exponent + 1) > 0 ? digits - (exponent + 1) : 0;
                int n3 = nsiz = nrhd != 0 ? nlhd + nrhd + 2 : nlhd + 1;
            }
            if (nrhd == 0) {
                fmt.LNXNFNRD = true;
            }
        }
        boolean bl = sign = (n2[0] & 0xFF) >= 128;
        if (fmt.LNXNFFSN) {
            temp = this.lnxfpr(n2, nrhd + nlhd);
        } else {
            temp = this.lnxsca(n2, nlhd, nrhd, big);
            if (big[0]) {
                throw new SQLException(CoreException.getMessage((byte)4));
            }
        }
        output = new char[64];
        index = 0;
        if (NUMBER._isZero(temp)) {
            if (fmt.LNXNFFBL) {
                if (fmt.LNXNFFIL) {
                    output = new char[nsiz];
                    for (i3 = 0; i3 < nsiz; ++i3) {
                        output[i3] = 32;
                    }
                    return new String(output);
                }
                return null;
            }
            pos = sign;
            negexp = false;
            rhd = 0;
            digs = 0;
            xpon = rhd;
            lhd = nlhd > 0 && nztr == 0 ? 1 : 0;
        } else {
            if (NUMBER._isNegInf(temp) || NUMBER._isPosInf(temp)) {
                throw new SQLException(CoreException.getMessage((byte)4));
            }
            digs = temp.length - 1;
            boolean bl2 = pos = (temp[0] & 0x80) != 0;
            if (!pos) {
                nump = new byte[digs];
                if (temp[digs] == 102) {
                    --digs;
                }
                for (i3 = 1; i3 <= digs; ++i3) {
                    nump[i3] = (byte)(102 - temp[i3]);
                }
                nump[0] = ~temp[0];
            } else {
                nump = temp;
            }
            boolean end = (nump[digs] & 0xFF) % 10 == 1;
            xpon = 2 * ((nump[0] & 0xFF) - 192);
            numpIndex = 1;
            bot = (nump[numpIndex] & 0xFF) < 11;
            if (bot) {
                curdig = ((nump[numpIndex] & 0xFF) - 1) / 10;
            }
            if (fmt.LNXNFFSN) {
                lhd = 1;
                rhd = 2 * digs - (bot ? 1 : 0) - (end ? 1 : 0) - 1;
                negexp = (xpon -= (bot ? 1 : 0) + 1) < 0;
                if (negexp) {
                    xpon = -xpon;
                }
                if (xpon < 100 && fmt.LNXNFFIL) {
                    output[index] = 32;
                    ++index;
                }
            } else {
                rhd = 2 * digs - xpon - (end ? 1 : 0);
                lhd = xpon - (bot ? 1 : 0);
                if (fmt.LNXNFF05 && (nrhd == 0 || rhd == nrhd)) {
                    int dig;
                    int mantnp = numpIndex + digs - 1;
                    if (!end) {
                        dig = (nump[mantnp] & 0xFF) % 10;
                        int n4 = dig = dig != 0 ? dig - 1 : 9;
                        if (dig <= 2) {
                            nump[mantnp] = (byte)((nump[mantnp] & 0xFF) - dig);
                        } else if (dig <= 7) {
                            nump[mantnp] = (byte)((nump[mantnp] & 0xFF) + (5 - dig));
                        }
                    } else {
                        dig = (nump[mantnp] & 0xFF) / 10;
                        if (dig <= 2) {
                            nump[mantnp] = 1;
                        } else if (dig <= 7) {
                            nump[mantnp] = 51;
                        }
                    }
                    if (dig > 7) {
                        nump = this.lnxrou(nump, rhd - 1);
                        digs = nump.length - 1;
                        end = (nump[--numpIndex] & 0xFF) % 10 == 1;
                        xpon = 2 * ((nump[numpIndex] & 0xFF) - 192);
                        if (bot = (nump[++numpIndex] & 0xFF) < 11) {
                            curdig = ((nump[numpIndex] & 0xFF) - 1) / 10;
                        }
                        rhd = 2 * digs - xpon - (end ? 1 : 0);
                        lhd = xpon - (bot ? 1 : 0);
                        if (lhd > nlhd) {
                            throw new SQLException(CoreException.getMessage((byte)4));
                        }
                    }
                }
            }
        }
        dpos = nlhd - (nzld > lhd ? nzld : lhd);
        if (dpos != 0 && fmt.LNXNFFIL) {
            int limit = dpos + index;
            i2 = 0;
            while (i2 < limit) {
                output[i2] = 32;
                ++i2;
                ++index;
            }
        }
        if (!fmt.LNXNFFMI && !fmt.LNXNFFST) {
            int ch;
            if (pos) {
                ch = fmt.LNXNFFSH ? 43 : 32;
            } else {
                int n5 = fmt.LNXNFFPR ? 60 : (ch = fmt.LNXNFFPT ? 40 : 45);
            }
            if (fmt.LNXNFFIL || ch != 32) {
                output[index] = ch;
                ++index;
            }
        }
        currsym = fmt.LNXNFFIC ? "USD" : (fmt.LNXNFFUN ? "$" : "$");
        if (fmt.LNXNFFDS) {
            output[index] = 36;
            ++index;
        } else if (fmt.LNXNFFCH) {
            i3 = 0;
            while (i3 < currsym.length()) {
                output[index] = currsym.charAt(i3);
                ++i3;
                ++index;
            }
        }
        gsepp = 0;
        while ((curcom = fmt.lnxnfgps[gsepp] & 0x7F) != 0 && curcom <= dpos) {
            ++gsepp;
        }
        if (diff > 0) {
            for (diff = nzld - (lhd > 0 ? lhd : 0); diff > 0; --diff) {
                output[index] = 48;
                ++index;
                ++dpos;
                while (dpos == curcom) {
                    output[index] = 44;
                    ++index;
                    curcom = fmt.lnxnfgps[++gsepp] & 0x7F;
                }
            }
        }
        if (lhd > 0) {
            while (lhd > 0 && digs != 0) {
                if (bot) {
                    tmp = nump != null ? (nump[numpIndex] & 0xFF) - 1 - curdig * 10 : 0;
                    ++numpIndex;
                    --digs;
                } else {
                    curdig = tmp = nump != null ? ((nump[numpIndex] & 0xFF) - 1) / 10 : 0;
                }
                output[index] = lnx_chars[tmp];
                ++index;
                ++dpos;
                while (dpos == curcom) {
                    output[index] = 44;
                    ++index;
                    curcom = fmt.lnxnfgps[++gsepp] & 0x7F;
                }
                --lhd;
                bot = !bot;
            }
            while (lhd > 0) {
                output[index] = 48;
                ++index;
                ++dpos;
                while (dpos == curcom) {
                    output[index] = 44;
                    ++index;
                    curcom = fmt.lnxnfgps[++gsepp] & 0x7F;
                }
                --lhd;
            }
        }
        if (!fmt.LNXNFNRD) {
            if (fmt.LNXNFRDX) {
                output[index] = 46;
                ++index;
            } else if (fmt.LNXNFFRC) {
                i3 = 0;
                while (i3 < currsym.length()) {
                    output[index] = currsym.charAt(i3);
                    ++i3;
                    ++index;
                }
            } else {
                output[index] = 46;
                ++index;
            }
        }
        dpos = 0;
        slen = nztr - (rhd > 0 ? rhd : 0);
        if (slen < 0) {
            slen = 0;
        }
        if (lhd != 0) {
            rhd -= lhd;
            for (lhd = -lhd; lhd != 0; --lhd) {
                output[index] = 48;
                ++index;
            }
        }
        while (digs != 0 && rhd != 0) {
            if (bot) {
                tmp = nump != null ? (nump[numpIndex] & 0xFF) - 1 - curdig * 10 : 0;
                ++numpIndex;
                --digs;
            } else {
                curdig = tmp = nump != null ? ((nump[numpIndex] & 0xFF) - 1) / 10 : 0;
            }
            output[index] = lnx_chars[tmp];
            ++index;
            --rhd;
            bot = !bot;
        }
        while (slen != 0) {
            output[index] = 48;
            ++index;
            --slen;
        }
        if (fmt.LNXNFFSN) {
            output[index] = 69;
            output[++index] = negexp ? 45 : 43;
            ++index;
            if (xpon > 99) {
                output[index] = 49;
                ++index;
                xpon -= 100;
            }
            output[index] = lnx_chars[xpon / 10];
            output[++index] = lnx_chars[xpon % 10];
            ++index;
        }
        if (fmt.LNXNFFCT) {
            i3 = 0;
            while (i3 < currsym.length()) {
                output[index] = currsym.charAt(i3);
                ++i3;
                ++index;
            }
        }
        if (pos) {
            if (fmt.LNXNFFST) {
                output[index] = 43;
                ++index;
            } else if ((fmt.LNXNFFPR || fmt.LNXNFFMI || fmt.LNXNFFPT) && fmt.LNXNFFIL) {
                output[index] = 32;
                ++index;
            }
        } else if (fmt.LNXNFFPR) {
            output[index] = 62;
            ++index;
        } else if (fmt.LNXNFFPT) {
            output[index] = 41;
            ++index;
        } else if (fmt.LNXNFFMI || fmt.LNXNFFST) {
            output[index] = 45;
            ++index;
        }
        slen = index;
        if (fmt.LNXNFFIL && slen != nsiz) {
            diff = nsiz - slen;
            char[] padarray = new char[diff];
            for (i2 = 0; i2 < diff; ++i2) {
                padarray[i2] = 32;
            }
            StringBuffer padString = new StringBuffer();
            padString.append(padarray);
            padString.append(output, 0, slen);
            return padString.toString();
        }
        return new String(output, 0, slen);
    }

    @Override
    public String lnxnuc(byte[] n2, int outStringLength, String lang) throws SQLException {
        int length;
        byte[][] componentPtr;
        byte[] numBuf = new byte[22];
        boolean overRadix = false;
        if (lang != null) {
            throw new SQLException(CoreException.getMessage((byte)12));
        }
        char[] charPtr = lnx_chars;
        int radix = 46;
        if (outStringLength == 0) {
            throw new SQLException(CoreException.getMessage((byte)13));
        }
        boolean wantFixed = outStringLength >= 0;
        if (!wantFixed) {
            outStringLength = -outStringLength;
        }
        char[] rslp = new char[outStringLength];
        boolean negative = !NUMBER._isPositive(n2);
        if (negative) {
            componentPtr = LnxqComponents_N;
            length = outStringLength - 1;
        } else {
            componentPtr = LnxqComponents_P;
            length = outStringLength;
        }
        boolean restart = true;
        while (restart) {
            int rslTerm;
            int rslPtr;
            int trailingZeros;
            int rslStart;
            int afterDigits;
            int beforeDigits;
            boolean trailingDigit;
            boolean leadingDigit;
            boolean isRadix;
            int precision;
            int digits;
            int exponent;
            int numd;
            int i2;
            int spaces;
            boolean useFixed = wantFixed;
            int numl = n2.length;
            if (numl == 1) {
                if ((n2[0] & 0xFF) == 128) {
                    if (useFixed) {
                        spaces = outStringLength - 1;
                        rslp[spaces] = charPtr[0];
                    } else {
                        if (outStringLength < 5) {
                            throw new SQLException(CoreException.getMessage((byte)13));
                        }
                        spaces = outStringLength - 5;
                        rslp[spaces] = charPtr[0];
                        rslp[spaces + 1] = charPtr[41];
                        rslp[spaces + 2] = charPtr[10];
                        rslp[spaces + 3] = charPtr[0];
                        rslp[spaces + 4] = charPtr[0];
                    }
                    if (spaces != 0) {
                        for (i2 = 0; i2 < spaces; ++i2) {
                            rslp[i2] = charPtr[12];
                        }
                    }
                    return new String(rslp);
                }
                if (outStringLength < 2) {
                    throw new SQLException(CoreException.getMessage((byte)13));
                }
                spaces = outStringLength - 2;
                rslp[spaces] = charPtr[11];
                rslp[spaces + 1] = charPtr[21];
                if (spaces != 0) {
                    for (i2 = 0; i2 < spaces; ++i2) {
                        rslp[i2] = charPtr[12];
                    }
                }
                return new String(rslp);
            }
            if (numl == 2 && (n2[0] & 0xFF) == 255 && (n2[1] & 0xFF) == 101) {
                spaces = outStringLength - 1;
                rslp[spaces] = charPtr[21];
                if (spaces != 0) {
                    for (i2 = 0; i2 < spaces; ++i2) {
                        rslp[i2] = charPtr[12];
                    }
                }
                return new String(rslp);
            }
            if (negative) {
                if (n2[numl - 1] == 102) {
                    --numl;
                }
                numd = numl - 1;
                exponent = 2 * (62 - (n2[0] & 0xFF)) + ((n2[1] & 0xFF) < 92 ? 1 : 0);
                digits = 2 * numd - ((n2[1] & 0xFF) > 91 ? 1 : 0) - LnxqFirstDigit[n2[numd]];
            } else {
                numd = numl - 1;
                exponent = 2 * ((n2[0] & 0xFF) - 193) + ((n2[1] & 0xFF) > 10 ? 1 : 0);
                digits = 2 * numd - ((n2[1] & 0xFF) < 11 ? 1 : 0) - LnxqFirstDigit[n2[numd]];
            }
            if (useFixed) {
                if (exponent >= 0) {
                    useFixed = exponent < length;
                } else {
                    boolean bl = useFixed = exponent >= -5 || digits - exponent <= length || length <= 6;
                }
            }
            if (useFixed) {
                precision = exponent >= 0 ? (length <= exponent + 1 ? length : length - 1) : length + exponent;
                if (precision < digits) {
                    n2 = this.lnxfpr(n2, precision);
                    continue;
                }
                restart = false;
                if (exponent >= 0) {
                    if (digits > exponent + 1) {
                        spaces = length - (digits + 1);
                        isRadix = true;
                        overRadix = false;
                        leadingDigit = (exponent & 1) <= 0;
                        trailingDigit = (digits - exponent & 1) <= 0;
                        int MAX_INT_JAVA = Integer.MAX_VALUE;
                        beforeDigits = exponent + 1 & MAX_INT_JAVA - 1;
                        afterDigits = digits - (exponent + 1) & MAX_INT_JAVA - 1;
                        rslStart = spaces;
                    } else {
                        spaces = length - (exponent + 1);
                        trailingZeros = exponent + 1 - digits;
                        isRadix = false;
                        leadingDigit = (exponent & 1) <= 0;
                        trailingDigit = (trailingZeros & 1) > 0;
                        beforeDigits = digits - (leadingDigit ? 1 : 0) - (trailingDigit ? 1 : 0);
                        afterDigits = 0;
                        if (trailingZeros != 0) {
                            rslPtr = spaces + (negative ? 1 : 0) + digits;
                            for (i2 = 0; i2 < trailingZeros; ++i2) {
                                rslp[rslPtr + i2] = charPtr[0];
                            }
                        }
                        rslStart = spaces;
                    }
                } else {
                    spaces = length - (digits - exponent);
                    int leadingZeros = -(exponent + 1);
                    isRadix = false;
                    leadingDigit = (leadingZeros & 1) > 0;
                    trailingDigit = (leadingZeros + digits & 1) > 0;
                    beforeDigits = 0;
                    afterDigits = digits - (leadingDigit ? 1 : 0) - (trailingDigit ? 1 : 0);
                    rslPtr = spaces;
                    if (negative) {
                        rslp[rslPtr] = charPtr[11];
                        ++rslPtr;
                        negative = false;
                    }
                    rslp[rslPtr] = radix;
                    ++rslPtr;
                    if (leadingZeros != 0) {
                        for (i2 = 0; i2 < leadingZeros; ++i2) {
                            rslp[rslPtr + i2] = charPtr[0];
                        }
                        rslPtr += leadingZeros;
                    }
                    rslStart = rslPtr;
                }
                if (spaces != 0) {
                    for (i2 = 0; i2 < spaces; ++i2) {
                        rslp[i2] = charPtr[12];
                    }
                }
            } else {
                precision = length - (exponent > 99 || exponent < -99 ? 6 : 5);
                if (precision < 2) {
                    throw new SQLException(CoreException.getMessage((byte)13));
                }
                if (precision < digits) {
                    n2 = this.lnxfpr(n2, precision);
                    continue;
                }
                restart = false;
                if (digits == 1) {
                    trailingZeros = precision - 1;
                    isRadix = true;
                    overRadix = (exponent & 1) > 0;
                    leadingDigit = !overRadix;
                    trailingDigit = false;
                    beforeDigits = 0;
                    afterDigits = 0;
                } else {
                    trailingZeros = precision - digits;
                    isRadix = true;
                    overRadix = (exponent & 1) > 0;
                    leadingDigit = !overRadix;
                    trailingDigit = overRadix == (digits & 1) > 0;
                    beforeDigits = 0;
                    afterDigits = digits - (leadingDigit ? 1 : 2) - (trailingDigit ? 1 : 0);
                }
                rslPtr = (negative ? 1 : 0) + 1 + digits;
                if (trailingZeros != 0) {
                    for (i2 = 0; i2 < trailingZeros; ++i2) {
                        rslp[rslPtr + i2] = charPtr[0];
                    }
                    rslPtr += trailingZeros;
                }
                if (exponent < 0) {
                    exponent = -exponent;
                    rslp[rslPtr] = charPtr[41];
                    rslp[rslPtr + 1] = charPtr[11];
                } else {
                    rslp[rslPtr] = charPtr[41];
                    rslp[rslPtr + 1] = charPtr[10];
                }
                if (exponent > 99) {
                    rslp[rslPtr + 2] = charPtr[1];
                    numBuf[0] = (byte)(exponent - 99);
                    rslp[rslPtr + 3] = charPtr[LnxqComponents_P[numBuf[0] & 0xFF][0]];
                    rslp[rslPtr + 4] = charPtr[LnxqComponents_P[numBuf[0] & 0xFF][1]];
                } else {
                    numBuf[0] = (byte)(exponent + 1);
                    rslp[rslPtr + 2] = charPtr[LnxqComponents_P[numBuf[0] & 0xFF][0]];
                    rslp[rslPtr + 3] = charPtr[LnxqComponents_P[numBuf[0] & 0xFF][1]];
                }
                rslStart = 0;
            }
            int numPtr = 1;
            rslPtr = rslStart;
            if (negative) {
                rslp[rslPtr] = charPtr[11];
                ++rslPtr;
            }
            if (leadingDigit) {
                rslp[rslPtr] = charPtr[componentPtr[n2[numPtr]][1]];
                ++rslPtr;
                ++numPtr;
            }
            if (beforeDigits != 0) {
                rslTerm = rslPtr + beforeDigits;
                while (rslPtr < rslTerm) {
                    rslp[rslPtr] = charPtr[componentPtr[n2[numPtr]][0]];
                    rslp[++rslPtr] = charPtr[componentPtr[n2[numPtr]][1]];
                    ++rslPtr;
                    ++numPtr;
                }
            }
            if (isRadix) {
                if (overRadix) {
                    rslp[rslPtr] = charPtr[componentPtr[n2[numPtr]][0]];
                    rslp[++rslPtr] = radix;
                    rslp[++rslPtr] = charPtr[componentPtr[n2[numPtr]][1]];
                    ++rslPtr;
                    ++numPtr;
                } else {
                    rslp[rslPtr] = radix;
                    ++rslPtr;
                }
            }
            if (afterDigits != 0) {
                rslTerm = rslPtr + afterDigits;
                while (rslPtr < rslTerm) {
                    rslp[rslPtr] = charPtr[componentPtr[n2[numPtr]][0]];
                    rslp[++rslPtr] = charPtr[componentPtr[n2[numPtr]][1]];
                    ++rslPtr;
                    ++numPtr;
                }
            }
            if (!trailingDigit) continue;
            rslp[rslPtr] = charPtr[componentPtr[n2[numPtr]][0]];
            ++rslPtr;
            ++numPtr;
        }
        return new String(rslp);
    }

    @Override
    public byte[] lnxren(double doubleNum) throws SQLException {
        int oIndex;
        if (doubleNum == 0.0) {
            return NUMBER._makeZero();
        }
        boolean isPositive = !(doubleNum < 0.0);
        doubleNum = Math.abs(doubleNum);
        int i2 = 0;
        int exponent = 0;
        if (doubleNum >= 1.0) {
            if (doubleNum < powerTable[4][1]) {
                i2 = 3;
            }
            for (i2 = 0; i2 < 8; ++i2) {
                if (!(doubleNum >= powerTable[i2][1])) continue;
                exponent += (int)powerTable[i2][0];
                doubleNum *= powerTable[i2][2];
            }
        } else {
            if (doubleNum > powerTable[4][2]) {
                i2 = 3;
            }
            for (i2 = 0; i2 < 8; ++i2) {
                if (!(doubleNum < powerTable[i2][2])) continue;
                exponent -= (int)powerTable[i2][0];
                doubleNum *= powerTable[i2][1];
            }
            if (doubleNum < 1.0) {
                --exponent;
                doubleNum *= 100.0;
            }
        }
        if (exponent > 62) {
            throw new SQLException(CoreException.getMessage((byte)3));
        }
        if (exponent < -65) {
            throw new SQLException(CoreException.getMessage((byte)2));
        }
        int digits = 8;
        boolean fullDig = !(doubleNum >= 10.0);
        byte[] mantissa = new byte[20];
        byte digit = (byte)doubleNum;
        for (oIndex = 0; oIndex < digits; ++oIndex) {
            mantissa[oIndex] = digit;
            doubleNum = (doubleNum - (double)digit) * 100.0;
            digit = (byte)doubleNum;
        }
        oIndex = digits - 1;
        if (fullDig) {
            if (digit >= 50) {
                int n2 = oIndex;
                mantissa[n2] = (byte)(mantissa[n2] + 1);
            }
        } else if (mantissa[oIndex] > 0) {
            mantissa[oIndex] = (byte)(LnxqRound_P[mantissa[oIndex]] - 1);
        }
        if (mantissa[oIndex] == 100) {
            while (mantissa[oIndex] == 100) {
                if (oIndex == 0) {
                    ++exponent;
                    mantissa[oIndex] = 1;
                    break;
                }
                mantissa[oIndex] = 0;
                int n3 = --oIndex;
                mantissa[n3] = (byte)(mantissa[n3] + 1);
            }
        }
        for (oIndex = digits - 1; oIndex != 0 && mantissa[oIndex] == 0; --oIndex) {
            digits = (byte)(digits - 1);
        }
        byte[] oranum = new byte[digits + 1];
        oranum[0] = (byte)exponent;
        System.arraycopy(mantissa, 0, oranum, 1, digits);
        return NUMBER._toLnxFmt(oranum, isPositive);
    }

    @Override
    public byte[] lnxmin(long longNum) {
        if (longNum <= Integer.MAX_VALUE && longNum >= Integer.MIN_VALUE) {
            return this.lnxmin32((int)longNum);
        }
        return this.lnxmin64(longNum);
    }

    public int lnxmin(long longNum, byte[] dst, int offset) {
        if (longNum >= Integer.MIN_VALUE && longNum <= Integer.MAX_VALUE) {
            return this.lnxmin32((int)longNum, dst, offset);
        }
        return this.lnxmin64(longNum, dst, offset);
    }

    private byte[] lnxmin64(long val) {
        int exponent;
        boolean sign = val >= 0L;
        if (sign) {
            val = -val;
        }
        int digits = exponent = this.log100(val);
        long qL = val / 100L;
        long leastDigit = qL * 100L - val;
        if (0L == leastDigit) {
            do {
                --digits;
            } while (0L == (leastDigit = (qL = (val = qL) / 100L) * 100L - val));
            if (digits == 0) {
                if (sign) {
                    byte[] dst = new byte[2];
                    this.lnxminEncodeP1((int)leastDigit, exponent, dst, 0);
                    return dst;
                }
                byte[] dst = new byte[3];
                this.lnxminEncodeN1((int)leastDigit, exponent, dst, 0);
                return dst;
            }
        }
        if (sign) {
            byte[] dst = new byte[digits + 2];
            this.lnxminEncodeP(qL, exponent, digits, (int)leastDigit, dst, 0);
            return dst;
        }
        byte[] dst = new byte[digits + 3];
        this.lnxminEncodeN(qL, exponent, digits, (int)leastDigit, dst, 0);
        return dst;
    }

    private int lnxmin64(long val, byte[] dst, int offset) {
        int exponent;
        boolean sign = val >= 0L;
        if (sign) {
            val = -val;
        }
        int digits = exponent = this.log100(val);
        long qL = val / 100L;
        long leastDigit = qL * 100L - val;
        if (0L == leastDigit) {
            do {
                --digits;
            } while (0L == (leastDigit = (qL = (val = qL) / 100L) * 100L - val));
            if (digits == 0) {
                if (sign) {
                    this.lnxminEncodeP1((int)leastDigit, exponent, dst, offset);
                    return 2;
                }
                this.lnxminEncodeN1((int)leastDigit, exponent, dst, offset);
                return 3;
            }
        }
        if (sign) {
            this.lnxminEncodeP(qL, exponent, digits, (int)leastDigit, dst, offset);
            return digits + 2;
        }
        this.lnxminEncodeN(qL, exponent, digits, (int)leastDigit, dst, offset);
        return digits + 3;
    }

    private int log100(long longNum) {
        return longNum > -10000000000L ? 4 : (longNum > -1000000000000L ? 5 : (longNum > -100000000000000L ? 6 : (longNum > -10000000000000000L ? 7 : (longNum > -1000000000000000000L ? 8 : 9))));
    }

    private void lnxminEncodeP1(int digit, int exponent, byte[] dst, int offset) {
        dst[offset] = (byte)(193 + exponent);
        dst[offset + 1] = (byte)(1 + digit);
    }

    private void lnxminEncodeN1(int digit, int exponent, byte[] dst, int offset) {
        dst[offset] = (byte)(62 - exponent);
        dst[offset + 1] = (byte)(101 - digit);
        dst[offset + 2] = 102;
    }

    private void lnxminEncodeP(long val, int exponent, int digits, int leastDigit, byte[] dst, int offset) {
        dst[offset] = (byte)(193 + exponent);
        int pos = offset + digits + 1;
        dst[pos--] = (byte)(1 + leastDigit);
        while (digits-- > 4) {
            long qL = val / 100L;
            dst[pos--] = (byte)(1L + qL * 100L - val);
            val = qL;
        }
        int val32 = (int)val;
        while (val32 <= -100) {
            int qI = val32 / 100;
            dst[pos--] = (byte)(1 + qI * 100 - val32);
            val32 = qI;
        }
        dst[pos] = (byte)(1 - val32);
    }

    private void lnxminEncodeN(long val, int exponent, int digits, int leastDigit, byte[] dst, int offset) {
        dst[offset] = (byte)(64 - (2 + exponent));
        int pos = offset + digits + 2;
        dst[pos--] = 102;
        dst[pos--] = (byte)(101 - leastDigit);
        while (digits-- > 4) {
            long qL = val / 100L;
            dst[pos--] = (byte)(101L - (qL * 100L - val));
            val = qL;
        }
        int val32 = (int)val;
        while (val32 <= -100) {
            int qI = val32 / 100;
            dst[pos--] = (byte)(101 - (qI * 100 - val32));
            val32 = qI;
        }
        dst[pos] = (byte)(101 + val32);
    }

    private byte[] lnxmin32(int val) {
        byte[] b2;
        if (val == 0) {
            b2 = new byte[]{-128};
        } else if (val < 0) {
            if (val == Integer.MIN_VALUE) {
                b2 = new byte[7];
                this.encodeIntMinValue(b2, 0);
            } else if (-val < 100) {
                b2 = new byte[]{62, (byte)(101 + val), 102};
            } else if (-val < 10000) {
                int x2 = -val % 100;
                if (x2 != 0) {
                    b2 = new byte[4];
                    b2[2] = (byte)(101 - x2);
                    b2[3] = 102;
                } else {
                    b2 = new byte[3];
                    b2[2] = 102;
                }
                b2[0] = 61;
                b2[1] = (byte)(101 - -val / 100);
            } else if (-val < 1000000) {
                int x3 = -val % 100;
                if (x3 != 0) {
                    b2 = new byte[5];
                    b2[2] = (byte)(101 - -val % 10000 / 100);
                    b2[3] = (byte)(101 - x3);
                    b2[4] = 102;
                } else {
                    x3 = -val % 10000 / 100;
                    if (x3 != 0) {
                        b2 = new byte[4];
                        b2[2] = (byte)(101 - x3);
                        b2[3] = 102;
                    } else {
                        b2 = new byte[3];
                        b2[2] = 102;
                    }
                }
                b2[0] = 60;
                b2[1] = (byte)(101 - -val / 10000);
            } else if (-val < 100000000) {
                int x4 = -val % 100;
                if (x4 != 0) {
                    b2 = new byte[6];
                    b2[2] = (byte)(101 - -val % 1000000 / 10000);
                    b2[3] = (byte)(101 - -val % 10000 / 100);
                    b2[4] = (byte)(101 - x4);
                    b2[5] = 102;
                } else {
                    x4 = -val % 10000 / 100;
                    if (x4 != 0) {
                        b2 = new byte[5];
                        b2[2] = (byte)(101 - -val % 1000000 / 10000);
                        b2[3] = (byte)(101 - x4);
                        b2[4] = 102;
                    } else {
                        x4 = -val % 1000000 / 10000;
                        if (x4 != 0) {
                            b2 = new byte[4];
                            b2[2] = (byte)(101 - x4);
                            b2[3] = 102;
                        } else {
                            b2 = new byte[3];
                            b2[2] = 102;
                        }
                    }
                }
                b2[0] = 59;
                b2[1] = (byte)(101 - -val / 1000000);
            } else {
                int x5 = -val % 100;
                if (x5 != 0) {
                    b2 = new byte[7];
                    b2[2] = (byte)(101 - -val % 100000000 / 1000000);
                    b2[3] = (byte)(101 - -val % 1000000 / 10000);
                    b2[4] = (byte)(101 - -val % 10000 / 100);
                    b2[5] = (byte)(101 - x5);
                    b2[6] = 102;
                } else {
                    x5 = -val % 10000 / 100;
                    if (x5 != 0) {
                        b2 = new byte[6];
                        b2[2] = (byte)(101 - -val % 100000000 / 1000000);
                        b2[3] = (byte)(101 - -val % 1000000 / 10000);
                        b2[4] = (byte)(101 - x5);
                        b2[5] = 102;
                    } else {
                        x5 = -val % 1000000 / 10000;
                        if (x5 != 0) {
                            b2 = new byte[5];
                            b2[2] = (byte)(101 - -val % 100000000 / 1000000);
                            b2[3] = (byte)(101 - x5);
                            b2[4] = 102;
                        } else {
                            x5 = -val % 100000000 / 1000000;
                            if (x5 != 0) {
                                b2 = new byte[4];
                                b2[2] = (byte)(101 - x5);
                                b2[3] = 102;
                            } else {
                                b2 = new byte[3];
                                b2[2] = 102;
                            }
                        }
                    }
                }
                b2[0] = 58;
                b2[1] = (byte)(101 - -val / 100000000);
            }
        } else if (val < 100) {
            b2 = new byte[]{-63, (byte)(val + 1)};
        } else if (val < 10000) {
            int x6 = val % 100;
            if (x6 != 0) {
                b2 = new byte[3];
                b2[2] = (byte)(x6 + 1);
            } else {
                b2 = new byte[]{-62, (byte)(val / 100 + 1)};
            }
        } else if (val < 1000000) {
            int x7 = val % 100;
            if (x7 != 0) {
                b2 = new byte[4];
                b2[2] = (byte)(val % 10000 / 100 + 1);
                b2[3] = (byte)(x7 + 1);
            } else {
                x7 = val % 10000 / 100;
                if (x7 != 0) {
                    b2 = new byte[3];
                    b2[2] = (byte)(x7 + 1);
                } else {
                    b2 = new byte[]{-61, (byte)(val / 10000 + 1)};
                }
            }
        } else if (val < 100000000) {
            int x8 = val % 100;
            if (x8 != 0) {
                b2 = new byte[5];
                b2[2] = (byte)(val % 1000000 / 10000 + 1);
                b2[3] = (byte)(val % 10000 / 100 + 1);
                b2[4] = (byte)(x8 + 1);
            } else {
                x8 = val % 10000 / 100;
                if (x8 != 0) {
                    b2 = new byte[4];
                    b2[2] = (byte)(val % 1000000 / 10000 + 1);
                    b2[3] = (byte)(x8 + 1);
                } else {
                    x8 = val % 1000000 / 10000;
                    if (x8 != 0) {
                        b2 = new byte[3];
                        b2[2] = (byte)(x8 + 1);
                    } else {
                        b2 = new byte[]{-60, (byte)(val / 1000000 + 1)};
                    }
                }
            }
        } else {
            int x9 = val % 100;
            if (x9 != 0) {
                b2 = new byte[6];
                b2[2] = (byte)(val % 100000000 / 1000000 + 1);
                b2[3] = (byte)(val % 1000000 / 10000 + 1);
                b2[4] = (byte)(val % 10000 / 100 + 1);
                b2[5] = (byte)(x9 + 1);
            } else {
                x9 = val % 10000 / 100;
                if (x9 != 0) {
                    b2 = new byte[5];
                    b2[2] = (byte)(val % 100000000 / 1000000 + 1);
                    b2[3] = (byte)(val % 1000000 / 10000 + 1);
                    b2[4] = (byte)(x9 + 1);
                } else {
                    x9 = val % 1000000 / 10000;
                    if (x9 != 0) {
                        b2 = new byte[4];
                        b2[2] = (byte)(val % 100000000 / 1000000 + 1);
                        b2[3] = (byte)(x9 + 1);
                    } else {
                        x9 = val % 100000000 / 1000000;
                        if (x9 != 0) {
                            b2 = new byte[3];
                            b2[2] = (byte)(x9 + 1);
                        } else {
                            b2 = new byte[]{-59, (byte)(val / 100000000 + 1)};
                        }
                    }
                }
            }
        }
        return b2;
    }

    private int lnxmin32(int val, byte[] b2, int offset) {
        if (val == 0) {
            b2[offset] = -128;
            return 1;
        }
        if (val < 0) {
            if (val == Integer.MIN_VALUE) {
                this.encodeIntMinValue(b2, offset);
                return 7;
            }
            if (-val < 100) {
                b2[offset] = 62;
                b2[offset + 1] = (byte)(101 + val);
                b2[offset + 2] = 102;
                return 3;
            }
            if (-val < 10000) {
                b2[offset] = 61;
                b2[offset + 1] = (byte)(101 - -val / 100);
                int x2 = -val % 100;
                if (x2 != 0) {
                    b2[offset + 2] = (byte)(101 - x2);
                    b2[offset + 3] = 102;
                    return 4;
                }
                b2[offset + 2] = 102;
                return 3;
            }
            if (-val < 1000000) {
                b2[offset] = 60;
                b2[offset + 1] = (byte)(101 - -val / 10000);
                int x3 = -val % 100;
                if (x3 != 0) {
                    b2[offset + 2] = (byte)(101 - -val % 10000 / 100);
                    b2[offset + 3] = (byte)(101 - x3);
                    b2[offset + 4] = 102;
                    return 5;
                }
                x3 = -val % 10000 / 100;
                if (x3 != 0) {
                    b2[offset + 2] = (byte)(101 - x3);
                    b2[offset + 3] = 102;
                    return 4;
                }
                b2[offset + 2] = 102;
                return 3;
            }
            if (-val < 100000000) {
                b2[offset] = 59;
                b2[offset + 1] = (byte)(101 - -val / 1000000);
                int x4 = -val % 100;
                if (x4 != 0) {
                    b2[offset + 2] = (byte)(101 - -val % 1000000 / 10000);
                    b2[offset + 3] = (byte)(101 - -val % 10000 / 100);
                    b2[offset + 4] = (byte)(101 - x4);
                    b2[offset + 5] = 102;
                    return 6;
                }
                x4 = -val % 10000 / 100;
                if (x4 != 0) {
                    b2[offset + 2] = (byte)(101 - -val % 1000000 / 10000);
                    b2[offset + 3] = (byte)(101 - x4);
                    b2[offset + 4] = 102;
                    return 5;
                }
                x4 = -val % 1000000 / 10000;
                if (x4 != 0) {
                    b2[offset + 2] = (byte)(101 - x4);
                    b2[offset + 3] = 102;
                    return 4;
                }
                b2[offset + 2] = 102;
                return 3;
            }
            b2[offset] = 58;
            b2[offset + 1] = (byte)(101 - -val / 100000000);
            int x5 = -val % 100;
            if (x5 != 0) {
                b2[offset + 2] = (byte)(101 - -val % 100000000 / 1000000);
                b2[offset + 3] = (byte)(101 - -val % 1000000 / 10000);
                b2[offset + 4] = (byte)(101 - -val % 10000 / 100);
                b2[offset + 5] = (byte)(101 - x5);
                b2[offset + 6] = 102;
                return 7;
            }
            x5 = -val % 10000 / 100;
            if (x5 != 0) {
                b2[offset + 2] = (byte)(101 - -val % 100000000 / 1000000);
                b2[offset + 3] = (byte)(101 - -val % 1000000 / 10000);
                b2[offset + 4] = (byte)(101 - x5);
                b2[offset + 5] = 102;
                return 6;
            }
            x5 = -val % 1000000 / 10000;
            if (x5 != 0) {
                b2[offset + 2] = (byte)(101 - -val % 100000000 / 1000000);
                b2[offset + 3] = (byte)(101 - x5);
                b2[offset + 4] = 102;
                return 5;
            }
            x5 = -val % 100000000 / 1000000;
            if (x5 != 0) {
                b2[offset + 2] = (byte)(101 - x5);
                b2[offset + 3] = 102;
                return 4;
            }
            b2[offset + 2] = 102;
            return 3;
        }
        if (val < 100) {
            b2[offset] = -63;
            b2[offset + 1] = (byte)(val + 1);
            return 2;
        }
        if (val < 10000) {
            b2[offset] = -62;
            b2[offset + 1] = (byte)(val / 100 + 1);
            int x6 = val % 100;
            if (x6 != 0) {
                b2[offset + 2] = (byte)(x6 + 1);
                return 3;
            }
            return 2;
        }
        if (val < 1000000) {
            b2[offset] = -61;
            b2[offset + 1] = (byte)(val / 10000 + 1);
            int x7 = val % 100;
            if (x7 != 0) {
                b2[offset + 2] = (byte)(val % 10000 / 100 + 1);
                b2[offset + 3] = (byte)(x7 + 1);
                return 4;
            }
            x7 = val % 10000 / 100;
            if (x7 != 0) {
                b2[offset + 2] = (byte)(x7 + 1);
                return 3;
            }
            return 2;
        }
        if (val < 100000000) {
            b2[offset] = -60;
            b2[offset + 1] = (byte)(val / 1000000 + 1);
            int x8 = val % 100;
            if (x8 != 0) {
                b2[offset + 2] = (byte)(val % 1000000 / 10000 + 1);
                b2[offset + 3] = (byte)(val % 10000 / 100 + 1);
                b2[offset + 4] = (byte)(x8 + 1);
                return 5;
            }
            x8 = val % 10000 / 100;
            if (x8 != 0) {
                b2[offset + 2] = (byte)(val % 1000000 / 10000 + 1);
                b2[offset + 3] = (byte)(x8 + 1);
                return 4;
            }
            x8 = val % 1000000 / 10000;
            if (x8 != 0) {
                b2[offset + 2] = (byte)(x8 + 1);
                return 3;
            }
            return 2;
        }
        b2[offset] = -59;
        b2[offset + 1] = (byte)(val / 100000000 + 1);
        int x9 = val % 100;
        if (x9 != 0) {
            b2[offset + 2] = (byte)(val % 100000000 / 1000000 + 1);
            b2[offset + 3] = (byte)(val % 1000000 / 10000 + 1);
            b2[offset + 4] = (byte)(val % 10000 / 100 + 1);
            b2[offset + 5] = (byte)(x9 + 1);
            return 6;
        }
        x9 = val % 10000 / 100;
        if (x9 != 0) {
            b2[offset + 2] = (byte)(val % 100000000 / 1000000 + 1);
            b2[offset + 3] = (byte)(val % 1000000 / 10000 + 1);
            b2[offset + 4] = (byte)(x9 + 1);
            return 5;
        }
        x9 = val % 1000000 / 10000;
        if (x9 != 0) {
            b2[offset + 2] = (byte)(val % 100000000 / 1000000 + 1);
            b2[offset + 3] = (byte)(x9 + 1);
            return 4;
        }
        x9 = val % 100000000 / 1000000;
        if (x9 != 0) {
            b2[offset + 2] = (byte)(x9 + 1);
            return 3;
        }
        return 2;
    }

    private void encodeIntMinValue(byte[] b2, int offset) {
        b2[offset] = 58;
        b2[offset + 1] = 80;
        b2[offset + 2] = 54;
        b2[offset + 3] = 53;
        b2[offset + 4] = 65;
        b2[offset + 5] = 53;
        b2[offset + 6] = 102;
    }

    @Override
    public double lnxnur(byte[] num) {
        double factor;
        int temp;
        int powers;
        int factidx;
        double number = 0.0;
        int digidx = 1;
        boolean Rounding = false;
        int tablemax = factorTable.length;
        byte[] oranum = NUMBER._fromLnxFmt(num);
        boolean fulldigit = oranum[1] < 10;
        double tablemaxexponent = factorTable[0][0];
        double tableminexponent = factorTable[0][0] - (double)(tablemax - 20);
        if ((double)oranum[0] > tablemaxexponent || (double)oranum[0] < tableminexponent) {
            if ((double)oranum[0] > tablemaxexponent) {
                factidx = -1;
                powers = (int)((double)oranum[0] - tablemaxexponent);
            } else {
                factidx = -1 + (tablemax - 20);
                powers = (int)((double)oranum[0] - tableminexponent);
            }
        } else {
            factidx = (int)(-1.0 + tablemaxexponent - (double)oranum[0]);
            powers = 0;
        }
        int digits = oranum.length - 1;
        if (fulldigit ? digits > 8 : digits >= 8) {
            digits = 8;
            Rounding = true;
        }
        switch (digits % 4) {
            case 3: {
                temp = (oranum[1] * 100 + oranum[2]) * 100 + oranum[3];
                factor = factorTable[factidx += 3][1];
                number = factor < 1.0 ? (double)temp / factorTable[factidx][2] : (double)temp * factorTable[factidx][1];
                digidx += 3;
                digits -= 3;
                break;
            }
            case 2: {
                temp = oranum[1] * 100 + oranum[2];
                factor = factorTable[factidx += 2][1];
                number = factor < 1.0 ? (double)temp / factorTable[factidx][2] : (double)temp * factorTable[factidx][1];
                digidx += 2;
                digits -= 2;
                break;
            }
            case 1: {
                temp = oranum[1];
                factor = factorTable[++factidx][1];
                number = factor < 1.0 ? (double)temp / factorTable[factidx][2] : (double)temp * factorTable[factidx][1];
                ++digidx;
                --digits;
                break;
            }
            default: {
                number = 0.0;
            }
        }
        while (digits > 0) {
            temp = ((oranum[digidx] * 100 + oranum[digidx + 1]) * 100 + oranum[digidx + 2]) * 100 + oranum[digidx + 3];
            factor = factorTable[factidx += 4][1];
            number = factor < 1.0 ? (number += (double)temp / factorTable[factidx][2]) : (number += (double)temp * factorTable[factidx][1]);
            digidx += 4;
            digits -= 4;
        }
        if (Rounding) {
            if (fulldigit) {
                if (oranum[digidx] > 50) {
                    temp = 1;
                    number += (double)temp * factorTable[factidx][1];
                }
            } else {
                temp = oranum[--digidx] % 10 >= 5 ? (oranum[digidx] / 10 + 1) * 10 : oranum[digidx] / 10 * 10;
                number += (double)(temp -= oranum[digidx]) * factorTable[factidx][1];
            }
        }
        if (powers != 0) {
            int powidx = 0;
            while (powers > 0) {
                if ((int)powerTable[powidx][0] <= powers) {
                    powers -= (int)powerTable[powidx][0];
                    number *= powerTable[powidx][1];
                }
                ++powidx;
            }
            while (powers < 0) {
                if ((int)powerTable[powidx][0] <= -powers) {
                    powers += (int)powerTable[powidx][0];
                    number *= powerTable[powidx][2];
                }
                ++powidx;
            }
        }
        return NUMBER._isPositive(num) ? number : -number;
    }

    @Override
    public long lnxsni(byte[] num) throws SQLException {
        int i2;
        byte exponent;
        long longNum = 0L;
        byte[] oranum = NUMBER._fromLnxFmt(num);
        int mantlen = oranum.length - 1;
        int convDigs = mantlen > (exponent = oranum[0]) + 1 ? exponent + 1 : mantlen;
        for (i2 = 0; i2 < convDigs; ++i2) {
            longNum = longNum * 100L + (long)oranum[i2 + 1];
        }
        for (i2 = exponent - mantlen; i2 >= 0; --i2) {
            longNum *= 100L;
        }
        return NUMBER._isPositive(num) ? longNum : -longNum;
    }

    private byte[] lnxqh2n(char[] ibuf) {
        int rslLen;
        int rslPtr;
        byte[] r2;
        int digitPtr;
        int txtl;
        int LNXQH2N_ZERO = 48;
        int txtp = 0;
        long[] digitBuffer = new long[14];
        int digitStart = 13;
        int digitEnd = 13;
        byte[] rslBuffer = new byte[42];
        int rslStart = 1;
        for (txtl = ibuf.length; txtl != 0 && ibuf[txtl - 1] == '\u0000'; --txtl) {
        }
        while (txtl != 0 && ibuf[txtp] == '0') {
            ++txtp;
            --txtl;
        }
        if (txtl == 0) {
            return NUMBER._makeZero();
        }
        digitBuffer[digitEnd] = 0L;
        switch (txtl % 3) {
            case 0: {
                digitBuffer[digitEnd] = this.LNXQH2N_DIGIT(ibuf[txtp], 8, digitBuffer[digitEnd]);
                ++txtp;
                --txtl;
            }
            case 2: {
                digitBuffer[digitEnd] = this.LNXQH2N_DIGIT(ibuf[txtp], 4, digitBuffer[digitEnd]);
                ++txtp;
                --txtl;
            }
            case 1: {
                digitBuffer[digitEnd] = this.LNXQH2N_DIGIT(ibuf[txtp], 0, digitBuffer[digitEnd]);
                ++txtp;
                --txtl;
                break;
            }
        }
        while (txtl != 0) {
            long value = 0L;
            value = this.LNXQH2N_DIGIT(ibuf[txtp], 8, value);
            value = this.LNXQH2N_DIGIT(ibuf[txtp + 1], 4, value);
            value = this.LNXQH2N_DIGIT(ibuf[txtp + 2], 0, value);
            for (digitPtr = digitEnd; digitPtr >= digitStart; --digitPtr) {
                digitBuffer[digitPtr] = (value += digitBuffer[digitPtr] << 12) % 1000000L;
                value /= 1000000L;
            }
            if (value != 0L) {
                digitBuffer[--digitStart] = value;
            }
            txtp += 3;
            txtl -= 3;
        }
        int digits = 3 * (digitEnd - digitStart) + 1;
        digits += digitBuffer[digitStart] >= 100L ? 1 : 0;
        int n2 = digitBuffer[digitStart] >= 10000L ? 1 : 0;
        byte[] rsl = new byte[22];
        int rslp = 0;
        rsl[rslp] = (byte)((digits += n2) + 192);
        if (digits > 20) {
            r2 = rslBuffer;
            rslPtr = rslStart;
            rslLen = 21;
        } else {
            r2 = rsl;
            rslPtr = rslp + 1;
            rslLen = digits + 1;
        }
        switch (digits % 3) {
            case 0: {
                r2[rslPtr] = (byte)(digitBuffer[digitStart] / 10000L + 1L);
                ++rslPtr;
            }
            case 2: {
                r2[rslPtr] = (byte)(digitBuffer[digitStart] % 10000L / 100L + 1L);
                ++rslPtr;
            }
            case 1: {
                r2[rslPtr] = (byte)(digitBuffer[digitStart] % 100L + 1L);
                ++rslPtr;
                break;
            }
        }
        for (digitPtr = digitStart + 1; digitPtr <= digitEnd; ++digitPtr) {
            r2[rslPtr] = (byte)(digitBuffer[digitPtr] / 10000L + 1L);
            r2[rslPtr + 1] = (byte)(digitBuffer[digitPtr] % 10000L / 100L + 1L);
            r2[rslPtr + 2] = (byte)(digitBuffer[digitPtr] % 100L + 1L);
            rslPtr += 3;
        }
        if (digits > 20) {
            rslPtr = rslStart + 20;
            if (rslBuffer[rslPtr] > 50) {
                rslBuffer[rslStart - 1] = 1;
                --rslPtr;
                while (rslBuffer[rslPtr] == 100) {
                    --rslPtr;
                    --rslLen;
                }
                int n3 = rslPtr;
                rslBuffer[n3] = (byte)(rslBuffer[n3] + 1);
                if (rslPtr < rslStart) {
                    --rslStart;
                    int n4 = rslp;
                    rsl[n4] = (byte)(rsl[n4] + 1);
                    rslLen = 2;
                }
            }
            for (int i2 = 0; i2 < rslLen; ++i2) {
                rsl[rslp + 1 + i2] = rslBuffer[rslStart + i2];
            }
        }
        rslPtr = rslp + (rslLen - 1);
        while (r2[rslPtr] == 1) {
            --rslPtr;
            --rslLen;
        }
        byte[] result = new byte[rslLen];
        System.arraycopy(rsl, 0, result, 0, rslLen);
        return result;
    }

    private long LNXQH2N_DIGIT(char ch, int shift, long value) {
        int LNXQH2N_A = 65;
        int LNXQH2N_a = 97;
        int LNXQH2N_F = 70;
        int LNXQH2N_f = 102;
        int LNXQH2N_ZERO = 48;
        if (ch >= 'a' && ch <= 'f') {
            long r2 = value + (long)(ch - 97 + 10 << shift);
            return r2;
        }
        if (ch >= 'A' && ch <= 'F') {
            long r3 = value + (long)(ch - 65 + 10 << shift);
            return r3;
        }
        long r4 = value + (long)(ch - 48 << shift);
        return r4;
    }

    private byte[] lnxqtra(byte[] n2, int funcid) throws SQLException {
        int prod;
        byte[] temp = null;
        byte[] x2 = null;
        byte[] term = null;
        byte[] lnxqpi = NUMBER.pi().shareBytes();
        byte[] lnxqneg1 = this.lnxmin(-1L);
        long power = 0L;
        if (funcid == 3 || funcid == 4 || funcid == 5) {
            term = this.lnxmul(lnxqtwo, lnxqpi);
            temp = this.lnxabs(n2);
            if (this.lnxcmp(temp = this.lnxmod(temp, term), lnxqpi) > 0) {
                temp = this.lnxsub(temp, term);
            }
            if (this.lnxsgn(n2) == -1) {
                temp = this.lnxneg(temp);
            }
            x2 = this.lnxmul(temp, temp);
        } else if (funcid == 9) {
            temp = this.lnxmod(n2, lnxqone);
            term = this.lnxsub(n2, temp);
            if ((term[0] & 0xFF) < 60) {
                return NUMBER._makeZero();
            }
            if ((term[0] & 0xFF) > 195) {
                return NUMBER._makePosInf();
            }
            power = this.lnxsni(term);
            x2 = this.lnxmul(temp, temp);
        } else {
            temp = new byte[n2.length];
            System.arraycopy(n2, 0, temp, 0, n2.length);
            x2 = this.lnxmul(temp, temp);
        }
        byte[] onex4 = null;
        byte[] x2x6 = null;
        if (funcid != 4 && funcid != 7) {
            term = lnxqone;
            onex4 = lnxqone;
            x2x6 = NUMBER._makeZero();
            int i2 = 0;
            do {
                term = this.lnxmul(x2, term);
                prod = (i2 + 1) * (i2 + 2);
                term = this.lnxqIDiv(term, prod);
                x2x6 = this.lnxadd(x2x6, term);
                term = this.lnxmul(x2, term);
                prod = ((i2 += 2) + 1) * (i2 + 2);
                i2 += 2;
            } while (((term = this.lnxqIDiv(term, prod))[0] & 0xFF) + 20 >= ((onex4 = this.lnxadd(onex4, term))[0] & 0xFF) && (x2x6[0] & 0xFF) != 255);
        }
        byte[] x1x5 = null;
        byte[] x3x7 = null;
        if (funcid != 3 && funcid != 6) {
            term = new byte[temp.length];
            System.arraycopy(temp, 0, term, 0, temp.length);
            x1x5 = new byte[temp.length];
            System.arraycopy(temp, 0, x1x5, 0, temp.length);
            x3x7 = NUMBER._makeZero();
            int i3 = 1;
            do {
                term = this.lnxmul(x2, term);
                prod = (i3 + 1) * (i3 + 2);
                term = this.lnxqIDiv(term, prod);
                x3x7 = this.lnxadd(x3x7, term);
                term = this.lnxmul(x2, term);
                prod = ((i3 += 2) + 1) * (i3 + 2);
                i3 += 2;
                term = this.lnxqIDiv(term, prod);
                x1x5 = this.lnxadd(x1x5, term);
            } while (!((term[0] & 0xFF) == 128 && term.length == 1 || (term[0] & 0xFF) >= 128 && (term[0] & 0xFF) + 20 < (x1x5[0] & 0xFF) || (term[0] & 0xFF) < 128 && (term[0] & 0xFF) > (x1x5[0] & 0xFF) + 20 || (x3x7[0] & 0xFF) == 255) && (x3x7[0] & 0xFF) != 0);
        }
        byte[] cos = null;
        byte[] sin = null;
        if (funcid == 3 || funcid == 4 || funcid == 5) {
            if (funcid == 3 || funcid == 5) {
                cos = this.lnxsub(onex4, x2x6);
                if (this.lnxcmp(cos, lnxqone) > 0) {
                    cos = lnxqone;
                } else if (this.lnxcmp(cos, lnxqneg1) < 0) {
                    cos = lnxqneg1;
                }
            }
            if (funcid == 3) {
                return cos;
            }
            sin = this.lnxsub(x1x5, x3x7);
            if (this.lnxcmp(sin, lnxqone) > 0) {
                sin = lnxqone;
            } else if (this.lnxcmp(sin, lnxqneg1) < 0) {
                sin = lnxqneg1;
            }
            if (funcid == 4) {
                return sin;
            }
            return this.lnxdiv(sin, cos);
        }
        if (funcid == 6) {
            return this.lnxadd(onex4, x2x6);
        }
        if (funcid == 7) {
            return this.lnxadd(x1x5, x3x7);
        }
        sin = this.lnxadd(x1x5, x3x7);
        cos = this.lnxadd(onex4, x2x6);
        if (funcid == 8) {
            if (Arrays.equals(sin, cos)) {
                return new NUMBER(1).shareBytes();
            }
            return this.lnxdiv(sin, cos);
        }
        byte[] lnxqe = NUMBER.e().shareBytes();
        byte[] exp = this.lnxadd(cos, sin);
        temp = this.lnxpow(lnxqe, (int)power);
        exp = this.lnxmul(exp, temp);
        return exp;
    }

    private byte[] lnxqtri(byte[] n2, int funcid) throws SQLException {
        int comparison;
        byte[] st1 = null;
        byte[] st2 = null;
        byte[] st3 = null;
        byte[] lnxqpi = NUMBER.pi().shareBytes();
        byte[] piover2 = this.lnxdiv(lnxqpi, lnxqtwo);
        if (funcid == 2) {
            if (NUMBER._isPosInf(n2)) {
                return piover2;
            }
            if (NUMBER._isNegInf(n2)) {
                return this.lnxneg(piover2);
            }
        }
        byte[] temp = this.lnxabs(n2);
        if (funcid == 1 || funcid == 0) {
            if (this.lnxcmp(temp, lnxqone) > 0) {
                throw new SQLException(CoreException.getMessage((byte)11));
            }
            if ((temp[0] & 0xFF) <= 183) {
                if (funcid == 1) {
                    byte[] result = new byte[n2.length];
                    System.arraycopy(n2, 0, result, 0, n2.length);
                    return result;
                }
                return this.lnxsub(piover2, n2);
            }
            st1 = this.lnxsub(lnxqone, temp);
            st2 = this.lnxadd(lnxqone, temp);
            temp = this.lnxdiv(st1, st2);
            temp = this.lnxsqr(temp);
        }
        if ((comparison = this.lnxcmp(temp, lnxqone)) > 0) {
            temp = this.lnxdiv(lnxqone, temp);
        }
        st1 = new byte[temp.length];
        System.arraycopy(temp, 0, st1, 0, temp.length);
        int u2 = 1;
        int LNXQTRIPREC = 15;
        int LNXQTRIMAXITER = 15;
        while (true) {
            int expEst;
            st2 = this.lnxtan(st1);
            st3 = this.lnxsub(temp, st2);
            st2 = this.lnxmul(st2, st2);
            st2 = this.lnxadd(st2, lnxqone);
            int expInc = ((st2 = this.lnxdiv(st3, st2))[0] & 0xFF) >= 128 ? (st2[0] & 0xFF) - 193 : 62 - (st2[0] & 0xFF);
            int n3 = expEst = (st1[0] & 0xFF) >= 128 ? (st1[0] & 0xFF) - 193 : 62 - (st1[0] & 0xFF);
            if ((st2[0] & 0xFF) == 128 && st2.length == 1 || (expInc & 0xFF) + 15 < (expEst & 0xFF) || u2 > 15) break;
            st1 = this.lnxadd(st1, st2);
            ++u2;
        }
        if (comparison > 0) {
            st1 = this.lnxsub(piover2, st1);
        }
        if ((st1[0] & 0xFF) < 128) {
            st1 = NUMBER._makeZero();
        }
        if (this.lnxcmp(st1, piover2) > 0) {
            st1 = piover2;
        }
        if (funcid == 1 || funcid == 0) {
            st1 = this.lnxmul(st1, lnxqtwo);
        }
        switch (funcid) {
            case 1: {
                if (NUMBER._isPositive(n2)) {
                    return this.lnxsub(piover2, st1);
                }
                return this.lnxsub(st1, piover2);
            }
            case 0: {
                if (NUMBER._isPositive(n2)) {
                    return st1;
                }
                return this.lnxsub(lnxqpi, st1);
            }
            case 2: {
                if (NUMBER._isPositive(n2)) {
                    return st1;
                }
                return this.lnxneg(st1);
            }
        }
        throw new SQLException(CoreException.getMessage((byte)11));
    }

    private int lnxcmp(byte[] n1, byte[] n2) {
        return NUMBER.compareBytes(n1, n2);
    }

    private int lnxsgn(byte[] n2) {
        if (NUMBER._isZero(n2)) {
            return 0;
        }
        if (NUMBER._isPositive(n2)) {
            return 1;
        }
        return -1;
    }

    private byte[] lnxqIDiv(byte[] y2, int x2) throws SQLException {
        byte[] temp = this.lnxmin(x2);
        return this.lnxdiv(y2, temp);
    }

    private static void _negateNumber(byte[] oranum) {
        for (int i2 = oranum.length - 1; i2 > 0; --i2) {
            oranum[i2] = LnxqNegate[oranum[i2]];
        }
        oranum[0] = ~oranum[0];
    }

    private static byte[] _setLength(byte[] oranum, int size) {
        byte[] temp;
        boolean pos = NUMBER._isPositive(oranum);
        if (pos) {
            temp = new byte[size];
        } else if (size <= 20 && oranum[size - 1] != 102) {
            temp = new byte[size + 1];
            temp[size] = 102;
        } else {
            temp = new byte[size];
        }
        System.arraycopy(oranum, 0, temp, 0, size);
        return temp;
    }

    /*
     * Opcode count of 20546 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        try {
            $$$methodRef$$$65 = LnxLibThin.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$64 = LnxLibThin.class.getDeclaredMethod("_setLength", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$63 = LnxLibThin.class.getDeclaredMethod("_negateNumber", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$62 = LnxLibThin.class.getDeclaredMethod("lnxqIDiv", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$61 = LnxLibThin.class.getDeclaredMethod("lnxsgn", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$60 = LnxLibThin.class.getDeclaredMethod("lnxcmp", byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$59 = LnxLibThin.class.getDeclaredMethod("lnxqtri", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$58 = LnxLibThin.class.getDeclaredMethod("lnxqtra", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = LnxLibThin.class.getDeclaredMethod("LNXQH2N_DIGIT", Character.TYPE, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = LnxLibThin.class.getDeclaredMethod("lnxqh2n", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = LnxLibThin.class.getDeclaredMethod("lnxsni", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = LnxLibThin.class.getDeclaredMethod("lnxnur", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = LnxLibThin.class.getDeclaredMethod("encodeIntMinValue", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = LnxLibThin.class.getDeclaredMethod("lnxmin32", Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = LnxLibThin.class.getDeclaredMethod("lnxmin32", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = LnxLibThin.class.getDeclaredMethod("lnxminEncodeN", Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = LnxLibThin.class.getDeclaredMethod("lnxminEncodeP", Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = LnxLibThin.class.getDeclaredMethod("lnxminEncodeN1", Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = LnxLibThin.class.getDeclaredMethod("lnxminEncodeP1", Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = LnxLibThin.class.getDeclaredMethod("log100", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = LnxLibThin.class.getDeclaredMethod("lnxmin64", Long.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = LnxLibThin.class.getDeclaredMethod("lnxmin64", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = LnxLibThin.class.getDeclaredMethod("lnxmin", Long.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = LnxLibThin.class.getDeclaredMethod("lnxmin", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = LnxLibThin.class.getDeclaredMethod("lnxren", Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = LnxLibThin.class.getDeclaredMethod("lnxnuc", byte[].class, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = LnxLibThin.class.getDeclaredMethod("lnxnfn", byte[].class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = LnxLibThin.class.getDeclaredMethod("lnxfcn", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = LnxLibThin.class.getDeclaredMethod("lnxqctn", Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = LnxLibThin.class.getDeclaredMethod("digitPtr", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = LnxLibThin.class.getDeclaredMethod("lnxcpn", String.class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = LnxLibThin.class.getDeclaredMethod("lnxtru", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = LnxLibThin.class.getDeclaredMethod("lnxtnh", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = LnxLibThin.class.getDeclaredMethod("lnxtan", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = LnxLibThin.class.getDeclaredMethod("lnxsub", byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = LnxLibThin.class.getDeclaredMethod("lnxsqr", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = LnxLibThin.class.getDeclaredMethod("lnxsnh", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = LnxLibThin.class.getDeclaredMethod("lnxsin", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = LnxLibThin.class.getDeclaredMethod("lnxshift", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = LnxLibThin.class.getDeclaredMethod("lnxsca", byte[].class, Integer.TYPE, Integer.TYPE, boolean[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = LnxLibThin.class.getDeclaredMethod("lnxrou", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = LnxLibThin.class.getDeclaredMethod("lnxpow", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = LnxLibThin.class.getDeclaredMethod("lnxneg", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = LnxLibThin.class.getDeclaredMethod("LnxmulSetDigit2", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = LnxLibThin.class.getDeclaredMethod("LnxmulSetDigit1", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = LnxLibThin.class.getDeclaredMethod("LnxmulSetSum", int[].class, int[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = LnxLibThin.class.getDeclaredMethod("lnxmul", byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = LnxLibThin.class.getDeclaredMethod("lnxmod", byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = LnxLibThin.class.getDeclaredMethod("lnxlog", byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = LnxLibThin.class.getDeclaredMethod("lnxln", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = LnxLibThin.class.getDeclaredMethod("lnxinc", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = LnxLibThin.class.getDeclaredMethod("lnxfpr", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = LnxLibThin.class.getDeclaredMethod("lnxceil", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = LnxLibThin.class.getDeclaredMethod("lnxflo", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = LnxLibThin.class.getDeclaredMethod("lnxexp", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = LnxLibThin.class.getDeclaredMethod("lnxdiv", byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = LnxLibThin.class.getDeclaredMethod("lnxdec", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = LnxLibThin.class.getDeclaredMethod("lnxcsh", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = LnxLibThin.class.getDeclaredMethod("lnxcos", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = LnxLibThin.class.getDeclaredMethod("lnxbex", byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = LnxLibThin.class.getDeclaredMethod("lnxatan2", byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = LnxLibThin.class.getDeclaredMethod("lnxatan", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = LnxLibThin.class.getDeclaredMethod("lnxasin", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = LnxLibThin.class.getDeclaredMethod("lnxadd", byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = LnxLibThin.class.getDeclaredMethod("lnxacos", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = LnxLibThin.class.getDeclaredMethod("lnxabs", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        lnxqone = new byte[]{-63, 2};
        lnxqtwo = new byte[]{-63, 3};
        LnxqFirstDigit = new byte[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        LnxqNegate = new byte[]{0, 101, 100, 99, 98, 97, 96, 95, 94, 93, 92, 91, 90, 89, 88, 87, 86, 85, 84, 83, 82, 81, 80, 79, 78, 77, 76, 75, 74, 73, 72, 71, 70, 69, 68, 67, 66, 65, 64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
        LnxqTruncate_P = new byte[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91};
        LnxqTruncate_N = new byte[]{0, 0, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101};
        LnxqRound_P = new byte[]{0, 1, 1, 1, 1, 1, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 101, 101, 101, 101, 101};
        LnxqRound_N = new byte[]{0, 0, 1, 1, 1, 1, 1, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 101, 101, 101, 101, 101};
        LnxqComponents_P = new byte[][]{{0, 0}, {0, 0}, {0, 1}, {0, 2}, {0, 3}, {0, 4}, {0, 5}, {0, 6}, {0, 7}, {0, 8}, {0, 9}, {1, 0}, {1, 1}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 9}, {2, 0}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {2, 9}, {3, 0}, {3, 1}, {3, 2}, {3, 3}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {4, 0}, {4, 1}, {4, 2}, {4, 3}, {4, 4}, {4, 5}, {4, 6}, {4, 7}, {4, 8}, {4, 9}, {5, 0}, {5, 1}, {5, 2}, {5, 3}, {5, 4}, {5, 5}, {5, 6}, {5, 7}, {5, 8}, {5, 9}, {6, 0}, {6, 1}, {6, 2}, {6, 3}, {6, 4}, {6, 5}, {6, 6}, {6, 7}, {6, 8}, {6, 9}, {7, 0}, {7, 1}, {7, 2}, {7, 3}, {7, 4}, {7, 5}, {7, 6}, {7, 7}, {7, 8}, {7, 9}, {8, 0}, {8, 1}, {8, 2}, {8, 3}, {8, 4}, {8, 5}, {8, 6}, {8, 7}, {8, 8}, {8, 9}, {9, 0}, {9, 1}, {9, 2}, {9, 3}, {9, 4}, {9, 5}, {9, 6}, {9, 7}, {9, 8}, {9, 9}};
        LnxqComponents_N = new byte[][]{{0, 0}, {0, 0}, {9, 9}, {9, 8}, {9, 7}, {9, 6}, {9, 5}, {9, 4}, {9, 3}, {9, 2}, {9, 1}, {9, 0}, {8, 9}, {8, 8}, {8, 7}, {8, 6}, {8, 5}, {8, 4}, {8, 3}, {8, 2}, {8, 1}, {8, 0}, {7, 9}, {7, 8}, {7, 7}, {7, 6}, {7, 5}, {7, 4}, {7, 3}, {7, 2}, {7, 1}, {7, 0}, {6, 9}, {6, 8}, {6, 7}, {6, 6}, {6, 5}, {6, 4}, {6, 3}, {6, 2}, {6, 1}, {6, 0}, {5, 9}, {5, 8}, {5, 7}, {5, 6}, {5, 5}, {5, 4}, {5, 3}, {5, 2}, {5, 1}, {5, 0}, {4, 9}, {4, 8}, {4, 7}, {4, 6}, {4, 5}, {4, 4}, {4, 3}, {4, 2}, {4, 1}, {4, 0}, {3, 9}, {3, 8}, {3, 7}, {3, 6}, {3, 5}, {3, 4}, {3, 3}, {3, 2}, {3, 1}, {3, 0}, {2, 9}, {2, 8}, {2, 7}, {2, 6}, {2, 5}, {2, 4}, {2, 3}, {2, 2}, {2, 1}, {2, 0}, {1, 9}, {1, 8}, {1, 7}, {1, 6}, {1, 5}, {1, 4}, {1, 3}, {1, 2}, {1, 1}, {1, 0}, {0, 9}, {0, 8}, {0, 7}, {0, 6}, {0, 5}, {0, 4}, {0, 3}, {0, 2}, {0, 1}, {0, 0}};
        LnxqAdd_PPP = new byte[][]{{0, 0}, {0, 1}, {1, 0}, {2, 0}, {3, 0}, {4, 0}, {5, 0}, {6, 0}, {7, 0}, {8, 0}, {9, 0}, {10, 0}, {11, 0}, {12, 0}, {13, 0}, {14, 0}, {15, 0}, {16, 0}, {17, 0}, {18, 0}, {19, 0}, {20, 0}, {21, 0}, {22, 0}, {23, 0}, {24, 0}, {25, 0}, {26, 0}, {27, 0}, {28, 0}, {29, 0}, {30, 0}, {31, 0}, {32, 0}, {33, 0}, {34, 0}, {35, 0}, {36, 0}, {37, 0}, {38, 0}, {39, 0}, {40, 0}, {41, 0}, {42, 0}, {43, 0}, {44, 0}, {45, 0}, {46, 0}, {47, 0}, {48, 0}, {49, 0}, {50, 0}, {51, 0}, {52, 0}, {53, 0}, {54, 0}, {55, 0}, {56, 0}, {57, 0}, {58, 0}, {59, 0}, {60, 0}, {61, 0}, {62, 0}, {63, 0}, {64, 0}, {65, 0}, {66, 0}, {67, 0}, {68, 0}, {69, 0}, {70, 0}, {71, 0}, {72, 0}, {73, 0}, {74, 0}, {75, 0}, {76, 0}, {77, 0}, {78, 0}, {79, 0}, {80, 0}, {81, 0}, {82, 0}, {83, 0}, {84, 0}, {85, 0}, {86, 0}, {87, 0}, {88, 0}, {89, 0}, {90, 0}, {91, 0}, {92, 0}, {93, 0}, {94, 0}, {95, 0}, {96, 0}, {97, 0}, {98, 0}, {99, 0}, {100, 0}, {1, 1}, {2, 1}, {3, 1}, {4, 1}, {5, 1}, {6, 1}, {7, 1}, {8, 1}, {9, 1}, {10, 1}, {11, 1}, {12, 1}, {13, 1}, {14, 1}, {15, 1}, {16, 1}, {17, 1}, {18, 1}, {19, 1}, {20, 1}, {21, 1}, {22, 1}, {23, 1}, {24, 1}, {25, 1}, {26, 1}, {27, 1}, {28, 1}, {29, 1}, {30, 1}, {31, 1}, {32, 1}, {33, 1}, {34, 1}, {35, 1}, {36, 1}, {37, 1}, {38, 1}, {39, 1}, {40, 1}, {41, 1}, {42, 1}, {43, 1}, {44, 1}, {45, 1}, {46, 1}, {47, 1}, {48, 1}, {49, 1}, {50, 1}, {51, 1}, {52, 1}, {53, 1}, {54, 1}, {55, 1}, {56, 1}, {57, 1}, {58, 1}, {59, 1}, {60, 1}, {61, 1}, {62, 1}, {63, 1}, {64, 1}, {65, 1}, {66, 1}, {67, 1}, {68, 1}, {69, 1}, {70, 1}, {71, 1}, {72, 1}, {73, 1}, {74, 1}, {75, 1}, {76, 1}, {77, 1}, {78, 1}, {79, 1}, {80, 1}, {81, 1}, {82, 1}, {83, 1}, {84, 1}, {85, 1}, {86, 1}, {87, 1}, {88, 1}, {89, 1}, {90, 1}, {91, 1}, {92, 1}, {93, 1}, {94, 1}, {95, 1}, {96, 1}, {97, 1}, {98, 1}, {99, 1}, {100, 1}};
        LnxqAdd_NNN = new byte[][]{{0, 2}, {0, 1}, {0, 0}, {0, 0}, {0, 0}, {2, 1}, {3, 1}, {4, 1}, {5, 1}, {6, 1}, {7, 1}, {8, 1}, {9, 1}, {10, 1}, {11, 1}, {12, 1}, {13, 1}, {14, 1}, {15, 1}, {16, 1}, {17, 1}, {18, 1}, {19, 1}, {20, 1}, {21, 1}, {22, 1}, {23, 1}, {24, 1}, {25, 1}, {26, 1}, {27, 1}, {28, 1}, {29, 1}, {30, 1}, {31, 1}, {32, 1}, {33, 1}, {34, 1}, {35, 1}, {36, 1}, {37, 1}, {38, 1}, {39, 1}, {40, 1}, {41, 1}, {42, 1}, {43, 1}, {44, 1}, {45, 1}, {46, 1}, {47, 1}, {48, 1}, {49, 1}, {50, 1}, {51, 1}, {52, 1}, {53, 1}, {54, 1}, {55, 1}, {56, 1}, {57, 1}, {58, 1}, {59, 1}, {60, 1}, {61, 1}, {62, 1}, {63, 1}, {64, 1}, {65, 1}, {66, 1}, {67, 1}, {68, 1}, {69, 1}, {70, 1}, {71, 1}, {72, 1}, {73, 1}, {74, 1}, {75, 1}, {76, 1}, {77, 1}, {78, 1}, {79, 1}, {80, 1}, {81, 1}, {82, 1}, {83, 1}, {84, 1}, {85, 1}, {86, 1}, {87, 1}, {88, 1}, {89, 1}, {90, 1}, {91, 1}, {92, 1}, {93, 1}, {94, 1}, {95, 1}, {96, 1}, {97, 1}, {98, 1}, {99, 1}, {100, 1}, {101, 1}, {2, 2}, {3, 2}, {4, 2}, {5, 2}, {6, 2}, {7, 2}, {8, 2}, {9, 2}, {10, 2}, {11, 2}, {12, 2}, {13, 2}, {14, 2}, {15, 2}, {16, 2}, {17, 2}, {18, 2}, {19, 2}, {20, 2}, {21, 2}, {22, 2}, {23, 2}, {24, 2}, {25, 2}, {26, 2}, {27, 2}, {28, 2}, {29, 2}, {30, 2}, {31, 2}, {32, 2}, {33, 2}, {34, 2}, {35, 2}, {36, 2}, {37, 2}, {38, 2}, {39, 2}, {40, 2}, {41, 2}, {42, 2}, {43, 2}, {44, 2}, {45, 2}, {46, 2}, {47, 2}, {48, 2}, {49, 2}, {50, 2}, {51, 2}, {52, 2}, {53, 2}, {54, 2}, {55, 2}, {56, 2}, {57, 2}, {58, 2}, {59, 2}, {60, 2}, {61, 2}, {62, 2}, {63, 2}, {64, 2}, {65, 2}, {66, 2}, {67, 2}, {68, 2}, {69, 2}, {70, 2}, {71, 2}, {72, 2}, {73, 2}, {74, 2}, {75, 2}, {76, 2}, {77, 2}, {78, 2}, {79, 2}, {80, 2}, {81, 2}, {82, 2}, {83, 2}, {84, 2}, {85, 2}, {86, 2}, {87, 2}, {88, 2}, {89, 2}, {90, 2}, {91, 2}, {92, 2}, {93, 2}, {94, 2}, {95, 2}, {96, 2}, {97, 2}, {98, 2}, {99, 2}, {100, 2}, {101, 2}};
        LnxqAdd_PNP = new byte[][]{{0, 2}, {0, 1}, {0, 0}, {0, 0}, {1, 1}, {2, 1}, {3, 1}, {4, 1}, {5, 1}, {6, 1}, {7, 1}, {8, 1}, {9, 1}, {10, 1}, {11, 1}, {12, 1}, {13, 1}, {14, 1}, {15, 1}, {16, 1}, {17, 1}, {18, 1}, {19, 1}, {20, 1}, {21, 1}, {22, 1}, {23, 1}, {24, 1}, {25, 1}, {26, 1}, {27, 1}, {28, 1}, {29, 1}, {30, 1}, {31, 1}, {32, 1}, {33, 1}, {34, 1}, {35, 1}, {36, 1}, {37, 1}, {38, 1}, {39, 1}, {40, 1}, {41, 1}, {42, 1}, {43, 1}, {44, 1}, {45, 1}, {46, 1}, {47, 1}, {48, 1}, {49, 1}, {50, 1}, {51, 1}, {52, 1}, {53, 1}, {54, 1}, {55, 1}, {56, 1}, {57, 1}, {58, 1}, {59, 1}, {60, 1}, {61, 1}, {62, 1}, {63, 1}, {64, 1}, {65, 1}, {66, 1}, {67, 1}, {68, 1}, {69, 1}, {70, 1}, {71, 1}, {72, 1}, {73, 1}, {74, 1}, {75, 1}, {76, 1}, {77, 1}, {78, 1}, {79, 1}, {80, 1}, {81, 1}, {82, 1}, {83, 1}, {84, 1}, {85, 1}, {86, 1}, {87, 1}, {88, 1}, {89, 1}, {90, 1}, {91, 1}, {92, 1}, {93, 1}, {94, 1}, {95, 1}, {96, 1}, {97, 1}, {98, 1}, {99, 1}, {100, 1}, {1, 2}, {2, 2}, {3, 2}, {4, 2}, {5, 2}, {6, 2}, {7, 2}, {8, 2}, {9, 2}, {10, 2}, {11, 2}, {12, 2}, {13, 2}, {14, 2}, {15, 2}, {16, 2}, {17, 2}, {18, 2}, {19, 2}, {20, 2}, {21, 2}, {22, 2}, {23, 2}, {24, 2}, {25, 2}, {26, 2}, {27, 2}, {28, 2}, {29, 2}, {30, 2}, {31, 2}, {32, 2}, {33, 2}, {34, 2}, {35, 2}, {36, 2}, {37, 2}, {38, 2}, {39, 2}, {40, 2}, {41, 2}, {42, 2}, {43, 2}, {44, 2}, {45, 2}, {46, 2}, {47, 2}, {48, 2}, {49, 2}, {50, 2}, {51, 2}, {52, 2}, {53, 2}, {54, 2}, {55, 2}, {56, 2}, {57, 2}, {58, 2}, {59, 2}, {60, 2}, {61, 2}, {62, 2}, {63, 2}, {64, 2}, {65, 2}, {66, 2}, {67, 2}, {68, 2}, {69, 2}, {70, 2}, {71, 2}, {72, 2}, {73, 2}, {74, 2}, {75, 2}, {76, 2}, {77, 2}, {78, 2}, {79, 2}, {80, 2}, {81, 2}, {82, 2}, {83, 2}, {84, 2}, {85, 2}, {86, 2}, {87, 2}, {88, 2}, {89, 2}, {90, 2}, {91, 2}, {92, 2}, {93, 2}, {94, 2}, {95, 2}, {96, 2}, {97, 2}, {98, 2}, {99, 2}, {100, 2}};
        LnxqAdd_PNN = new byte[][]{{0, 0}, {0, 1}, {0, 0}, {2, 0}, {3, 0}, {4, 0}, {5, 0}, {6, 0}, {7, 0}, {8, 0}, {9, 0}, {10, 0}, {11, 0}, {12, 0}, {13, 0}, {14, 0}, {15, 0}, {16, 0}, {17, 0}, {18, 0}, {19, 0}, {20, 0}, {21, 0}, {22, 0}, {23, 0}, {24, 0}, {25, 0}, {26, 0}, {27, 0}, {28, 0}, {29, 0}, {30, 0}, {31, 0}, {32, 0}, {33, 0}, {34, 0}, {35, 0}, {36, 0}, {37, 0}, {38, 0}, {39, 0}, {40, 0}, {41, 0}, {42, 0}, {43, 0}, {44, 0}, {45, 0}, {46, 0}, {47, 0}, {48, 0}, {49, 0}, {50, 0}, {51, 0}, {52, 0}, {53, 0}, {54, 0}, {55, 0}, {56, 0}, {57, 0}, {58, 0}, {59, 0}, {60, 0}, {61, 0}, {62, 0}, {63, 0}, {64, 0}, {65, 0}, {66, 0}, {67, 0}, {68, 0}, {69, 0}, {70, 0}, {71, 0}, {72, 0}, {73, 0}, {74, 0}, {75, 0}, {76, 0}, {77, 0}, {78, 0}, {79, 0}, {80, 0}, {81, 0}, {82, 0}, {83, 0}, {84, 0}, {85, 0}, {86, 0}, {87, 0}, {88, 0}, {89, 0}, {90, 0}, {91, 0}, {92, 0}, {93, 0}, {94, 0}, {95, 0}, {96, 0}, {97, 0}, {98, 0}, {99, 0}, {100, 0}, {101, 0}, {2, 1}, {3, 1}, {4, 1}, {5, 1}, {6, 1}, {7, 1}, {8, 1}, {9, 1}, {10, 1}, {11, 1}, {12, 1}, {13, 1}, {14, 1}, {15, 1}, {16, 1}, {17, 1}, {18, 1}, {19, 1}, {20, 1}, {21, 1}, {22, 1}, {23, 1}, {24, 1}, {25, 1}, {26, 1}, {27, 1}, {28, 1}, {29, 1}, {30, 1}, {31, 1}, {32, 1}, {33, 1}, {34, 1}, {35, 1}, {36, 1}, {37, 1}, {38, 1}, {39, 1}, {40, 1}, {41, 1}, {42, 1}, {43, 1}, {44, 1}, {45, 1}, {46, 1}, {47, 1}, {48, 1}, {49, 1}, {50, 1}, {51, 1}, {52, 1}, {53, 1}, {54, 1}, {55, 1}, {56, 1}, {57, 1}, {58, 1}, {59, 1}, {60, 1}, {61, 1}, {62, 1}, {63, 1}, {64, 1}, {65, 1}, {66, 1}, {67, 1}, {68, 1}, {69, 1}, {70, 1}, {71, 1}, {72, 1}, {73, 1}, {74, 1}, {75, 1}, {76, 1}, {77, 1}, {78, 1}, {79, 1}, {80, 1}, {81, 1}, {82, 1}, {83, 1}, {84, 1}, {85, 1}, {86, 1}, {87, 1}, {88, 1}, {89, 1}, {90, 1}, {91, 1}, {92, 1}, {93, 1}, {94, 1}, {95, 1}, {96, 1}, {97, 1}, {98, 1}, {99, 1}, {100, 1}, {101, 1}};
        LnxsubIdentity = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101};
        LnxqDigit_P = new byte[][]{{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {11, 12, 13, 14, 15, 16, 17, 18, 19, 20}, {21, 22, 23, 24, 25, 26, 27, 28, 29, 30}, {31, 32, 33, 34, 35, 36, 37, 38, 39, 40}, {41, 42, 43, 44, 45, 46, 47, 48, 49, 50}, {51, 52, 53, 54, 55, 56, 57, 58, 59, 60}, {61, 62, 63, 64, 65, 66, 67, 68, 69, 70}, {71, 72, 73, 74, 75, 76, 77, 78, 79, 80}, {81, 82, 83, 84, 85, 86, 87, 88, 89, 90}, {91, 92, 93, 94, 95, 96, 97, 98, 99, 100}};
        LnxqDigit_N = new byte[][]{{101, 100, 99, 98, 97, 96, 95, 94, 93, 92}, {91, 90, 89, 88, 87, 86, 85, 84, 83, 82}, {81, 80, 79, 78, 77, 76, 75, 74, 73, 72}, {71, 70, 69, 68, 67, 66, 65, 64, 63, 62}, {61, 60, 59, 58, 57, 56, 55, 54, 53, 52}, {51, 50, 49, 48, 47, 46, 45, 44, 43, 42}, {41, 40, 39, 38, 37, 36, 35, 34, 33, 32}, {31, 30, 29, 28, 27, 26, 25, 24, 23, 22}, {21, 20, 19, 18, 17, 16, 15, 14, 13, 12}, {11, 10, 9, 8, 7, 6, 5, 4, 3, 2}};
        powerTable = new double[][]{{128.0, 1.0E256, 1.0E-256}, {64.0, 1.0E128, 1.0E-128}, {32.0, 1.0E64, 1.0E-64}, {16.0, 1.0E32, 1.0E-32}, {8.0, 1.0E16, 1.0E-16}, {4.0, 1.0E8, 1.0E-8}, {2.0, 10000.0, 1.0E-4}, {1.0, 100.0, 0.01}};
        factorTable = new double[][]{{15.0, 1.0E30, 1.0E-30}, {14.0, 1.0E28, 1.0E-28}, {13.0, 1.0E26, 1.0E-26}, {12.0, 1.0E24, 1.0E-24}, {11.0, 1.0E22, 1.0E-22}, {10.0, 1.0E20, 1.0E-20}, {9.0, 1.0E18, 1.0E-18}, {8.0, 1.0E16, 1.0E-16}, {7.0, 1.0E14, 1.0E-14}, {6.0, 1.0E12, 1.0E-12}, {5.0, 1.0E10, 1.0E-10}, {4.0, 1.0E8, 1.0E-8}, {3.0, 1000000.0, 1.0E-6}, {2.0, 10000.0, 1.0E-4}, {1.0, 100.0, 0.01}, {0.0, 1.0, 1.0}, {-1.0, 0.01, 100.0}, {-2.0, 1.0E-4, 10000.0}, {-3.0, 1.0E-6, 1000000.0}, {-4.0, 1.0E-8, 1.0E8}, {-5.0, 1.0E-10, 1.0E10}, {-6.0, 1.0E-12, 1.0E12}, {-7.0, 1.0E-14, 1.0E14}, {-8.0, 1.0E-16, 1.0E16}, {-9.0, 1.0E-18, 1.0E18}, {-10.0, 1.0E-20, 1.0E20}, {-11.0, 1.0E-22, 1.0E22}, {-12.0, 1.0E-24, 1.0E24}, {-13.0, 1.0E-26, 1.0E26}, {-14.0, 1.0E-28, 1.0E28}, {-15.0, 1.0E-30, 1.0E30}, {-16.0, 1.0E-32, 1.0E32}, {-17.0, 1.0E-34, 1.0E34}, {-18.0, 1.0E-36, 1.0E36}, {-19.0, 1.0E-38, 1.0E38}, {-20.0, 1.0E-40, 1.0E40}, {-21.0, 1.0E-42, 1.0E42}, {-22.0, 1.0E-44, 1.0E44}, {-23.0, 1.0E-46, 1.0E46}, {-24.0, 1.0E-48, 1.0E48}, {-25.0, 1.0E-50, 1.0E50}, {-26.0, 1.0E-52, 1.0E52}, {-27.0, 1.0E-54, 1.0E54}, {-28.0, 1.0E-56, 1.0E56}, {-29.0, 1.0E-58, 1.0E58}, {-30.0, 1.0E-60, 1.0E60}, {-31.0, 1.0E-62, 1.0E62}, {-32.0, 1.0E-64, 1.0E64}, {-33.0, 1.0E-66, 1.0E66}, {-34.0, 1.0E-68, 1.0E68}};
        lnx_chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '-', ' ', '.', ',', '$', '<', '>', '(', ')', '#', '~', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'i', 'l', 'm', 'p', 'r', 's', 't', 'v', 'A', 'B', 'C', 'D', 'E', 'F', 'I', 'L', 'M', 'P', 'R', 'S', 'T'};
    }

    private static class lnxqc {
        static final int LNXQC0 = 0;
        static final int LNXQC1 = 1;
        static final int LNXQC2 = 2;
        static final int LNXQC3 = 3;
        static final int LNXQC4 = 4;
        static final int LNXQC5 = 5;
        static final int LNXQC6 = 6;
        static final int LNXQC7 = 7;
        static final int LNXQC8 = 8;
        static final int LNXQC9 = 9;
        static final int LNXQCPLUS = 10;
        static final int LNXQCMINUS = 11;
        static final int LNXQCSPACE = 12;
        static final int LNXQCDOT = 13;
        static final int LNXQCCOMMA = 14;
        static final int LNXQCDOLLR = 15;
        static final int LNXQCLT = 16;
        static final int LNXQCGRT = 17;
        static final int LNXQCLPT = 18;
        static final int LNXQCRPT = 19;
        static final int LNXQCHASH = 20;
        static final int LNXQCTILDE = 21;
        static final int LNXQCASML = 22;
        static final int LNXQCBSML = 23;
        static final int LNXQCCSML = 24;
        static final int LNXQCDSML = 25;
        static final int LNXQCESML = 26;
        static final int LNXQCFSML = 27;
        static final int LNXQCGSML = 28;
        static final int LNXQCISML = 29;
        static final int LNXQCLSML = 30;
        static final int LNXQCMSML = 31;
        static final int LNXQCPSML = 32;
        static final int LNXQCRSML = 33;
        static final int LNXQCSSML = 34;
        static final int LNXQCTSML = 35;
        static final int LNXQCVSML = 36;
        static final int LNXQCALRG = 37;
        static final int LNXQCBLRG = 38;
        static final int LNXQCCLRG = 39;
        static final int LNXQCDLRG = 40;
        static final int LNXQCELRG = 41;
        static final int LNXQCFLRG = 42;
        static final int LNXQCILRG = 43;
        static final int LNXQCLLRG = 44;
        static final int LNXQCMLRG = 45;
        static final int LNXQCPLRG = 46;
        static final int LNXQCRLRG = 47;
        static final int LNXQCSLRG = 48;
        static final int LNXQCTLRG = 49;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        private lnxqc() {
        }

        static {
            try {
                $$$methodRef$$$0 = lnxqc.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

