/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C8TTILobd;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
abstract class T4C8TTILob
extends T4CTTIfun {
    static final int KPLOB_GET_LEN = 1;
    static final int KPLOB_READ = 2;
    static final int KPLOB_TRIM = 32;
    static final int KPLOB_WRITE = 64;
    static final int KPLOB_FILE_OPEN = 256;
    static final int KPLOB_FILE_CLOSE = 512;
    static final int KPLOB_FILE_ISOPEN = 1024;
    static final int KPLOB_FILE_EXISTS = 2048;
    static final int KPLOB_TMP_CREATE = 272;
    static final int KPLOB_TMP_FREE = 273;
    static final int KPLOB_TMP_CBK = 17;
    static final int KPLOB_WRITE_APPEND = 8192;
    static final int KPLOB_PAGE_SIZE = 16384;
    static final int KPLOB_OPEN = 32768;
    static final int KPLOB_CLOSE = 65536;
    static final int KPLOB_ISOPEN = 69632;
    static final int KPLOB_ARRAY_OPERATION = 524288;
    static final int KPLOB_ARRAY_TMPFR = 524561;
    static final int KOKL_ORDONLY = 1;
    static final int KOKL_ORDWR = 2;
    static final int KOLF_ORDONLY = 11;
    static final int DTYCLOB = 112;
    static final int DTYBLOB = 113;
    byte[] sourceLobLocator;
    byte[] destinationLobLocator;
    int destinationLength;
    long sourceOffset;
    long destinationOffset;
    short characterSet;
    long lobamt;
    boolean lobnull;
    long lobops;
    int[] lobscn;
    int lobscnl;
    boolean nullO2U;
    boolean sendLobamt;
    byte[] inBuffer;
    long inBufferOffset;
    long inBufferNumBytes;
    byte[] outBuffer;
    int offsetInOutBuffer;
    long rowsProcessed;
    long lobBytesRead;
    boolean littleEndianClob;
    T4C8TTILobd lobd;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;

    T4C8TTILob(T4CConnection _conn) {
        super(_conn, (byte)3);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$29, null, _conn);
            }
            this.sourceLobLocator = null;
            this.destinationLobLocator = null;
            this.destinationLength = 0;
            this.sourceOffset = 0L;
            this.destinationOffset = 0L;
            this.characterSet = 0;
            this.lobamt = 0L;
            this.lobnull = false;
            this.lobops = 0L;
            this.lobscn = null;
            this.lobscnl = 0;
            this.nullO2U = false;
            this.sendLobamt = false;
            this.inBuffer = null;
            this.outBuffer = null;
            this.offsetInOutBuffer = 0;
            this.rowsProcessed = 0L;
            this.lobBytesRead = 0L;
            this.littleEndianClob = false;
            this.lobd = null;
            this.setFunCode((short)96);
            this.lobd = new T4C8TTILobd(_conn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$29, null);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$29, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$29, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    long read(byte[] byArray, long l2, long l3, byte[] byArray2, int n2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _offsetInOutBuffer;
            void outBuffer;
            void _numBytes;
            void offset;
            void lobLocator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$0, this, byArray, l2, l3, byArray2, n2);
            }
            this.initializeLobdef();
            this.lobops = 2L;
            this.sourceLobLocator = lobLocator;
            this.sourceOffset = offset;
            this.lobamt = _numBytes;
            this.sendLobamt = true;
            this.outBuffer = outBuffer;
            this.offsetInOutBuffer = _offsetInOutBuffer;
            this.doRPC();
            long l4 = this.lobBytesRead;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$0, this, l4);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$0, this, null);
            }
            return l4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final CompletionStage<Long> readAsync(byte[] byArray, long l2, long l3, byte[] byArray2, int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _offsetInOutBuffer;
            void outBuffer;
            void _numBytes;
            void offset;
            void lobLocator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$1, this, byArray, l2, l3, byArray2, n2);
            }
            this.initializeLobdef();
            this.lobops = 2L;
            this.sourceLobLocator = lobLocator;
            this.sourceOffset = offset;
            this.lobamt = _numBytes;
            this.sendLobamt = true;
            this.outBuffer = outBuffer;
            this.offsetInOutBuffer = _offsetInOutBuffer;
            CompletionStage<Long> completionStage = this.doRPCAsync().thenApply(void_ -> {
                boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
                try {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$28, this, void_);
                    }
                    Long l2 = this.lobBytesRead;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$28, this, l2);
                        ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$28, this, null);
                    }
                    return l2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$28, this, throwable2);
                    }
                    throw throwable;
                }
            });
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$1, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$1, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    long write(byte[] byArray, long l2, byte[] byArray2, long l3, long l4) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _inBufferOffset;
            void _inBuffer;
            void _numBytes;
            void offset;
            void lobLocator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$2, this, byArray, l2, byArray2, l3, l4);
            }
            this.validateLobOperation((byte[])lobLocator, 64, "write()");
            long bytesWritten = 0L;
            this.initializeLobdef();
            this.lobops = 64L;
            this.sourceLobLocator = lobLocator;
            this.sourceOffset = offset;
            this.lobamt = _numBytes;
            this.sendLobamt = true;
            this.inBuffer = _inBuffer;
            this.inBufferOffset = _inBufferOffset;
            this.inBufferNumBytes = _numBytes;
            this.doRPC();
            long l5 = bytesWritten = this.lobamt;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$2, this, l5);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$2, this, null);
            }
            return l5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final CompletionStage<Long> writeAsync(byte[] byArray, long l2, byte[] byArray2, long l3, long l4) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void _inBufferOffset;
            void _inBuffer;
            void _numBytes;
            void offset;
            void lobLocator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$3, this, byArray, l2, byArray2, l3, l4);
            }
            try {
                this.validateLobOperation((byte[])lobLocator, 64, "writeAsync()");
            }
            catch (SQLException ex) {
                CompletionStage<Long> completionStage = CompletableFuture.failedStage(ex);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$3, this, completionStage);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$3, this, null);
                }
                return completionStage;
            }
            this.initializeLobdef();
            this.lobops = 64L;
            this.sourceLobLocator = lobLocator;
            this.sourceOffset = offset;
            this.lobamt = _numBytes;
            this.sendLobamt = true;
            this.inBuffer = _inBuffer;
            this.inBufferOffset = _inBufferOffset;
            this.inBufferNumBytes = _numBytes;
            CompletionStage<Long> completionStage = this.doRPCAsync().thenApply(void_ -> {
                boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
                try {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$27, this, void_);
                    }
                    Long l2 = this.lobamt;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$27, this, l2);
                        ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$27, this, null);
                    }
                    return l2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$27, this, throwable2);
                    }
                    throw throwable;
                }
            });
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$3, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$3, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    long getLength(byte[] byArray) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void lobLocator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$4, this, new Object[]{byArray});
            }
            this.prepareForGetLengthRPC((byte[])lobLocator);
            this.doRPC();
            long l2 = this.lobamt;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$4, this, l2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$4, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final CompletionStage<Long> getLengthAsync(byte[] byArray) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void lobLocator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$5, this, new Object[]{byArray});
            }
            this.prepareForGetLengthRPC((byte[])lobLocator);
            CompletionStage<Long> completionStage = this.doRPCAsync().thenApply(void_ -> {
                boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
                try {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$26, this, void_);
                    }
                    Long l2 = this.lobamt;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$26, this, l2);
                        ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$26, this, null);
                    }
                    return l2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$26, this, throwable2);
                    }
                    throw throwable;
                }
            });
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$5, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$5, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void prepareForGetLengthRPC(byte[] byArray) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void lobLocator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$6, this, new Object[]{byArray});
            }
            this.initializeLobdef();
            this.lobops = 1L;
            this.sourceLobLocator = lobLocator;
            this.sendLobamt = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    long getChunkSize(byte[] byArray) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void lobLocator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$7, this, new Object[]{byArray});
            }
            long chunkSize = 0L;
            this.initializeLobdef();
            this.lobops = 16384L;
            this.sourceLobLocator = lobLocator;
            this.sendLobamt = true;
            this.doRPC();
            long l2 = chunkSize = this.lobamt;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$7, this, l2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$7, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    long trim(byte[] byArray, long l2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void newLength;
            void lobLocator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$8, this, byArray, l2);
            }
            this.validateLobOperation((byte[])lobLocator, 32, "trim()");
            long newLengthfromServer = 0L;
            this.initializeLobdef();
            this.lobops = 32L;
            this.sourceLobLocator = lobLocator;
            this.lobamt = newLength;
            this.sendLobamt = true;
            this.doRPC();
            long l3 = newLengthfromServer = this.lobamt;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$8, this, l3);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$8, this, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract Datum createTemporaryLob(Connection var1, boolean var2, int var3) throws SQLException, IOException;

    void doFreeLobPiggyback() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$9, this, new Object[0]);
            }
            if (this.connection.tempLobFreeOffset > 0) {
                this.initializeLobdef();
                this.lobops = 524561L;
                this.sourceLobLocator = new byte[this.connection.tempLobFreeOffset];
                System.arraycopy(this.connection.tempLobsToFree, 0, this.sourceLobLocator, 0, this.connection.tempLobFreeOffset);
                this.setTTCCode((byte)17);
                this.doPigRPC();
                this.connection.tempLobFreeOffset = 0;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void freeTemporaryLob(byte[] byArray) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void lobLocator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$10, this, new Object[]{byArray});
            }
            if (PhysicalConnection.isQuasiLocator((byte[])lobLocator) || !PhysicalConnection.isTemporary((byte[])lobLocator)) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$10, this);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$10, this, null);
                }
                return;
            }
            if (this.connection.getTTCVersion() >= 4) {
                if ((lobLocator[5] & 8) == 0 || !this.isAbstractLocator((byte[])lobLocator) && !this.isTemporaryLocator((byte[])lobLocator)) {
                    SQLException sQLException = new SQLException("ORA-22275: invalid LOB locator specified\n", "22275", 22275);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$10, this, sQLException);
                    }
                    throw sQLException;
                }
                if (this.connection.tempLobFreeOffset + ((void)lobLocator).length > this.connection.tempLobsToFree.length) {
                    byte[] tempBuf = new byte[this.connection.tempLobsToFree.length * 2];
                    System.arraycopy(this.connection.tempLobsToFree, 0, tempBuf, 0, this.connection.tempLobsToFree.length);
                    this.connection.tempLobsToFree = tempBuf;
                }
                System.arraycopy(lobLocator, 0, this.connection.tempLobsToFree, this.connection.tempLobFreeOffset, ((void)lobLocator).length);
                this.connection.tempLobFreeOffset += ((void)lobLocator).length;
                void v0 = lobLocator;
                v0[4] = (byte)(v0[4] & 0xFFFFFFBF);
                void v1 = lobLocator;
                v1[5] = (byte)(v1[5] & 0xFFFFFFF7);
                void v2 = lobLocator;
                v2[7] = (byte)(v2[7] & 0xFFFFFFFE);
            } else {
                this.initializeLobdef();
                this.lobops = 273L;
                this.sourceLobLocator = lobLocator;
                this.doRPC();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract boolean open(byte[] var1, int var2) throws SQLException, IOException;

    /*
     * WARNING - void declaration
     */
    boolean _open(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void mode;
            void lobLocator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$11, this, byArray, n2, n3);
            }
            boolean didOpen = false;
            if (PhysicalConnection.isQuasiLocator((byte[])lobLocator)) {
                boolean bl2 = didOpen;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$11, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$11, this, null);
                }
                return bl2;
            }
            if (this.isTemporaryLocator((byte[])lobLocator) || this.isAbstractLocator((byte[])lobLocator)) {
                if (this.isOpenLocator((byte[])lobLocator)) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 445).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$11, this, sQLException);
                    }
                    throw sQLException;
                }
                void v0 = lobLocator;
                v0[7] = (byte)(v0[7] | 8);
                if (mode == 2) {
                    void v1 = lobLocator;
                    v1[7] = (byte)(v1[7] | 0x10);
                }
                didOpen = true;
            } else {
                void lobops;
                this.initializeLobdef();
                this.sourceLobLocator = lobLocator;
                this.lobops = (long)lobops;
                this.lobamt = (long)mode;
                this.sendLobamt = true;
                this.doRPC();
                if (this.lobamt != 0L) {
                    didOpen = true;
                }
            }
            boolean bl3 = didOpen;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$11, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$11, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract boolean close(byte[] var1) throws SQLException, IOException;

    /*
     * WARNING - void declaration
     */
    boolean _close(byte[] byArray, int n2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void lobLocator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$12, this, byArray, n2);
            }
            boolean isClosed = true;
            if (PhysicalConnection.isQuasiLocator((byte[])lobLocator)) {
                boolean bl2 = isClosed;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$12, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$12, this, null);
                }
                return bl2;
            }
            if (this.isTemporaryLocator((byte[])lobLocator) || this.isAbstractLocator((byte[])lobLocator)) {
                if (!this.isOpenLocator((byte[])lobLocator)) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 446).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$12, this, sQLException);
                    }
                    throw sQLException;
                }
                void v0 = lobLocator;
                v0[7] = (byte)(v0[7] & 0xFFFFFFE7);
            } else {
                void lobops;
                this.initializeLobdef();
                this.sourceLobLocator = lobLocator;
                this.lobops = (long)lobops;
                this.doRPC();
            }
            boolean bl3 = isClosed;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$12, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$12, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final CompletionStage<Void> _closeAsync(byte[] byArray, int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void lobops;
            void lobLocator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$13, this, byArray, n2);
            }
            if (PhysicalConnection.isQuasiLocator((byte[])lobLocator)) {
                CompletableFuture<Void> completableFuture = CompletionStageUtil.VOID_COMPLETED_FUTURE;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$13, this, completableFuture);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$13, this, null);
                }
                return completableFuture;
            }
            if (this.isTemporaryLocator((byte[])lobLocator) || this.isAbstractLocator((byte[])lobLocator)) {
                if (!this.isOpenLocator((byte[])lobLocator)) {
                    CompletionStage<Void> completionStage = CompletableFuture.failedStage(DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 446).fillInStackTrace());
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$13, this, completionStage);
                        ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$13, this, null);
                    }
                    return completionStage;
                }
                void v0 = lobLocator;
                v0[7] = (byte)(v0[7] & 0xFFFFFFE7);
                CompletableFuture<Void> completableFuture = CompletionStageUtil.VOID_COMPLETED_FUTURE;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$13, this, completableFuture);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$13, this, null);
                }
                return completableFuture;
            }
            this.initializeLobdef();
            this.sourceLobLocator = lobLocator;
            this.lobops = (long)lobops;
            CompletionStage<Void> completionStage = this.doRPCAsync();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$13, this, completionStage);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$13, this, null);
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isTemporaryLocator(byte[] byArray) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void lobLocator;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$14, this, new Object[]{byArray});
            }
            boolean bl3 = bl2 = (lobLocator[7] & 1) == 1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$14, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$14, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isAbstractLocator(byte[] byArray) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void lobLocator;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$15, this, new Object[]{byArray});
            }
            boolean bl3 = bl2 = (lobLocator[4] & 0x40) == 64;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$15, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$15, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isOpenLocator(byte[] byArray) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void lobLocator;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$16, this, new Object[]{byArray});
            }
            boolean bl3 = bl2 = (lobLocator[7] & 8) == 8;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$16, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$16, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract boolean isOpen(byte[] var1) throws SQLException, IOException;

    /*
     * WARNING - void declaration
     */
    boolean _isOpen(byte[] byArray, int n2) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void lobLocator;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$17, this, byArray, n2);
            }
            boolean lobOpen = false;
            if (PhysicalConnection.isQuasiLocator((byte[])lobLocator)) {
                boolean bl2 = lobOpen;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$17, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$17, this, null);
                }
                return bl2;
            }
            if (this.isTemporaryLocator((byte[])lobLocator) || this.isAbstractLocator((byte[])lobLocator)) {
                if (this.isOpenLocator((byte[])lobLocator)) {
                    lobOpen = true;
                }
            } else {
                void lobops;
                this.initializeLobdef();
                this.sourceLobLocator = lobLocator;
                this.lobops = (long)lobops;
                this.nullO2U = true;
                this.doRPC();
                lobOpen = this.lobnull;
            }
            boolean bl3 = lobOpen;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$17, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$17, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    void initializeLobdef() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$18, this, new Object[0]);
            }
            this.setTTCCode((byte)3);
            this.sourceLobLocator = null;
            this.destinationLobLocator = null;
            this.sourceOffset = 0L;
            this.destinationOffset = 0L;
            this.destinationLength = 0;
            this.characterSet = 0;
            this.lobamt = 0L;
            this.lobnull = false;
            this.lobops = 0L;
            this.lobscn = null;
            this.lobscnl = 0;
            this.inBuffer = null;
            this.outBuffer = null;
            this.nullO2U = false;
            this.sendLobamt = false;
            this.littleEndianClob = false;
            this.lobBytesRead = 0L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void marshal() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$19, this, new Object[0]);
            }
            int slength = 0;
            if (this.sourceLobLocator != null) {
                slength = this.sourceLobLocator.length;
                this.meg.marshalPTR();
            } else {
                this.meg.marshalNULLPTR();
            }
            this.meg.marshalSB4(slength);
            if (this.destinationLobLocator != null) {
                this.destinationLength = this.destinationLobLocator.length;
                this.meg.marshalPTR();
            } else {
                this.meg.marshalNULLPTR();
            }
            this.meg.marshalSB4(this.destinationLength);
            if (this.connection.getTTCVersion() >= 3) {
                this.meg.marshalUB4(0L);
            } else {
                this.meg.marshalUB4(this.sourceOffset);
            }
            if (this.connection.getTTCVersion() >= 3) {
                this.meg.marshalUB4(0L);
            } else {
                this.meg.marshalUB4(this.destinationOffset);
            }
            if (this.characterSet != 0) {
                this.meg.marshalPTR();
            } else {
                this.meg.marshalNULLPTR();
            }
            if (this.sendLobamt && this.connection.getTTCVersion() < 3) {
                this.meg.marshalPTR();
            } else {
                this.meg.marshalNULLPTR();
            }
            if (this.nullO2U) {
                this.meg.marshalPTR();
            } else {
                this.meg.marshalNULLPTR();
            }
            this.meg.marshalUB4(this.lobops);
            if (this.lobscnl != 0) {
                this.meg.marshalPTR();
            } else {
                this.meg.marshalNULLPTR();
            }
            this.meg.marshalSB4(this.lobscnl);
            if (this.connection.getTTCVersion() >= 3) {
                this.meg.marshalSB8(this.sourceOffset);
                this.meg.marshalSB8(this.destinationOffset);
                if (this.sendLobamt) {
                    this.meg.marshalPTR();
                } else {
                    this.meg.marshalNULLPTR();
                }
                if (this.connection.getTTCVersion() >= 4) {
                    this.meg.marshalNULLPTR();
                    this.meg.marshalSWORD(0);
                    this.meg.marshalNULLPTR();
                    this.meg.marshalSWORD(0);
                    this.meg.marshalNULLPTR();
                    this.meg.marshalSWORD(0);
                }
            }
            if (this.sourceLobLocator != null) {
                this.meg.marshalB1Array(this.sourceLobLocator);
            }
            if (this.destinationLobLocator != null) {
                this.meg.marshalB1Array(this.destinationLobLocator);
            }
            if (this.characterSet != 0) {
                this.meg.marshalUB2(this.characterSet);
            }
            if (this.sendLobamt && this.connection.getTTCVersion() < 3) {
                this.meg.marshalUB4(this.lobamt);
            }
            if (this.lobscnl != 0) {
                for (int i2 = 0; i2 < this.lobscnl; ++i2) {
                    this.meg.marshalUB4(this.lobscn[i2]);
                }
            }
            if (this.sendLobamt && this.connection.getTTCVersion() >= 3) {
                this.meg.marshalSB8(this.lobamt);
            }
            if (this.lobops == 64L) {
                this.marshalData();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$19, this);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$19, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    void marshalData() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$20, this, new Object[0]);
            }
            boolean useZeroCopyIO = this.connection.isZeroCopyIOEnabled() & (this.sourceLobLocator[7] & 0xFFFFFF80) != 0;
            boolean varWidthChar = false;
            if ((this.sourceLobLocator[6] & 0x80) == 128) {
                varWidthChar = true;
            }
            if (this.connection.versionNumber < 10101 && varWidthChar) {
                this.lobd.marshalClobUB2_For9iDB(this.inBuffer, this.inBufferOffset, this.inBufferNumBytes);
            } else {
                this.lobd.marshalLobData(this.inBuffer, this.inBufferOffset, this.inBufferNumBytes, useZeroCopyIO);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void readLOBD() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$21, this, new Object[0]);
            }
            boolean useZeroCopyIO = this.connection.isZeroCopyIOEnabled() & (this.sourceLobLocator[7] & 0xFFFFFF80) != 0;
            boolean varWidthChar = false;
            if ((this.sourceLobLocator[6] & 0x80) == 128) {
                varWidthChar = true;
            }
            this.lobBytesRead = this.connection.versionNumber < 10101 && varWidthChar ? this.lobd.unmarshalClobUB2_For9iDB(this.outBuffer, this.offsetInOutBuffer) : this.lobd.unmarshalLobData(this.outBuffer, this.offsetInOutBuffer, useZeroCopyIO);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void processError() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$22, this, new Object[0]);
            }
            this.rowsProcessed = this.oer.getCurRowNumber();
            if (this.oer.getRetCode() != 1403L) {
                this.oer.processError();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$22, this);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$22, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void readRPA() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            short isNull;
            int length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$23, this, new Object[0]);
            }
            if (this.sourceLobLocator != null) {
                if (this.lobops == 272L) {
                    this.meg.getNBytes(this.sourceLobLocator, 0, 2);
                    byte b0 = this.sourceLobLocator[0];
                    byte b1 = this.sourceLobLocator[1];
                    short locatorLen = (short)(b0 << 8 | b1);
                    int extraUnusedLocatorBytes = 0;
                    if (locatorLen + 2 != this.sourceLobLocator.length) {
                        if (this.sourceLobLocator.length > locatorLen + 2) {
                            extraUnusedLocatorBytes = (short)(this.sourceLobLocator.length - (locatorLen + 2));
                        }
                        this.sourceLobLocator = new byte[locatorLen + 2];
                        this.sourceLobLocator[0] = b0;
                        this.sourceLobLocator[1] = b1;
                    }
                    this.meg.getNBytes(this.sourceLobLocator, 2, locatorLen);
                    if (extraUnusedLocatorBytes > 0) {
                        byte[] temp = new byte[extraUnusedLocatorBytes];
                        this.meg.getNBytes(temp, 0, extraUnusedLocatorBytes);
                    }
                } else {
                    length = this.sourceLobLocator.length;
                    this.meg.getNBytes(this.sourceLobLocator, 0, length);
                }
            }
            if (this.destinationLobLocator != null) {
                length = this.meg.unmarshalSB2();
                this.destinationLobLocator = this.meg.unmarshalNBytes(length);
            }
            if (this.characterSet != 0) {
                this.characterSet = this.meg.unmarshalSB2();
            }
            if (this.sendLobamt) {
                this.lobamt = this.connection.getTTCVersion() >= 3 ? this.meg.unmarshalSB8() : this.meg.unmarshalUB4();
            }
            if (this.nullO2U && (isNull = (short)this.meg.unmarshalSB1()) != 0) {
                this.lobnull = true;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$23, this);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$23, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    int getTemporaryLobSize() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block10: {
                int n3;
                block8: {
                    int n4;
                    block9: {
                        int n5;
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$24, this, new Object[0]);
                        }
                        try {
                            if (this.connection.getVersionNumber() < 19000) break block8;
                            n4 = n5 = 108;
                            if (!bl) break block9;
                        }
                        catch (SQLException sqe) {
                            int n6 = 40;
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$24, this, n6);
                                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$24, this, null);
                            }
                            return 40;
                        }
                        ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$24, this, n5);
                        ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$24, this, null);
                    }
                    return n4;
                }
                n2 = n3 = 40;
                if (!bl) break block10;
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$24, this, n3);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$24, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void validateLobOperation(byte[] byArray, int n2, String string) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void lobOperation;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$25, this, byArray, n2, string);
            }
            switch (lobOperation) {
                case 32: 
                case 64: {
                    void caller;
                    void lobLocator;
                    if (PhysicalConnection.isValueBasedLocator((byte[])lobLocator)) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 454, caller).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$25, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (!PhysicalConnection.isReadOnly((byte[])lobLocator)) break;
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 455, caller).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$25, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4C8TTILob.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$29 = T4C8TTILob.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = T4C8TTILob.class.getDeclaredMethod("lambda$readAsync$0", Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = T4C8TTILob.class.getDeclaredMethod("lambda$writeAsync$1", Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = T4C8TTILob.class.getDeclaredMethod("lambda$getLengthAsync$2", Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = T4C8TTILob.class.getDeclaredMethod("validateLobOperation", byte[].class, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = T4C8TTILob.class.getDeclaredMethod("getTemporaryLobSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = T4C8TTILob.class.getDeclaredMethod("readRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = T4C8TTILob.class.getDeclaredMethod("processError", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4C8TTILob.class.getDeclaredMethod("readLOBD", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4C8TTILob.class.getDeclaredMethod("marshalData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4C8TTILob.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4C8TTILob.class.getDeclaredMethod("initializeLobdef", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4C8TTILob.class.getDeclaredMethod("_isOpen", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4C8TTILob.class.getDeclaredMethod("isOpenLocator", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4C8TTILob.class.getDeclaredMethod("isAbstractLocator", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4C8TTILob.class.getDeclaredMethod("isTemporaryLocator", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4C8TTILob.class.getDeclaredMethod("_closeAsync", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4C8TTILob.class.getDeclaredMethod("_close", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4C8TTILob.class.getDeclaredMethod("_open", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4C8TTILob.class.getDeclaredMethod("freeTemporaryLob", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4C8TTILob.class.getDeclaredMethod("doFreeLobPiggyback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4C8TTILob.class.getDeclaredMethod("trim", byte[].class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4C8TTILob.class.getDeclaredMethod("getChunkSize", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4C8TTILob.class.getDeclaredMethod("prepareForGetLengthRPC", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4C8TTILob.class.getDeclaredMethod("getLengthAsync", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4C8TTILob.class.getDeclaredMethod("getLength", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4C8TTILob.class.getDeclaredMethod("writeAsync", byte[].class, Long.TYPE, byte[].class, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4C8TTILob.class.getDeclaredMethod("write", byte[].class, Long.TYPE, byte[].class, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4C8TTILob.class.getDeclaredMethod("readAsync", byte[].class, Long.TYPE, Long.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4C8TTILob.class.getDeclaredMethod("read", byte[].class, Long.TYPE, Long.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

