/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltins;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.lib.PyObjectGetItemNodeGen;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PySequenceGetItemNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
public abstract class PyObjectGetItem
extends PNodeWithContext {
    public static Object executeUncached(Object receiver, Object key) {
        return PyObjectGetItemNodeGen.getUncached().execute(null, null, receiver, key);
    }

    public final Object executeCached(Frame frame, Object object, Object key) {
        return this.execute(frame, this, object, key);
    }

    public abstract Object execute(Frame var1, Node var2, Object var3, Object var4);

    @Specialization(guards={"isBuiltinList(object)"}, excludeForUncached=true)
    static Object doList(VirtualFrame frame, PList object, Object key, @Cached ListBuiltins.GetItemNode getItemNode) {
        return getItemNode.execute(frame, object, key);
    }

    @Specialization(guards={"isBuiltinTuple(object)"}, excludeForUncached=true)
    static Object doTuple(VirtualFrame frame, PTuple object, Object key, @Cached TupleBuiltins.GetItemNode getItemNode) {
        return getItemNode.execute(frame, object, key);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isBuiltinDict(object)"}, excludeForUncached=true)
    static Object doDict(VirtualFrame frame, PDict object, Object key, @Cached DictBuiltins.GetItemNode getItemNode) {
        return getItemNode.execute(frame, object, key);
    }

    @Specialization(replaces={"doList", "doTuple", "doDict"})
    static Object doGeneric(VirtualFrame frame, Node inliningTarget, Object object, Object key, @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached PyObjectGetItemGeneric genericNode) {
        TpSlots slots = getSlotsNode.execute(inliningTarget, object);
        return genericNode.execute((Frame)frame, inliningTarget, object, slots, key);
    }

    @NeverDefault
    public static PyObjectGetItem create() {
        return PyObjectGetItemNodeGen.create();
    }

    public static PyObjectGetItem getUncached() {
        return PyObjectGetItemNodeGen.getUncached();
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PyObjectGetItemGeneric
    extends PNodeWithContext {
        public abstract Object execute(Frame var1, Node var2, Object var3, TpSlots var4, Object var5);

        @Specialization(guards={"slots.mp_subscript() != null"})
        static Object doMapping(VirtualFrame frame, Node inliningTarget, Object object, TpSlots slots, Object key, @Cached TpSlotBinaryFunc.CallSlotBinaryFuncNode callNode) {
            return callNode.execute(frame, inliningTarget, slots.mp_subscript(), object, key);
        }

        @Specialization(guards={"slots.mp_subscript() == null", "slots.sq_item() != null", "key >= 0"})
        static Object doSequenceFastPath(VirtualFrame frame, Node inliningTarget, Object object, TpSlots slots, int key, @Cached.Exclusive @Cached TpSlotSizeArgFun.CallSlotSizeArgFun callSqItem) {
            return callSqItem.execute(frame, inliningTarget, slots.sq_item(), object, key);
        }

        @Specialization(guards={"slots.mp_subscript() == null", "slots.sq_item() != null"}, replaces={"doSequenceFastPath"})
        @HostCompilerDirectives.InliningCutoff
        static Object doSequence(VirtualFrame frame, Node inliningTarget, Object object, TpSlots slots, Object key, @Cached PySequenceGetItemNode.IndexForSqSlot indexForSqSlot, @Cached.Exclusive @Cached TpSlotSizeArgFun.CallSlotSizeArgFun callSqItem) {
            int index = indexForSqSlot.execute(frame, inliningTarget, object, slots, key);
            return callSqItem.execute(frame, inliningTarget, slots.sq_item(), object, index);
        }

        @HostCompilerDirectives.InliningCutoff
        @Fallback
        static Object tryType(VirtualFrame frame, Node inliningTarget, Object maybeType, TpSlots slots, Object key, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached PyObjectLookupAttr lookupClassGetItem, @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isBuiltinClassProfile, @Cached(inline=false) CallNode callClassGetItem, @Cached PRaiseNode raiseNode) {
            if (isTypeNode.execute(inliningTarget, maybeType)) {
                Object classGetitem = lookupClassGetItem.execute((Frame)frame, inliningTarget, maybeType, SpecialMethodNames.T___CLASS_GETITEM__);
                if (!(classGetitem instanceof PNone)) {
                    return callClassGetItem.execute((Frame)frame, classGetitem, key);
                }
                if (isBuiltinClassProfile.profileClass(inliningTarget, maybeType, PythonBuiltinClassType.PythonClass)) {
                    return PFactory.createGenericAlias(PythonLanguage.get(inliningTarget), maybeType, key);
                }
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.TYPE_NOT_SUBSCRIPTABLE, maybeType);
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_NOT_SUBSCRIPTABLE, maybeType);
        }
    }
}

