/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core;

import java.io.Closeable;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.Base64Variants;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.TreeNode;
import tools.jackson.core.Version;
import tools.jackson.core.Versioned;
import tools.jackson.core.async.NonBlockingInputFeeder;
import tools.jackson.core.exc.InputCoercionException;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.sym.PropertyNameMatcher;
import tools.jackson.core.type.ResolvedType;
import tools.jackson.core.type.TypeReference;
import tools.jackson.core.util.JacksonFeature;
import tools.jackson.core.util.JacksonFeatureSet;

public abstract class JsonParser
implements Closeable,
Versioned {
    protected static final JacksonFeatureSet<StreamReadCapability> DEFAULT_READ_CAPABILITIES = JacksonFeatureSet.fromDefaults((JacksonFeature[])StreamReadCapability.values());

    protected JsonParser() {
    }

    @Override
    public abstract Version version();

    public abstract TokenStreamContext streamReadContext();

    public abstract ObjectReadContext objectReadContext();

    public abstract TokenStreamLocation currentTokenLocation();

    public abstract TokenStreamLocation currentLocation();

    public abstract long currentTokenCount();

    public abstract Object streamReadInputSource();

    public abstract Object currentValue();

    public abstract void assignCurrentValue(Object var1);

    public boolean canParseAsync() {
        return false;
    }

    public NonBlockingInputFeeder nonBlockingInputFeeder() {
        return null;
    }

    @Override
    public abstract void close();

    public abstract boolean isClosed();

    public int releaseBuffered(OutputStream out) throws JacksonException {
        return -1;
    }

    public int releaseBuffered(Writer w) throws JacksonException {
        return -1;
    }

    public abstract boolean isEnabled(StreamReadFeature var1);

    public abstract int streamReadFeatures();

    public FormatSchema getSchema() {
        return null;
    }

    public abstract JacksonFeatureSet<StreamReadCapability> streamReadCapabilities();

    public abstract StreamReadConstraints streamReadConstraints();

    public abstract JsonToken nextToken() throws JacksonException;

    public abstract JsonToken nextValue() throws JacksonException;

    public abstract JsonParser skipChildren() throws JacksonException;

    public abstract void finishToken() throws JacksonException;

    public abstract String nextName() throws JacksonException;

    public abstract boolean nextName(SerializableString var1) throws JacksonException;

    public abstract int nextNameMatch(PropertyNameMatcher var1) throws JacksonException;

    public abstract int currentNameMatch(PropertyNameMatcher var1);

    public String nextStringValue() throws JacksonException {
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getString() : null;
    }

    public int nextIntValue(int defaultValue) throws JacksonException {
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getIntValue() : defaultValue;
    }

    public long nextLongValue(long defaultValue) throws JacksonException {
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getLongValue() : defaultValue;
    }

    public Boolean nextBooleanValue() throws JacksonException {
        JsonToken t = this.nextToken();
        if (t == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    public abstract JsonToken currentToken();

    public abstract int currentTokenId();

    public abstract boolean hasCurrentToken();

    public abstract boolean hasTokenId(int var1);

    public abstract boolean hasToken(JsonToken var1);

    public abstract boolean isExpectedStartArrayToken();

    public abstract boolean isExpectedStartObjectToken();

    public abstract boolean isExpectedNumberIntToken();

    public abstract boolean isNaN();

    public abstract void clearCurrentToken();

    public abstract JsonToken getLastClearedToken();

    public abstract String currentName();

    public abstract String getString() throws JacksonException;

    public abstract int getString(Writer var1) throws JacksonException;

    public abstract char[] getStringCharacters() throws JacksonException;

    public abstract int getStringLength() throws JacksonException;

    public abstract int getStringOffset() throws JacksonException;

    public abstract boolean hasStringCharacters();

    @Deprecated
    public String getText() throws JacksonException {
        return this.getString();
    }

    @Deprecated
    public char[] getTextCharacters() throws JacksonException {
        return this.getStringCharacters();
    }

    @Deprecated
    public int getTextLength() throws JacksonException {
        return this.getStringLength();
    }

    @Deprecated
    public int getTextOffset() throws JacksonException {
        return this.getStringOffset();
    }

    public abstract Number getNumberValue() throws InputCoercionException;

    public abstract Number getNumberValueExact() throws InputCoercionException;

    public abstract Object getNumberValueDeferred() throws InputCoercionException;

    public abstract NumberType getNumberType();

    public abstract NumberTypeFP getNumberTypeFP();

    public abstract byte getByteValue() throws InputCoercionException;

    public abstract short getShortValue() throws InputCoercionException;

    public abstract int getIntValue() throws InputCoercionException;

    public abstract long getLongValue() throws InputCoercionException;

    public abstract BigInteger getBigIntegerValue() throws InputCoercionException;

    public abstract float getFloatValue() throws InputCoercionException;

    public abstract double getDoubleValue() throws InputCoercionException;

    public abstract BigDecimal getDecimalValue() throws InputCoercionException;

    public abstract boolean getBooleanValue() throws InputCoercionException;

    public abstract Object getEmbeddedObject();

    public abstract byte[] getBinaryValue(Base64Variant var1) throws JacksonException;

    public byte[] getBinaryValue() throws JacksonException {
        return this.getBinaryValue(Base64Variants.getDefaultVariant());
    }

    public int readBinaryValue(OutputStream out) throws JacksonException {
        return this.readBinaryValue(Base64Variants.getDefaultVariant(), out);
    }

    public int readBinaryValue(Base64Variant bv, OutputStream out) throws JacksonException {
        this._reportUnsupportedOperation();
        return 0;
    }

    public boolean getValueAsBoolean() {
        return this.getValueAsBoolean(false);
    }

    public abstract boolean getValueAsBoolean(boolean var1);

    public int getValueAsInt() throws InputCoercionException {
        return this.getValueAsInt(0);
    }

    public int getValueAsInt(int def) throws InputCoercionException {
        return def;
    }

    public long getValueAsLong() throws InputCoercionException {
        return this.getValueAsLong(0L);
    }

    public long getValueAsLong(long def) throws InputCoercionException {
        return def;
    }

    public double getValueAsDouble() throws InputCoercionException {
        return this.getValueAsDouble(0.0);
    }

    public double getValueAsDouble(double def) throws InputCoercionException {
        return def;
    }

    public String getValueAsString() {
        return this.getValueAsString(null);
    }

    public abstract String getValueAsString(String var1);

    public boolean canReadObjectId() {
        return false;
    }

    public boolean canReadTypeId() {
        return false;
    }

    public Object getObjectId() {
        return null;
    }

    public Object getTypeId() {
        return null;
    }

    public abstract <T> T readValueAs(Class<T> var1) throws JacksonException;

    public abstract <T> T readValueAs(TypeReference<T> var1) throws JacksonException;

    public abstract <T> T readValueAs(ResolvedType var1) throws JacksonException;

    public abstract <T extends TreeNode> T readValueAsTree() throws JacksonException;

    protected void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Operation not supported by parser of type " + this.getClass().getName());
    }

    protected StreamReadException _constructReadException(String msg) {
        return new StreamReadException(this, msg);
    }

    protected StreamReadException _constructReadException(String msg, Object arg) {
        return this._constructReadException(String.format(msg, arg));
    }

    protected StreamReadException _constructReadException(String msg, Object arg1, Object arg2) {
        return this._constructReadException(String.format(msg, arg1, arg2));
    }

    protected StreamReadException _constructReadException(String msg, Object arg1, Object arg2, Object arg3) {
        return this._constructReadException(String.format(msg, arg1, arg2, arg3));
    }

    protected StreamReadException _constructReadException(String msg, Throwable t) {
        return new StreamReadException(this, msg, this.currentLocation(), t);
    }

    protected StreamReadException _constructReadException(String msg, TokenStreamLocation loc) {
        return new StreamReadException(this, msg, loc);
    }

    public static enum NumberTypeFP {
        FLOAT16,
        FLOAT32,
        DOUBLE64,
        BIG_DECIMAL,
        UNKNOWN;

    }

    public static enum NumberType {
        INT,
        LONG,
        BIG_INTEGER,
        FLOAT,
        DOUBLE,
        BIG_DECIMAL;

    }
}

