/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.set;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.set.BaseSetBuiltins;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.set.SetNodesFactory;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

public abstract class SetNodes {

    public static abstract class DiscardNode
    extends PythonBinaryBuiltinNode {
        public abstract boolean execute(VirtualFrame var1, PSet var2, Object var3);

        @Specialization
        boolean discard(VirtualFrame frame, PSet self, Object key, @Bind Node inliningTarget, @Cached BaseSetBuiltins.ConvertKeyNode conv, @Cached HashingStorageNodes.HashingStorageDelItem delItem) {
            Object checkedKey = conv.execute(inliningTarget, key);
            return delItem.execute((Frame)frame, inliningTarget, self.getDictStorage(), checkedKey, self);
        }
    }

    @GenerateUncached
    @OperationProxy.Proxyable
    @GenerateInline(value=false)
    public static abstract class AddNode
    extends PNodeWithContext {
        public abstract void execute(Frame var1, PSet var2, Object var3);

        @Specialization
        public static void add(VirtualFrame frame, PSet self, Object o, @Bind Node inliningTarget, @Cached HashingCollectionNodes.SetItemNode setItemNode) {
            setItemNode.execute((Frame)frame, inliningTarget, self, o, PNone.NONE);
        }

        @NeverDefault
        public static AddNode create() {
            return SetNodesFactory.AddNodeGen.create();
        }

        public static AddNode getUncached() {
            return SetNodesFactory.AddNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class ConstructSetNode
    extends PNodeWithContext {
        public abstract PSet execute(Frame var1, Object var2);

        @Specialization(guards={"isNoValue(none)"})
        static PSet set(PNone none, @Bind PythonLanguage language) {
            return PFactory.createSet(language);
        }

        @Specialization(guards={"!isNoValue(iterable)"})
        static PSet setIterable(VirtualFrame frame, Object iterable, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Exclusive @Cached HashingCollectionNodes.SetItemNode setItemNode, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode nextNode) {
            PSet set = PFactory.createSet(language);
            Object iterator = getIter.execute((Frame)frame, inliningTarget, iterable);
            while (true) {
                Object next;
                try {
                    next = nextNode.execute((Frame)frame, inliningTarget, iterator);
                }
                catch (IteratorExhausted e) {
                    return set;
                }
                setItemNode.execute((Frame)frame, inliningTarget, set, next, PNone.NONE);
            }
        }

        @Fallback
        static PSet setObject(Object value, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.OBJ_NOT_ITERABLE, value);
        }

        @NeverDefault
        public static ConstructSetNode create() {
            return SetNodesFactory.ConstructSetNodeGen.create();
        }

        public static ConstructSetNode getUncached() {
            return SetNodesFactory.ConstructSetNodeGen.getUncached();
        }
    }
}

