/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetry;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class CSVMetricsExporter {
    private static final SFLogger logger = SFLoggerFactory.getLogger(CSVMetricsExporter.class);
    static final String CSV_EXPORTER_FILE_PROPERTY = "metrics.csv.exporter.file";
    static final String CSV_EXPORTER_FLUSH_SIZE_PROPERTY = "metrics.csv.exporter.flush.size";
    private final List<ExecTimeTelemetryData> entries = new ArrayList<ExecTimeTelemetryData>();
    private final String filePath;
    private final Integer flushSize;
    private static CSVMetricsExporter instance;

    CSVMetricsExporter(String filePath, int flushSize) {
        this.filePath = filePath;
        this.flushSize = flushSize;
        Runtime.getRuntime().addShutdownHook(new Thread(this::flush));
    }

    public static synchronized CSVMetricsExporter getDefaultInstance() {
        if (instance == null) {
            String filePath = System.getProperty(CSV_EXPORTER_FILE_PROPERTY);
            int limit = Integer.parseInt(Optional.ofNullable(System.getProperty(CSV_EXPORTER_FLUSH_SIZE_PROPERTY)).orElse("1"));
            instance = new CSVMetricsExporter(filePath, limit);
        }
        return instance;
    }

    public synchronized void save(ExecTimeTelemetryData data) {
        if (SnowflakeUtil.isNullOrEmpty(this.filePath)) {
            return;
        }
        this.entries.add(data);
        if (this.entries.size() >= this.flushSize) {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flush() {
        if (SnowflakeUtil.isNullOrEmpty(this.filePath)) {
            return;
        }
        if (this.entries.isEmpty()) {
            return;
        }
        Path path = Paths.get(this.filePath, new String[0]);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            boolean fileExists = Files.exists(path, new LinkOption[0]);
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.filePath, true));){
                if (!fileExists) {
                    writer.write("sessionId,requestId,queryId,queryText,executeToSendTime,bindTime,gzipTime,httpClientTime,responseIOStreamTime,processResultChunkTime,createResultSetTime,queryTime");
                    writer.newLine();
                }
                for (ExecTimeTelemetryData data : this.entries) {
                    writer.write(this.formatCsvRow(data));
                    writer.newLine();
                }
                writer.flush();
            }
        }
        catch (IOException e) {
            logger.warn("Failed to write metrics to CSV file: {}", this.filePath, e);
        }
        finally {
            this.entries.clear();
        }
    }

    private String formatCsvRow(ExecTimeTelemetryData data) {
        return String.join((CharSequence)",", this.escapeCsvValue(data.getSessionId()), this.escapeCsvValue(data.getRequestId()), this.escapeCsvValue(data.getQueryId()), this.escapeCsvValue(data.getQueryText()), String.valueOf(data.getExecuteToSend().getTime()), String.valueOf(data.getBind().getTime()), String.valueOf(data.getGzip().getTime()), String.valueOf(data.getHttpClient().getTime()), String.valueOf(data.getResponseIOStream().getTime()), String.valueOf(data.getProcessResultChunk().getTime()), String.valueOf(data.getCreateResultSet().getTime()), String.valueOf(data.getQuery().getTime()));
    }

    private String escapeCsvValue(String value) {
        if (value == null) {
            return "";
        }
        if (value.contains(",") || value.contains("\"") || value.contains("\n") || value.contains("\r")) {
            return "\"" + value.replace("\"", "\"\"") + "\"";
        }
        return value;
    }
}

