/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import net.snowflake.client.jdbc.internal.google.auth.oauth2.ComputeEngineCredentials;
import net.snowflake.client.jdbc.internal.google.auth.oauth2.IdTokenCredentials;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.primitives.UnsignedLongs;
import net.snowflake.client.jdbc.internal.google.protobuf.Any;
import net.snowflake.client.jdbc.internal.google.protobuf.InvalidProtocolBufferException;
import net.snowflake.client.jdbc.internal.google.protobuf.Message;
import net.snowflake.client.jdbc.internal.grpc.CallCredentials;
import net.snowflake.client.jdbc.internal.grpc.CallOptions;
import net.snowflake.client.jdbc.internal.grpc.Channel;
import net.snowflake.client.jdbc.internal.grpc.ClientCall;
import net.snowflake.client.jdbc.internal.grpc.ClientInterceptor;
import net.snowflake.client.jdbc.internal.grpc.CompositeCallCredentials;
import net.snowflake.client.jdbc.internal.grpc.Metadata;
import net.snowflake.client.jdbc.internal.grpc.MethodDescriptor;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.StatusOr;
import net.snowflake.client.jdbc.internal.grpc.auth.MoreCallCredentials;
import net.snowflake.client.jdbc.internal.grpc.xds.ConfigOrError;
import net.snowflake.client.jdbc.internal.grpc.xds.Filter;
import net.snowflake.client.jdbc.internal.grpc.xds.MetadataRegistry;
import net.snowflake.client.jdbc.internal.grpc.xds.XdsConfig;
import net.snowflake.client.jdbc.internal.grpc.xds.XdsNameResolver;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsResourceType;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.gcp_authn.v3.Audience;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.gcp_authn.v3.GcpAuthnFilterConfig;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.gcp_authn.v3.TokenCacheConfig;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

final class GcpAuthenticationFilter
implements Filter {
    static final String TYPE_URL = "type.googleapis.com/envoy.extensions.filters.http.gcp_authn.v3.GcpAuthnFilterConfig";
    private final LruCache<String, CallCredentials> callCredentialsCache;
    final String filterInstanceName;

    GcpAuthenticationFilter(String name, int cacheSize) {
        this.filterInstanceName = Preconditions.checkNotNull(name, "name");
        this.callCredentialsCache = new LruCache(cacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ClientInterceptor buildClientInterceptor(Filter.FilterConfig config, @Nullable Filter.FilterConfig overrideConfig, ScheduledExecutorService scheduler) {
        final ComputeEngineCredentials credentials = ComputeEngineCredentials.create();
        LruCache<String, CallCredentials> lruCache = this.callCredentialsCache;
        synchronized (lruCache) {
            ((LruCache)this.callCredentialsCache).resizeCache(((GcpAuthenticationConfig)config).getCacheSize());
        }
        return new ClientInterceptor(){

            @Override
            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                String clusterName = callOptions.getOption(XdsNameResolver.CLUSTER_SELECTION_KEY);
                if (clusterName == null) {
                    return new FailingClientCall(Status.UNAVAILABLE.withDescription(String.format("GCP Authn for %s does not contain cluster resource", GcpAuthenticationFilter.this.filterInstanceName)));
                }
                if (!clusterName.startsWith("cluster:")) {
                    return next.newCall(method, callOptions);
                }
                XdsConfig xdsConfig = callOptions.getOption(XdsNameResolver.XDS_CONFIG_CALL_OPTION_KEY);
                if (xdsConfig == null) {
                    return new FailingClientCall(Status.UNAVAILABLE.withDescription(String.format("GCP Authn for %s with %s does not contain xds configuration", GcpAuthenticationFilter.this.filterInstanceName, clusterName)));
                }
                StatusOr<XdsConfig.XdsClusterConfig> xdsCluster = xdsConfig.getClusters().get(clusterName.substring("cluster:".length()));
                if (xdsCluster == null) {
                    return new FailingClientCall(Status.UNAVAILABLE.withDescription(String.format("GCP Authn for %s with %s - xds cluster config does not contain xds cluster", GcpAuthenticationFilter.this.filterInstanceName, clusterName)));
                }
                if (!xdsCluster.hasValue()) {
                    return new FailingClientCall(xdsCluster.getStatus());
                }
                Object audienceObj = xdsCluster.getValue().getClusterResource().parsedMetadata().get(GcpAuthenticationFilter.this.filterInstanceName);
                if (audienceObj == null) {
                    return next.newCall(method, callOptions);
                }
                if (!(audienceObj instanceof AudienceMetadataParser.AudienceWrapper)) {
                    return new FailingClientCall(Status.UNAVAILABLE.withDescription(String.format("GCP Authn found wrong type in %s metadata: %s=%s", clusterName, GcpAuthenticationFilter.this.filterInstanceName, audienceObj.getClass())));
                }
                AudienceMetadataParser.AudienceWrapper audience = (AudienceMetadataParser.AudienceWrapper)audienceObj;
                CallCredentials existingCallCredentials = callOptions.getCredentials();
                CallCredentials newCallCredentials = GcpAuthenticationFilter.this.getCallCredentials(GcpAuthenticationFilter.this.callCredentialsCache, audience.audience, credentials);
                callOptions = existingCallCredentials != null ? callOptions.withCallCredentials(new CompositeCallCredentials(existingCallCredentials, newCallCredentials)) : callOptions.withCallCredentials(newCallCredentials);
                return next.newCall(method, callOptions);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallCredentials getCallCredentials(LruCache<String, CallCredentials> cache, String audience, ComputeEngineCredentials credentials) {
        LruCache<String, CallCredentials> lruCache = cache;
        synchronized (lruCache) {
            return cache.getOrInsert(audience, key -> {
                IdTokenCredentials creds = IdTokenCredentials.newBuilder().setIdTokenProvider(credentials).setTargetAudience(audience).build();
                return MoreCallCredentials.from(creds);
            });
        }
    }

    static class AudienceMetadataParser
    implements MetadataRegistry.MetadataValueParser {
        AudienceMetadataParser() {
        }

        @Override
        public String getTypeUrl() {
            return "type.googleapis.com/envoy.extensions.filters.http.gcp_authn.v3.Audience";
        }

        @Override
        public AudienceWrapper parse(Any any) throws XdsResourceType.ResourceInvalidException {
            Audience audience;
            try {
                audience = any.unpack(Audience.class);
            }
            catch (InvalidProtocolBufferException ex) {
                throw new XdsResourceType.ResourceInvalidException("Invalid Resource in address proto", ex);
            }
            String url = audience.getUrl();
            if (url.isEmpty()) {
                throw new XdsResourceType.ResourceInvalidException("Audience URL is empty. Metadata value must contain a valid URL.");
            }
            return new AudienceWrapper(url);
        }

        static final class AudienceWrapper {
            final String audience;

            AudienceWrapper(String audience) {
                this.audience = Preconditions.checkNotNull(audience);
            }
        }
    }

    private static final class LruCache<K, V> {
        private Map<K, V> cache;
        private int maxSize;

        LruCache(int maxSize) {
            this.maxSize = maxSize;
            this.cache = this.createEvictingMap(maxSize);
        }

        V getOrInsert(K key, Function<K, V> create) {
            return this.cache.computeIfAbsent(key, create);
        }

        private void resizeCache(int newSize) {
            if (newSize >= this.maxSize) {
                this.maxSize = newSize;
                return;
            }
            Map<K, V> newCache = this.createEvictingMap(newSize);
            this.maxSize = newSize;
            newCache.putAll(this.cache);
            this.cache = newCache;
        }

        private Map<K, V> createEvictingMap(int size) {
            return new LinkedHashMap<K, V>(size, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                    return this.size() > maxSize;
                }
            };
        }
    }

    @VisibleForTesting
    static final class FailingClientCall<ReqT, RespT>
    extends ClientCall<ReqT, RespT> {
        @VisibleForTesting
        final Status error;

        public FailingClientCall(Status error) {
            this.error = error;
        }

        @Override
        public void start(ClientCall.Listener<RespT> listener, Metadata headers) {
            listener.onClose(this.error, new Metadata());
        }

        @Override
        public void request(int numMessages) {
        }

        @Override
        public void cancel(String message, Throwable cause) {
        }

        @Override
        public void halfClose() {
        }

        @Override
        public void sendMessage(ReqT message) {
        }
    }

    static final class GcpAuthenticationConfig
    implements Filter.FilterConfig {
        private final int cacheSize;

        public GcpAuthenticationConfig(int cacheSize) {
            this.cacheSize = cacheSize;
        }

        public int getCacheSize() {
            return this.cacheSize;
        }

        @Override
        public String typeUrl() {
            return GcpAuthenticationFilter.TYPE_URL;
        }
    }

    static final class Provider
    implements Filter.Provider {
        private final int cacheSize = 10;

        Provider() {
        }

        @Override
        public String[] typeUrls() {
            return new String[]{GcpAuthenticationFilter.TYPE_URL};
        }

        @Override
        public boolean isClientFilter() {
            return true;
        }

        @Override
        public GcpAuthenticationFilter newInstance(String name) {
            return new GcpAuthenticationFilter(name, 10);
        }

        public ConfigOrError<GcpAuthenticationConfig> parseFilterConfig(Message rawProtoMessage) {
            GcpAuthnFilterConfig gcpAuthnProto;
            if (!(rawProtoMessage instanceof Any)) {
                return ConfigOrError.fromError("Invalid config type: " + rawProtoMessage.getClass());
            }
            Any anyMessage = (Any)rawProtoMessage;
            try {
                gcpAuthnProto = anyMessage.unpack(GcpAuthnFilterConfig.class);
            }
            catch (InvalidProtocolBufferException e) {
                return ConfigOrError.fromError("Invalid proto: " + e);
            }
            long cacheSize = 10L;
            if (gcpAuthnProto.hasCacheConfig()) {
                TokenCacheConfig cacheConfig = gcpAuthnProto.getCacheConfig();
                if (cacheConfig.hasCacheSize() && (cacheSize = cacheConfig.getCacheSize().getValue()) == 0L) {
                    return ConfigOrError.fromError("cache_config.cache_size must be greater than zero");
                }
                cacheSize = UnsignedLongs.min((long[])new long[]{cacheSize, 0x7FFFFFFEL});
            }
            GcpAuthenticationConfig config = new GcpAuthenticationConfig((int)cacheSize);
            return ConfigOrError.fromConfig(config);
        }

        public ConfigOrError<GcpAuthenticationConfig> parseFilterConfigOverride(Message rawProtoMessage) {
            return this.parseFilterConfig(rawProtoMessage);
        }
    }
}

