/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.httpjson;

import java.util.concurrent.CancellationException;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonClientCall;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonMetadata;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ApiCallContext;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ResponseObserver;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.StreamController;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;

class HttpJsonDirectStreamController<RequestT, ResponseT>
implements StreamController {
    private final HttpJsonClientCall<RequestT, ResponseT> clientCall;
    private final ResponseObserver<ResponseT> responseObserver;
    private volatile boolean hasStarted;
    private volatile boolean autoflowControl = true;
    private volatile int numRequested;
    private volatile CancellationException cancellationException;

    HttpJsonDirectStreamController(HttpJsonClientCall<RequestT, ResponseT> clientCall, ResponseObserver<ResponseT> responseObserver) {
        this.clientCall = clientCall;
        this.responseObserver = responseObserver;
    }

    @Override
    public void cancel() {
        this.cancellationException = new CancellationException("User cancelled stream");
        this.clientCall.cancel(null, this.cancellationException);
    }

    @Override
    public void disableAutoInboundFlowControl() {
        Preconditions.checkState(!this.hasStarted, "Can't disable automatic flow control after the stream has started.");
        this.autoflowControl = false;
    }

    @Override
    public void request(int count) {
        Preconditions.checkState(!this.autoflowControl, "Autoflow control is enabled.");
        if (!this.hasStarted) {
            this.numRequested += count;
        } else {
            this.clientCall.request(count);
        }
    }

    void start(RequestT request, ApiCallContext context) {
        this.responseObserver.onStart(this);
        this.hasStarted = true;
        this.clientCall.start(new ResponseObserverAdapter(), HttpJsonMetadata.newBuilder().build().withHeaders(context.getExtraHeaders()));
        if (this.autoflowControl) {
            this.clientCall.request(1);
        } else if (this.numRequested > 0) {
            this.clientCall.request(this.numRequested);
        }
        this.clientCall.sendMessage(request);
    }

    private class ResponseObserverAdapter
    extends HttpJsonClientCall.Listener<ResponseT> {
        private ResponseObserverAdapter() {
        }

        @Override
        public void onMessage(ResponseT message) {
            HttpJsonDirectStreamController.this.responseObserver.onResponse(message);
            if (HttpJsonDirectStreamController.this.autoflowControl) {
                HttpJsonDirectStreamController.this.clientCall.request(1);
            }
        }

        @Override
        public void onClose(int statusCode, HttpJsonMetadata trailers) {
            if (statusCode >= 200 && statusCode < 300) {
                HttpJsonDirectStreamController.this.responseObserver.onComplete();
            } else if (HttpJsonDirectStreamController.this.cancellationException != null) {
                HttpJsonDirectStreamController.this.responseObserver.onError(HttpJsonDirectStreamController.this.cancellationException);
            } else {
                HttpJsonDirectStreamController.this.responseObserver.onError(trailers.getException());
            }
        }
    }
}

