/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.time.Period;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BigIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.SmallIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

class IntervalYearMonthToPeriodConverter
extends AbstractArrowVectorConverter {
    private SmallIntVector smallIntVector;
    private IntVector intVector;
    private BigIntVector bigIntVector;
    private static final int monthsInYear = 12;

    public IntervalYearMonthToPeriodConverter(ValueVector vector, int idx, DataConversionContext context) {
        super(SnowflakeType.INTERVAL_YEAR_MONTH.name(), vector, idx, context);
        if (vector instanceof SmallIntVector) {
            this.smallIntVector = (SmallIntVector)vector;
        } else if (vector instanceof IntVector) {
            this.intVector = (IntVector)vector;
        } else if (vector instanceof BigIntVector) {
            this.bigIntVector = (BigIntVector)vector;
        }
    }

    @Override
    public Period toPeriod(int index) {
        if (this.isNull(index)) {
            return null;
        }
        if (this.smallIntVector != null) {
            short value = this.smallIntVector.get(index);
            return Period.of(value / 12, value % 12, 0);
        }
        if (this.intVector != null) {
            int value = this.intVector.get(index);
            return Period.of(value / 12, value % 12, 0);
        }
        long value = this.bigIntVector.get(index);
        return Period.of((int)(value / 12L), (int)(value % 12L), 0);
    }

    @Override
    public String toString(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        return this.toPeriod(index).toString();
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.toPeriod(index);
    }
}

