/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.Array;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.Map;
import net.snowflake.client.core.FieldSchemaCreator;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.BindingParameterMetadata;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;

@SnowflakeJdbcInternalApi
public class SfSqlArray
implements Array {
    private final String text;
    private final int baseType;
    private final Object elements;
    private String jsonStringFromElements;
    private final ObjectMapper objectMapper;

    public SfSqlArray(String text, int baseType, Object elements, SFBaseSession session, ObjectMapper objectMapper) {
        this.text = text;
        this.baseType = baseType;
        this.elements = elements;
        this.objectMapper = objectMapper;
    }

    public SfSqlArray(int baseType, Object elements, SFBaseSession session, ObjectMapper objectMapper) {
        this(null, baseType, elements, session, objectMapper);
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return JDBCType.valueOf(this.baseType).getName();
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.baseType;
    }

    @Override
    public Object getArray() throws SQLException {
        return this.elements;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getArray(Map<String, Class<?>> map)");
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        throw new SQLFeatureNotSupportedException("getArray(long index, int count)");
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getArray(long index, int count, Map<String, Class<?>> map)");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new SQLFeatureNotSupportedException("getArray(long index, int count, Map<String, Class<?>> map)");
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet(Map<String, Class<?>> map)");
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet(long index, int count)");
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet(long index, int count, Map<String, Class<?>> map)");
    }

    @Override
    public void free() throws SQLException {
    }

    public String getText() {
        if (this.text == null) {
            FieldSchemaCreator.logger.warn("Text field wasn't initialized. Should never happen.", new Object[0]);
        }
        return this.text;
    }

    public String getJsonString() throws SQLException {
        if (this.jsonStringFromElements == null) {
            this.jsonStringFromElements = this.buildJsonStringFromElements(this.elements);
        }
        return this.jsonStringFromElements;
    }

    private String buildJsonStringFromElements(Object elements) throws SQLException {
        try {
            return this.objectMapper.writeValueAsString(elements);
        }
        catch (JsonProcessingException e) {
            throw new SQLException("There is exception during array to json string.", e);
        }
    }

    public BindingParameterMetadata getSchema() throws SQLException {
        return BindingParameterMetadata.BindingParameterMetadataBuilder.bindingParameterMetadata().withType("array").withFields(Arrays.asList(FieldSchemaCreator.buildBindingSchemaForType(this.getBaseType(), false))).build();
    }
}

