/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.crypto.ec;

import java.security.spec.ECParameterSpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.security.crypto.ec.EnhancedECParameterSpec;
import org.opensaml.security.crypto.ec.NamedCurve;
import org.slf4j.Logger;

public class NamedCurveRegistry {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(NamedCurveRegistry.class);
    @Nonnull
    private final Map<String, NamedCurve> byOID = new HashMap<String, NamedCurve>();
    @Nonnull
    private final Map<String, NamedCurve> byURI = new HashMap<String, NamedCurve>();
    @Nonnull
    private final Map<String, NamedCurve> byName = new HashMap<String, NamedCurve>();
    @Nonnull
    private final Map<EnhancedECParameterSpec, NamedCurve> byParamSpec = new HashMap<EnhancedECParameterSpec, NamedCurve>();

    public void register(@Nonnull NamedCurve curve) {
        Constraint.isNotNull(curve, "NamedCurve was null in registration");
        this.byOID.put(curve.getObjectIdentifier(), curve);
        this.byURI.put(curve.getURI(), curve);
        this.byName.put(curve.getName(), curve);
        this.byParamSpec.put(new EnhancedECParameterSpec(curve.getParameterSpec()), curve);
        this.log.debug("Registered NamedCurve: {}", (Object)curve);
    }

    public void deregister(@Nonnull NamedCurve curve) {
        Constraint.isNotNull(curve, "NamedCurve was null in deregistration");
        this.byOID.remove(curve.getObjectIdentifier());
        this.byURI.remove(curve.getURI());
        this.byName.remove(curve.getName());
        this.byParamSpec.remove(new EnhancedECParameterSpec(curve.getParameterSpec()));
        this.log.debug("Deregistered NamedCurve: {}", (Object)curve);
    }

    public void deregisterByOID(@Nonnull String oid) {
        Constraint.isNotNull(oid, "OID was null in NamedCurve deregistration");
        NamedCurve curve = this.getByOID(oid);
        if (curve != null) {
            this.deregister(curve);
        }
    }

    public void deregisterByURI(@Nonnull String uri) {
        Constraint.isNotNull(uri, "URI was null in NamedCurve deregistration");
        NamedCurve curve = this.getByURI(uri);
        if (curve != null) {
            this.deregister(curve);
        }
    }

    public void deregisterByName(@Nonnull String name) {
        Constraint.isNotNull(name, "Name was null in NamedCurve deregistration");
        NamedCurve curve = this.getByName(name);
        if (curve != null) {
            this.deregister(curve);
        }
    }

    public void deregisterByParameterSpec(@Nonnull ECParameterSpec spec) {
        Constraint.isNotNull(spec, "ECParameterSpec was null in NamedCurve deregistration");
        NamedCurve curve = this.getByParameterSpec(spec);
        if (curve != null) {
            this.deregister(curve);
        }
    }

    public void clear() {
        this.byOID.clear();
        this.byURI.clear();
        this.byName.clear();
        this.byParamSpec.clear();
        this.log.debug("Cleared all registered NamedCurves");
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<NamedCurve> getRegisteredCurves() {
        return CollectionSupport.copyToSet(this.byOID.values());
    }

    @Nullable
    public NamedCurve getByOID(@Nonnull String oid) {
        Constraint.isNotNull(oid, "OID was null in NamedCurve lookup");
        return this.byOID.get(StringSupport.trimOrNull(oid));
    }

    @Nullable
    public NamedCurve getByURI(@Nonnull String uri) {
        Constraint.isNotNull(uri, "URI was null in NamedCurve lookup");
        return this.byURI.get(StringSupport.trimOrNull(uri));
    }

    @Nullable
    public NamedCurve getByName(@Nonnull String name) {
        Constraint.isNotNull(name, "Name was null in NamedCurve lookup");
        return this.byName.get(StringSupport.trimOrNull(name));
    }

    @Nullable
    public NamedCurve getByParameterSpec(@Nonnull ECParameterSpec spec) {
        Constraint.isNotNull(spec, "ECParameterSpec was null in NamedCurve lookup");
        return this.byParamSpec.get(new EnhancedECParameterSpec(spec));
    }
}

