/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.util.DerUtil;

public class DEROtherInfo {
    private final ASN1Sequence sequence;

    private DEROtherInfo(DERSequence dERSequence) {
        this.sequence = dERSequence;
    }

    public DEROtherInfo(byte[] byArray) {
        this.sequence = ASN1Sequence.getInstance(byArray);
    }

    public byte[] getEncoded() throws IOException {
        return this.sequence.getEncoded("DER");
    }

    public static final class Builder {
        private final AlgorithmIdentifier algorithmID;
        private final ASN1OctetString partyUVInfo;
        private final ASN1OctetString partyVInfo;
        private ASN1TaggedObject suppPubInfo;
        private ASN1TaggedObject suppPrivInfo;

        public Builder(DEROtherInfo dEROtherInfo) {
            ASN1Sequence aSN1Sequence = dEROtherInfo.sequence;
            this.algorithmID = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
            this.partyUVInfo = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1));
            this.partyVInfo = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(2));
            if (aSN1Sequence.size() == 5) {
                this.suppPubInfo = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(3));
                this.suppPrivInfo = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(4));
            } else if (aSN1Sequence.size() == 4) {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(3));
                if (aSN1TaggedObject.getTagNo() == 0) {
                    this.suppPubInfo = aSN1TaggedObject;
                } else {
                    this.suppPrivInfo = aSN1TaggedObject;
                }
            }
        }

        public Builder(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2) {
            this.algorithmID = algorithmIdentifier;
            this.partyUVInfo = DerUtil.getOctetString(byArray);
            this.partyVInfo = DerUtil.getOctetString(byArray2);
        }

        public Builder withSuppPubInfo(byte[] byArray) {
            this.suppPubInfo = new DERTaggedObject(false, 0, DerUtil.getOctetString(byArray));
            return this;
        }

        public Builder withSuppPrivInfo(byte[] byArray) {
            this.suppPrivInfo = new DERTaggedObject(false, 1, DerUtil.getOctetString(byArray));
            return this;
        }

        public DEROtherInfo build() {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(this.algorithmID);
            aSN1EncodableVector.add(this.partyUVInfo);
            aSN1EncodableVector.add(this.partyVInfo);
            if (this.suppPubInfo != null) {
                aSN1EncodableVector.add(this.suppPubInfo);
            }
            if (this.suppPrivInfo != null) {
                aSN1EncodableVector.add(this.suppPrivInfo);
            }
            return new DEROtherInfo(new DERSequence(aSN1EncodableVector));
        }
    }
}

