/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot.restore;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ShardStatistics;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SnapshotRestore
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SnapshotRestore> {
    @Nonnull
    private final List<String> indices;
    @Nonnull
    private final ShardStatistics shards;
    @Nonnull
    private final String snapshot;
    public static final JsonpDeserializer<SnapshotRestore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotRestore::setupSnapshotRestoreDeserializer);

    private SnapshotRestore(Builder builder) {
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
        this.snapshot = ApiTypeHelper.requireNonNull(builder.snapshot, this, "snapshot");
    }

    public static SnapshotRestore of(Function<Builder, ObjectBuilder<SnapshotRestore>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> indices() {
        return this.indices;
    }

    @Nonnull
    public final ShardStatistics shards() {
        return this.shards;
    }

    @Nonnull
    public final String snapshot() {
        return this.snapshot;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("indices");
        generator.writeStartArray();
        for (String item0 : this.indices) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("snapshot");
        generator.write(this.snapshot);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSnapshotRestoreDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "shards");
        op.add(Builder::snapshot, JsonpDeserializer.stringDeserializer(), "snapshot");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.indices.hashCode();
        result = 31 * result + this.shards.hashCode();
        result = 31 * result + this.snapshot.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotRestore other = (SnapshotRestore)o;
        return this.indices.equals(other.indices) && this.shards.equals(other.shards) && this.snapshot.equals(other.snapshot);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, SnapshotRestore> {
        private List<String> indices;
        private ShardStatistics shards;
        private String snapshot;

        public Builder() {
        }

        private Builder(SnapshotRestore o) {
            this.indices = Builder._listCopy(o.indices);
            this.shards = o.shards;
            this.snapshot = o.snapshot;
        }

        private Builder(Builder o) {
            this.indices = Builder._listCopy(o.indices);
            this.shards = o.shards;
            this.snapshot = o.snapshot;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        @Nonnull
        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        @Nonnull
        public final Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        @Nonnull
        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Nonnull
        public final Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        @Override
        @Nonnull
        public SnapshotRestore build() {
            this._checkSingleUse();
            return new SnapshotRestore(this);
        }
    }
}

