/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SegmentReplicationStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SegmentReplicationStats> {
    @Nonnull
    private final JsonData maxBytesBehind;
    @Nonnull
    private final JsonData maxReplicationLag;
    @Nonnull
    private final JsonData totalBytesBehind;
    public static final JsonpDeserializer<SegmentReplicationStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SegmentReplicationStats::setupSegmentReplicationStatsDeserializer);

    private SegmentReplicationStats(Builder builder) {
        this.maxBytesBehind = ApiTypeHelper.requireNonNull(builder.maxBytesBehind, this, "maxBytesBehind");
        this.maxReplicationLag = ApiTypeHelper.requireNonNull(builder.maxReplicationLag, this, "maxReplicationLag");
        this.totalBytesBehind = ApiTypeHelper.requireNonNull(builder.totalBytesBehind, this, "totalBytesBehind");
    }

    public static SegmentReplicationStats of(Function<Builder, ObjectBuilder<SegmentReplicationStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final JsonData maxBytesBehind() {
        return this.maxBytesBehind;
    }

    @Nonnull
    public final JsonData maxReplicationLag() {
        return this.maxReplicationLag;
    }

    @Nonnull
    public final JsonData totalBytesBehind() {
        return this.totalBytesBehind;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max_bytes_behind");
        this.maxBytesBehind.serialize(generator, mapper);
        generator.writeKey("max_replication_lag");
        this.maxReplicationLag.serialize(generator, mapper);
        generator.writeKey("total_bytes_behind");
        this.totalBytesBehind.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSegmentReplicationStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxBytesBehind, JsonData._DESERIALIZER, "max_bytes_behind");
        op.add(Builder::maxReplicationLag, JsonData._DESERIALIZER, "max_replication_lag");
        op.add(Builder::totalBytesBehind, JsonData._DESERIALIZER, "total_bytes_behind");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.maxBytesBehind.hashCode();
        result = 31 * result + this.maxReplicationLag.hashCode();
        result = 31 * result + this.totalBytesBehind.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentReplicationStats other = (SegmentReplicationStats)o;
        return this.maxBytesBehind.equals(other.maxBytesBehind) && this.maxReplicationLag.equals(other.maxReplicationLag) && this.totalBytesBehind.equals(other.totalBytesBehind);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, SegmentReplicationStats> {
        private JsonData maxBytesBehind;
        private JsonData maxReplicationLag;
        private JsonData totalBytesBehind;

        public Builder() {
        }

        private Builder(SegmentReplicationStats o) {
            this.maxBytesBehind = o.maxBytesBehind;
            this.maxReplicationLag = o.maxReplicationLag;
            this.totalBytesBehind = o.totalBytesBehind;
        }

        private Builder(Builder o) {
            this.maxBytesBehind = o.maxBytesBehind;
            this.maxReplicationLag = o.maxReplicationLag;
            this.totalBytesBehind = o.totalBytesBehind;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder maxBytesBehind(JsonData value) {
            this.maxBytesBehind = value;
            return this;
        }

        @Nonnull
        public final Builder maxReplicationLag(JsonData value) {
            this.maxReplicationLag = value;
            return this;
        }

        @Nonnull
        public final Builder totalBytesBehind(JsonData value) {
            this.totalBytesBehind = value;
            return this;
        }

        @Override
        @Nonnull
        public SegmentReplicationStats build() {
            this._checkSingleUse();
            return new SegmentReplicationStats(this);
        }
    }
}

