(()=>{var __webpack_modules__={945:function(module,__unused_webpack_exports,__webpack_require__){var cssKeywords=__webpack_require__(973);var reverseKeywords={};for(var key in cssKeywords){if(cssKeywords.hasOwnProperty(key)){reverseKeywords[cssKeywords[key]]=key}}var convert=module.exports={rgb:{channels:3,labels:"rgb"},hsl:{channels:3,labels:"hsl"},hsv:{channels:3,labels:"hsv"},hwb:{channels:3,labels:"hwb"},cmyk:{channels:4,labels:"cmyk"},xyz:{channels:3,labels:"xyz"},lab:{channels:3,labels:"lab"},lch:{channels:3,labels:"lch"},hex:{channels:1,labels:["hex"]},keyword:{channels:1,labels:["keyword"]},ansi16:{channels:1,labels:["ansi16"]},ansi256:{channels:1,labels:["ansi256"]},hcg:{channels:3,labels:["h","c","g"]},apple:{channels:3,labels:["r16","g16","b16"]},gray:{channels:1,labels:["gray"]}};for(var model in convert){if(convert.hasOwnProperty(model)){if(!("channels"in convert[model])){throw new Error("missing channels property: "+model)}if(!("labels"in convert[model])){throw new Error("missing channel labels property: "+model)}if(convert[model].labels.length!==convert[model].channels){throw new Error("channel and label counts mismatch: "+model)}var channels=convert[model].channels;var labels=convert[model].labels;delete convert[model].channels;delete convert[model].labels;Object.defineProperty(convert[model],"channels",{value:channels});Object.defineProperty(convert[model],"labels",{value:labels})}}convert.rgb.hsl=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var min=Math.min(r,g,b);var max=Math.max(r,g,b);var delta=max-min;var h;var s;var l;if(max===min){h=0}else if(r===max){h=(g-b)/delta}else if(g===max){h=2+(b-r)/delta}else if(b===max){h=4+(r-g)/delta}h=Math.min(h*60,360);if(h<0){h+=360}l=(min+max)/2;if(max===min){s=0}else if(l<=.5){s=delta/(max+min)}else{s=delta/(2-max-min)}return[h,s*100,l*100]};convert.rgb.hsv=function(rgb){var rdif;var gdif;var bdif;var h;var s;var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var v=Math.max(r,g,b);var diff=v-Math.min(r,g,b);var diffc=function(c){return(v-c)/6/diff+1/2};if(diff===0){h=s=0}else{s=diff/v;rdif=diffc(r);gdif=diffc(g);bdif=diffc(b);if(r===v){h=bdif-gdif}else if(g===v){h=1/3+rdif-bdif}else if(b===v){h=2/3+gdif-rdif}if(h<0){h+=1}else if(h>1){h-=1}}return[h*360,s*100,v*100]};convert.rgb.hwb=function(rgb){var r=rgb[0];var g=rgb[1];var b=rgb[2];var h=convert.rgb.hsl(rgb)[0];var w=1/255*Math.min(r,Math.min(g,b));b=1-1/255*Math.max(r,Math.max(g,b));return[h,w*100,b*100]};convert.rgb.cmyk=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var c;var m;var y;var k;k=Math.min(1-r,1-g,1-b);c=(1-r-k)/(1-k)||0;m=(1-g-k)/(1-k)||0;y=(1-b-k)/(1-k)||0;return[c*100,m*100,y*100,k*100]};function comparativeDistance(x,y){return Math.pow(x[0]-y[0],2)+Math.pow(x[1]-y[1],2)+Math.pow(x[2]-y[2],2)}convert.rgb.keyword=function(rgb){var reversed=reverseKeywords[rgb];if(reversed){return reversed}var currentClosestDistance=Infinity;var currentClosestKeyword;for(var keyword in cssKeywords){if(cssKeywords.hasOwnProperty(keyword)){var value=cssKeywords[keyword];var distance=comparativeDistance(rgb,value);if(distance<currentClosestDistance){currentClosestDistance=distance;currentClosestKeyword=keyword}}}return currentClosestKeyword};convert.keyword.rgb=function(keyword){return cssKeywords[keyword]};convert.rgb.xyz=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;r=r>.04045?Math.pow((r+.055)/1.055,2.4):r/12.92;g=g>.04045?Math.pow((g+.055)/1.055,2.4):g/12.92;b=b>.04045?Math.pow((b+.055)/1.055,2.4):b/12.92;var x=r*.4124+g*.3576+b*.1805;var y=r*.2126+g*.7152+b*.0722;var z=r*.0193+g*.1192+b*.9505;return[x*100,y*100,z*100]};convert.rgb.lab=function(rgb){var xyz=convert.rgb.xyz(rgb);var x=xyz[0];var y=xyz[1];var z=xyz[2];var l;var a;var b;x/=95.047;y/=100;z/=108.883;x=x>.008856?Math.pow(x,1/3):7.787*x+16/116;y=y>.008856?Math.pow(y,1/3):7.787*y+16/116;z=z>.008856?Math.pow(z,1/3):7.787*z+16/116;l=116*y-16;a=500*(x-y);b=200*(y-z);return[l,a,b]};convert.hsl.rgb=function(hsl){var h=hsl[0]/360;var s=hsl[1]/100;var l=hsl[2]/100;var t1;var t2;var t3;var rgb;var val;if(s===0){val=l*255;return[val,val,val]}if(l<.5){t2=l*(1+s)}else{t2=l+s-l*s}t1=2*l-t2;rgb=[0,0,0];for(var i=0;i<3;i++){t3=h+1/3*-(i-1);if(t3<0){t3++}if(t3>1){t3--}if(6*t3<1){val=t1+(t2-t1)*6*t3}else if(2*t3<1){val=t2}else if(3*t3<2){val=t1+(t2-t1)*(2/3-t3)*6}else{val=t1}rgb[i]=val*255}return rgb};convert.hsl.hsv=function(hsl){var h=hsl[0];var s=hsl[1]/100;var l=hsl[2]/100;var smin=s;var lmin=Math.max(l,.01);var sv;var v;l*=2;s*=l<=1?l:2-l;smin*=lmin<=1?lmin:2-lmin;v=(l+s)/2;sv=l===0?2*smin/(lmin+smin):2*s/(l+s);return[h,sv*100,v*100]};convert.hsv.rgb=function(hsv){var h=hsv[0]/60;var s=hsv[1]/100;var v=hsv[2]/100;var hi=Math.floor(h)%6;var f=h-Math.floor(h);var p=255*v*(1-s);var q=255*v*(1-s*f);var t=255*v*(1-s*(1-f));v*=255;switch(hi){case 0:return[v,t,p];case 1:return[q,v,p];case 2:return[p,v,t];case 3:return[p,q,v];case 4:return[t,p,v];case 5:return[v,p,q]}};convert.hsv.hsl=function(hsv){var h=hsv[0];var s=hsv[1]/100;var v=hsv[2]/100;var vmin=Math.max(v,.01);var lmin;var sl;var l;l=(2-s)*v;lmin=(2-s)*vmin;sl=s*vmin;sl/=lmin<=1?lmin:2-lmin;sl=sl||0;l/=2;return[h,sl*100,l*100]};convert.hwb.rgb=function(hwb){var h=hwb[0]/360;var wh=hwb[1]/100;var bl=hwb[2]/100;var ratio=wh+bl;var i;var v;var f;var n;if(ratio>1){wh/=ratio;bl/=ratio}i=Math.floor(6*h);v=1-bl;f=6*h-i;if((i&1)!==0){f=1-f}n=wh+f*(v-wh);var r;var g;var b;switch(i){default:case 6:case 0:r=v;g=n;b=wh;break;case 1:r=n;g=v;b=wh;break;case 2:r=wh;g=v;b=n;break;case 3:r=wh;g=n;b=v;break;case 4:r=n;g=wh;b=v;break;case 5:r=v;g=wh;b=n;break}return[r*255,g*255,b*255]};convert.cmyk.rgb=function(cmyk){var c=cmyk[0]/100;var m=cmyk[1]/100;var y=cmyk[2]/100;var k=cmyk[3]/100;var r;var g;var b;r=1-Math.min(1,c*(1-k)+k);g=1-Math.min(1,m*(1-k)+k);b=1-Math.min(1,y*(1-k)+k);return[r*255,g*255,b*255]};convert.xyz.rgb=function(xyz){var x=xyz[0]/100;var y=xyz[1]/100;var z=xyz[2]/100;var r;var g;var b;r=x*3.2406+y*-1.5372+z*-.4986;g=x*-.9689+y*1.8758+z*.0415;b=x*.0557+y*-.204+z*1.057;r=r>.0031308?1.055*Math.pow(r,1/2.4)-.055:r*12.92;g=g>.0031308?1.055*Math.pow(g,1/2.4)-.055:g*12.92;b=b>.0031308?1.055*Math.pow(b,1/2.4)-.055:b*12.92;r=Math.min(Math.max(0,r),1);g=Math.min(Math.max(0,g),1);b=Math.min(Math.max(0,b),1);return[r*255,g*255,b*255]};convert.xyz.lab=function(xyz){var x=xyz[0];var y=xyz[1];var z=xyz[2];var l;var a;var b;x/=95.047;y/=100;z/=108.883;x=x>.008856?Math.pow(x,1/3):7.787*x+16/116;y=y>.008856?Math.pow(y,1/3):7.787*y+16/116;z=z>.008856?Math.pow(z,1/3):7.787*z+16/116;l=116*y-16;a=500*(x-y);b=200*(y-z);return[l,a,b]};convert.lab.xyz=function(lab){var l=lab[0];var a=lab[1];var b=lab[2];var x;var y;var z;y=(l+16)/116;x=a/500+y;z=y-b/200;var y2=Math.pow(y,3);var x2=Math.pow(x,3);var z2=Math.pow(z,3);y=y2>.008856?y2:(y-16/116)/7.787;x=x2>.008856?x2:(x-16/116)/7.787;z=z2>.008856?z2:(z-16/116)/7.787;x*=95.047;y*=100;z*=108.883;return[x,y,z]};convert.lab.lch=function(lab){var l=lab[0];var a=lab[1];var b=lab[2];var hr;var h;var c;hr=Math.atan2(b,a);h=hr*360/2/Math.PI;if(h<0){h+=360}c=Math.sqrt(a*a+b*b);return[l,c,h]};convert.lch.lab=function(lch){var l=lch[0];var c=lch[1];var h=lch[2];var a;var b;var hr;hr=h/360*2*Math.PI;a=c*Math.cos(hr);b=c*Math.sin(hr);return[l,a,b]};convert.rgb.ansi16=function(args){var r=args[0];var g=args[1];var b=args[2];var value=1 in arguments?arguments[1]:convert.rgb.hsv(args)[2];value=Math.round(value/50);if(value===0){return 30}var ansi=30+(Math.round(b/255)<<2|Math.round(g/255)<<1|Math.round(r/255));if(value===2){ansi+=60}return ansi};convert.hsv.ansi16=function(args){return convert.rgb.ansi16(convert.hsv.rgb(args),args[2])};convert.rgb.ansi256=function(args){var r=args[0];var g=args[1];var b=args[2];if(r===g&&g===b){if(r<8){return 16}if(r>248){return 231}return Math.round((r-8)/247*24)+232}var ansi=16+36*Math.round(r/255*5)+6*Math.round(g/255*5)+Math.round(b/255*5);return ansi};convert.ansi16.rgb=function(args){var color=args%10;if(color===0||color===7){if(args>50){color+=3.5}color=color/10.5*255;return[color,color,color]}var mult=(~~(args>50)+1)*.5;var r=(color&1)*mult*255;var g=(color>>1&1)*mult*255;var b=(color>>2&1)*mult*255;return[r,g,b]};convert.ansi256.rgb=function(args){if(args>=232){var c=(args-232)*10+8;return[c,c,c]}args-=16;var rem;var r=Math.floor(args/36)/5*255;var g=Math.floor((rem=args%36)/6)/5*255;var b=rem%6/5*255;return[r,g,b]};convert.rgb.hex=function(args){var integer=((Math.round(args[0])&255)<<16)+((Math.round(args[1])&255)<<8)+(Math.round(args[2])&255);var string=integer.toString(16).toUpperCase();return"000000".substring(string.length)+string};convert.hex.rgb=function(args){var match=args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);if(!match){return[0,0,0]}var colorString=match[0];if(match[0].length===3){colorString=colorString.split("").map(function(char){return char+char}).join("")}var integer=parseInt(colorString,16);var r=integer>>16&255;var g=integer>>8&255;var b=integer&255;return[r,g,b]};convert.rgb.hcg=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var max=Math.max(Math.max(r,g),b);var min=Math.min(Math.min(r,g),b);var chroma=max-min;var grayscale;var hue;if(chroma<1){grayscale=min/(1-chroma)}else{grayscale=0}if(chroma<=0){hue=0}else if(max===r){hue=(g-b)/chroma%6}else if(max===g){hue=2+(b-r)/chroma}else{hue=4+(r-g)/chroma+4}hue/=6;hue%=1;return[hue*360,chroma*100,grayscale*100]};convert.hsl.hcg=function(hsl){var s=hsl[1]/100;var l=hsl[2]/100;var c=1;var f=0;if(l<.5){c=2*s*l}else{c=2*s*(1-l)}if(c<1){f=(l-.5*c)/(1-c)}return[hsl[0],c*100,f*100]};convert.hsv.hcg=function(hsv){var s=hsv[1]/100;var v=hsv[2]/100;var c=s*v;var f=0;if(c<1){f=(v-c)/(1-c)}return[hsv[0],c*100,f*100]};convert.hcg.rgb=function(hcg){var h=hcg[0]/360;var c=hcg[1]/100;var g=hcg[2]/100;if(c===0){return[g*255,g*255,g*255]}var pure=[0,0,0];var hi=h%1*6;var v=hi%1;var w=1-v;var mg=0;switch(Math.floor(hi)){case 0:pure[0]=1;pure[1]=v;pure[2]=0;break;case 1:pure[0]=w;pure[1]=1;pure[2]=0;break;case 2:pure[0]=0;pure[1]=1;pure[2]=v;break;case 3:pure[0]=0;pure[1]=w;pure[2]=1;break;case 4:pure[0]=v;pure[1]=0;pure[2]=1;break;default:pure[0]=1;pure[1]=0;pure[2]=w}mg=(1-c)*g;return[(c*pure[0]+mg)*255,(c*pure[1]+mg)*255,(c*pure[2]+mg)*255]};convert.hcg.hsv=function(hcg){var c=hcg[1]/100;var g=hcg[2]/100;var v=c+g*(1-c);var f=0;if(v>0){f=c/v}return[hcg[0],f*100,v*100]};convert.hcg.hsl=function(hcg){var c=hcg[1]/100;var g=hcg[2]/100;var l=g*(1-c)+.5*c;var s=0;if(l>0&&l<.5){s=c/(2*l)}else if(l>=.5&&l<1){s=c/(2*(1-l))}return[hcg[0],s*100,l*100]};convert.hcg.hwb=function(hcg){var c=hcg[1]/100;var g=hcg[2]/100;var v=c+g*(1-c);return[hcg[0],(v-c)*100,(1-v)*100]};convert.hwb.hcg=function(hwb){var w=hwb[1]/100;var b=hwb[2]/100;var v=1-b;var c=v-w;var g=0;if(c<1){g=(v-c)/(1-c)}return[hwb[0],c*100,g*100]};convert.apple.rgb=function(apple){return[apple[0]/65535*255,apple[1]/65535*255,apple[2]/65535*255]};convert.rgb.apple=function(rgb){return[rgb[0]/255*65535,rgb[1]/255*65535,rgb[2]/255*65535]};convert.gray.rgb=function(args){return[args[0]/100*255,args[0]/100*255,args[0]/100*255]};convert.gray.hsl=convert.gray.hsv=function(args){return[0,0,args[0]]};convert.gray.hwb=function(gray){return[0,100,gray[0]]};convert.gray.cmyk=function(gray){return[0,0,0,gray[0]]};convert.gray.lab=function(gray){return[gray[0],0,0]};convert.gray.hex=function(gray){var val=Math.round(gray[0]/100*255)&255;var integer=(val<<16)+(val<<8)+val;var string=integer.toString(16).toUpperCase();return"000000".substring(string.length)+string};convert.rgb.gray=function(rgb){var val=(rgb[0]+rgb[1]+rgb[2])/3;return[val/255*100]}},767:function(module,__unused_webpack_exports,__webpack_require__){var conversions=__webpack_require__(945);var route=__webpack_require__(13);var convert={};var models=Object.keys(conversions);function wrapRaw(fn){var wrappedFn=function(args){if(args===undefined||args===null){return args}if(arguments.length>1){args=Array.prototype.slice.call(arguments)}return fn(args)};if("conversion"in fn){wrappedFn.conversion=fn.conversion}return wrappedFn}function wrapRounded(fn){var wrappedFn=function(args){if(args===undefined||args===null){return args}if(arguments.length>1){args=Array.prototype.slice.call(arguments)}var result=fn(args);if(typeof result==="object"){for(var len=result.length,i=0;i<len;i++){result[i]=Math.round(result[i])}}return result};if("conversion"in fn){wrappedFn.conversion=fn.conversion}return wrappedFn}models.forEach(function(fromModel){convert[fromModel]={};Object.defineProperty(convert[fromModel],"channels",{value:conversions[fromModel].channels});Object.defineProperty(convert[fromModel],"labels",{value:conversions[fromModel].labels});var routes=route(fromModel);var routeModels=Object.keys(routes);routeModels.forEach(function(toModel){var fn=routes[toModel];convert[fromModel][toModel]=wrapRounded(fn);convert[fromModel][toModel].raw=wrapRaw(fn)})});module.exports=convert},973:function(module){"use strict";module.exports={"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aqua":[0,255,255],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"black":[0,0,0],"blanchedalmond":[255,235,205],"blue":[0,0,255],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"fuchsia":[255,0,255],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"gray":[128,128,128],"green":[0,128,0],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"lime":[0,255,0],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"maroon":[128,0,0],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"navy":[0,0,128],"oldlace":[253,245,230],"olive":[128,128,0],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"purple":[128,0,128],"rebeccapurple":[102,51,153],"red":[255,0,0],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"silver":[192,192,192],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"teal":[0,128,128],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"white":[255,255,255],"whitesmoke":[245,245,245],"yellow":[255,255,0],"yellowgreen":[154,205,50]}},13:function(module,__unused_webpack_exports,__webpack_require__){var conversions=__webpack_require__(945);function buildGraph(){var graph={};var models=Object.keys(conversions);for(var len=models.length,i=0;i<len;i++){graph[models[i]]={distance:-1,parent:null}}return graph}function deriveBFS(fromModel){var graph=buildGraph();var queue=[fromModel];graph[fromModel].distance=0;while(queue.length){var current=queue.pop();var adjacents=Object.keys(conversions[current]);for(var len=adjacents.length,i=0;i<len;i++){var adjacent=adjacents[i];var node=graph[adjacent];if(node.distance===-1){node.distance=graph[current].distance+1;node.parent=current;queue.unshift(adjacent)}}}return graph}function link(from,to){return function(args){return to(from(args))}}function wrapConversion(toModel,graph){var path=[graph[toModel].parent,toModel];var fn=conversions[graph[toModel].parent][toModel];var cur=graph[toModel].parent;while(graph[cur].parent){path.unshift(graph[cur].parent);fn=link(conversions[graph[cur].parent][cur],fn);cur=graph[cur].parent}fn.conversion=path;return fn}module.exports=function(fromModel){var graph=deriveBFS(fromModel);var conversion={};var models=Object.keys(graph);for(var len=models.length,i=0;i<len;i++){var toModel=models[i];var node=graph[toModel];if(node.parent===null){continue}conversion[toModel]=wrapConversion(toModel,graph)}return conversion}},518:function(module){"use strict";module.exports={"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aqua":[0,255,255],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"black":[0,0,0],"blanchedalmond":[255,235,205],"blue":[0,0,255],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"fuchsia":[255,0,255],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"gray":[128,128,128],"green":[0,128,0],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"lime":[0,255,0],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"maroon":[128,0,0],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"navy":[0,0,128],"oldlace":[253,245,230],"olive":[128,128,0],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"purple":[128,0,128],"rebeccapurple":[102,51,153],"red":[255,0,0],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"silver":[192,192,192],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"teal":[0,128,128],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"white":[255,255,255],"whitesmoke":[245,245,245],"yellow":[255,255,0],"yellowgreen":[154,205,50]}},148:function(module,__unused_webpack_exports,__webpack_require__){var colorNames=__webpack_require__(518);var swizzle=__webpack_require__(618);var hasOwnProperty=Object.hasOwnProperty;var reverseNames={};for(var name in colorNames){if(hasOwnProperty.call(colorNames,name)){reverseNames[colorNames[name]]=name}}var cs=module.exports={to:{},get:{}};cs.get=function(string){var prefix=string.substring(0,3).toLowerCase();var val;var model;switch(prefix){case"hsl":val=cs.get.hsl(string);model="hsl";break;case"hwb":val=cs.get.hwb(string);model="hwb";break;default:val=cs.get.rgb(string);model="rgb";break}if(!val){return null}return{model:model,value:val}};cs.get.rgb=function(string){if(!string){return null}var abbr=/^#([a-f0-9]{3,4})$/i;var hex=/^#([a-f0-9]{6})([a-f0-9]{2})?$/i;var rgba=/^rgba?\(\s*([+-]?\d+)(?=[\s,])\s*(?:,\s*)?([+-]?\d+)(?=[\s,])\s*(?:,\s*)?([+-]?\d+)\s*(?:[,|\/]\s*([+-]?[\d\.]+)(%?)\s*)?\)$/;var per=/^rgba?\(\s*([+-]?[\d\.]+)\%\s*,?\s*([+-]?[\d\.]+)\%\s*,?\s*([+-]?[\d\.]+)\%\s*(?:[,|\/]\s*([+-]?[\d\.]+)(%?)\s*)?\)$/;var keyword=/^(\w+)$/;var rgb=[0,0,0,1];var match;var i;var hexAlpha;if(match=string.match(hex)){hexAlpha=match[2];match=match[1];for(i=0;i<3;i++){var i2=i*2;rgb[i]=parseInt(match.slice(i2,i2+2),16)}if(hexAlpha){rgb[3]=parseInt(hexAlpha,16)/255}}else if(match=string.match(abbr)){match=match[1];hexAlpha=match[3];for(i=0;i<3;i++){rgb[i]=parseInt(match[i]+match[i],16)}if(hexAlpha){rgb[3]=parseInt(hexAlpha+hexAlpha,16)/255}}else if(match=string.match(rgba)){for(i=0;i<3;i++){rgb[i]=parseInt(match[i+1],0)}if(match[4]){if(match[5]){rgb[3]=parseFloat(match[4])*.01}else{rgb[3]=parseFloat(match[4])}}}else if(match=string.match(per)){for(i=0;i<3;i++){rgb[i]=Math.round(parseFloat(match[i+1])*2.55)}if(match[4]){if(match[5]){rgb[3]=parseFloat(match[4])*.01}else{rgb[3]=parseFloat(match[4])}}}else if(match=string.match(keyword)){if(match[1]==="transparent"){return[0,0,0,0]}if(!hasOwnProperty.call(colorNames,match[1])){return null}rgb=colorNames[match[1]];rgb[3]=1;return rgb}else{return null}for(i=0;i<3;i++){rgb[i]=clamp(rgb[i],0,255)}rgb[3]=clamp(rgb[3],0,1);return rgb};cs.get.hsl=function(string){if(!string){return null}var hsl=/^hsla?\(\s*([+-]?(?:\d{0,3}\.)?\d+)(?:deg)?\s*,?\s*([+-]?[\d\.]+)%\s*,?\s*([+-]?[\d\.]+)%\s*(?:[,|\/]\s*([+-]?(?=\.\d|\d)(?:0|[1-9]\d*)?(?:\.\d*)?(?:[eE][+-]?\d+)?)\s*)?\)$/;var match=string.match(hsl);if(match){var alpha=parseFloat(match[4]);var h=(parseFloat(match[1])%360+360)%360;var s=clamp(parseFloat(match[2]),0,100);var l=clamp(parseFloat(match[3]),0,100);var a=clamp(isNaN(alpha)?1:alpha,0,1);return[h,s,l,a]}return null};cs.get.hwb=function(string){if(!string){return null}var hwb=/^hwb\(\s*([+-]?\d{0,3}(?:\.\d+)?)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?(?=\.\d|\d)(?:0|[1-9]\d*)?(?:\.\d*)?(?:[eE][+-]?\d+)?)\s*)?\)$/;var match=string.match(hwb);if(match){var alpha=parseFloat(match[4]);var h=(parseFloat(match[1])%360+360)%360;var w=clamp(parseFloat(match[2]),0,100);var b=clamp(parseFloat(match[3]),0,100);var a=clamp(isNaN(alpha)?1:alpha,0,1);return[h,w,b,a]}return null};cs.to.hex=function(){var rgba=swizzle(arguments);return"#"+hexDouble(rgba[0])+hexDouble(rgba[1])+hexDouble(rgba[2])+(rgba[3]<1?hexDouble(Math.round(rgba[3]*255)):"")};cs.to.rgb=function(){var rgba=swizzle(arguments);return rgba.length<4||rgba[3]===1?"rgb("+Math.round(rgba[0])+", "+Math.round(rgba[1])+", "+Math.round(rgba[2])+")":"rgba("+Math.round(rgba[0])+", "+Math.round(rgba[1])+", "+Math.round(rgba[2])+", "+rgba[3]+")"};cs.to.rgb.percent=function(){var rgba=swizzle(arguments);var r=Math.round(rgba[0]/255*100);var g=Math.round(rgba[1]/255*100);var b=Math.round(rgba[2]/255*100);return rgba.length<4||rgba[3]===1?"rgb("+r+"%, "+g+"%, "+b+"%)":"rgba("+r+"%, "+g+"%, "+b+"%, "+rgba[3]+")"};cs.to.hsl=function(){var hsla=swizzle(arguments);return hsla.length<4||hsla[3]===1?"hsl("+hsla[0]+", "+hsla[1]+"%, "+hsla[2]+"%)":"hsla("+hsla[0]+", "+hsla[1]+"%, "+hsla[2]+"%, "+hsla[3]+")"};cs.to.hwb=function(){var hwba=swizzle(arguments);var a="";if(hwba.length>=4&&hwba[3]!==1){a=", "+hwba[3]}return"hwb("+hwba[0]+", "+hwba[1]+"%, "+hwba[2]+"%"+a+")"};cs.to.keyword=function(rgb){return reverseNames[rgb.slice(0,3)]};function clamp(num,min,max){return Math.min(Math.max(min,num),max)}function hexDouble(num){var str=Math.round(num).toString(16).toUpperCase();return str.length<2?"0"+str:str}},762:function(module,__unused_webpack_exports,__webpack_require__){"use strict";var colorString=__webpack_require__(148);var convert=__webpack_require__(767);var _slice=[].slice;var skippedModels=["keyword","gray","hex"];var hashedModelKeys={};Object.keys(convert).forEach(function(model){hashedModelKeys[_slice.call(convert[model].labels).sort().join("")]=model});var limiters={};function Color(obj,model){if(!(this instanceof Color)){return new Color(obj,model)}if(model&&model in skippedModels){model=null}if(model&&!(model in convert)){throw new Error("Unknown model: "+model)}var i;var channels;if(!obj){this.model="rgb";this.color=[0,0,0];this.valpha=1}else if(obj instanceof Color){this.model=obj.model;this.color=obj.color.slice();this.valpha=obj.valpha}else if(typeof obj==="string"){var result=colorString.get(obj);if(result===null){throw new Error("Unable to parse color from string: "+obj)}this.model=result.model;channels=convert[this.model].channels;this.color=result.value.slice(0,channels);this.valpha=typeof result.value[channels]==="number"?result.value[channels]:1}else if(obj.length){this.model=model||"rgb";channels=convert[this.model].channels;var newArr=_slice.call(obj,0,channels);this.color=zeroArray(newArr,channels);this.valpha=typeof obj[channels]==="number"?obj[channels]:1}else if(typeof obj==="number"){obj&=0xffffff;this.model="rgb";this.color=[obj>>16&255,obj>>8&255,obj&255];this.valpha=1}else{this.valpha=1;var keys=Object.keys(obj);if("alpha"in obj){keys.splice(keys.indexOf("alpha"),1);this.valpha=typeof obj.alpha==="number"?obj.alpha:0}var hashedKeys=keys.sort().join("");if(!(hashedKeys in hashedModelKeys)){throw new Error("Unable to parse color from object: "+JSON.stringify(obj))}this.model=hashedModelKeys[hashedKeys];var labels=convert[this.model].labels;var color=[];for(i=0;i<labels.length;i++){color.push(obj[labels[i]])}this.color=zeroArray(color)}if(limiters[this.model]){channels=convert[this.model].channels;for(i=0;i<channels;i++){var limit=limiters[this.model][i];if(limit){this.color[i]=limit(this.color[i])}}}this.valpha=Math.max(0,Math.min(1,this.valpha));if(Object.freeze){Object.freeze(this)}}Color.prototype={toString:function(){return this.string()},toJSON:function(){return this[this.model]()},string:function(places){var self=this.model in colorString.to?this:this.rgb();self=self.round(typeof places==="number"?places:1);var args=self.valpha===1?self.color:self.color.concat(this.valpha);return colorString.to[self.model](args)},percentString:function(places){var self=this.rgb().round(typeof places==="number"?places:1);var args=self.valpha===1?self.color:self.color.concat(this.valpha);return colorString.to.rgb.percent(args)},array:function(){return this.valpha===1?this.color.slice():this.color.concat(this.valpha)},object:function(){var result={};var channels=convert[this.model].channels;var labels=convert[this.model].labels;for(var i=0;i<channels;i++){result[labels[i]]=this.color[i]}if(this.valpha!==1){result.alpha=this.valpha}return result},unitArray:function(){var rgb=this.rgb().color;rgb[0]/=255;rgb[1]/=255;rgb[2]/=255;if(this.valpha!==1){rgb.push(this.valpha)}return rgb},unitObject:function(){var rgb=this.rgb().object();rgb.r/=255;rgb.g/=255;rgb.b/=255;if(this.valpha!==1){rgb.alpha=this.valpha}return rgb},round:function(places){places=Math.max(places||0,0);return new Color(this.color.map(roundToPlace(places)).concat(this.valpha),this.model)},alpha:function(val){if(arguments.length){return new Color(this.color.concat(Math.max(0,Math.min(1,val))),this.model)}return this.valpha},red:getset("rgb",0,maxfn(255)),green:getset("rgb",1,maxfn(255)),blue:getset("rgb",2,maxfn(255)),hue:getset(["hsl","hsv","hsl","hwb","hcg"],0,function(val){return(val%360+360)%360}),saturationl:getset("hsl",1,maxfn(100)),lightness:getset("hsl",2,maxfn(100)),saturationv:getset("hsv",1,maxfn(100)),value:getset("hsv",2,maxfn(100)),chroma:getset("hcg",1,maxfn(100)),gray:getset("hcg",2,maxfn(100)),white:getset("hwb",1,maxfn(100)),wblack:getset("hwb",2,maxfn(100)),cyan:getset("cmyk",0,maxfn(100)),magenta:getset("cmyk",1,maxfn(100)),yellow:getset("cmyk",2,maxfn(100)),black:getset("cmyk",3,maxfn(100)),x:getset("xyz",0,maxfn(100)),y:getset("xyz",1,maxfn(100)),z:getset("xyz",2,maxfn(100)),l:getset("lab",0,maxfn(100)),a:getset("lab",1),b:getset("lab",2),keyword:function(val){if(arguments.length){return new Color(val)}return convert[this.model].keyword(this.color)},hex:function(val){if(arguments.length){return new Color(val)}return colorString.to.hex(this.rgb().round().color)},rgbNumber:function(){var rgb=this.rgb().color;return(rgb[0]&255)<<16|(rgb[1]&255)<<8|rgb[2]&255},luminosity:function(){var rgb=this.rgb().color;var lum=[];for(var i=0;i<rgb.length;i++){var chan=rgb[i]/255;lum[i]=chan<=.03928?chan/12.92:Math.pow((chan+.055)/1.055,2.4)}return .2126*lum[0]+.7152*lum[1]+.0722*lum[2]},contrast:function(color2){var lum1=this.luminosity();var lum2=color2.luminosity();if(lum1>lum2){return(lum1+.05)/(lum2+.05)}return(lum2+.05)/(lum1+.05)},level:function(color2){var contrastRatio=this.contrast(color2);if(contrastRatio>=7.1){return"AAA"}return contrastRatio>=4.5?"AA":""},dark:function(){var rgb=this.rgb().color;var yiq=(rgb[0]*299+rgb[1]*587+rgb[2]*114)/1e3;return yiq<128},light:function(){return!this.dark()},negate:function(){var rgb=this.rgb();for(var i=0;i<3;i++){rgb.color[i]=255-rgb.color[i]}return rgb},lighten:function(ratio){var hsl=this.hsl();hsl.color[2]+=hsl.color[2]*ratio;return hsl},darken:function(ratio){var hsl=this.hsl();hsl.color[2]-=hsl.color[2]*ratio;return hsl},saturate:function(ratio){var hsl=this.hsl();hsl.color[1]+=hsl.color[1]*ratio;return hsl},desaturate:function(ratio){var hsl=this.hsl();hsl.color[1]-=hsl.color[1]*ratio;return hsl},whiten:function(ratio){var hwb=this.hwb();hwb.color[1]+=hwb.color[1]*ratio;return hwb},blacken:function(ratio){var hwb=this.hwb();hwb.color[2]+=hwb.color[2]*ratio;return hwb},grayscale:function(){var rgb=this.rgb().color;var val=rgb[0]*.3+rgb[1]*.59+rgb[2]*.11;return Color.rgb(val,val,val)},fade:function(ratio){return this.alpha(this.valpha-this.valpha*ratio)},opaquer:function(ratio){return this.alpha(this.valpha+this.valpha*ratio)},rotate:function(degrees){var hsl=this.hsl();var hue=hsl.color[0];hue=(hue+degrees)%360;hue=hue<0?360+hue:hue;hsl.color[0]=hue;return hsl},mix:function(mixinColor,weight){var color1=this.rgb();var color2=mixinColor.rgb();var p=weight===undefined?.5:weight;var w=2*p-1;var a=color1.alpha()-color2.alpha();var w1=((w*a===-1?w:(w+a)/(1+w*a))+1)/2;var w2=1-w1;return Color.rgb(w1*color1.red()+w2*color2.red(),w1*color1.green()+w2*color2.green(),w1*color1.blue()+w2*color2.blue(),color1.alpha()*p+color2.alpha()*(1-p))}};Object.keys(convert).forEach(function(model){if(skippedModels.indexOf(model)!==-1){return}var channels=convert[model].channels;Color.prototype[model]=function(){if(this.model===model){return new Color(this)}if(arguments.length){return new Color(arguments,model)}var newAlpha=typeof arguments[channels]==="number"?channels:this.valpha;return new Color(assertArray(convert[this.model][model].raw(this.color)).concat(newAlpha),model)};Color[model]=function(color){if(typeof color==="number"){color=zeroArray(_slice.call(arguments),channels)}return new Color(color,model)}});function roundTo(num,places){return Number(num.toFixed(places))}function roundToPlace(places){return function(num){return roundTo(num,places)}}function getset(model,channel,modifier){model=Array.isArray(model)?model:[model];model.forEach(function(m){(limiters[m]||(limiters[m]=[]))[channel]=modifier});model=model[0];return function(val){var result;if(arguments.length){if(modifier){val=modifier(val)}result=this[model]();result.color[channel]=val;return result}result=this[model]().color[channel];if(modifier){result=modifier(result)}return result}}function maxfn(max){return function(v){return Math.max(0,Math.min(max,v))}}function assertArray(val){return Array.isArray(val)?val:[val]}function zeroArray(arr,length){for(var i=0;i<length;i++){if(typeof arr[i]!=="number"){arr[i]=0}}return arr}module.exports=Color},94:function(__unused_webpack_module,exports,__webpack_require__){"use strict";var f=__webpack_require__(933),g=60103;exports.Fragment=60107;if("function"===typeof Symbol&&Symbol.for){var h=Symbol.for;g=h("react.element");exports.Fragment=h("react.fragment")}var m=f.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner,n=Object.prototype.hasOwnProperty,p={key:!0,ref:!0,__self:!0,__source:!0};function q(c,a,k){var b,d={},e=null,l=null;void 0!==k&&(e=""+k);void 0!==a.key&&(e=""+a.key);void 0!==a.ref&&(l=a.ref);for(b in a)n.call(a,b)&&!p.hasOwnProperty(b)&&(d[b]=a[b]);if(c&&c.defaultProps)for(b in a=c.defaultProps,a)void 0===d[b]&&(d[b]=a[b]);return{$$typeof:g,type:c,key:e,ref:l,props:d,_owner:m.current}}exports.jsx=q;exports.jsxs=q},870:function(module,__unused_webpack_exports,__webpack_require__){"use strict";if(true){module.exports=__webpack_require__(94)}else{}},618:function(module,__unused_webpack_exports,__webpack_require__){"use strict";var isArrayish=__webpack_require__(346);var concat=Array.prototype.concat;var slice=Array.prototype.slice;var swizzle=module.exports=function swizzle(args){var results=[];for(var i=0,len=args.length;i<len;i++){var arg=args[i];if(isArrayish(arg)){results=concat.call(results,slice.call(arg))}else{results.push(arg)}}return results};swizzle.wrap=function(fn){return function(){return fn(swizzle(arguments))}}},346:function(module){module.exports=function isArrayish(obj){if(!obj||typeof obj==="string"){return false}return obj instanceof Array||Array.isArray(obj)||obj.length>=0&&(obj.splice instanceof Function||Object.getOwnPropertyDescriptor(obj,obj.length-1)&&obj.constructor.name!=="String")}},786:function(__unused_webpack_module,__unused_webpack_exports,__webpack_require__){__webpack_require__.p=window.__osdPublicPath__["charts"];__webpack_require__.nc=window.__webpack_nonce__||""},719:function(__unused_webpack_module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,{SetColorRangeValue:()=>color_ranges_namespaceObject.SetColorRangeValue,RequiredNumberInputOption:()=>RequiredNumberInputOption,Style:()=>types_namespaceObject.Style,SwitchOption:()=>SwitchOption,colorSchemas:()=>color_maps_colorSchemas,getHeatmapColors:()=>getHeatmapColors,RangeOption:()=>RangeOption,vislibColorMaps:()=>vislibColorMaps,NumberInputOption:()=>NumberInputOption,BasicOptions:()=>BasicOptions,ColorSchemaOptions:()=>ColorSchemaOptions,ColorRanges:()=>ColorRanges,plugin:()=>public_plugin,RawColorSchema:()=>color_maps_namespaceObject.RawColorSchema,SetColorSchemaOptionsValue:()=>color_schema_namespaceObject.SetColorSchemaOptionsValue,truncatedColorSchemas:()=>truncatedColorSchemas,Rotates:()=>Rotates,TextInputOption:()=>TextInputOption,ColorModes:()=>ColorModes,truncatedColorMaps:()=>truncatedColorMaps,ColorSchemas:()=>color_maps_ColorSchemas,ColorMap:()=>color_maps_namespaceObject.ColorMap,ColorSchema:()=>color_maps_namespaceObject.ColorSchema,ColorSchemaParams:()=>types_namespaceObject.ColorSchemaParams,Labels:()=>types_namespaceObject.Labels,SelectOption:()=>SelectOption});var color_maps_namespaceObject={};__webpack_require__.r(color_maps_namespaceObject);__webpack_require__.d(color_maps_namespaceObject,{cf:()=>color_maps_ColorSchemas,yK:()=>color_maps_colorSchemas,Oc:()=>vislibColorMaps});var color_ranges_namespaceObject={};__webpack_require__.r(color_ranges_namespaceObject);__webpack_require__.d(color_ranges_namespaceObject,{o:()=>ColorRanges});var color_schema_namespaceObject={};__webpack_require__.r(color_schema_namespaceObject);__webpack_require__.d(color_schema_namespaceObject,{$:()=>ColorSchemaOptions});var types_namespaceObject={};__webpack_require__.r(types_namespaceObject);function _class_call_check(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")};function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}function _create_class(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);return Constructor};function _define_property(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else obj[key]=value;return obj};function _type_of(obj){"@swc/helpers - typeof";return obj&&typeof Symbol!=="undefined"&&obj.constructor===Symbol?"symbol":typeof obj};const external_osdSharedDeps_Lodash_namespaceObject=__osdSharedDeps__.Lodash;var external_osdSharedDeps_Lodash_default=__webpack_require__.n(external_osdSharedDeps_Lodash_namespaceObject);const external_osdSharedDeps_ElasticEui_namespaceObject=__osdSharedDeps__.ElasticEui;var node_modules_color=__webpack_require__(762);var color_default=__webpack_require__.n(node_modules_color);var COLOR_MAPPING_SETTING="visualization:colorMapping";var standardizeColor=function(color){return new(color_default())(color).hex().toLowerCase()};var mapped_colors_MappedColors=function(){"use strict";function MappedColors(uiSettings){_class_call_check(this,MappedColors);_define_property(this,"uiSettings",void 0);_define_property(this,"_oldMap",void 0);_define_property(this,"_mapping",void 0);this.uiSettings=uiSettings;this._oldMap={};this._mapping={}}_create_class(MappedColors,[{key:"getConfigColorMapping",value:function getConfigColorMapping(){return external_osdSharedDeps_Lodash_default().mapValues(this.uiSettings.get(COLOR_MAPPING_SETTING),standardizeColor)}},{key:"oldMap",get:function get(){return this._oldMap}},{key:"mapping",get:function get(){return this._mapping}},{key:"get",value:function get(key){return this.getConfigColorMapping()[key]||this._mapping[key]}},{key:"flush",value:function flush(){this._oldMap=external_osdSharedDeps_Lodash_default().clone(this._mapping);this._mapping={}}},{key:"purge",value:function purge(){this._oldMap={};this._mapping={}}},{key:"mapKeys",value:function mapKeys(keys){var _this=this;var configMapping=this.getConfigColorMapping();var configColors=external_osdSharedDeps_Lodash_default().values(configMapping);var oldColors=external_osdSharedDeps_Lodash_default().values(this._oldMap);var alreadyUsedColors=[];var keysToMap=[];external_osdSharedDeps_Lodash_default().each(keys,function(key){if(configMapping[key]){delete _this._mapping[key];alreadyUsedColors.push(configMapping[key])}if(external_osdSharedDeps_Lodash_default().includes(configColors,_this._mapping[key]))keysToMap.push(key);if(_this._oldMap[key]){_this._mapping[key]=_this._oldMap[key];alreadyUsedColors.push(_this._mapping[key])}if(_this.get(key)==null)keysToMap.push(key)});var rotations=Math.ceil(keys.length/10);var colorPalette=(0,external_osdSharedDeps_ElasticEui_namespaceObject.euiPaletteColorBlind)({rotations:rotations,direction:rotations===2?"lighter":"both",order:rotations>2?"middle-out":"append"}).filter(function(color){return!alreadyUsedColors.includes(color.toLowerCase())}).slice(0,keysToMap.length);external_osdSharedDeps_Lodash_default().merge(this._mapping,external_osdSharedDeps_Lodash_default().zipObject(keysToMap,colorPalette))}}]);return MappedColors}();var colors_ColorsService=function(){"use strict";function ColorsService(){_class_call_check(this,ColorsService);_define_property(this,"_mappedColors",void 0);_define_property(this,"seedColors",(0,external_osdSharedDeps_ElasticEui_namespaceObject.euiPaletteColorBlind)())}_create_class(ColorsService,[{key:"mappedColors",get:function get(){if(!this._mappedColors){throw new Error("ColorService not yet initialized")}return this._mappedColors}},{key:"init",value:function init(uiSettings){this._mappedColors=new mapped_colors_MappedColors(uiSettings)}},{key:"createColorLookupFunction",value:function createColorLookupFunction(arrayOfStringsOrNumbers){var _this=this;var colorMapping=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{};if(!Array.isArray(arrayOfStringsOrNumbers)){throw new Error("createColorLookupFunction expects an array but received: ".concat(typeof arrayOfStringsOrNumbers==="undefined"?"undefined":_type_of(arrayOfStringsOrNumbers)))}arrayOfStringsOrNumbers.forEach(function(val){if(!external_osdSharedDeps_Lodash_default().isString(val)&&!external_osdSharedDeps_Lodash_default().isNumber(val)&&!external_osdSharedDeps_Lodash_default().isUndefined(val)){throw new TypeError("createColorLookupFunction expects an array of strings, numbers, or undefined values")}});this.mappedColors.mapKeys(arrayOfStringsOrNumbers);return function(value){return colorMapping[value]||_this.mappedColors.get(value)}}}]);return ColorsService}();;function _array_with_holes(arr){if(Array.isArray(arr))return arr};function _iterable_to_array_limit(arr,i){var _i=arr==null?null:typeof Symbol!=="undefined"&&arr[Symbol.iterator]||arr["@@iterator"];if(_i==null)return;var _arr=[];var _n=true;var _d=false;var _s,_e;try{for(_i=_i.call(arr);!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"]!=null)_i["return"]()}finally{if(_d)throw _e}}return _arr};function _non_iterable_rest(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")};function _array_like_to_array(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2};function _unsupported_iterable_to_array(o,minLen){if(!o)return;if(typeof o==="string")return _array_like_to_array(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(n);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _array_like_to_array(o,minLen)};function _sliced_to_array(arr,i){return _array_with_holes(arr)||_iterable_to_array_limit(arr,i)||_unsupported_iterable_to_array(arr,i)||_non_iterable_rest()}var external_osdSharedDeps_React_=__webpack_require__(933);const external_osdSharedDeps_Rxjs_namespaceObject=__osdSharedDeps__.Rxjs;const external_osdSharedDeps_ElasticCharts_namespaceObject=__osdSharedDeps__.ElasticCharts;const external_osdSharedDeps_ElasticEuiChartsTheme_namespaceObject=__osdSharedDeps__.ElasticEuiChartsTheme;var theme_ThemeService=function(){"use strict";function ThemeService(){var _this=this;_class_call_check(this,ThemeService);_define_property(this,"chartsDefaultTheme",external_osdSharedDeps_ElasticEuiChartsTheme_namespaceObject.EUI_CHARTS_THEME_LIGHT.theme);_define_property(this,"chartsDefaultBaseTheme",external_osdSharedDeps_ElasticCharts_namespaceObject.LIGHT_THEME);_define_property(this,"_uiSettingsDarkMode$",void 0);_define_property(this,"_chartsTheme$",new external_osdSharedDeps_Rxjs_namespaceObject.BehaviorSubject(this.chartsDefaultTheme));_define_property(this,"_chartsBaseTheme$",new external_osdSharedDeps_Rxjs_namespaceObject.BehaviorSubject(this.chartsDefaultBaseTheme));_define_property(this,"chartsTheme$",this._chartsTheme$.asObservable());_define_property(this,"chartsBaseTheme$",this._chartsBaseTheme$.asObservable());_define_property(this,"useDarkMode",function(){var _useState=_sliced_to_array((0,external_osdSharedDeps_React_.useState)(false),2),value=_useState[0],update=_useState[1];(0,external_osdSharedDeps_React_.useEffect)(function(){var s=_this.darkModeEnabled$.subscribe(update);return function(){return s.unsubscribe()}},[]);return value});_define_property(this,"useChartsTheme",function(){var _useState=_sliced_to_array((0,external_osdSharedDeps_React_.useState)(_this.chartsDefaultTheme),2),value=_useState[0],update=_useState[1];(0,external_osdSharedDeps_React_.useEffect)(function(){var s=_this.chartsTheme$.subscribe(update);return function(){return s.unsubscribe()}},[]);return value});_define_property(this,"useChartsBaseTheme",function(){var _useState=_sliced_to_array((0,external_osdSharedDeps_React_.useState)(_this.chartsDefaultBaseTheme),2),value=_useState[0],update=_useState[1];(0,external_osdSharedDeps_React_.useEffect)(function(){var s=_this.chartsBaseTheme$.subscribe(update);return function(){return s.unsubscribe()}},[]);return value})}_create_class(ThemeService,[{key:"darkModeEnabled$",get:function get(){if(!this._uiSettingsDarkMode$){throw new Error("ThemeService not initialized")}return this._uiSettingsDarkMode$}},{key:"init",value:function init(uiSettings){var _this=this;this._uiSettingsDarkMode$=uiSettings.get$("theme:darkMode");this._uiSettingsDarkMode$.subscribe(function(darkMode){_this._chartsTheme$.next(darkMode?external_osdSharedDeps_ElasticEuiChartsTheme_namespaceObject.EUI_CHARTS_THEME_DARK.theme:external_osdSharedDeps_ElasticEuiChartsTheme_namespaceObject.EUI_CHARTS_THEME_LIGHT.theme);_this._chartsBaseTheme$.next(darkMode?external_osdSharedDeps_ElasticCharts_namespaceObject.DARK_THEME:external_osdSharedDeps_ElasticCharts_namespaceObject.LIGHT_THEME)})}}]);return ThemeService}();;;var plugin_ChartsPlugin=function(){"use strict";function ChartsPlugin(){_class_call_check(this,ChartsPlugin);_define_property(this,"themeService",new theme_ThemeService);_define_property(this,"colorsService",new colors_ColorsService)}_create_class(ChartsPlugin,[{key:"setup",value:function setup(param){var uiSettings=param.uiSettings;this.themeService.init(uiSettings);this.colorsService.init(uiSettings);return{colors:this.colorsService,theme:this.themeService}}},{key:"start",value:function start(){return{colors:this.colorsService,theme:this.themeService}}}]);return ChartsPlugin}();const external_osdSharedDeps_OsdI18n_namespaceObject=__osdSharedDeps__.OsdI18n;const external_osdSharedDeps_Theme_namespaceObject=__osdSharedDeps__.Theme;var color_maps_ColorSchemas=function(ColorSchemas){ColorSchemas["Blues"]="Blues";ColorSchemas["Greens"]="Greens";ColorSchemas["Greys"]="Greys";ColorSchemas["Reds"]="Reds";ColorSchemas["YellowToRed"]="Yellow to Red";ColorSchemas["GreenToRed"]="Green to Red";return ColorSchemas}({});var COLOR_MAP_LENGTH=512;function convertColorPaletteToColorMap(colorPalette){var colorMap=[];for(var i=0;i<colorPalette.length;i++){var color=colorPalette[i];var regex=/#([0-9a-zA-Z]{2})([0-9a-zA-Z]{2})([0-9a-zA-Z]{2})/;var _regex_exec=_sliced_to_array(regex.exec(color),4),rawRed=_regex_exec[1],rawGreen=_regex_exec[2],rawBlue=_regex_exec[3];var _ref=[parseInt(rawRed,16)/255,parseInt(rawGreen,16)/255,parseInt(rawBlue,16)/255],red=_ref[0],green=_ref[1],blue=_ref[2];colorMap[i]=[i/(colorPalette.length-1),[red,green,blue]]}return colorMap}var _obj;var vislibColorMaps=(_obj={},_define_property(_obj,"Blues",{id:"Blues",label:external_osdSharedDeps_OsdI18n_namespaceObject.i18n.translate("charts.colormaps.bluesText",{defaultMessage:"Blues"}),value:convertColorPaletteToColorMap((0,external_osdSharedDeps_ElasticEui_namespaceObject.ouiPaletteCool)(COLOR_MAP_LENGTH))}),_define_property(_obj,"Greens",{id:"Greens",label:external_osdSharedDeps_OsdI18n_namespaceObject.i18n.translate("charts.colormaps.greensText",{defaultMessage:"Greens"}),value:convertColorPaletteToColorMap((0,external_osdSharedDeps_ElasticEui_namespaceObject.ouiPalettePositive)(COLOR_MAP_LENGTH))}),_define_property(_obj,"Greys",{id:"Greys",label:external_osdSharedDeps_OsdI18n_namespaceObject.i18n.translate("charts.colormaps.greysText",{defaultMessage:"Greys"}),value:convertColorPaletteToColorMap((0,external_osdSharedDeps_ElasticEui_namespaceObject.ouiPaletteGray)(COLOR_MAP_LENGTH))}),_define_property(_obj,"Reds",{id:"Reds",label:external_osdSharedDeps_OsdI18n_namespaceObject.i18n.translate("charts.colormaps.redsText",{defaultMessage:"Reds"}),value:convertColorPaletteToColorMap((0,external_osdSharedDeps_ElasticEui_namespaceObject.ouiPaletteNegative)(COLOR_MAP_LENGTH))}),_define_property(_obj,"Yellow to Red",{id:"Yellow to Red",label:external_osdSharedDeps_OsdI18n_namespaceObject.i18n.translate("charts.colormaps.yellowToRedText",{defaultMessage:"Yellow to Red"}),value:convertColorPaletteToColorMap((0,external_osdSharedDeps_ElasticEui_namespaceObject.colorPalette)([external_osdSharedDeps_Theme_namespaceObject.euiThemeVars.euiColorWarning,external_osdSharedDeps_Theme_namespaceObject.euiThemeVars.euiColorDanger],COLOR_MAP_LENGTH,false,true))}),_define_property(_obj,"Green to Red",{id:"Green to Red",label:external_osdSharedDeps_OsdI18n_namespaceObject.i18n.translate("charts.colormaps.greenToRedText",{defaultMessage:"Green to Red"}),value:convertColorPaletteToColorMap((0,external_osdSharedDeps_ElasticEui_namespaceObject.colorPalette)([external_osdSharedDeps_Theme_namespaceObject.euiThemeVars.euiColorSuccess,external_osdSharedDeps_Theme_namespaceObject.euiThemeVars.euiColorWarning,external_osdSharedDeps_Theme_namespaceObject.euiThemeVars.euiColorDanger],COLOR_MAP_LENGTH,false,true))}),_obj);var color_maps_colorSchemas=Object.values(vislibColorMaps).map(function(param){var id=param.id,label=param.label;return{value:id,text:label}});function enforceBounds(x){if(x<0){return 0}else if(x>1){return 1}else{return x}}function interpolateLinearly(x,values){var xValues=[];var rValues=[];var gValues=[];var bValues=[];values.forEach(function(value){xValues.push(value[0]);rValues.push(value[1][0]);gValues.push(value[1][1]);bValues.push(value[1][2])});var i=1;while(xValues[i]<x)i++;var width=Math.abs(xValues[i-1]-xValues[i]);var scalingFactor=(x-xValues[i-1])/width;var r=rValues[i-1]+scalingFactor*(rValues[i]-rValues[i-1]);var g=gValues[i-1]+scalingFactor*(gValues[i]-gValues[i-1]);var b=bValues[i-1]+scalingFactor*(bValues[i]-bValues[i-1]);return[enforceBounds(r),enforceBounds(g),enforceBounds(b)]}function getHeatmapColors(value,colorSchemaName){if(!external_osdSharedDeps_Lodash_default().isNumber(value)||value<0||value>1){throw new Error("heatmap_color expects a number from 0 to 1 as first parameter")}var colorSchema=vislibColorMaps[colorSchemaName].value;if(!colorSchema){throw new Error("invalid colorSchemaName provided")}var color=interpolateLinearly(value,colorSchema);var r=Math.round(255*color[0]);var g=Math.round(255*color[1]);var b=Math.round(255*color[2]);return"rgb(".concat(r,",").concat(g,",").concat(b,")")}function drawColormap(colorSchema){var width=arguments.length>1&&arguments[1]!==void 0?arguments[1]:100,height=arguments.length>2&&arguments[2]!==void 0?arguments[2]:10;var canvas=document.createElement("canvas");canvas.width=width;canvas.height=height;var ctx=canvas.getContext("2d");if(ctx===null){throw new Error("no HeatmapColors canvas context found")}for(var i=0;i<=width;i++){ctx.fillStyle=getHeatmapColors(i/width,colorSchema);ctx.fillRect(i,0,1,height)}return canvas}getHeatmapColors.prototype.drawColormap=drawColormap;function _object_spread(target){for(var i=1;i<arguments.length;i++){var source=arguments[i]!=null?arguments[i]:{};var ownKeys=Object.keys(source);if(typeof Object.getOwnPropertySymbols==="function"){ownKeys=ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function(sym){return Object.getOwnPropertyDescriptor(source,sym).enumerable}))}ownKeys.forEach(function(key){_define_property(target,key,source[key])})}return target};function _object_spread_props_ownKeys(object,enumerableOnly){var keys=Object.keys(object);if(Object.getOwnPropertySymbols){var symbols=Object.getOwnPropertySymbols(object);if(enumerableOnly){symbols=symbols.filter(function(sym){return Object.getOwnPropertyDescriptor(object,sym).enumerable})}keys.push.apply(keys,symbols)}return keys}function _object_spread_props(target,source){source=source!=null?source:{};if(Object.getOwnPropertyDescriptors)Object.defineProperties(target,Object.getOwnPropertyDescriptors(source));else{_object_spread_props_ownKeys(Object(source)).forEach(function(key){Object.defineProperty(target,key,Object.getOwnPropertyDescriptor(source,key))})}return target};var truncatedColorMaps={};var colormaps=vislibColorMaps;for(var truncated_color_maps_key in colormaps){if(colormaps.hasOwnProperty(truncated_color_maps_key)){var truncated_color_maps_color=colormaps[truncated_color_maps_key];truncatedColorMaps[truncated_color_maps_key]=_object_spread_props(_object_spread({},truncated_color_maps_color),{value:truncated_color_maps_color.value.slice(Math.floor(truncated_color_maps_color.value.length/4))})}}var truncatedColorSchemas=Object.values(truncatedColorMaps).map(function(param){var id=param.id,label=param.label;return{value:id,text:label}});var jsx_runtime=__webpack_require__(870);function SwitchOption(param){var dataTestSubj=param["data-test-subj"],tooltip=param.tooltip,label=param.label,disabled=param.disabled,paramName=param.paramName,_param_value=param.value,value=_param_value===void 0?false:_param_value,setValue=param.setValue;return(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_namespaceObject.EuiFormRow,{fullWidth:true,display:"rowCompressed",children:(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_namespaceObject.EuiToolTip,{content:tooltip,delay:"long",position:"right",children:(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_namespaceObject.EuiSwitch,{compressed:true,label:label,checked:value,disabled:disabled,"data-test-subj":dataTestSubj,onChange:function(ev){return setValue(paramName,ev.target.checked)}})})})};function _array_without_holes(arr){if(Array.isArray(arr))return _array_like_to_array(arr)};function _iterable_to_array(iter){if(typeof Symbol!=="undefined"&&iter[Symbol.iterator]!=null||iter["@@iterator"]!=null){return Array.from(iter)}};function _non_iterable_spread(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")};function _to_consumable_array(arr){return _array_without_holes(arr)||_iterable_to_array(arr)||_unsupported_iterable_to_array(arr)||_non_iterable_spread()};var emptyValue={text:"",value:"EMPTY_VALUE",disabled:true,hidden:true};function SelectOption(param){var disabled=param.disabled,helpText=param.helpText,id=param.id,label=param.label,labelAppend=param.labelAppend,options=param.options,paramName=param.paramName,value=param.value,setValue=param.setValue,dataTestSubj=param["data-test-subj"];var availableOptions=(0,external_osdSharedDeps_React_.useMemo)(function(){return[emptyValue].concat(_to_consumable_array(options))},[options]);return(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_namespaceObject.EuiFormRow,{display:"rowCompressed",fullWidth:true,helpText:helpText,id:id,label:label,labelAppend:labelAppend,children:(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_namespaceObject.EuiSelect,{compressed:true,disabled:disabled,options:availableOptions,value:value===undefined?emptyValue.value:value,onChange:function(ev){return setValue(paramName,ev.target.value)},fullWidth:true,"data-test-subj":dataTestSubj})})};function BasicOptions(param){var stateParams=param.stateParams,setValue=param.setValue,vis=param.vis;return(0,jsx_runtime.jsxs)(jsx_runtime.Fragment,{children:[(0,jsx_runtime.jsx)(SelectOption,{label:external_osdSharedDeps_OsdI18n_namespaceObject.i18n.translate("charts.controls.vislibBasicOptions.legendPositionLabel",{defaultMessage:"Legend position"}),options:vis.type.editorConfig.collections.legendPositions,paramName:"legendPosition",value:stateParams.legendPosition,setValue:setValue}),(0,jsx_runtime.jsx)(SwitchOption,{label:external_osdSharedDeps_OsdI18n_namespaceObject.i18n.translate("charts.controls.vislibBasicOptions.showTooltipLabel",{defaultMessage:"Show tooltip"}),paramName:"addTooltip",value:stateParams.addTooltip,setValue:setValue})]})};var ColorModes=Object.freeze({BACKGROUND:"Background",LABELS:"Labels",NONE:"None"});var Rotates=Object.freeze({HORIZONTAL:0,VERTICAL:90,ANGLED:75});var vis_default_editor_public=__webpack_require__(908);function ColorRanges(param){var dataTestSubj=param["data-test-subj"],colorsRange=param.colorsRange,setValue=param.setValue,setValidity=param.setValidity,setTouched=param.setTouched;var addRangeValues=(0,external_osdSharedDeps_React_.useCallback)(function(){var previousRange=(0,external_osdSharedDeps_Lodash_namespaceObject.last)(colorsRange)||{};var from=previousRange.to?previousRange.to:0;var to=previousRange.to?from+(previousRange.to-(previousRange.from||0)):100;return{from:from,to:to}},[colorsRange]);var validateRange=(0,external_osdSharedDeps_React_.useCallback)(function(param,index){var from=param.from,to=param.to;if(!colorsRange[index]){return[false,false]}var leftBound=index===0?-Infinity:colorsRange[index-1].to||0;var isFromValid=from>=leftBound;var isToValid=to>=from;return[isFromValid,isToValid]},[colorsRange]);var setColorRanges=(0,external_osdSharedDeps_React_.useCallback)(function(value){return setValue("colorsRange",value)},[setValue]);return(0,jsx_runtime.jsx)(vis_default_editor_public.RangesParamEditor,{"data-test-subj":dataTestSubj,error:external_osdSharedDeps_OsdI18n_namespaceObject.i18n.translate("charts.controls.colorRanges.errorText",{defaultMessage:"Each range should be greater than previous."}),hidePlaceholders:true,value:colorsRange,setValue:setColorRanges,setValidity:setValidity,setTouched:setTouched,addRangeValues:addRangeValues,validateRange:validateRange})};const external_osdSharedDeps_OsdI18nReact_namespaceObject=__osdSharedDeps__.OsdI18nReact;function ColorSchemaOptions(param){var disabled=param.disabled,colorSchema=param.colorSchema,colorSchemas=param.colorSchemas,invertColors=param.invertColors,uiState=param.uiState,setValue=param.setValue,_param_showHelpText=param.showHelpText,showHelpText=_param_showHelpText===void 0?true:_param_showHelpText;var _useState=_sliced_to_array((0,external_osdSharedDeps_React_.useState)(function(){return!!uiState.get("vis.colors")}),2),isCustomColors=_useState[0],setIsCustomColors=_useState[1];(0,external_osdSharedDeps_React_.useEffect)(function(){uiState.on("colorChanged",function(){setIsCustomColors(true)})},[uiState]);var resetColorsButton=(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_namespaceObject.EuiText,{size:"xs",children:(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_namespaceObject.EuiLink,{onClick:function(){uiState.set("vis.colors",null);setIsCustomColors(false)},children:(0,jsx_runtime.jsx)(external_osdSharedDeps_OsdI18nReact_namespaceObject.FormattedMessage,{id:"charts.controls.colorSchema.resetColorsButtonLabel",defaultMessage:"Reset colors"})})});return(0,jsx_runtime.jsxs)(jsx_runtime.Fragment,{children:[(0,jsx_runtime.jsx)(SelectOption,{disabled:disabled,helpText:showHelpText&&external_osdSharedDeps_OsdI18n_namespaceObject.i18n.translate("charts.controls.colorSchema.howToChangeColorsDescription",{defaultMessage:"Individual colors can be changed in the legend."}),label:external_osdSharedDeps_OsdI18n_namespaceObject.i18n.translate("charts.controls.colorSchema.colorSchemaLabel",{defaultMessage:"Color schema"}),labelAppend:isCustomColors&&resetColorsButton,options:colorSchemas,paramName:"colorSchema",value:colorSchema,setValue:setValue}),(0,jsx_runtime.jsx)(SwitchOption,{disabled:disabled,label:external_osdSharedDeps_OsdI18n_namespaceObject.i18n.translate("charts.controls.colorSchema.reverseColorSchemaLabel",{defaultMessage:"Reverse schema"}),paramName:"invertColors",value:invertColors,setValue:setValue})]})};;function NumberInputOption(param){var disabled=param.disabled,error=param.error,isInvalid=param.isInvalid,label=param.label,max=param.max,min=param.min,paramName=param.paramName,step=param.step,_param_value=param.value,value=_param_value===void 0?"":_param_value,setValue=param.setValue,dataTestSubj=param["data-test-subj"];return(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_namespaceObject.EuiFormRow,{label:label,error:error,isInvalid:isInvalid,fullWidth:true,display:"rowCompressed",children:(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_namespaceObject.EuiFieldNumber,{"data-test-subj":dataTestSubj,disabled:disabled,compressed:true,fullWidth:true,isInvalid:isInvalid,step:step,max:max,min:min,value:value,onChange:function(ev){return setValue(paramName,isNaN(ev.target.valueAsNumber)?"":ev.target.valueAsNumber)}})})};function RangeOption(param){var label=param.label,max=param.max,min=param.min,showInput=param.showInput,showLabels=param.showLabels,_param_showValue=param.showValue,showValue=_param_showValue===void 0?true:_param_showValue,step=param.step,paramName=param.paramName,value=param.value,setValue=param.setValue;var _useState=_sliced_to_array((0,external_osdSharedDeps_React_.useState)(value),2),stateValue=_useState[0],setStateValue=_useState[1];var _useState1=_sliced_to_array((0,external_osdSharedDeps_React_.useState)(true),2),isValidState=_useState1[0],setIsValidState=_useState1[1];var error=external_osdSharedDeps_OsdI18n_namespaceObject.i18n.translate("charts.controls.rangeErrorMessage",{defaultMessage:"Values must be on or between {min} and {max}",values:{min:min,max:max}});var onChangeHandler=function(event,isValid){var valueAsNumber=event.target.valueAsNumber;setStateValue(valueAsNumber);setIsValidState(isValid);if(isValid){setValue(paramName,valueAsNumber)}};return(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_namespaceObject.EuiFormRow,{label:label,fullWidth:true,isInvalid:!isValidState,error:error,display:"rowCompressed",children:(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_namespaceObject.EuiRange,{compressed:true,fullWidth:true,max:max,min:min,showInput:showInput,showLabels:showLabels,showValue:showValue,step:step,value:stateValue,onChange:onChangeHandler})})};function RequiredNumberInputOption(param){var disabled=param.disabled,error=param.error,isInvalid=param.isInvalid,label=param.label,max=param.max,min=param.min,paramName=param.paramName,step=param.step,value=param.value,setValue=param.setValue,setValidity=param.setValidity,dataTestSubj=param["data-test-subj"];var isValid=value!==null;(0,external_osdSharedDeps_React_.useEffect)(function(){setValidity(paramName,isValid);return function(){return setValidity(paramName,true)}},[isValid,paramName,setValidity]);var onChange=(0,external_osdSharedDeps_React_.useCallback)(function(ev){return setValue(paramName,isNaN(ev.target.valueAsNumber)?null:ev.target.valueAsNumber)},[setValue,paramName]);return(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_namespaceObject.EuiFormRow,{label:label,error:error,isInvalid:isInvalid,fullWidth:true,display:"rowCompressed",children:(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_namespaceObject.EuiFieldNumber,{compressed:true,fullWidth:true,required:true,"data-test-subj":dataTestSubj,disabled:disabled,isInvalid:!isValid,step:step,max:max,min:min,value:value===null?"":value,onChange:onChange})})};function TextInputOption(param){var dataTestSubj=param["data-test-subj"],disabled=param.disabled,helpText=param.helpText,label=param.label,paramName=param.paramName,_param_value=param.value,value=_param_value===void 0?"":_param_value,setValue=param.setValue;return(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_namespaceObject.EuiFormRow,{helpText:helpText,label:label,fullWidth:true,display:"rowCompressed",children:(0,jsx_runtime.jsx)(external_osdSharedDeps_ElasticEui_namespaceObject.EuiFieldText,{compressed:true,fullWidth:true,"data-test-subj":dataTestSubj,disabled:disabled,value:value,onChange:function(ev){return setValue(paramName,ev.target.value)}})})};;;var public_plugin=function(){return new plugin_ChartsPlugin}},908:function(module){module.exports=__osdBundles__.get("plugin/visDefaultEditor/public")},933:function(module){"use strict";module.exports=__osdSharedDeps__.React}};var __webpack_module_cache__={};function __webpack_require__(moduleId){var cachedModule=__webpack_module_cache__[moduleId];if(cachedModule!==undefined){return cachedModule.exports}var module=__webpack_module_cache__[moduleId]={exports:{}};__webpack_modules__[moduleId](module,module.exports,__webpack_require__);return module.exports}(()=>{__webpack_require__.n=module=>{var getter=module&&module.__esModule?()=>module["default"]:()=>module;__webpack_require__.d(getter,{a:getter});return getter}})();(()=>{__webpack_require__.d=(exports,definition)=>{for(var key in definition){if(__webpack_require__.o(definition,key)&&!__webpack_require__.o(exports,key)){Object.defineProperty(exports,key,{enumerable:true,get:definition[key]})}}}})();(()=>{__webpack_require__.g=(()=>{if(typeof globalThis==="object")return globalThis;try{return this||new Function("return this")()}catch(e){if(typeof window==="object")return window}})()})();(()=>{__webpack_require__.o=(obj,prop)=>Object.prototype.hasOwnProperty.call(obj,prop)})();(()=>{__webpack_require__.r=exports=>{if(typeof Symbol!=="undefined"&&Symbol.toStringTag){Object.defineProperty(exports,Symbol.toStringTag,{value:"Module"})}Object.defineProperty(exports,"__esModule",{value:true})}})();(()=>{__webpack_require__.nc=undefined})();(()=>{__webpack_require__.rv=()=>"1.6.4"})();(()=>{var scriptUrl;if(__webpack_require__.g.importScripts)scriptUrl=__webpack_require__.g.location+"";var document1=__webpack_require__.g.document;if(!scriptUrl&&document1){if(document1.currentScript&&document1.currentScript.tagName.toUpperCase()==="SCRIPT")scriptUrl=document1.currentScript.src;if(!scriptUrl){var scripts=document1.getElementsByTagName("script");if(scripts.length){var i=scripts.length-1;while(i>-1&&(!scriptUrl||!/^http(s?):/.test(scriptUrl)))scriptUrl=scripts[i--].src}}}if(!scriptUrl)throw new Error("Automatic publicPath is not supported in this browser");scriptUrl=scriptUrl.replace(/^blob:/,"").replace(/#.*$/,"").replace(/\?.*$/,"").replace(/\/[^\/]+$/,"/");__webpack_require__.p=scriptUrl})();(()=>{__webpack_require__.ruid="bundler=rspack@1.6.4"})();var __webpack_exports__={};(()=>{"use strict";var _node_modules_val_loader_dist_cjs_js_key_charts_osd_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(786);var _node_modules_val_loader_dist_cjs_js_key_charts_osd_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_val_loader_dist_cjs_js_key_charts_osd_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0__);__osdBundles__.define("plugin/charts/public",()=>{return __webpack_require__(719)})})()})();