/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.task;

import java.time.Instant;
import org.opensearch.timeseries.model.TaskState;

public class ADHCBatchTaskRunState {
    public static final int HC_TASK_RUN_STATE_TIMEOUT_IN_MILLIS = 60000;
    private String detectorTaskState = TaskState.INIT.name();
    private boolean isHistoricalAnalysisCancelled;
    private String cancelReason;
    private String cancelledBy;
    private Long lastTaskRunTimeInMillis;
    private Long cancelledTimeInMillis;

    public String getDetectorTaskState() {
        return this.detectorTaskState;
    }

    public void setDetectorTaskState(String detectorTaskState) {
        this.detectorTaskState = detectorTaskState;
    }

    public boolean getHistoricalAnalysisCancelled() {
        return this.isHistoricalAnalysisCancelled;
    }

    public void setHistoricalAnalysisCancelled(boolean historicalAnalysisCancelled) {
        this.isHistoricalAnalysisCancelled = historicalAnalysisCancelled;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }

    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public String getCancelledBy() {
        return this.cancelledBy;
    }

    public void setCancelledBy(String cancelledBy) {
        this.cancelledBy = cancelledBy;
    }

    public void setCancelledTimeInMillis(Long cancelledTimeInMillis) {
        this.cancelledTimeInMillis = cancelledTimeInMillis;
    }

    public void setLastTaskRunTimeInMillis(Long lastTaskRunTimeInMillis) {
        this.lastTaskRunTimeInMillis = lastTaskRunTimeInMillis;
    }

    public boolean expired() {
        long nowInMillis = Instant.now().toEpochMilli();
        if (this.isHistoricalAnalysisCancelled && this.cancelledTimeInMillis != null && this.cancelledTimeInMillis + 60000L < nowInMillis) {
            return true;
        }
        return !this.isHistoricalAnalysisCancelled && this.lastTaskRunTimeInMillis != null && this.lastTaskRunTimeInMillis + 60000L < nowInMillis;
    }
}

