/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.sandbox.facet.FacetFieldCollectorManager;
import org.apache.lucene.sandbox.facet.utils.FacetBuilder;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollectorManager;
import org.apache.lucene.search.Query;

public final class FacetOrchestrator {
    private List<FacetBuilder> facetBuilders = new ArrayList<FacetBuilder>();

    public FacetOrchestrator addBuilder(FacetBuilder request) {
        this.facetBuilders.add(request);
        return this;
    }

    public void collect(Query query, IndexSearcher searcher) throws IOException {
        this.collect(query, searcher, null);
    }

    public <C extends Collector, T> T collect(Query query, IndexSearcher searcher, CollectorManager<C, T> mainCollector) throws IOException {
        MultiCollectorManager mcm = FacetOrchestrator.createMainCollector(this.facetBuilders, mainCollector);
        Object[] res = (Object[])searcher.search(query, (CollectorManager)mcm);
        if (mainCollector != null) {
            return (T)res[0];
        }
        return null;
    }

    static <C extends Collector, T> MultiCollectorManager createMainCollector(List<FacetBuilder> facetBuilders, CollectorManager<C, T> additionalCollectorManager) {
        CollectorManager[] managersArray;
        List<FacetFieldCollectorManager<?>> drillDownManagers = FacetOrchestrator.collectorManagerForBuilders(facetBuilders);
        int i = 0;
        if (additionalCollectorManager != null) {
            managersArray = new CollectorManager[drillDownManagers.size() + 1];
            managersArray[i++] = additionalCollectorManager;
        } else {
            managersArray = new CollectorManager[drillDownManagers.size()];
        }
        for (FacetFieldCollectorManager<?> m : drillDownManagers) {
            managersArray[i++] = m;
        }
        return new MultiCollectorManager(managersArray);
    }

    static List<FacetFieldCollectorManager<?>> collectorManagerForBuilders(List<FacetBuilder> facetBuilders) {
        HashMap<Object, FacetBuilder> buildersUniqueForCollection = new HashMap<Object, FacetBuilder>();
        for (FacetBuilder builder : facetBuilders) {
            buildersUniqueForCollection.compute(builder.collectionKey(), (x, v) -> builder.initOrReuseCollector((FacetBuilder)v));
        }
        ArrayList managers = new ArrayList();
        for (FacetBuilder c : buildersUniqueForCollection.values()) {
            managers.add(c.getCollectorManager());
        }
        return managers;
    }
}

