/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.resolver;

import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class FileSystemResolver
implements MustacheResolver {
    private final File fileRoot;
    private final Path pathRoot;

    public FileSystemResolver() {
        this.fileRoot = null;
        this.pathRoot = null;
    }

    public FileSystemResolver(File fileRoot) {
        if (!fileRoot.exists()) {
            throw new MustacheException(fileRoot + " does not exist");
        }
        if (!fileRoot.isDirectory()) {
            throw new MustacheException(fileRoot + " is not a directory");
        }
        this.fileRoot = fileRoot;
        this.pathRoot = null;
    }

    public FileSystemResolver(Path pathRoot) {
        if (!Files.exists(pathRoot, new LinkOption[0])) {
            throw new MustacheException(pathRoot + " does not exist");
        }
        if (!Files.isDirectory(pathRoot, new LinkOption[0])) {
            throw new MustacheException(pathRoot + " is not a directory");
        }
        this.fileRoot = null;
        this.pathRoot = pathRoot;
    }

    @Override
    public Reader getReader(String resourceName) {
        File file;
        if (this.pathRoot != null) {
            return this.getReaderFromPath(resourceName);
        }
        FileInputStream is = null;
        File file2 = file = this.fileRoot == null ? new File(resourceName) : new File(this.fileRoot, resourceName);
        if (file.exists() && file.isFile()) {
            try {
                File checkRoot = this.fileRoot == null ? new File("").getCanonicalFile() : this.fileRoot.getCanonicalFile();
                File parent = file.getCanonicalFile();
                while ((parent = parent.getParentFile()) != null && !parent.equals(checkRoot)) {
                }
                if (parent == null) {
                    throw new MustacheException("File not under root: " + checkRoot.getAbsolutePath());
                }
                is = new FileInputStream(file);
            }
            catch (IOException e) {
                throw new MustacheException("Found file, could not open: " + file, e);
            }
        }
        if (is != null) {
            return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        }
        return null;
    }

    private Reader getReaderFromPath(String resourceName) {
        Path file;
        try {
            file = this.pathRoot.getFileSystem().getPath(this.pathRoot.toString(), resourceName);
        }
        catch (InvalidPathException ignored) {
            return null;
        }
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return null;
        }
        try {
            Path canonicalFile = file.toRealPath(new LinkOption[0]);
            Path canonicalRoot = this.pathRoot.toRealPath(new LinkOption[0]);
            if (!canonicalFile.startsWith(canonicalRoot)) {
                throw new MustacheException("File not under root, file=" + canonicalFile + ", root=" + canonicalRoot);
            }
            return Files.newBufferedReader(file);
        }
        catch (IOException e) {
            throw new MustacheException("Found file, could not open: " + file, e);
        }
    }
}

