/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffprobe;

import com.github.kokorin.jaffree.LogLevel;
import com.github.kokorin.jaffree.StreamType;
import com.github.kokorin.jaffree.ffprobe.ChannelInput;
import com.github.kokorin.jaffree.ffprobe.FFprobeLogReader;
import com.github.kokorin.jaffree.ffprobe.FFprobeResult;
import com.github.kokorin.jaffree.ffprobe.FFprobeResultReader;
import com.github.kokorin.jaffree.ffprobe.Input;
import com.github.kokorin.jaffree.ffprobe.PipeInput;
import com.github.kokorin.jaffree.ffprobe.UrlInput;
import com.github.kokorin.jaffree.ffprobe.data.FormatParser;
import com.github.kokorin.jaffree.ffprobe.data.JsonFormatParser;
import com.github.kokorin.jaffree.process.ProcessHandler;
import com.github.kokorin.jaffree.process.ProcessHelper;
import com.github.kokorin.jaffree.process.StdReader;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public class FFprobe {
    private LogLevel logLevel = LogLevel.INFO;
    private String selectStreams;
    private boolean showData;
    private boolean showPrivateData = true;
    private String showDataHash;
    private boolean showFormat;
    private String showEntries;
    private boolean showPackets;
    private boolean showFrames;
    private LogLevel showLog;
    private boolean showStreams;
    private boolean showPrograms;
    private boolean showChapters;
    private boolean countFrames;
    private boolean countPackets;
    private String readIntervals;
    private Long probeSize;
    private Long analyzeDuration;
    private Long fpsProbeSize;
    private final List<String> additionalArguments = new ArrayList<String>();
    private String format;
    private Input input;
    private FormatParser formatParser = new JsonFormatParser();
    private final Path executable;

    public FFprobe(Path executable) {
        this.executable = executable;
    }

    public FFprobe addArgument(String argument) {
        this.additionalArguments.add(argument);
        return this;
    }

    public FFprobe addArguments(String key, String value) {
        this.additionalArguments.addAll(Arrays.asList(key, value));
        return this;
    }

    public FFprobe setSelectStreams(String streamSpecifier) {
        this.selectStreams = streamSpecifier;
        return this;
    }

    public FFprobe setSelectStreams(StreamType streamType) {
        this.selectStreams = streamType.code();
        return this;
    }

    public FFprobe setShowData(boolean showData) {
        this.showData = showData;
        return this;
    }

    public FFprobe setShowPrivateData(boolean showPrivateData) {
        this.showPrivateData = showPrivateData;
        return this;
    }

    public FFprobe setShowDataHash(String algorithm) {
        this.showDataHash = algorithm;
        return this;
    }

    public FFprobe setShowFormat(boolean showFormat) {
        this.showFormat = showFormat;
        return this;
    }

    public FFprobe setShowEntries(String showEntries) {
        this.showEntries = showEntries;
        return this;
    }

    public FFprobe setShowPackets(boolean showPackets) {
        this.showPackets = showPackets;
        return this;
    }

    public FFprobe setShowFrames(boolean showFrames) {
        this.showFrames = showFrames;
        return this;
    }

    public FFprobe setShowLog(LogLevel showLog) {
        this.showLog = showLog;
        return this;
    }

    public FFprobe setShowStreams(boolean showStreams) {
        this.showStreams = showStreams;
        return this;
    }

    public FFprobe setShowPrograms(boolean showPrograms) {
        this.showPrograms = showPrograms;
        return this;
    }

    public FFprobe setShowChapters(boolean showChapters) {
        this.showChapters = showChapters;
        return this;
    }

    public FFprobe setCountFrames(boolean countFrames) {
        this.countFrames = countFrames;
        return this;
    }

    public FFprobe setCountPackets(boolean countPackets) {
        this.countPackets = countPackets;
        return this;
    }

    public FFprobe setReadIntervals(String intervals) {
        this.readIntervals = intervals;
        return this;
    }

    public FFprobe setProbeSize(Long probeSize) {
        this.probeSize = probeSize;
        return this;
    }

    public FFprobe setAnalyzeDuration(Long analyzeDurationMicros) {
        this.analyzeDuration = analyzeDurationMicros;
        return this;
    }

    public FFprobe setAnalyzeDuration(Number analyzeDurationInTimeUnit, TimeUnit timeUnit) {
        long micros = (long)(analyzeDurationInTimeUnit.doubleValue() * (double)timeUnit.toMicros(1L));
        return this.setAnalyzeDuration(micros);
    }

    public FFprobe setFpsProbeSize(Long fpsProbeSize) {
        this.fpsProbeSize = fpsProbeSize;
        return this;
    }

    public FFprobe setFormat(String format) {
        this.format = format;
        return this;
    }

    public FFprobe setInput(Path inputPath) {
        return this.setInput(inputPath.toString());
    }

    public FFprobe setInput(String inputUriOrPath) {
        return this.setInput(new UrlInput(inputUriOrPath));
    }

    public FFprobe setInput(InputStream inputStream) {
        return this.setInput(PipeInput.pumpFrom(inputStream));
    }

    public FFprobe setInput(InputStream inputStream, int bufferSize) {
        return this.setInput(PipeInput.pumpFrom(inputStream, bufferSize));
    }

    public FFprobe setInput(SeekableByteChannel inputChannel) {
        return this.setInput(ChannelInput.fromChannel(inputChannel));
    }

    public FFprobe setInput(SeekableByteChannel inputChannel, int bufferSize) {
        return this.setInput(ChannelInput.fromChannel(inputChannel, bufferSize));
    }

    public FFprobe setInput(Input input) {
        this.input = input;
        return this;
    }

    public FFprobe setFormatParser(FormatParser formatParser) {
        if (formatParser == null) {
            throw new IllegalArgumentException("Parser must be non null");
        }
        this.formatParser = formatParser;
        return this;
    }

    public FFprobe setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public Future<FFprobeResult> executeAsync() {
        FutureTask<FFprobeResult> resultFuture = new FutureTask<FFprobeResult>(new Callable<FFprobeResult>(){

            @Override
            public FFprobeResult call() throws Exception {
                return FFprobe.this.execute();
            }
        });
        Thread runner = new Thread(resultFuture, "FFprobe-async-runner");
        runner.setDaemon(true);
        runner.start();
        return resultFuture;
    }

    public FFprobeResult execute() {
        ProcessHelper helper;
        ArrayList<ProcessHelper> helpers = new ArrayList<ProcessHelper>();
        if (this.input != null && (helper = this.input.helperThread()) != null) {
            helpers.add(helper);
        }
        return new ProcessHandler<FFprobeResult>(this.executable, null).setStdOutReader(this.createStdOutReader(this.formatParser)).setStdErrReader(this.createStdErrReader()).setHelpers(helpers).setArguments(this.buildArguments()).execute();
    }

    protected List<String> buildArguments() {
        ArrayList<String> result = new ArrayList<String>();
        String logLevelArgument = "level";
        if (this.logLevel != null) {
            logLevelArgument = logLevelArgument + "+" + this.logLevel.name().toLowerCase();
        }
        result.addAll(Arrays.asList("-loglevel", logLevelArgument));
        if (this.selectStreams != null) {
            result.addAll(Arrays.asList("-select_streams", this.selectStreams));
        }
        if (this.showData) {
            result.add("-show_data");
        }
        if (this.showDataHash != null) {
            result.addAll(Arrays.asList("-show_data_hash", this.showDataHash));
        }
        if (this.showFormat) {
            result.add("-show_format");
        }
        if (this.showEntries != null) {
            result.addAll(Arrays.asList("-show_entries", this.showEntries));
        }
        if (this.showPackets) {
            result.add("-show_packets");
        }
        if (this.showFrames) {
            result.add("-show_frames");
        }
        if (this.showLog != null) {
            result.addAll(Arrays.asList("-show_log", Integer.toString(this.showLog.code())));
        }
        if (this.showStreams) {
            result.add("-show_streams");
        }
        if (this.showPrograms) {
            result.add("-show_programs");
        }
        if (this.showChapters) {
            result.add("-show_chapters");
        }
        if (this.countFrames) {
            result.add("-count_frames");
        }
        if (this.countPackets) {
            result.add("-count_packets");
        }
        if (this.readIntervals != null) {
            result.addAll(Arrays.asList("-read_intervals", this.readIntervals));
        }
        if (this.showPrivateData) {
            result.add("-show_private_data");
        } else {
            result.add("-noprivate");
        }
        if (this.probeSize != null) {
            result.addAll(Arrays.asList("-probesize", this.probeSize.toString()));
        }
        if (this.analyzeDuration != null) {
            result.addAll(Arrays.asList("-analyzeduration", this.analyzeDuration.toString()));
        }
        if (this.fpsProbeSize != null) {
            result.addAll(Arrays.asList("-fpsprobesize", this.fpsProbeSize.toString()));
        }
        result.addAll(Arrays.asList("-print_format", this.formatParser.getFormatName()));
        result.addAll(this.additionalArguments);
        if (this.format != null) {
            result.addAll(Arrays.asList("-f", this.format));
        }
        if (this.input != null) {
            result.addAll(Arrays.asList("-i", this.input.getUrl()));
        }
        return result;
    }

    protected StdReader<FFprobeResult> createStdOutReader(FormatParser formatParser) {
        return new FFprobeResultReader(formatParser);
    }

    protected StdReader<FFprobeResult> createStdErrReader() {
        return new FFprobeLogReader();
    }

    public static FFprobe atPath() {
        return FFprobe.atPath(null);
    }

    public static FFprobe atPath(Path pathToDir) {
        Path executable = pathToDir != null ? pathToDir.resolve("ffprobe") : Paths.get("ffprobe", new String[0]);
        return new FFprobe(executable);
    }
}

