/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.infinispan.commons.io.FileWatcher;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.ReloadingX509KeyManager;
import org.infinispan.commons.util.ReloadingX509TrustManager;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.Util;

public class SslContextFactory {
    private static final String DEFAULT_KEYSTORE_TYPE = "PKCS12";
    private static final String DEFAULT_SSL_PROTOCOL = "TLSv1.3";
    private static final String CLASSPATH_RESOURCE = "classpath:";
    private static final ConcurrentHashMap<ClassLoader, Provider[]> PER_CLASSLOADER_PROVIDERS = new ConcurrentHashMap(2);
    private String keyStoreFileName;
    private char[] keyStorePassword;
    private String keyStoreType = "PKCS12";
    private String keyAlias;
    private String trustStoreFileName;
    private char[] trustStorePassword;
    private String trustStoreType = "PKCS12";
    private String sslProtocol = "TLSv1.3";
    private ClassLoader classLoader;
    private String provider;
    private FileWatcher watcher;

    public SslContextFactory keyStoreFileName(String keyStoreFileName) {
        this.keyStoreFileName = keyStoreFileName;
        return this;
    }

    public SslContextFactory keyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public SslContextFactory keyStoreType(String keyStoreType) {
        if (keyStoreType != null) {
            this.keyStoreType = keyStoreType;
        }
        return this;
    }

    public SslContextFactory keyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
        return this;
    }

    public SslContextFactory trustStoreFileName(String trustStoreFileName) {
        this.trustStoreFileName = trustStoreFileName;
        return this;
    }

    public SslContextFactory trustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public SslContextFactory trustStoreType(String trustStoreType) {
        if (trustStoreType != null) {
            this.trustStoreType = trustStoreType;
        }
        return this;
    }

    public SslContextFactory sslProtocol(String sslProtocol) {
        if (sslProtocol != null) {
            this.sslProtocol = sslProtocol;
        }
        return this;
    }

    public SslContextFactory provider(String provider) {
        if (provider != null) {
            this.provider = provider;
        }
        return this;
    }

    public SslContextFactory watcher(FileWatcher watcher) {
        if (watcher != null) {
            this.watcher = watcher;
        }
        return this;
    }

    @Deprecated(forRemoval=true, since="15.0")
    public SslContextFactory useNativeIfAvailable(boolean useNativeIfAvailable) {
        return this;
    }

    public SslContextFactory classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public Context build() {
        try {
            KeyManager[] kms = null;
            if (this.keyStoreFileName != null) {
                kms = this.watcher != null ? new KeyManager[]{new ReloadingX509KeyManager(this.watcher, Path.of(this.keyStoreFileName, new String[0]), p -> this.getKeyManager())} : new KeyManager[]{this.getKeyManager()};
            }
            TrustManager[] tms = null;
            if (this.trustStoreFileName != null) {
                tms = this.watcher != null ? new TrustManager[]{new ReloadingX509TrustManager(this.watcher, Path.of(this.trustStoreFileName, new String[0]), p -> this.getTrustManager())} : new TrustManager[]{this.getTrustManager()};
            }
            Provider provider = null;
            if (this.provider != null) {
                provider = SslContextFactory.findProvider(this.provider, SSLContext.class.getSimpleName(), this.sslProtocol);
            }
            SSLContext sslContext = provider != null ? SSLContext.getInstance(this.sslProtocol, provider) : SSLContext.getInstance(this.sslProtocol);
            sslContext.init(kms, tms, null);
            return new Context(sslContext, kms != null ? kms[0] : null, tms != null ? tms[0] : null);
        }
        catch (Exception e) {
            throw Log.SECURITY.sslInitializationException(e);
        }
    }

    private X509ExtendedKeyManager getKeyManager() {
        try {
            String type = this.keyStoreType != null ? this.keyStoreType : DEFAULT_KEYSTORE_TYPE;
            Provider provider = SslContextFactory.findProvider(this.provider, KeyManagerFactory.class.getSimpleName(), type);
            KeyStore ks = provider != null ? KeyStore.getInstance(type, provider) : KeyStore.getInstance(type);
            SslContextFactory.loadKeyStore(ks, this.keyStoreFileName, this.keyStorePassword, this.classLoader);
            if (this.keyAlias != null) {
                if (ks.containsAlias(this.keyAlias) && ks.isKeyEntry(this.keyAlias)) {
                    KeyStore.PasswordProtection passParam = new KeyStore.PasswordProtection(this.keyStorePassword);
                    KeyStore.Entry entry = ks.getEntry(this.keyAlias, passParam);
                    ks = provider != null ? KeyStore.getInstance(type, provider) : KeyStore.getInstance(type);
                    ks.load(null, null);
                    ks.setEntry(this.keyAlias, entry, passParam);
                } else {
                    throw Log.SECURITY.noSuchAliasInKeyStore(this.keyAlias, this.keyStoreFileName);
                }
            }
            String algorithm = KeyManagerFactory.getDefaultAlgorithm();
            provider = SslContextFactory.findProvider(this.provider, KeyManagerFactory.class.getSimpleName(), algorithm);
            KeyManagerFactory kmf = provider != null ? KeyManagerFactory.getInstance(algorithm, provider) : KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, this.keyStorePassword);
            for (KeyManager km : kmf.getKeyManagers()) {
                if (!(km instanceof X509ExtendedKeyManager)) continue;
                X509ExtendedKeyManager xkm = (X509ExtendedKeyManager)km;
                return xkm;
            }
            throw new GeneralSecurityException("Could not obtain an X509ExtendedKeyManager");
        }
        catch (IOException | GeneralSecurityException e) {
            throw Log.SECURITY.sslInitializationException(e);
        }
    }

    private X509ExtendedTrustManager getTrustManager() {
        try {
            String type = this.trustStoreType != null ? this.trustStoreType : DEFAULT_KEYSTORE_TYPE;
            Provider provider = SslContextFactory.findProvider(this.provider, KeyStore.class.getSimpleName(), this.trustStoreType);
            KeyStore ks = provider != null ? KeyStore.getInstance(type, provider) : KeyStore.getInstance(type);
            SslContextFactory.loadKeyStore(ks, this.trustStoreFileName, this.trustStorePassword, this.classLoader);
            String algorithm = KeyManagerFactory.getDefaultAlgorithm();
            provider = SslContextFactory.findProvider(this.provider, TrustManagerFactory.class.getSimpleName(), algorithm);
            TrustManagerFactory tmf = provider != null ? TrustManagerFactory.getInstance(algorithm, provider) : TrustManagerFactory.getInstance(algorithm);
            tmf.init(ks);
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509ExtendedTrustManager)) continue;
                X509ExtendedTrustManager xkm = (X509ExtendedTrustManager)tm;
                return xkm;
            }
            throw new GeneralSecurityException("Could not obtain an X509TrustManager");
        }
        catch (IOException | GeneralSecurityException e) {
            throw Log.SECURITY.sslInitializationException(e);
        }
    }

    @Deprecated(forRemoval=true, since="15.0")
    public static String getSslProvider() {
        return null;
    }

    public static SSLEngine getEngine(SSLContext sslContext, boolean useClientMode, boolean needClientAuth) {
        SSLEngine sslEngine = sslContext.createSSLEngine();
        sslEngine.setUseClientMode(useClientMode);
        sslEngine.setNeedClientAuth(needClientAuth);
        return sslEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadKeyStore(KeyStore ks, String keyStoreFileName, char[] keyStorePassword, ClassLoader classLoader) throws IOException, GeneralSecurityException {
        InputStream is = null;
        try {
            if (keyStoreFileName.startsWith(CLASSPATH_RESOURCE)) {
                String fileName = keyStoreFileName.substring(keyStoreFileName.indexOf(":") + 1);
                is = Util.getResourceAsStream(fileName, classLoader);
                if (is == null) {
                    throw Log.SECURITY.cannotFindResource(keyStoreFileName);
                }
            } else {
                is = new BufferedInputStream(new FileInputStream(keyStoreFileName));
            }
            ks.load(is, keyStorePassword);
        }
        catch (Throwable throwable) {
            Util.close(is);
            throw throwable;
        }
        Util.close((AutoCloseable)is);
    }

    public static Provider findProvider(String providerName, String serviceType, String algorithm) {
        Provider[] providers;
        for (Provider provider : providers = SslContextFactory.discoverSecurityProviders(Thread.currentThread().getContextClassLoader())) {
            Provider.Service providerService;
            if (providerName != null && !providerName.equals(provider.getName()) || (providerService = provider.getService(serviceType, algorithm)) == null) continue;
            return provider;
        }
        return null;
    }

    public static Provider[] discoverSecurityProviders(ClassLoader classLoader) {
        return PER_CLASSLOADER_PROVIDERS.computeIfAbsent(classLoader, cl -> {
            LinkedHashMap providers = new LinkedHashMap();
            for (Provider provider : Security.getProviders()) {
                providers.put(provider.getClass(), provider);
            }
            for (Provider provider : ServiceFinder.load(Provider.class, classLoader)) {
                providers.putIfAbsent(provider.getClass(), provider);
            }
            return providers.values().toArray(new Provider[0]);
        });
    }

    public record Context(SSLContext sslContext, KeyManager keyManager, TrustManager trustManager) {
    }
}

