/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.compatibility;

import io.smallrye.config.ConfigValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.keycloak.compatibility.CompatibilityMetadataProvider;
import org.keycloak.config.DatabaseOptions;
import org.keycloak.config.Option;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public class DatabaseCompatibilityMetadataProvider
implements CompatibilityMetadataProvider {
    public static final String ID = "database";

    public Map<String, String> metadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(DatabaseOptions.DB.getKey(), Configuration.getConfigValue(DatabaseOptions.DB).getValue());
        this.addOptional(DatabaseOptions.DB_SCHEMA, metadata);
        ConfigValue dbUrl = Configuration.getConfigValue(DatabaseOptions.DB_URL);
        if (!dbUrl.getValue().equals(dbUrl.getRawValue())) {
            this.addOptional(DatabaseOptions.DB_URL_HOST, metadata);
            this.addOptional(DatabaseOptions.DB_URL_PORT, metadata);
            this.addOptional(DatabaseOptions.DB_URL_DATABASE, metadata);
        }
        return metadata;
    }

    void addOptional(Option<?> option, Map<String, String> metadata) {
        Optional<String> optional = Configuration.getOptionalKcValue(option.getKey());
        optional.ifPresent(opt -> metadata.put(option.getKey(), (String)opt));
    }

    public String getId() {
        return ID;
    }
}

