/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.spi;

import jakarta.persistence.criteria.Nulls;
import java.util.function.Supplier;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EntityNameResolver;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.annotations.CacheLayout;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.cache.spi.TimestampsCacheFactory;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.context.spi.TenantSchemaMapper;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.type.format.FormatMapper;

public abstract class AbstractDelegatingSessionFactoryBuilder<T extends SessionFactoryBuilder>
implements SessionFactoryBuilder {
    private final SessionFactoryBuilder delegate;

    public AbstractDelegatingSessionFactoryBuilder(SessionFactoryBuilder delegate) {
        this.delegate = delegate;
    }

    protected abstract T getThis();

    protected SessionFactoryBuilder delegate() {
        return this.delegate;
    }

    public T applyValidatorFactory(Object validatorFactory) {
        this.delegate.applyValidatorFactory(validatorFactory);
        return this.getThis();
    }

    public T applyBeanManager(Object beanManager) {
        this.delegate.applyBeanManager(beanManager);
        return this.getThis();
    }

    public T applyName(String sessionFactoryName) {
        this.delegate.applyName(sessionFactoryName);
        return this.getThis();
    }

    public T applyNameAsJndiName(boolean isJndiName) {
        this.delegate.applyNameAsJndiName(isJndiName);
        return this.getThis();
    }

    public T applyAutoClosing(boolean enabled) {
        this.delegate.applyAutoClosing(enabled);
        return this.getThis();
    }

    public T applyAutoFlushing(boolean enabled) {
        this.delegate.applyAutoFlushing(enabled);
        return this.getThis();
    }

    public T applyStatisticsSupport(boolean enabled) {
        this.delegate.applyStatisticsSupport(enabled);
        return this.getThis();
    }

    public T applyInterceptor(Interceptor interceptor) {
        this.delegate.applyInterceptor(interceptor);
        return this.getThis();
    }

    public T applyStatementInspector(StatementInspector statementInspector) {
        this.delegate.applyStatementInspector(statementInspector);
        return this.getThis();
    }

    public T addSessionFactoryObservers(SessionFactoryObserver ... observers) {
        this.delegate.addSessionFactoryObservers(observers);
        return this.getThis();
    }

    public T applyCustomEntityDirtinessStrategy(CustomEntityDirtinessStrategy strategy) {
        this.delegate.applyCustomEntityDirtinessStrategy(strategy);
        return this.getThis();
    }

    public T addEntityNameResolver(EntityNameResolver ... entityNameResolvers) {
        this.delegate.addEntityNameResolver(entityNameResolvers);
        return this.getThis();
    }

    public T applyEntityNotFoundDelegate(EntityNotFoundDelegate entityNotFoundDelegate) {
        this.delegate.applyEntityNotFoundDelegate(entityNotFoundDelegate);
        return this.getThis();
    }

    public T applyIdentifierRollbackSupport(boolean enabled) {
        this.delegate.applyIdentifierRollbackSupport(enabled);
        return this.getThis();
    }

    public T applyNullabilityChecking(boolean enabled) {
        this.delegate.applyNullabilityChecking(enabled);
        return this.getThis();
    }

    public T applyLazyInitializationOutsideTransaction(boolean enabled) {
        this.delegate.applyLazyInitializationOutsideTransaction(enabled);
        return this.getThis();
    }

    @Deprecated
    public T applyTempTableDdlTransactionHandling(TempTableDdlTransactionHandling handling) {
        this.delegate.applyTempTableDdlTransactionHandling(handling);
        return this.getThis();
    }

    public T applyDelayedEntityLoaderCreations(boolean delay) {
        this.delegate.applyDelayedEntityLoaderCreations(delay);
        return this.getThis();
    }

    public T applyDefaultBatchFetchSize(int size) {
        this.delegate.applyDefaultBatchFetchSize(size);
        return this.getThis();
    }

    public T applyMaximumFetchDepth(int depth) {
        this.delegate.applyMaximumFetchDepth(depth);
        return this.getThis();
    }

    public T applySubselectFetchEnabled(boolean enabled) {
        this.delegate.applySubselectFetchEnabled(enabled);
        return this.getThis();
    }

    public T applyDefaultNullPrecedence(Nulls nullPrecedence) {
        this.delegate.applyDefaultNullPrecedence(nullPrecedence);
        return this.getThis();
    }

    public T applyOrderingOfInserts(boolean enabled) {
        this.delegate.applyOrderingOfInserts(enabled);
        return this.getThis();
    }

    public T applyOrderingOfUpdates(boolean enabled) {
        this.delegate.applyOrderingOfUpdates(enabled);
        return this.getThis();
    }

    public T applyMultiTenancy(boolean enabled) {
        this.delegate.applyMultiTenancy(enabled);
        return this.getThis();
    }

    public T applyCurrentTenantIdentifierResolver(CurrentTenantIdentifierResolver<?> resolver) {
        this.delegate.applyCurrentTenantIdentifierResolver(resolver);
        return this.getThis();
    }

    @Override
    public SessionFactoryBuilder applyTenantSchemaMapper(TenantSchemaMapper<?> mapper) {
        this.delegate.applyTenantSchemaMapper(mapper);
        return this.getThis();
    }

    public T applyJtaTrackingByThread(boolean enabled) {
        this.delegate.applyJtaTrackingByThread(enabled);
        return this.getThis();
    }

    public T applyPreferUserTransactions(boolean preferUserTransactions) {
        this.delegate.applyPreferUserTransactions(preferUserTransactions);
        return this.getThis();
    }

    public T applyNamedQueryCheckingOnStartup(boolean enabled) {
        this.delegate.applyNamedQueryCheckingOnStartup(enabled);
        return this.getThis();
    }

    public T applySecondLevelCacheSupport(boolean enabled) {
        this.delegate.applySecondLevelCacheSupport(enabled);
        return this.getThis();
    }

    public T applyQueryCacheSupport(boolean enabled) {
        this.delegate.applyQueryCacheSupport(enabled);
        return this.getThis();
    }

    public T applyQueryCacheLayout(CacheLayout cacheLayout) {
        this.delegate.applyQueryCacheLayout(cacheLayout);
        return this.getThis();
    }

    public T applyTimestampsCacheFactory(TimestampsCacheFactory factory) {
        this.delegate.applyTimestampsCacheFactory(factory);
        return this.getThis();
    }

    public T applyCacheRegionPrefix(String prefix) {
        this.delegate.applyCacheRegionPrefix(prefix);
        return this.getThis();
    }

    public T applyMinimalPutsForCaching(boolean enabled) {
        this.delegate.applyMinimalPutsForCaching(enabled);
        return this.getThis();
    }

    public T applyStructuredCacheEntries(boolean enabled) {
        this.delegate.applyStructuredCacheEntries(enabled);
        return this.getThis();
    }

    public T applyDirectReferenceCaching(boolean enabled) {
        this.delegate.applyDirectReferenceCaching(enabled);
        return this.getThis();
    }

    public T applyAutomaticEvictionOfCollectionCaches(boolean enabled) {
        this.delegate.applyAutomaticEvictionOfCollectionCaches(enabled);
        return this.getThis();
    }

    public T applyJdbcBatchSize(int size) {
        this.delegate.applyJdbcBatchSize(size);
        return this.getThis();
    }

    public T applyScrollableResultsSupport(boolean enabled) {
        this.delegate.applyScrollableResultsSupport(enabled);
        return this.getThis();
    }

    public T applyGetGeneratedKeysSupport(boolean enabled) {
        this.delegate.applyGetGeneratedKeysSupport(enabled);
        return this.getThis();
    }

    public T applyJdbcFetchSize(int size) {
        this.delegate.applyJdbcFetchSize(size);
        return this.getThis();
    }

    public T applyConnectionProviderDisablesAutoCommit(boolean providerDisablesAutoCommit) {
        this.delegate.applyConnectionProviderDisablesAutoCommit(providerDisablesAutoCommit);
        return this.getThis();
    }

    public T applySqlComments(boolean enabled) {
        this.delegate.applySqlComments(enabled);
        return this.getThis();
    }

    public T applySqlFunction(String registrationName, SqmFunctionDescriptor sqlFunction) {
        this.delegate.applySqlFunction(registrationName, sqlFunction);
        return this.getThis();
    }

    public T applyCollectionsInDefaultFetchGroup(boolean enabled) {
        this.delegate.applyCollectionsInDefaultFetchGroup(enabled);
        return this.getThis();
    }

    public T allowOutOfTransactionUpdateOperations(boolean allow) {
        this.delegate.allowOutOfTransactionUpdateOperations(allow);
        return this.getThis();
    }

    @Deprecated
    public T enableReleaseResourcesOnCloseEnabled(boolean enable) {
        this.delegate.enableReleaseResourcesOnCloseEnabled(enable);
        return this.getThis();
    }

    public T enableJpaQueryCompliance(boolean enabled) {
        this.delegate.enableJpaQueryCompliance(enabled);
        return this.getThis();
    }

    public T enableJpaOrderByMappingCompliance(boolean enabled) {
        this.delegate.enableJpaOrderByMappingCompliance(enabled);
        return this.getThis();
    }

    public T enableJpaTransactionCompliance(boolean enabled) {
        this.delegate.enableJpaTransactionCompliance(enabled);
        return this.getThis();
    }

    public T enableJpaCascadeCompliance(boolean enabled) {
        this.delegate.enableJpaCascadeCompliance(enabled);
        return this.getThis();
    }

    public T enableJpaClosedCompliance(boolean enabled) {
        this.delegate.enableJpaClosedCompliance(enabled);
        return this.getThis();
    }

    public T applyStatelessInterceptor(Supplier<? extends Interceptor> statelessInterceptorSupplier) {
        this.delegate.applyStatelessInterceptor(statelessInterceptorSupplier);
        return this.getThis();
    }

    public T applyStatelessInterceptor(Class<? extends Interceptor> statelessInterceptorClass) {
        this.delegate.applyStatelessInterceptor(statelessInterceptorClass);
        return this.getThis();
    }

    public T applyConnectionHandlingMode(PhysicalConnectionHandlingMode connectionHandlingMode) {
        this.delegate.applyConnectionHandlingMode(connectionHandlingMode);
        return this.getThis();
    }

    public T applyJsonFormatMapper(FormatMapper jsonFormatMapper) {
        this.delegate.applyJsonFormatMapper(jsonFormatMapper);
        return this.getThis();
    }

    public T applyXmlFormatMapper(FormatMapper xmlFormatMapper) {
        this.delegate.applyXmlFormatMapper(xmlFormatMapper);
        return this.getThis();
    }

    @Override
    public SessionFactory build() {
        return this.delegate.build();
    }
}

