/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.narayana;

import io.agroal.api.transaction.TransactionAware;
import io.agroal.narayana.XAExceptionUtils;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.tm.XAResourceWrapper;

public class BaseXAResource
implements XAResourceWrapper {
    private static final String PRODUCT_NAME = BaseXAResource.class.getPackage().getImplementationTitle();
    private static final String PRODUCT_VERSION = BaseXAResource.class.getPackage().getImplementationVersion();
    private final TransactionAware transactionAware;
    private final XAResource xaResource;
    private final String jndiName;

    public BaseXAResource(TransactionAware transactionAware, XAResource xaResource, String jndiName) {
        this.transactionAware = transactionAware;
        this.xaResource = xaResource;
        this.jndiName = jndiName;
    }

    public XAResource getResource() {
        return this.xaResource;
    }

    public String getProductName() {
        return PRODUCT_NAME;
    }

    public String getProductVersion() {
        return PRODUCT_VERSION;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.transactionAware.transactionBeforeCompletion(true);
            this.xaResource.commit(xid, onePhase);
        }
        catch (XAException xe) {
            this.transactionAware.setFlushOnly();
            throw xe;
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        try {
            this.xaResource.end(xid, flags);
        }
        catch (XAException xe) {
            if (!XAExceptionUtils.isUnilateralRollbackOnAbort(xe.errorCode, flags)) {
                this.transactionAware.setFlushOnly();
            }
            throw xe;
        }
        catch (Exception e) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtils.xaException(-7, "Error trying to end xa transaction: ", e);
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            this.xaResource.forget(xid);
        }
        catch (XAException xe) {
            this.transactionAware.setFlushOnly();
            throw xe;
        }
    }

    public int getTransactionTimeout() throws XAException {
        try {
            return this.xaResource.getTransactionTimeout();
        }
        catch (XAException xe) {
            this.transactionAware.setFlushOnly();
            throw xe;
        }
    }

    public boolean isSameRM(XAResource xaRes) throws XAException {
        try {
            return this.xaResource.isSameRM(xaRes);
        }
        catch (XAException xe) {
            this.transactionAware.setFlushOnly();
            throw xe;
        }
    }

    public int prepare(Xid xid) throws XAException {
        try {
            return this.xaResource.prepare(xid);
        }
        catch (XAException xe) {
            this.transactionAware.setFlushOnly();
            throw xe;
        }
    }

    public Xid[] recover(int flag) throws XAException {
        try {
            return this.xaResource.recover(flag);
        }
        catch (XAException xe) {
            this.transactionAware.setFlushOnly();
            throw xe;
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.transactionAware.transactionBeforeCompletion(false);
            this.xaResource.rollback(xid);
        }
        catch (XAException xe) {
            this.transactionAware.setFlushOnly();
            throw xe;
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            return this.xaResource.setTransactionTimeout(seconds);
        }
        catch (XAException xe) {
            this.transactionAware.setFlushOnly();
            throw xe;
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            this.transactionAware.transactionStart();
            this.xaResource.start(xid, flags);
        }
        catch (XAException xe) {
            this.transactionAware.setFlushOnly();
            throw xe;
        }
        catch (Exception e) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtils.xaException(-7, "Error trying to start xa transaction: ", e);
        }
    }
}

