/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.io.Serializable;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;

public final class OAuth2DeviceConfig
implements Serializable {
    public static final int DEFAULT_OAUTH2_DEVICE_CODE_LIFESPAN = 600;
    public static final int DEFAULT_OAUTH2_DEVICE_POLLING_INTERVAL = 5;
    public static String OAUTH2_DEVICE_CODE_LIFESPAN = "oauth2DeviceCodeLifespan";
    public static String OAUTH2_DEVICE_POLLING_INTERVAL = "oauth2DevicePollingInterval";
    public static String OAUTH2_DEVICE_CODE_LIFESPAN_PER_CLIENT = "oauth2.device.code.lifespan";
    public static String OAUTH2_DEVICE_POLLING_INTERVAL_PER_CLIENT = "oauth2.device.polling.interval";
    public static final String OAUTH2_DEVICE_AUTHORIZATION_GRANT_ENABLED = "oauth2.device.authorization.grant.enabled";
    private int lifespan = 600;
    private int poolingInterval = 5;

    public OAuth2DeviceConfig(RealmModel realm) {
        String pooling;
        String lifespan = realm.getAttribute(OAUTH2_DEVICE_CODE_LIFESPAN);
        if (lifespan != null && !lifespan.trim().isEmpty()) {
            this.setOAuth2DeviceCodeLifespan(Integer.parseInt(lifespan));
        }
        if ((pooling = realm.getAttribute(OAUTH2_DEVICE_POLLING_INTERVAL)) != null && !pooling.trim().isEmpty()) {
            this.setOAuth2DevicePollingInterval(Integer.parseInt(pooling));
        }
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public void setOAuth2DeviceCodeLifespan(Integer seconds) {
        this.setOAuth2DeviceCodeLifespan(null, seconds);
    }

    public void setOAuth2DeviceCodeLifespan(RealmModel realm, Integer seconds) {
        if (seconds == null) {
            seconds = 600;
        }
        this.lifespan = seconds;
        this.persistRealmAttribute(realm, OAUTH2_DEVICE_CODE_LIFESPAN, this.lifespan);
    }

    public int getPoolingInterval() {
        return this.poolingInterval;
    }

    public void setOAuth2DevicePollingInterval(Integer seconds) {
        this.setOAuth2DevicePollingInterval(null, seconds);
    }

    public void setOAuth2DevicePollingInterval(RealmModel realm, Integer seconds) {
        if (seconds == null) {
            seconds = 5;
        }
        this.poolingInterval = seconds;
        this.persistRealmAttribute(realm, OAUTH2_DEVICE_POLLING_INTERVAL, this.poolingInterval);
    }

    public int getLifespan(ClientModel client) {
        String lifespan = client.getAttribute(OAUTH2_DEVICE_CODE_LIFESPAN_PER_CLIENT);
        if (lifespan != null && !lifespan.trim().isEmpty()) {
            return Integer.parseInt(lifespan);
        }
        return this.getLifespan();
    }

    public int getPoolingInterval(ClientModel client) {
        String interval = client.getAttribute(OAUTH2_DEVICE_POLLING_INTERVAL_PER_CLIENT);
        if (interval != null && !interval.trim().isEmpty()) {
            return Integer.parseInt(interval);
        }
        return this.getPoolingInterval();
    }

    public boolean isOAuth2DeviceAuthorizationGrantEnabled(ClientModel client) {
        String enabled = client.getAttribute(OAUTH2_DEVICE_AUTHORIZATION_GRANT_ENABLED);
        return Boolean.parseBoolean(enabled);
    }

    private void persistRealmAttribute(RealmModel realm, String name, Integer value) {
        if (realm != null) {
            realm.setAttribute(name, value);
        }
    }
}

