/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.vertx.http.runtime.security.AbstractHttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.AbstractPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Singleton
public final class HttpAuthorizer
extends AbstractHttpAuthorizer {
    HttpAuthorizer(IdentityProviderManager identityProviderManager, AuthorizationController controller, Instance<HttpSecurityPolicy> installedPolicies, BlockingSecurityExecutor blockingExecutor, BeanManager beanManager, Event<AuthorizationFailureEvent> authZFailureEvent, Event<AuthorizationSuccessEvent> authZSuccessEvent, @ConfigProperty(name="quarkus.security.events.enabled") boolean securityEventsEnabled) {
        super(identityProviderManager, controller, HttpAuthorizer.toList(installedPolicies), beanManager, blockingExecutor, authZFailureEvent, authZSuccessEvent, securityEventsEnabled);
    }

    private static List<HttpSecurityPolicy> toList(Instance<HttpSecurityPolicy> installedPolicies) {
        ArrayList<HttpSecurityPolicy> globalPolicies = new ArrayList<HttpSecurityPolicy>();
        for (HttpSecurityPolicy i : installedPolicies) {
            AbstractPathMatchingHttpSecurityPolicy i1;
            if (i.name() != null || i instanceof AbstractPathMatchingHttpSecurityPolicy && (i1 = (AbstractPathMatchingHttpSecurityPolicy)((Object)i)).hasNoPermissions()) continue;
            globalPolicies.add(i);
        }
        return globalPolicies;
    }
}

