/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.internal.models.parameters;

import io.smallrye.openapi.model.BaseExtensibleModel;
import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;

public abstract class AbstractRequestBody
extends BaseExtensibleModel<RequestBody>
implements RequestBody {
    public static final PropertyMetadata PROPERTIES = new Properties();

    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }

    protected RequestBody filter(OASFilter filter) {
        return filter.filterRequestBody((RequestBody)this);
    }

    public Content getContent() {
        return (Content)this.getProperty("content", Content.class);
    }

    public void setContent(Content newValue) {
        this.setProperty("content", newValue);
    }

    public Boolean getRequired() {
        return (Boolean)this.getProperty("required", Boolean.class);
    }

    public void setRequired(Boolean newValue) {
        this.setProperty("required", newValue);
    }

    public static class Properties
    implements PropertyMetadata {
        private final Map<String, DataType> types = new HashMap<String, DataType>(4);
        private final Map<String, OpenApiVersion> minVersions = new HashMap<String, OpenApiVersion>(4);

        public Properties() {
            this.types.put("ref", DataType.type(String.class));
            this.minVersions.put("ref", OpenApiVersion.V3_0);
            this.types.put("description", DataType.type(String.class));
            this.minVersions.put("description", OpenApiVersion.V3_0);
            this.types.put("content", DataType.type(Content.class));
            this.minVersions.put("content", OpenApiVersion.V3_0);
            this.types.put("required", DataType.type(Boolean.class));
            this.minVersions.put("required", OpenApiVersion.V3_0);
        }

        public DataType getPropertyType(String name) {
            if (this.types.containsKey(name)) {
                return this.types.get(name);
            }
            return DataType.type(Object.class);
        }

        public OpenApiVersion getMinVersion(String name) {
            return this.minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}

