/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.keycloak.utils.ClosingStream;

public class StreamsUtil {
    public static <T> Stream<T> closing(Stream<T> stream) {
        return new ClosingStream<T>(stream);
    }

    public static <T> Stream<T> throwIfEmpty(Stream<T> stream, RuntimeException ex) {
        Iterator iterator = stream.iterator();
        if (iterator.hasNext()) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
        }
        throw ex;
    }

    public static <T> Stream<T> paginatedStream(Stream<T> originalStream, Integer first, Integer max) {
        if (first != null && first > 0) {
            originalStream = originalStream.skip(first.intValue());
        }
        if (max != null && max >= 0) {
            originalStream = originalStream.limit(max.intValue());
        }
        return originalStream;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        HashSet seen = new HashSet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public static <T> Stream<Collection<T>> chunkedStream(Stream<T> originalStream, final int chunkSize) {
        final Spliterator source = originalStream.spliterator();
        return StreamSupport.stream(new Spliterator<Collection<T>>(){
            final ArrayList<T> buf = new ArrayList();

            @Override
            public boolean tryAdvance(Consumer<? super Collection<T>> action) {
                while (this.buf.size() < chunkSize) {
                    if (source.tryAdvance(this.buf::add)) continue;
                    if (!this.buf.isEmpty()) {
                        action.accept((Collection)this.buf.clone());
                        this.buf.clear();
                        return true;
                    }
                    return false;
                }
                action.accept((Collection)this.buf.clone());
                this.buf.clear();
                return true;
            }

            @Override
            public Spliterator<Collection<T>> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                long sourceSize = source.estimateSize();
                return sourceSize / (long)chunkSize + (long)(sourceSize % (long)chunkSize != 0L ? 1 : 0);
            }

            @Override
            public int characteristics() {
                return 272;
            }
        }, false);
    }

    public static <T> Stream<T> prepareSortedStreamToWorkInsideOfFlatMapWithTerminalOperations(Stream<T> originalStream) {
        return StreamSupport.stream(originalStream.spliterator(), false);
    }
}

