/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.resteasy;

import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.HashSet;
import java.util.Set;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.vertx.VertxResteasyReactiveRequestContext;
import org.keycloak.http.HttpResponse;

public final class QuarkusHttpResponse
implements HttpResponse {
    private static final RuntimeDelegate.HeaderDelegate<NewCookie> NEW_COOKIE_HEADER_DELEGATE = RuntimeDelegate.getInstance().createHeaderDelegate(NewCookie.class);
    private final ResteasyReactiveRequestContext requestContext;
    private Set<NewCookie> newCookies;

    public QuarkusHttpResponse(ResteasyReactiveRequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public int getStatus() {
        VertxResteasyReactiveRequestContext serverHttpResponse = (VertxResteasyReactiveRequestContext)this.requestContext.serverResponse();
        return serverHttpResponse.vertxServerResponse().getStatusCode();
    }

    public void setStatus(int statusCode) {
        this.requestContext.serverResponse().setStatusCode(statusCode);
    }

    public void addHeader(String name, String value) {
        this.requestContext.serverResponse().addResponseHeader((CharSequence)name, (CharSequence)value);
    }

    public void setHeader(String name, String value) {
        this.requestContext.serverResponse().setResponseHeader((CharSequence)name, (CharSequence)value);
    }

    public void setCookieIfAbsent(NewCookie newCookie) {
        if (newCookie == null) {
            throw new IllegalArgumentException("Cookie is null");
        }
        if (this.newCookies == null) {
            this.newCookies = new HashSet<NewCookie>();
        }
        if (this.newCookies.add(newCookie)) {
            String headerValue = NEW_COOKIE_HEADER_DELEGATE.toString((Object)newCookie);
            this.addHeader("Set-Cookie", headerValue);
        }
    }
}

