/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.parameters.converters;

import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import org.jboss.resteasy.reactive.server.core.parameters.converters.TemporalParamConverter;

public class YearMonthParamConverter
extends TemporalParamConverter<YearMonth> {
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).toFormatter();

    public YearMonthParamConverter() {
        super(PARSER);
    }

    public YearMonthParamConverter(DateTimeFormatter formatter) {
        super(formatter);
    }

    @Override
    protected YearMonth convert(String value) {
        return YearMonth.parse(value);
    }

    @Override
    protected YearMonth convert(String value, DateTimeFormatter formatter) {
        return YearMonth.parse(value, formatter);
    }

    public static class Supplier
    extends TemporalParamConverter.TemporalSupplier<YearMonthParamConverter> {
        public Supplier() {
        }

        public Supplier(String pattern, String dateTimeFormatterProviderClassName) {
            super(pattern, dateTimeFormatterProviderClassName);
        }

        @Override
        protected YearMonthParamConverter createConverter(DateTimeFormatter dateTimeFormatter) {
            return new YearMonthParamConverter(dateTimeFormatter);
        }

        @Override
        public String getClassName() {
            return YearMonthParamConverter.class.getName();
        }
    }
}

