/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDirFailureChannel {
    private static final Logger log = LoggerFactory.getLogger(LogDirFailureChannel.class);
    private final ConcurrentMap<String, String> offlineLogDirs = new ConcurrentHashMap<String, String>();
    private final BlockingQueue<String> offlineLogDirQueue;

    public LogDirFailureChannel(int logDirNum) {
        this.offlineLogDirQueue = new ArrayBlockingQueue<String>(logDirNum);
    }

    public boolean hasOfflineLogDir(String logDir) {
        return this.offlineLogDirs.containsKey(logDir);
    }

    public void maybeAddOfflineLogDir(String logDir, String msg, IOException e) {
        log.error(msg, (Throwable)e);
        if (this.offlineLogDirs.putIfAbsent(logDir, logDir) == null) {
            this.offlineLogDirQueue.add(logDir);
        }
    }

    public String takeNextOfflineLogDir() throws InterruptedException {
        return this.offlineLogDirQueue.take();
    }
}

