/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.text.DecimalFormat;

public class Measure
implements Comparable<Measure> {
    private String expValue = "";
    private double calcValue;
    protected double diff;
    private int type;
    static final int TYPE_DISTANCE = 0;
    static final int TYPE_J = 1;
    static final int TYPE_NOE = 2;
    static final int TYPE_EXP_NOE = 0;
    static final DecimalFormat[] df = new DecimalFormat[]{new DecimalFormat("0.00"), new DecimalFormat("0.0"), new DecimalFormat("0.0000")};

    Measure(String expValue, double calcValue, int type) {
        this.expValue = expValue;
        this.calcValue = calcValue;
        this.type = type;
    }

    public String getExpValue() {
        return this.expValue;
    }

    public double getCalcValue() {
        return this.calcValue;
    }

    public double getDiff() {
        return this.diff;
    }

    @Override
    public int compareTo(Measure m) {
        double dcomp = this.calcValue - m.getCalcValue();
        if (dcomp > 0.0) {
            return 1;
        }
        if (dcomp < 0.0) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "" + this.calcValue;
    }

    public String round() {
        return df[this.type].format(this.calcValue);
    }

    public static String formatDistance(double d) {
        return df[0].format(d);
    }

    public static String formatJ(double d) {
        return df[1].format(d);
    }

    public static String formatNOE(double d) {
        return df[2].format(d);
    }

    public static String formatExpNOE(double d) {
        return df[0].format(d);
    }
}

