/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.util.Map;
import javajs.util.BS;
import org.jmol.adapter.readers.xml.CDXMLParser;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Edge;

public class XmlCdxReader
extends XmlReader
implements CDXMLParser.CDXReaderI {
    private boolean no3D;
    private CDXMLParser parser = new CDXMLParser(this);
    public boolean isCDX;

    @Override
    protected void processXml(XmlReader parent, Object saxReader) throws Exception {
        this.is2D = true;
        if (parent == null) {
            this.processXml2(this, saxReader);
            parent = this;
        } else {
            this.no3D = parent.checkFilterKey("NO3D");
            this.noHydrogens = parent.noHydrogens;
            this.processXml2(parent, saxReader);
            this.filter = parent.filter;
        }
    }

    @Override
    public void processStartElement(String localName, String nodeName) {
        this.parser.processStartElement(localName, this.atts);
    }

    @Override
    void processEndElement(String localName) {
        this.parser.processEndElement(localName, this.chars.toString());
    }

    @Override
    public void setKeepChars(boolean TF) {
        super.setKeepChars(TF);
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.parser.finalizeParsing();
        this.createMolecule();
    }

    @Override
    public int getBondOrder(String key) {
        switch (key) {
            case "1": 
            case "single": {
                return 1;
            }
            case "2": 
            case "double": {
                return 2;
            }
            case "3": 
            case "triple": {
                return 3;
            }
            case "up": {
                return 1025;
            }
            case "down": {
                return 1041;
            }
            case "either": {
                return 1057;
            }
            case "null": {
                return 131071;
            }
            case "delocalized": {
                return 515;
            }
        }
        return Edge.getBondOrderFromString(key);
    }

    @Override
    public void handleCoordinates(Map<String, String> atts) {
        boolean hasXYZ = atts.containsKey("xyz");
        boolean hasXY = atts.containsKey("p");
        if (!(!hasXYZ || this.no3D && hasXY)) {
            this.is2D = false;
            this.parser.setAtom("xyz", atts);
        } else if (atts.containsKey("p")) {
            this.parser.setAtom("p", atts);
        }
    }

    public void createMolecule() {
        BS bs = this.parser.bsAtoms;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            CDXMLParser.CDNode atom = this.parser.getAtom(i);
            Atom a = new Atom();
            a.set(atom.x, atom.y, atom.z);
            a.atomSerial = atom.intID;
            a.elementNumber = (short)atom.elementNumber;
            a.formalCharge = atom.formalCharge;
            String element = XmlCdxReader.getElementSymbol(atom.elementNumber);
            if (atom.isotope != null) {
                element = atom.isotope + element;
            }
            this.setElementAndIsotope(a, element);
            this.asc.addAtom(a);
            i = bs.nextSetBit(i + 1);
        }
        bs = this.parser.bsBonds;
        i = bs.nextSetBit(0);
        while (i >= 0) {
            CDXMLParser.CDBond bond = this.parser.getBond(i);
            Bond b = new Bond(bond.atomIndex1, bond.atomIndex2, bond.order);
            this.asc.addBondNoCheck(b);
            i = bs.nextSetBit(i + 1);
        }
        this.parent.appendLoadNote((this.isCDX ? "CDX: " : "CDXML: ") + (this.is2D ? "2D" : "3D"));
        this.asc.setInfo("minimize3D", !this.is2D && !this.noHydrogens);
        this.asc.setInfo("is2D", this.is2D);
        if (this.is2D) {
            this.optimize2D = !this.noHydrogens && !this.noMinimize;
            this.asc.setModelInfoForSet("dimension", "2D", this.asc.iSet);
            this.set2D();
        }
    }

    @Override
    public void warn(String warning) {
        this.parent.appendLoadNote(warning);
    }
}

