/*
 * Decompiled with CFR 0.152.
 */
package naga;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import naga.PacketWriter;
import naga.packetwriter.RawPacketWriter;

class SocketWriter {
    private long m_bytesWritten = 0L;
    private ByteBuffer[] m_writeBuffers = null;
    private PacketWriter m_packetWriter = RawPacketWriter.INSTANCE;
    private Object m_tag;
    private int m_currentBuffer;

    SocketWriter() {
    }

    public PacketWriter getPacketWriter() {
        return this.m_packetWriter;
    }

    public void setPacketWriter(PacketWriter packetWriter) {
        this.m_packetWriter = packetWriter;
    }

    public boolean isEmpty() {
        return this.m_writeBuffers == null;
    }

    public void setPacket(byte[] byArray, Object object) {
        if (!this.isEmpty()) {
            throw new IllegalStateException("This method should only called when m_writeBuffers == null");
        }
        this.m_writeBuffers = this.m_packetWriter.write(new ByteBuffer[]{ByteBuffer.wrap(byArray)});
        this.m_currentBuffer = 0;
        this.m_tag = object;
    }

    public boolean write(SocketChannel socketChannel) throws IOException {
        if (this.m_writeBuffers == null || this.m_currentBuffer == this.m_writeBuffers.length - 1 && !this.m_writeBuffers[this.m_currentBuffer].hasRemaining()) {
            this.m_writeBuffers = null;
            return true;
        }
        long l = socketChannel.write(this.m_writeBuffers, this.m_currentBuffer, this.m_writeBuffers.length - this.m_currentBuffer);
        if (l == 0L) {
            return false;
        }
        this.m_bytesWritten += l;
        for (int i = this.m_currentBuffer; i < this.m_writeBuffers.length; ++i) {
            if (this.m_writeBuffers[i].hasRemaining()) {
                this.m_currentBuffer = i;
                break;
            }
            this.m_writeBuffers[i] = null;
        }
        if (this.m_writeBuffers[this.m_currentBuffer] == null) {
            this.m_writeBuffers = null;
        }
        return true;
    }

    public long getBytesWritten() {
        return this.m_bytesWritten;
    }

    public Object getTag() {
        return this.m_tag;
    }
}

