/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal;

import org.gradle.api.artifacts.PublishException;
import org.gradle.api.publish.Publication;

public abstract class PublishOperation
implements Runnable {
    private final String publicationName;
    private final String repository;

    protected PublishOperation(Publication publication, String repository) {
        this(publication.getName(), repository);
    }

    protected PublishOperation(String publicationName, String repository) {
        this.publicationName = publicationName;
        this.repository = repository;
    }

    protected abstract void publish() throws Exception;

    @Override
    public void run() {
        try {
            this.publish();
        }
        catch (Exception e) {
            throw new PublishException(String.format("Failed to publish publication '%s' to repository '%s'", this.publicationName, this.repository), (Throwable)e);
        }
    }
}

