/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfs;

import java.io.PrintStream;
import org.catacombae.hfsexplorer.Util;

public class BTHdrRec {
    public static final int STRUCTSIZE = 106;
    private final byte[] bthDepth = new byte[2];
    private final byte[] bthRoot = new byte[4];
    private final byte[] bthNRecs = new byte[4];
    private final byte[] bthFNode = new byte[4];
    private final byte[] bthLNode = new byte[4];
    private final byte[] bthNodeSize = new byte[2];
    private final byte[] bthKeyLen = new byte[2];
    private final byte[] bthNNodes = new byte[4];
    private final byte[] bthFree = new byte[4];
    private final byte[] bthResv = new byte[76];

    public BTHdrRec(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.bthDepth, 0, 2);
        System.arraycopy(data, offset + 2, this.bthRoot, 0, 4);
        System.arraycopy(data, offset + 6, this.bthNRecs, 0, 4);
        System.arraycopy(data, offset + 10, this.bthFNode, 0, 4);
        System.arraycopy(data, offset + 14, this.bthLNode, 0, 4);
        System.arraycopy(data, offset + 18, this.bthNodeSize, 0, 2);
        System.arraycopy(data, offset + 20, this.bthKeyLen, 0, 2);
        System.arraycopy(data, offset + 22, this.bthNNodes, 0, 4);
        System.arraycopy(data, offset + 26, this.bthFree, 0, 4);
        System.arraycopy(data, offset + 30, this.bthResv, 0, 76);
    }

    public static int length() {
        return 106;
    }

    public short getBthDepth() {
        return Util.readShortBE(this.bthDepth);
    }

    public int getBthRoot() {
        return Util.readIntBE(this.bthRoot);
    }

    public int getBthNRecs() {
        return Util.readIntBE(this.bthNRecs);
    }

    public int getBthFNode() {
        return Util.readIntBE(this.bthFNode);
    }

    public int getBthLNode() {
        return Util.readIntBE(this.bthLNode);
    }

    public short getBthNodeSize() {
        return Util.readShortBE(this.bthNodeSize);
    }

    public short getBthKeyLen() {
        return Util.readShortBE(this.bthKeyLen);
    }

    public int getBthNNodes() {
        return Util.readIntBE(this.bthNNodes);
    }

    public int getBthFree() {
        return Util.readIntBE(this.bthFree);
    }

    public byte[] getBthResv() {
        return Util.readByteArrayBE(this.bthResv);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " bthDepth: " + this.getBthDepth());
        ps.println(prefix + " bthRoot: " + this.getBthRoot());
        ps.println(prefix + " bthNRecs: " + this.getBthNRecs());
        ps.println(prefix + " bthFNode: " + this.getBthFNode());
        ps.println(prefix + " bthLNode: " + this.getBthLNode());
        ps.println(prefix + " bthNodeSize: " + this.getBthNodeSize());
        ps.println(prefix + " bthKeyLen: " + this.getBthKeyLen());
        ps.println(prefix + " bthNNodes: " + this.getBthNNodes());
        ps.println(prefix + " bthFree: " + this.getBthFree());
        ps.println(prefix + " bthResv: " + this.getBthResv());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "BTHdrRec:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[106];
        int offset = 0;
        System.arraycopy(this.bthDepth, 0, result, offset, this.bthDepth.length);
        System.arraycopy(this.bthRoot, 0, result, offset += this.bthDepth.length, this.bthRoot.length);
        System.arraycopy(this.bthNRecs, 0, result, offset += this.bthRoot.length, this.bthNRecs.length);
        System.arraycopy(this.bthFNode, 0, result, offset += this.bthNRecs.length, this.bthFNode.length);
        System.arraycopy(this.bthLNode, 0, result, offset += this.bthFNode.length, this.bthLNode.length);
        System.arraycopy(this.bthNodeSize, 0, result, offset += this.bthLNode.length, this.bthNodeSize.length);
        System.arraycopy(this.bthKeyLen, 0, result, offset += this.bthNodeSize.length, this.bthKeyLen.length);
        System.arraycopy(this.bthNNodes, 0, result, offset += this.bthKeyLen.length, this.bthNNodes.length);
        System.arraycopy(this.bthFree, 0, result, offset += this.bthNNodes.length, this.bthFree.length);
        System.arraycopy(this.bthResv, 0, result, offset += this.bthFree.length, this.bthResv.length);
        offset += this.bthResv.length;
        return result;
    }
}

