/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MemoryMapBytesFile {
    private OutputStream os;
    private String fileName;
    private int bytesWritten;
    private Memory memory;

    public MemoryMapBytesFile(Program program, String fileName) throws IOException {
        this.memory = program.getMemory();
        fileName = (String)fileName + ".bytes";
        File file = new File((String)fileName);
        this.fileName = file.getName();
        if (file.exists()) {
            file.delete();
        }
        this.os = new BufferedOutputStream(new FileOutputStream(file));
    }

    void close() throws IOException {
        this.os.close();
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getOffset() {
        return this.bytesWritten;
    }

    public void writeBytes(AddressRange range) throws IOException {
        try {
            long size;
            int BUFSIZE = 32768;
            byte[] buf = new byte[(int)Math.min(size, (long)BUFSIZE)];
            Address addr = range.getMinAddress();
            int n = 0;
            for (size = range.getLength(); size > 0L; size -= (long)n) {
                addr = addr.addNoWrap((long)n);
                n = this.memory.getBytes(addr, buf);
                this.os.write(buf, 0, n);
                this.bytesWritten += n;
            }
        }
        catch (AddressOverflowException e) {
            throw new IOException(e.getMessage());
        }
        catch (MemoryAccessException e) {
            throw new IOException(e.getMessage());
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
    }
}

